/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet;

import guideme.internal.shaded.lucene.facet.Facets;
import guideme.internal.shaded.lucene.facet.FacetsCollector;
import guideme.internal.shaded.lucene.index.IndexReaderContext;
import guideme.internal.shaded.lucene.index.ReaderUtil;
import guideme.internal.shaded.lucene.search.ConjunctionUtils;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public abstract class FacetCountsWithFilterQuery
extends Facets {
    protected final Query fastMatchQuery;

    protected FacetCountsWithFilterQuery(Query fastMatchQuery) {
        this.fastMatchQuery = fastMatchQuery;
    }

    protected DocIdSetIterator createIterator(FacetsCollector.MatchingDocs hits, DocIdSetIterator ... iterators) throws IOException {
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        allIterators.add(hits.bits.iterator());
        allIterators.addAll(Arrays.asList(iterators));
        if (allIterators.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        if (this.fastMatchQuery != null) {
            IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext(hits.context);
            IndexSearcher searcher = new IndexSearcher(topLevelContext);
            searcher.setQueryCache(null);
            Weight fastMatchWeight = searcher.createWeight(searcher.rewrite(this.fastMatchQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            Scorer s = fastMatchWeight.scorer(hits.context);
            if (s == null) {
                return null;
            }
            DocIdSetIterator fastMatchQueryIterator = s.iterator();
            allIterators.add(fastMatchQueryIterator);
        }
        if (allIterators.size() == 1) {
            return (DocIdSetIterator)allIterators.get(0);
        }
        return ConjunctionUtils.intersectIterators(allIterators);
    }
}

