/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.processor;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public interface ITemplateFeatureProcessor {
    public static final BlockState AIR = Blocks.f_50016_.m_49966_();
    public static final TagKey<Biome> BADLANDS_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("yungsbridges", "collections/badlands"));
    public static final TagKey<Biome> TAIGA_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("yungsbridges", "collections/taiga"));
    public static final TagKey<Biome> SAVANNA_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("yungsbridges", "collections/savanna"));
    public static final TagKey<Biome> JUNGLE_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("yungsbridges", "collections/jungle"));

    public void processTemplate(StructureTemplate var1, WorldGenLevel var2, RandomSource var3, BlockPos var4, BlockPos var5, StructurePlaceSettings var6);

    default public void generatePillarDown(WorldGenLevel level, BlockPos pos, Supplier<BlockState> replacementBlockSupplier, Supplier<BlockState> legBlockSupplier) {
        level.m_7731_(pos, replacementBlockSupplier.get(), 2);
        BlockPos.MutableBlockPos mutable = pos.m_7495_().m_122032_();
        BlockState currBlock = level.m_8055_((BlockPos)mutable);
        while (mutable.m_123342_() > 0 && (currBlock.m_60795_() || currBlock.m_278721_())) {
            level.m_7731_((BlockPos)mutable, legBlockSupplier.get(), 2);
            mutable.m_122173_(Direction.DOWN);
            currBlock = level.m_8055_((BlockPos)mutable);
        }
    }

    default public BlockState getStairsBlockWithState(BlockState input, BlockState source) {
        if (input.m_60734_() instanceof StairBlock) {
            return (BlockState)((BlockState)((BlockState)((BlockState)input.m_61124_((Property)StairBlock.f_56841_, (Comparable)(source.m_61138_((Property)StairBlock.f_56841_) ? (Direction)source.m_61143_((Property)StairBlock.f_56841_) : Direction.NORTH))).m_61124_((Property)StairBlock.f_56842_, (Comparable)(source.m_61138_((Property)StairBlock.f_56842_) ? (Half)source.m_61143_((Property)StairBlock.f_56842_) : Half.BOTTOM))).m_61124_((Property)StairBlock.f_56843_, (Comparable)(source.m_61138_((Property)StairBlock.f_56843_) ? (StairsShape)source.m_61143_((Property)StairBlock.f_56843_) : StairsShape.STRAIGHT))).m_61124_((Property)StairBlock.f_56844_, (Comparable)(source.m_61138_((Property)StairBlock.f_56844_) ? (Boolean)source.m_61143_((Property)StairBlock.f_56844_) : Boolean.valueOf(false)));
        }
        return input;
    }

    default public BlockState getSlabBlockWithState(BlockState input, BlockState source) {
        if (input.m_60734_() instanceof SlabBlock) {
            return (BlockState)((BlockState)input.m_61124_((Property)SlabBlock.f_56353_, (Comparable)(source.m_61138_((Property)SlabBlock.f_56353_) ? (SlabType)source.m_61143_((Property)SlabBlock.f_56353_) : SlabType.BOTTOM))).m_61124_((Property)SlabBlock.f_56354_, (Comparable)(source.m_61138_((Property)SlabBlock.f_56354_) ? (Boolean)source.m_61143_((Property)SlabBlock.f_56354_) : Boolean.valueOf(false)));
        }
        return input;
    }

    default public BlockState getWallBlockWithState(BlockState input, BlockState source) {
        if (input.m_60734_() instanceof WallBlock && source.m_60734_() instanceof WallBlock) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)input.m_61124_((Property)WallBlock.f_57951_, (Comparable)(source.m_61138_((Property)WallBlock.f_57951_) ? (WallSide)source.m_61143_((Property)WallBlock.f_57951_) : WallSide.NONE))).m_61124_((Property)WallBlock.f_57950_, (Comparable)(source.m_61138_((Property)WallBlock.f_57950_) ? (WallSide)source.m_61143_((Property)WallBlock.f_57950_) : WallSide.NONE))).m_61124_((Property)WallBlock.f_57952_, (Comparable)(source.m_61138_((Property)WallBlock.f_57952_) ? (WallSide)source.m_61143_((Property)WallBlock.f_57952_) : WallSide.NONE))).m_61124_((Property)WallBlock.f_57953_, (Comparable)(source.m_61138_((Property)WallBlock.f_57953_) ? (WallSide)source.m_61143_((Property)WallBlock.f_57953_) : WallSide.NONE))).m_61124_((Property)WallBlock.f_57949_, (Comparable)(source.m_61138_((Property)WallBlock.f_57949_) ? (Boolean)source.m_61143_((Property)WallBlock.f_57949_) : Boolean.valueOf(true)))).m_61124_((Property)WallBlock.f_57954_, (Comparable)(source.m_61138_((Property)WallBlock.f_57954_) ? (Boolean)source.m_61143_((Property)WallBlock.f_57954_) : Boolean.valueOf(false)));
        }
        return input;
    }

    default public BlockState getFenceBlockWithState(BlockState input, BlockState source) {
        if (input.m_60734_() instanceof FenceBlock) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)input.m_61124_((Property)FenceBlock.f_52309_, (Comparable)(source.m_61138_((Property)FenceBlock.f_52309_) ? (Boolean)source.m_61143_((Property)FenceBlock.f_52309_) : Boolean.valueOf(false)))).m_61124_((Property)FenceBlock.f_52310_, (Comparable)(source.m_61138_((Property)FenceBlock.f_52310_) ? (Boolean)source.m_61143_((Property)FenceBlock.f_52310_) : Boolean.valueOf(false)))).m_61124_((Property)FenceBlock.f_52311_, (Comparable)(source.m_61138_((Property)FenceBlock.f_52311_) ? (Boolean)source.m_61143_((Property)FenceBlock.f_52311_) : Boolean.valueOf(false)))).m_61124_((Property)FenceBlock.f_52312_, (Comparable)(source.m_61138_((Property)FenceBlock.f_52312_) ? (Boolean)source.m_61143_((Property)FenceBlock.f_52312_) : Boolean.valueOf(false)))).m_61124_((Property)FenceBlock.f_52313_, (Comparable)(source.m_61138_((Property)FenceBlock.f_52313_) ? (Boolean)source.m_61143_((Property)FenceBlock.f_52313_) : Boolean.valueOf(false)));
        }
        return input;
    }

    default public BlockState getLogBlockWithState(BlockState input, BlockState source) {
        if (input.m_60734_() instanceof RotatedPillarBlock) {
            return (BlockState)input.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)(source.m_61138_((Property)RotatedPillarBlock.f_55923_) ? (Direction.Axis)source.m_61143_((Property)RotatedPillarBlock.f_55923_) : Direction.Axis.Y));
        }
        return input;
    }

    default public BlockState getLanternBlockWithState(BlockState input, BlockState source) {
        if (input.m_60734_() instanceof LanternBlock) {
            return (BlockState)((BlockState)input.m_61124_((Property)LanternBlock.f_153459_, (Comparable)(source.m_61138_((Property)LanternBlock.f_153459_) ? (Boolean)source.m_61143_((Property)LanternBlock.f_153459_) : Boolean.valueOf(true)))).m_61124_((Property)LanternBlock.f_153460_, (Comparable)(source.m_61138_((Property)LanternBlock.f_153460_) ? (Boolean)source.m_61143_((Property)LanternBlock.f_153460_) : Boolean.valueOf(true)));
        }
        return input;
    }

    default public BlockState getFenceBiomeVariant(Holder<Biome> biome) {
        if (biome.m_203656_(BADLANDS_TAG)) {
            return Blocks.f_50483_.m_49966_();
        }
        if (biome.m_203656_(TAIGA_TAG)) {
            return Blocks.f_50479_.m_49966_();
        }
        if (biome.m_203656_(JUNGLE_TAG)) {
            return Blocks.f_50481_.m_49966_();
        }
        if (biome.m_203656_(SAVANNA_TAG)) {
            return Blocks.f_50482_.m_49966_();
        }
        return Blocks.f_50132_.m_49966_();
    }

    default public BlockState getLogBiomeVariant(Holder<Biome> biome) {
        if (biome.m_203656_(BADLANDS_TAG)) {
            return Blocks.f_50004_.m_49966_();
        }
        if (biome.m_203656_(TAIGA_TAG)) {
            return Blocks.f_50000_.m_49966_();
        }
        if (biome.m_203656_(JUNGLE_TAG)) {
            return Blocks.f_50002_.m_49966_();
        }
        if (biome.m_203656_(SAVANNA_TAG)) {
            return Blocks.f_50003_.m_49966_();
        }
        return Blocks.f_49999_.m_49966_();
    }

    default public BlockState getPlanksBiomeVariant(Holder<Biome> biome) {
        if (biome.m_203656_(BADLANDS_TAG)) {
            return Blocks.f_50745_.m_49966_();
        }
        if (biome.m_203656_(TAIGA_TAG)) {
            return Blocks.f_50741_.m_49966_();
        }
        if (biome.m_203656_(JUNGLE_TAG)) {
            return Blocks.f_50743_.m_49966_();
        }
        if (biome.m_203656_(SAVANNA_TAG)) {
            return Blocks.f_50744_.m_49966_();
        }
        return Blocks.f_50705_.m_49966_();
    }

    default public BlockState getSlabBiomeVariant(Holder<Biome> biome) {
        if (biome.m_203656_(BADLANDS_TAG)) {
            return Blocks.f_50403_.m_49966_();
        }
        if (biome.m_203656_(TAIGA_TAG)) {
            return Blocks.f_50399_.m_49966_();
        }
        if (biome.m_203656_(JUNGLE_TAG)) {
            return Blocks.f_50401_.m_49966_();
        }
        if (biome.m_203656_(SAVANNA_TAG)) {
            return Blocks.f_50402_.m_49966_();
        }
        return Blocks.f_50398_.m_49966_();
    }

    default public BlockState getStairsBiomeVariant(Holder<Biome> biome) {
        if (biome.m_203656_(BADLANDS_TAG)) {
            return Blocks.f_50373_.m_49966_();
        }
        if (biome.m_203656_(TAIGA_TAG)) {
            return Blocks.f_50269_.m_49966_();
        }
        if (biome.m_203656_(JUNGLE_TAG)) {
            return Blocks.f_50271_.m_49966_();
        }
        if (biome.m_203656_(SAVANNA_TAG)) {
            return Blocks.f_50372_.m_49966_();
        }
        return Blocks.f_50086_.m_49966_();
    }
}

