/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import appeng.client.render.effects.ParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class EnergyParticleData
implements ParticleOptions {
    public static final EnergyParticleData FOR_BLOCK = new EnergyParticleData(false, null);
    public final boolean forItem;
    public final Direction direction;
    public static final ParticleOptions.Deserializer<EnergyParticleData> DESERIALIZER = new ParticleOptions.Deserializer<EnergyParticleData>(){

        public EnergyParticleData fromCommand(ParticleType<EnergyParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            boolean forItem = reader.readBoolean();
            reader.expect(' ');
            Direction direction = Direction.valueOf((String)reader.readString().toUpperCase(Locale.ROOT));
            return new EnergyParticleData(forItem, direction);
        }

        public EnergyParticleData fromNetwork(ParticleType<EnergyParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            boolean forItem = buffer.readBoolean();
            Direction direction = Direction.values()[buffer.readByte()];
            return new EnergyParticleData(forItem, direction);
        }
    };

    public EnergyParticleData(boolean forItem, Direction direction) {
        this.forItem = forItem;
        this.direction = direction;
    }

    public ParticleType<?> m_6012_() {
        return ParticleTypes.ENERGY;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.forItem);
        buffer.writeByte((int)((byte)this.direction.ordinal()));
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %s", this.forItem ? "true" : "false", this.direction.name().toLowerCase(Locale.ROOT));
    }
}

