/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.world.feature;

import com.mojang.serialization.Codec;
import com.peeko32213.unusualprehistory.common.entity.EntitySludge;
import com.peeko32213.unusualprehistory.core.registry.UPBlocks;
import com.peeko32213.unusualprehistory.core.registry.UPEntities;
import com.peeko32213.unusualprehistory.core.registry.util.FastNoiseLite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.Vec3;

public class TarPitFeature
extends Feature<NoneFeatureConfiguration> {
    public TarPitFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        BlockPos blockPos;
        WorldGenLevel worldGenLevel = pContext.m_159774_();
        if (worldGenLevel.m_6425_(blockPos = pContext.m_159777_()).m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        RandomSource random = pContext.m_225041_();
        FastNoiseLite noiseTar = TarPitFeature.createNoise(worldGenLevel.m_7328_() + random.m_188505_(), 0.06f);
        FastNoiseLite noisePreprocessor = TarPitFeature.createNoise(worldGenLevel.m_7328_() + random.m_188505_(), 0.6f);
        TarPitFeature.createTarPitFeature(worldGenLevel, blockPos, random, 15, 30, noiseTar, true);
        TarPitFeature.preProcessTarFeature(worldGenLevel, blockPos, random, 17, 15, noisePreprocessor, noiseTar, true);
        TarPitFeature.spawnTarMonster(worldGenLevel, blockPos);
        return true;
    }

    private static void createTarPitFeature(WorldGenLevel worldgenlevel, BlockPos origin, RandomSource random, int radius, int height, FastNoiseLite noise, boolean finalSection) {
        BlockState block = Blocks.f_50069_.m_49966_();
        BlockState block2 = ((Block)UPBlocks.TAR.get()).m_49966_();
        BlockState block3 = Blocks.f_220864_.m_49966_();
        BlockState block4 = (BlockState)((Block)UPBlocks.SPLATTERED_TAR.get()).m_49966_().m_61124_((Property)MultifaceBlock.m_153933_((Direction)Direction.DOWN), (Comparable)Boolean.valueOf(true));
        BlockState block5 = ((Block)UPBlocks.STONE_TAR_FOSSIL.get()).m_49966_();
        BlockState block6 = Blocks.f_50069_.m_49966_();
        int heightLower = 0;
        if (finalSection) {
            heightLower = -height;
        }
        for (int x = -radius; x < radius; ++x) {
            for (int y = heightLower; y < height; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    BlockPos pos = origin.m_7918_(x, y, z);
                    double distance = TarPitFeature.distance(x, y, z, radius, height, radius);
                    float f = noise.GetNoise(x, y, z);
                    if (!(distance < 1.0) || worldgenlevel.m_8055_(pos).m_60795_()) continue;
                    if ((double)f < -0.1 && (double)f > -0.8 && distance < 0.8 && pos.m_123342_() < origin.m_123342_() - 1) {
                        worldgenlevel.m_7731_(pos, block2, 3);
                        continue;
                    }
                    if (((double)f >= -0.1 && (double)f < 0.1 || (double)f <= -0.8) && distance < 0.8 && pos.m_123342_() < origin.m_123342_() - 1) {
                        worldgenlevel.m_7731_(pos, block, 3);
                        continue;
                    }
                    if (!(f < 0.0f)) continue;
                    if (pos.m_123342_() < origin.m_123342_()) {
                        if ((double)f >= -0.6 && (double)f < -0.55 || (double)f >= -0.85 && (double)f < -0.8) {
                            worldgenlevel.m_7731_(pos, block5, 3);
                        } else if (pos.m_123342_() < origin.m_123342_() - 4) {
                            worldgenlevel.m_7731_(pos, block, 3);
                        } else {
                            worldgenlevel.m_7731_(pos, block3, 3);
                        }
                        if ((double)f < -0.1 && (double)f > -0.8 && distance < 0.8 && pos.m_123342_() >= origin.m_123342_() - 1) {
                            worldgenlevel.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                        }
                    }
                    if (!((double)f < -0.1) || !((double)f > -0.8) || pos.m_123342_() < origin.m_123342_() || pos.m_123342_() >= origin.m_123342_() + 1 || !(random.m_188501_() < 0.5f) || !worldgenlevel.m_8055_(pos.m_7495_()).m_280296_()) continue;
                    worldgenlevel.m_7731_(pos, block4, 3);
                }
            }
        }
    }

    private static void preProcessTarFeature(WorldGenLevel worldgenlevel, BlockPos origin, RandomSource random, int radius, int height, FastNoiseLite noise, FastNoiseLite noise2, boolean finalSection) {
        BlockState block = Blocks.f_50069_.m_49966_();
        BlockState block2 = ((Block)UPBlocks.TAR.get()).m_49966_();
        BlockState block3 = Blocks.f_220864_.m_49966_();
        BlockState block4 = (BlockState)((Block)UPBlocks.SPLATTERED_TAR.get()).m_49966_().m_61124_((Property)MultifaceBlock.m_153933_((Direction)Direction.DOWN), (Comparable)Boolean.valueOf(true));
        BlockState block5 = ((Block)UPBlocks.STONE_TAR_FOSSIL.get()).m_49966_();
        BlockState block6 = Blocks.f_50069_.m_49966_();
        int heightLower = 0;
        if (finalSection) {
            heightLower = -height;
        }
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                boolean isCorrectBlock;
                BlockPos pos = origin.m_7918_(x, 0, z);
                double yHeight = worldgenlevel.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_()) - 1;
                BlockPos pos2 = BlockPos.m_274561_((double)pos.m_123341_(), (double)yHeight, (double)pos.m_123343_());
                double distance = TarPitFeature.distance(x, 0.0, z, radius, 1.0, radius);
                float f = noise.GetNoise(x, (float)yHeight, z);
                float f2 = noise2.GetNoise(x, (float)yHeight, z);
                if (!(distance < 1.0) || !(distance > 0.75) || !((double)f2 >= -0.1 && (double)f2 < 0.1) && !((double)f2 <= -0.8)) continue;
                boolean bl = isCorrectBlock = !worldgenlevel.m_8055_(pos2).m_60713_((Block)UPBlocks.TAR.get()) && !worldgenlevel.m_8055_(pos2).m_60713_((Block)UPBlocks.SPLATTERED_TAR.get()) && !worldgenlevel.m_8055_(pos2).m_60713_(Blocks.f_50069_) && !worldgenlevel.m_8055_(pos2).m_60713_(Blocks.f_220864_);
                if (f < 0.0f && (double)f > -0.3 && isCorrectBlock) {
                    worldgenlevel.m_7731_(pos2, Blocks.f_50493_.m_49966_(), 3);
                    worldgenlevel.m_7731_(pos2.m_7494_(), block4, 3);
                    continue;
                }
                if ((double)f < 0.5 && f > 0.0f && isCorrectBlock) {
                    worldgenlevel.m_7731_(pos2, Blocks.f_220864_.m_49966_(), 3);
                    continue;
                }
                if (!isCorrectBlock) continue;
                worldgenlevel.m_7731_(pos2, Blocks.f_50069_.m_49966_(), 3);
            }
        }
    }

    private static void spawnTarMonster(WorldGenLevel worldgenlevel, BlockPos origin) {
        EntitySludge sludge = (EntitySludge)((EntityType)UPEntities.SLUDGE.get()).m_20615_((Level)worldgenlevel.m_6018_());
        sludge.m_8023_();
        sludge.m_21530_();
        sludge.m_146884_(Vec3.m_82512_((Vec3i)origin));
        worldgenlevel.m_7967_((Entity)sludge);
    }

    public static double distance(double x, double y, double z, double xRadius, double yRadius, double zRadius) {
        return Mth.m_144952_((double)(x / xRadius)) + Mth.m_144952_((double)(y / yRadius)) + Mth.m_144952_((double)(z / zRadius));
    }

    private static FastNoiseLite createNoise(long seed, float frequency) {
        FastNoiseLite noise = new FastNoiseLite((int)seed);
        noise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        noise.SetFrequency(frequency);
        return noise;
    }
}

