/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.message;

import com.peeko32213.unusualprehistory.common.entity.IAttackEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.network.NetworkEvent;

public class AttackOutputMessage {
    public int key;

    public AttackOutputMessage(int key) {
        this.key = key;
    }

    public AttackOutputMessage(FriendlyByteBuf buf) {
        this.key = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.key);
    }

    public static void handle(AttackOutputMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            Entity vehicle = player.m_20202_();
            if (vehicle instanceof IAttackEntity) {
                IAttackEntity attackEntity = (IAttackEntity)vehicle;
                if (vehicle instanceof TamableAnimal) {
                    TamableAnimal animal = (TamableAnimal)vehicle;
                    attackEntity.afterAttack();
                }
            }
        });
        context.setPacketHandled(true);
    }
}

