/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity.msc.util.dino;

import com.google.common.collect.ImmutableList;
import com.peeko32213.unusualprehistory.UnusualPrehistory;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class EntityWorldSpawnable
extends LivingEntity
implements GeoAnimatable {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityWorldSpawnable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> WIDTH_SCALE = SynchedEntityData.m_135353_(EntityWorldSpawnable.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HEIGHT_SCALE = SynchedEntityData.m_135353_(EntityWorldSpawnable.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final ResourceLocation MAMMOTH_LOOT = UnusualPrehistory.prefix("entities/iceberg/mammoth");
    public static final ResourceLocation SMILODON_LOOT = UnusualPrehistory.prefix("entities/iceberg/smilodon");
    public static final ResourceLocation ERYON_LOOT = UnusualPrehistory.prefix("entities/iceberg/eryon");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final Logger LOGGER = LogManager.getLogger();
    private boolean hasGivenDna;
    private boolean canGiveItems;
    private int itemCount;
    private int currentDrop;

    public EntityWorldSpawnable(EntityType<? extends LivingEntity> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.0);
    }

    protected abstract ItemStack getDnaItem();

    protected abstract int dropCount();

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (itemStack.m_41619_() && pHand == InteractionHand.MAIN_HAND) {
            if (!this.hasGivenDna) {
                ItemStack dna = this.getDnaItem();
                if (!dna.m_41619_() && !this.m_9236_().f_46443_) {
                    this.m_5552_(dna, 1.0f);
                    this.hasGivenDna = true;
                }
            } else if (this.dropCount() > 0 && ++this.currentDrop < this.dropCount()) {
                this.itemDrop();
            } else {
                this.m_216990_(SoundEvents.f_12424_);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        return super.m_6096_(pPlayer, pHand);
    }

    protected abstract ResourceLocation getDeadLootTable();

    public void itemDrop() {
        ItemStack drop = this.getSoundForDrop();
        if (!drop.m_41619_() && !this.m_9236_().f_46443_) {
            this.m_5552_(drop, 1.0f);
        }
    }

    protected ItemStack getSoundForDrop() {
        ItemStack lootItem = this.getItemFromLootTable();
        if (lootItem.m_41720_() == UPItems.FROZEN_FOSSIL.get() || lootItem.m_41720_() == UPItems.SMILODON_EMBRYO.get()) {
            this.m_5496_(SoundEvents.f_144245_, 1.0f, 1.0f);
        } else {
            this.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
        }
        return lootItem;
    }

    public ItemStack getItemFromLootTable() {
        LootParams lootparams;
        if (this.m_9236_().m_7654_() == null) {
            return ItemStack.f_41583_;
        }
        LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(this.getDeadLootTable());
        ObjectListIterator objectListIterator = loottable.m_287195_(lootparams = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81457_, (Object)this.m_269291_().m_269264_()).m_287235_(LootContextParamSets.f_81411_)).iterator();
        if (objectListIterator.hasNext()) {
            ItemStack itemstack = (ItemStack)objectListIterator.next();
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (HEIGHT_SCALE.equals(pKey) || WIDTH_SCALE.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.hasGivenDna = compound.m_128471_("hasGivenDna");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasGivenDna", this.hasGivenDna);
    }

    public Iterable<ItemStack> m_6168_() {
        return ImmutableList.of();
    }

    public ItemStack m_6844_(EquipmentSlot p_21127_) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot p_21036_, ItemStack p_21037_) {
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (source == this.m_269291_().m_269318_() || source == this.m_269291_().m_269264_()) {
            return false;
        }
        return false;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean m_5789_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    protected abstract RawAnimation getFrozenState();

    private <E extends EntityWorldSpawnable> PlayState predicate(AnimationState<E> event) {
        if (this.getFrozenState() != null) {
            event.getController().setAnimation(this.getFrozenState());
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 10, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }
}

