/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.google.common.collect.Lists;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EntityTalpanas
extends EntityBaseDinosaurAnimal {
    private static final EntityDataAccessor<Optional<BlockPos>> FEEDING_POS = SynchedEntityData.m_135353_(EntityTalpanas.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> FEEDING_TIME = SynchedEntityData.m_135353_(EntityTalpanas.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final ResourceLocation TALPANAS_REWARD = new ResourceLocation("unusualprehistory", "gameplay/talpanas_reward");
    private Ingredient temptationItems;
    public float prevFeedProgress;
    public float feedProgress;
    private int rideCooldown = 0;
    public int soundTimer = 0;
    private static final RawAnimation TALPANAS_WALK = RawAnimation.begin().thenLoop("animation.talpanas.walk");
    private static final RawAnimation TALPANAS_IDLE = RawAnimation.begin().thenLoop("animation.talpanas.idle");
    private static final RawAnimation TALPANAS_SWIM = RawAnimation.begin().thenLoop("animation.talpanas.swim");
    private static final RawAnimation TALPANAS_SIT = RawAnimation.begin().thenLoop("animation.talpanas.sit");
    private static final RawAnimation TALPANAS_FORGE = RawAnimation.begin().thenLoop("animation.talpanas.forge");

    public EntityTalpanas(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22285_, 0.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, this.getTemptationItems(), false));
        this.f_21345_.m_25352_(5, (Goal)new DigRootedDirtGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FleeLightGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.m_204132_((TagKey)ItemTags.f_13143_)}));
        }
        return this.temptationItems;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.TALPANAS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.TALPANAS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.TALPANAS_DEATH.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_11754_, 0.1f, 1.0f);
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 0;
    }

    @Override
    protected boolean canGetHungry() {
        return false;
    }

    @Override
    protected boolean hasTargets() {
        return false;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public int getFeedingTime() {
        return (Integer)this.f_19804_.m_135370_(FEEDING_TIME);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FEEDING_TIME, (Object)0);
        this.f_19804_.m_135372_(FEEDING_POS, Optional.empty());
    }

    public void setFeedingTime(int feedingTime) {
        this.f_19804_.m_135381_(FEEDING_TIME, (Object)feedingTime);
    }

    @Override
    public void m_8119_() {
        BlockPos feedingPos;
        super.m_8119_();
        if (this.soundTimer > 0) {
            --this.soundTimer;
        }
        this.prevFeedProgress = this.feedProgress;
        if (this.getFeedingTime() > 0 && this.feedProgress < 5.0f) {
            this.feedProgress += 1.0f;
        }
        if (this.getFeedingTime() <= 0 && this.feedProgress > 0.0f) {
            this.feedProgress -= 1.0f;
        }
        if ((feedingPos = (BlockPos)((Optional)this.f_19804_.m_135370_(FEEDING_POS)).orElse(null)) == null) {
            float f2 = (float)(-((double)((float)this.m_20184_().f_82480_ * 2.2f) * 57.2957763671875));
            this.m_146926_(f2);
        } else if (this.getFeedingTime() > 0) {
            Vec3 face = Vec3.m_82512_((Vec3i)feedingPos).m_82546_(this.m_20182_());
            double d0 = face.m_165924_();
            this.m_146926_((float)(-Mth.m_14136_((double)face.f_82480_, (double)d0) * 57.2957763671875));
            this.m_146922_((float)Mth.m_14136_((double)face.f_82481_, (double)face.f_82479_) * 57.295776f - 90.0f);
            this.f_20883_ = this.m_146908_();
            this.f_20885_ = this.m_146908_();
            BlockState state = this.m_9236_().m_8055_(feedingPos);
            if (this.f_19796_.m_188503_(2) == 0 && !state.m_60795_()) {
                Vec3 mouth = new Vec3(0.0, (double)(this.m_20206_() * 0.5f), (double)-0.2f).m_82496_(this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                for (int i = 0; i < 4 + this.f_19796_.m_188503_(2); ++i) {
                    double motX = this.f_19796_.m_188583_() * 0.02;
                    double motY = 0.1f + this.f_19796_.m_188501_() * 0.2f;
                    double motZ = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), this.m_20185_() + mouth.f_82479_, this.m_20186_() + mouth.f_82480_, this.m_20189_() + mouth.f_82481_, motX, motY, motZ);
                }
            }
        }
        if (this.rideCooldown > 0) {
            --this.rideCooldown;
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.m_8127_();
        super.m_6667_(pDamageSource);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_6083_() {
        Entity mount = this.m_20202_();
        if (this.m_20159_() && !mount.m_6084_()) {
            this.m_8127_();
            return;
        }
        if (mount instanceof Player) {
            Player player = (Player)mount;
            if (this.m_20159_()) {
                this.m_20334_(0.0, 0.0, 0.0);
                float radius = 0.0f;
                float angle = (float)Math.PI / 180 * (player.f_20883_ - 180.0f);
                double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraZ = radius * Mth.m_14089_((float)angle);
                this.playPanicSound();
                this.m_6034_(player.m_20185_() + extraX, Math.max(player.m_20186_() + (double)player.m_20206_() + 0.1, player.m_20186_()), player.m_20189_() + extraZ);
                if (player.m_6084_() && this.rideCooldown != 0 && !player.m_6144_()) {
                    if (mount.m_6084_()) return;
                }
                this.m_8127_();
                return;
            }
        }
        super.m_6083_();
    }

    private void playPanicSound() {
        if (this.soundTimer <= 0) {
            this.m_5496_((SoundEvent)UPSounds.TALPANAS_PANIC.get(), this.m_6121_(), (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.0f);
            this.soundTimer = 80;
        }
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268612_);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        ItemStack itemstack2 = player.m_21120_(InteractionHand.OFF_HAND);
        Item item = itemstack.m_41720_();
        if (!this.m_6898_(itemstack) && itemstack.m_41619_() && hand == InteractionHand.MAIN_HAND && player.m_20197_().isEmpty()) {
            this.m_20329_((Entity)player);
            this.rideCooldown = 20;
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    private boolean canSeeBlock(BlockPos destinationBlock) {
        Vec3 Vector3d = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 blockVec = Vec3.m_82512_((Vec3i)destinationBlock);
        BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(Vector3d, blockVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return result.m_82425_().equals((Object)destinationBlock);
    }

    private static List<ItemStack> getDigLoot(EntityTalpanas crab) {
        LootTable loottable = crab.m_9236_().m_7654_().m_278653_().m_278676_(TALPANAS_REWARD);
        return loottable.m_287195_(new LootParams.Builder((ServerLevel)crab.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)crab).m_287235_(LootContextParamSets.f_81417_));
    }

    protected boolean m_6107_() {
        return this.m_20159_();
    }

    public Vec3 m_7688_(LivingEntity pLivingEntity) {
        Vec3 vec3 = EntityTalpanas.m_19903_((double)this.m_20205_(), (double)pLivingEntity.m_20205_(), (float)(this.m_146908_() + (pLivingEntity.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vec31 = this.getDismountLocationInDirection(vec3, pLivingEntity);
        if (vec31 != null) {
            return vec31;
        }
        Vec3 vec32 = EntityTalpanas.m_19903_((double)this.m_20205_(), (double)pLivingEntity.m_20205_(), (float)(this.m_146908_() + (pLivingEntity.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vec33 = this.getDismountLocationInDirection(vec32, pLivingEntity);
        return vec33 != null ? vec33 : this.m_20182_();
    }

    @javax.annotation.Nullable
    private Vec3 getDismountLocationInDirection(Vec3 pDirection, LivingEntity pPassenger) {
        double d0 = this.m_20185_() + pDirection.f_82479_;
        double d1 = this.m_20191_().f_82289_;
        double d2 = this.m_20189_() + pDirection.f_82481_;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : pPassenger.m_7431_()) {
            blockpos$mutableblockpos.m_122169_(d0, d1, d2);
            double d3 = this.m_20191_().f_82292_ + 0.75;
            do {
                double d4 = this.m_9236_().m_45573_((BlockPos)blockpos$mutableblockpos);
                if ((double)blockpos$mutableblockpos.m_123342_() + d4 > d3) continue block0;
                if (DismountHelper.m_38439_((double)d4)) {
                    AABB aabb = pPassenger.m_21270_(pose);
                    Vec3 vec3 = new Vec3(d0, (double)blockpos$mutableblockpos.m_123342_() + d4, d2);
                    if (DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)pPassenger, (AABB)aabb.m_82383_(vec3))) {
                        pPassenger.m_20124_(pose);
                        return vec3;
                    }
                }
                blockpos$mutableblockpos.m_122173_(Direction.UP);
            } while ((double)blockpos$mutableblockpos.m_123342_() < d3);
        }
        return null;
    }

    protected <E extends EntityTalpanas> PlayState Controller(AnimationState<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6 && !this.m_20159_() && !this.m_6069_()) {
            event.setAndContinue(TALPANAS_WALK);
            return PlayState.CONTINUE;
        }
        if (this.m_20159_() && !this.m_6069_()) {
            event.setAndContinue(TALPANAS_SIT);
            return PlayState.CONTINUE;
        }
        if (this.m_20069_()) {
            event.setAndContinue(TALPANAS_SWIM);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        event.setAndContinue(TALPANAS_IDLE);
        return PlayState.CONTINUE;
    }

    protected <E extends EntityTalpanas> PlayState digController(AnimationState<E> event) {
        if (this.getFeedingTime() > 0) {
            event.setAndContinue(TALPANAS_FORGE);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 10, this::Controller)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Attack", 0, this::digController)});
    }

    @Override
    public double getTick(Object o) {
        return this.f_19797_;
    }

    private class DigRootedDirtGoal
    extends Goal {
        private final int searchLength;
        private final int verticalSearchRange;
        protected BlockPos destinationBlock;
        private EntityTalpanas crab;
        private int runDelay = 70;
        private int maxFeedTime = 200;

        private DigRootedDirtGoal(EntityTalpanas crab) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.crab = crab;
            this.searchLength = 16;
            this.verticalSearchRange = 6;
        }

        public boolean m_8045_() {
            return this.destinationBlock != null && this.isDigBlock(this.crab.m_9236_(), this.destinationBlock.m_122032_()) && this.isCloseToMoss(16.0);
        }

        public boolean isCloseToMoss(double dist) {
            return this.destinationBlock == null || this.crab.m_20238_(Vec3.m_82512_((Vec3i)this.destinationBlock)) < dist * dist;
        }

        public boolean m_8036_() {
            if (this.runDelay > 0) {
                --this.runDelay;
                return false;
            }
            this.runDelay = 200 + this.crab.f_19796_.m_188503_(150);
            return this.searchForDestination();
        }

        public void m_8056_() {
            this.maxFeedTime = 60 + EntityTalpanas.this.f_19796_.m_188503_(60);
        }

        public void m_8037_() {
            Vec3 vec = Vec3.m_82512_((Vec3i)this.destinationBlock);
            if (vec != null) {
                this.crab.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 1.0);
                if (this.crab.m_20238_(vec) < (double)1.15f) {
                    this.crab.f_19804_.m_135381_(FEEDING_POS, Optional.of(this.destinationBlock));
                    Vec3 face = vec.m_82546_(this.crab.m_20182_());
                    this.crab.m_20256_(this.crab.m_20184_().m_82549_(face.m_82541_().m_82490_((double)0.1f)));
                    this.crab.setFeedingTime(this.crab.getFeedingTime() + 1);
                    this.crab.m_5496_(SoundEvents.f_144206_, this.crab.m_6121_(), this.crab.m_6100_());
                    if (this.crab.getFeedingTime() > this.maxFeedTime) {
                        List<ItemStack> lootList;
                        this.destinationBlock = null;
                        if (EntityTalpanas.this.f_19796_.m_188503_(1) == 0 && (lootList = EntityTalpanas.getDigLoot(this.crab)).size() > 0) {
                            for (ItemStack stack : lootList) {
                                ItemEntity e = this.crab.m_19983_(stack.m_41777_());
                                e.f_19812_ = true;
                                e.m_20256_(e.m_20184_().m_82542_(0.2, 0.2, 0.2));
                            }
                        }
                    }
                } else {
                    this.crab.f_19804_.m_135381_(FEEDING_POS, Optional.empty());
                }
            }
        }

        public void m_8041_() {
            this.crab.f_19804_.m_135381_(FEEDING_POS, Optional.empty());
            this.destinationBlock = null;
            this.crab.setFeedingTime(0);
        }

        protected boolean searchForDestination() {
            int lvt_1_1_ = this.searchLength;
            int lvt_2_1_ = this.verticalSearchRange;
            BlockPos lvt_3_1_ = this.crab.m_20183_();
            BlockPos.MutableBlockPos lvt_4_1_ = new BlockPos.MutableBlockPos();
            for (int lvt_5_1_ = -8; lvt_5_1_ <= 2; ++lvt_5_1_) {
                for (int lvt_6_1_ = 0; lvt_6_1_ < lvt_1_1_; ++lvt_6_1_) {
                    int lvt_7_1_ = 0;
                    while (lvt_7_1_ <= lvt_6_1_) {
                        int lvt_8_1_;
                        int n = lvt_8_1_ = lvt_7_1_ < lvt_6_1_ && lvt_7_1_ > -lvt_6_1_ ? lvt_6_1_ : 0;
                        while (lvt_8_1_ <= lvt_6_1_) {
                            lvt_4_1_.m_122154_((Vec3i)lvt_3_1_, lvt_7_1_, lvt_5_1_ - 1, lvt_8_1_);
                            if (this.isDigBlock(this.crab.m_9236_(), lvt_4_1_) && this.crab.canSeeBlock((BlockPos)lvt_4_1_)) {
                                this.destinationBlock = lvt_4_1_;
                                return true;
                            }
                            lvt_8_1_ = lvt_8_1_ > 0 ? -lvt_8_1_ : 1 - lvt_8_1_;
                        }
                        lvt_7_1_ = lvt_7_1_ > 0 ? -lvt_7_1_ : 1 - lvt_7_1_;
                    }
                }
            }
            return false;
        }

        private boolean isDigBlock(Level world, BlockPos.MutableBlockPos pos) {
            return world.m_8055_((BlockPos)pos).m_204336_(UPTags.TALPANAS_DIGGABLES);
        }
    }

    public class FleeLightGoal
    extends Goal {
        protected final PathfinderMob creature;
        private double shelterX;
        private double shelterY;
        private double shelterZ;
        private final double movementSpeed;
        private final Level world;
        private int executeChance = 50;
        private int lightLevel = 10;

        public FleeLightGoal(PathfinderMob p_i1623_1_, double p_i1623_2_) {
            this.creature = p_i1623_1_;
            this.movementSpeed = p_i1623_2_;
            this.world = p_i1623_1_.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public FleeLightGoal(PathfinderMob p_i1623_1_, double p_i1623_2_, int chance, int level) {
            this.creature = p_i1623_1_;
            this.movementSpeed = p_i1623_2_;
            this.world = p_i1623_1_.m_9236_();
            this.executeChance = chance;
            this.lightLevel = level;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.creature.m_5448_() != null || this.creature.m_217043_().m_188503_(this.executeChance) != 0) {
                return false;
            }
            if (this.world.m_46803_(this.creature.m_20183_()) < this.lightLevel) {
                return false;
            }
            return this.isPossibleShelter();
        }

        protected boolean isPossibleShelter() {
            Vec3 lvt_1_1_ = this.findPossibleShelter();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.shelterX = lvt_1_1_.f_82479_;
            this.shelterY = lvt_1_1_.f_82480_;
            this.shelterZ = lvt_1_1_.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.creature.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.creature.m_21573_().m_26519_(this.shelterX, this.shelterY, this.shelterZ, this.movementSpeed);
        }

        @Nullable
        protected Vec3 findPossibleShelter() {
            RandomSource lvt_1_1_ = this.creature.m_217043_();
            BlockPos lvt_2_1_ = this.creature.m_20183_();
            for (int lvt_3_1_ = 0; lvt_3_1_ < 10; ++lvt_3_1_) {
                BlockPos lvt_4_1_ = lvt_2_1_.m_7918_(lvt_1_1_.m_188503_(20) - 10, lvt_1_1_.m_188503_(6) - 3, lvt_1_1_.m_188503_(20) - 10);
                if (this.creature.m_9236_().m_46803_(lvt_4_1_) >= this.lightLevel) continue;
                return Vec3.m_82539_((Vec3i)lvt_4_1_);
            }
            return null;
        }
    }
}

