/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.peeko32213.unusualprehistory.common.config.UnusualPrehistoryConfig;
import com.peeko32213.unusualprehistory.common.entity.EntityDunkleosteus;
import com.peeko32213.unusualprehistory.common.entity.EntityTyrannosaurusRex;
import com.peeko32213.unusualprehistory.common.entity.IBookEntity;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityScaumenacia
extends AbstractFish
implements Bucketable,
GeoAnimatable,
IBookEntity {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(EntityScaumenacia.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BOOK = SynchedEntityData.m_135353_(EntityScaumenacia.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final RawAnimation SCAU_SWIM = RawAnimation.begin().thenLoop("animation.scaumenacia.move");
    private static final RawAnimation SCAU_FLOP = RawAnimation.begin().thenLoop("animation.scaumenacia.flop");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public EntityScaumenacia(EntityType<? extends AbstractFish> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntityDunkleosteus.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntityTyrannosaurusRex.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean isGolden() {
        String s = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        return s != null && s.toLowerCase().contains("sengoku");
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11758_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11759_;
    }

    protected SoundEvent m_7975_(DamageSource p_28281_) {
        return SoundEvents.f_11761_;
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_11760_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(FROM_BOOK, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromBucket", this.isFromBucket());
        compound.m_128379_("Bucketed", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_27497_(compound.m_128471_("FromBucket"));
        this.m_27497_(compound.m_128471_("Bucketed"));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128350_("Health", this.m_21223_());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double p_213397_1_) {
        return !this.m_27487_() && !this.m_8077_();
    }

    private boolean isFromBucket() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_203706_1_);
    }

    public boolean isFromBook() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BOOK);
    }

    public void setIsFromBook(boolean fromBook) {
        this.f_19804_.m_135381_(FROM_BOOK, (Object)fromBook);
    }

    public void m_142278_(CompoundTag p_148832_) {
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11779_;
    }

    protected InteractionResult m_6071_(Player p_27477_, InteractionHand p_27478_) {
        return Bucketable.m_148828_((Player)p_27477_, (InteractionHand)p_27478_, (LivingEntity)this).orElse(super.m_6071_(p_27477_, p_27478_));
    }

    public ItemStack m_28282_() {
        ItemStack stack = new ItemStack((ItemLike)UPItems.SCAU_BUCKET.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    protected <E extends EntityScaumenacia> PlayState Controller(AnimationState<E> event) {
        if (!(this.isFromBook() || event.getLimbSwingAmount() > -0.06f && event.getLimbSwingAmount() < 0.06f || !this.m_20069_())) {
            event.setAndContinue(SCAU_SWIM);
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_28134_, DifficultyInstance p_28135_, MobSpawnType p_28136_, @Nullable SpawnGroupData p_28137_, @Nullable CompoundTag p_28138_) {
        p_28137_ = super.m_6518_(p_28134_, p_28135_, p_28136_, p_28137_, p_28138_);
        ServerLevel level = p_28134_.m_6018_();
        if (level instanceof ServerLevel) {
            this.m_21530_();
        }
        return p_28137_;
    }

    public static boolean checkSurfaceWaterDinoSpawnRules(EntityType<? extends EntityScaumenacia> pWaterAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int i = pLevel.m_5736_();
        int j = i - 13;
        return pPos.m_123342_() >= j && pPos.m_123342_() <= i && pLevel.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && pLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_) && (Boolean)UnusualPrehistoryConfig.DINO_NATURAL_SPAWNING.get() != false;
    }

    @Override
    public void setFromBook(boolean fromBook) {
        this.f_19804_.m_135381_(FROM_BOOK, (Object)fromBook);
    }
}

