/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.peeko32213.unusualprehistory.common.entity.msc.util.BabyPanicGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRandomStrollGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityAustroraptor
extends EntityBaseDinosaurAnimal {
    private static final EntityDataAccessor<Integer> PREENING_TIME = SynchedEntityData.m_135353_(EntityAustroraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PREENING = SynchedEntityData.m_135353_(EntityAustroraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int timeUntilDrops = this.f_19796_.m_188503_(200) + 400;
    public float prevPreenProgress;
    public float preenProgress;
    public float preenSoundTimer = 100.0f;
    public static final Logger LOGGER = LogManager.getLogger();
    private static final RawAnimation AUSTRO_WALK = RawAnimation.begin().thenLoop("animation.austroraptor.walk");
    private static final RawAnimation AUSTRO_IDLE = RawAnimation.begin().thenLoop("animation.austroraptor.idle");
    private static final RawAnimation AUSTRO_SWIM = RawAnimation.begin().thenLoop("animation.austroraptor.swim");
    private static final RawAnimation AUSTRO_PREEN = RawAnimation.begin().thenPlay("animation.austroraptor.preening");
    private static final RawAnimation AUSTRO_ATTACK = RawAnimation.begin().thenPlay("animation.austroraptor.attack");

    public EntityAustroraptor(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false));
        this.f_21345_.m_25352_(2, (Goal)new IMeleeAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new BabyPanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new CustomRandomStrollGoal((PathfinderMob)this, 30, 1.0, 100, 34){

            @Override
            public boolean m_8036_() {
                Vec3 vec3d;
                if (this.f_25725_.m_20160_()) {
                    return false;
                }
                if (!this.f_25731_) {
                    if (this.f_25725_.m_21216_() >= 100) {
                        return false;
                    }
                    if (((EntityAustroraptor)this.f_25725_).isHungry() ? this.f_25725_.m_217043_().m_188503_(60) != 0 : this.f_25725_.m_217043_().m_188503_(30) != 0) {
                        return false;
                    }
                }
                if ((vec3d = this.m_7037_()) == null) {
                    return false;
                }
                this.f_25726_ = vec3d.f_82479_;
                this.f_25727_ = vec3d.f_82480_;
                this.f_25728_ = vec3d.f_82481_;
                this.f_25731_ = false;
                return true;
            }

            public boolean m_8045_() {
                return !((EntityAustroraptor)this.f_25725_).getIsPreening() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.AUSTRO_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.AUSTRO_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.AUSTRO_DEATH.get();
    }

    public boolean getIsPreening() {
        return (Boolean)this.f_19804_.m_135370_(PREENING);
    }

    public void setIsPreening(boolean preening) {
        this.f_19804_.m_135381_(PREENING, (Object)preening);
    }

    public int getPreeningTime() {
        return (Integer)this.f_19804_.m_135370_(PREENING_TIME);
    }

    public void setPreeningTime(int shaking) {
        this.f_19804_.m_135381_(PREENING_TIME, (Object)shaking);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.getIsPreening()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            pTravelVector = Vec3.f_82478_;
            super.m_7023_(pTravelVector);
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public boolean m_7307_(Entity pEntity) {
        return pEntity.m_7306_((Entity)this);
    }

    @Override
    public boolean m_7327_(Entity target) {
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        float knockback = (float)this.m_21133_(Attributes.f_22282_);
        boolean shouldHurt = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage);
        if (shouldHurt) {
            if (knockback > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, target);
            this.m_21335_(target);
            this.setPreeningTime(0);
        }
        return shouldHurt;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PREENING_TIME, (Object)0);
        this.f_19804_.m_135372_(PREENING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("DropTime", this.timeUntilDrops);
        compound.m_128405_("preeningTime", this.getPreeningTime());
        compound.m_128379_("isPreening", this.getIsPreening());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setPreeningTime(compound.m_128451_("preeningTime"));
        this.setIsPreening(compound.m_128471_("isPreening"));
        if (compound.m_128441_("SpitTime")) {
            this.timeUntilDrops = compound.m_128451_("DropTime");
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevPreenProgress = this.preenProgress;
        if (this.f_19796_.m_188503_(5000) == 0 && !this.getIsPreening()) {
            this.setPreeningTime(100 + this.f_19796_.m_188503_(30));
            this.setIsPreening(true);
        }
        if (this.getPreeningTime() <= 0 && this.getIsPreening()) {
            this.setIsPreening(false);
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8056_);
        }
        if (this.getIsPreening()) {
            this.setPreeningTime(this.getPreeningTime() - 1);
            this.m_21573_().m_26573_();
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
            if (this.preenSoundTimer <= 0.0f) {
                this.preenSoundTimer = 100.0f;
            }
            if (this.preenSoundTimer >= 100.0f) {
                this.m_5496_((SoundEvent)UPSounds.AUSTRO_PREEN.get(), 0.1f, 1.0f);
            }
            this.preenSoundTimer -= 1.0f;
            if (this.f_19796_.m_188503_(90) == 0) {
                this.m_19998_((ItemLike)UPItems.AUSTRO_FEATHER.get());
            }
        }
    }

    @Override
    protected SoundEvent getAttackSound() {
        return (SoundEvent)UPSounds.AUSTRO_BITE.get();
    }

    @Override
    protected int getKillHealAmount() {
        return 5;
    }

    @Override
    protected boolean canGetHungry() {
        return true;
    }

    @Override
    protected boolean hasTargets() {
        return true;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return true;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return UPTags.RAPTOR_TARGETS;
    }

    private void attack(LivingEntity entity) {
        entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 5.0f);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    protected <E extends EntityAustroraptor> PlayState Controller(AnimationState<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6 && !this.m_6069_()) {
            event.setAndContinue(AUSTRO_WALK);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (!this.m_20069_()) {
            event.setAndContinue(AUSTRO_IDLE);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        event.setAndContinue(AUSTRO_SWIM);
        event.getController().setAnimationSpeed(1.0);
        return PlayState.CONTINUE;
    }

    protected <E extends EntityAustroraptor> PlayState attackController(AnimationState<E> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.PAUSED)) {
            return event.setAndContinue(AUSTRO_ATTACK);
        }
        return PlayState.CONTINUE;
    }

    protected <E extends EntityAustroraptor> PlayState preenController(AnimationState<E> event) {
        if (this.getIsPreening() && !this.m_20069_()) {
            event.setAndContinue(AUSTRO_PREEN);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Attack", 3, this::attackController)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Preen", 5, this::preenController)});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public double getTick(Object o) {
        return this.f_19797_;
    }

    class IMeleeAttackGoal
    extends MeleeAttackGoal {
        public IMeleeAttackGoal() {
            super((PathfinderMob)EntityAustroraptor.this, 1.6, true);
        }

        protected double m_6639_(LivingEntity p_25556_) {
            return this.f_25540_.m_20205_() * 2.0f * this.f_25540_.m_20205_() * 0.66f + p_25556_.m_20205_();
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25565_() <= 0) {
                this.m_25563_();
                ((EntityAustroraptor)this.f_25540_).setHungry(false);
                ((EntityAustroraptor)this.f_25540_).attack(enemy);
                ((EntityAustroraptor)this.f_25540_).setTimeTillHungry(this.f_25540_.m_217043_().m_188503_(300) + 300);
            }
        }
    }
}

