/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.peeko32213.unusualprehistory.common.data.RollableItemCodec;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;

public class LootFruitCodec {
    public static Codec<LootFruitCodec> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("tier").forGetter(t -> t.tier), (App)Codec.STRING.fieldOf("translation_key").forGetter(t -> t.translationKey), (App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("trade_item").forGetter(t -> t.tradeItem), (App)RollableItemCodec.CODEC.listOf().fieldOf("items").forGetter(i -> i.items), (App)TextColor.f_237295_.fieldOf("color").forGetter(c -> c.color), (App)Codec.INT.fieldOf("CustomModelData").forGetter(m -> m.customModelData)).apply((Applicative)inst, LootFruitCodec::new));
    private final int tier;
    private final String translationKey;
    private final List<RollableItemCodec> items;
    private final Item tradeItem;
    private final TextColor color;
    private final int customModelData;

    public LootFruitCodec(int tier, String translationKey, Item tradeItem, List<RollableItemCodec> items, TextColor color, int customModelData) {
        this.tier = tier;
        this.translationKey = translationKey;
        this.items = items;
        this.color = color;
        this.tradeItem = tradeItem;
        this.customModelData = customModelData;
    }

    public int getTier() {
        return this.tier;
    }

    public Item getTradeItem() {
        return this.tradeItem;
    }

    public List<RollableItemCodec> getItems() {
        return this.items;
    }

    public TextColor getColor() {
        return this.color;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public static <T> Map<T, List<LootFruitCodec>> convertToMap(Map<T, List<LootFruitCodec>> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(lootFruitCodec -> new LootFruitCodec(lootFruitCodec.getTier(), lootFruitCodec.getTranslationKey(), lootFruitCodec.getTradeItem(), lootFruitCodec.getItems(), lootFruitCodec.getColor(), lootFruitCodec.getCustomModelData())).collect(Collectors.toList())));
    }

    public static <T> Map<T, List<LootFruitCodec>> convertFromMap(Map<T, List<LootFruitCodec>> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(lootFruit -> new LootFruitCodec(lootFruit.getTier(), lootFruit.getTranslationKey(), lootFruit.getTradeItem(), lootFruit.getItems(), lootFruit.getColor(), lootFruit.getCustomModelData())).collect(Collectors.toList())));
    }
}

