/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.capabilities;

import com.peeko32213.unusualprehistory.common.capabilities.UPCapabilities;
import com.peeko32213.unusualprehistory.common.message.AmberProtectionSyncS2CPacket;
import com.peeko32213.unusualprehistory.core.registry.UPMessages;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UPPlayerCapability
implements INBTSerializable<CompoundTag> {
    public static final Logger LOGGER = LogManager.getLogger();
    public int amberProtection = 0;

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("amberProtection", this.amberProtection);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.amberProtection = nbt.m_128451_("amberProtection");
    }

    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(UPCapabilities.PLAYER_CAPABILITY).ifPresent(oldStore -> event.getOriginal().getCapability(UPCapabilities.PLAYER_CAPABILITY).ifPresent(newStore -> {
                newStore.amberProtection = oldStore.amberProtection;
            }));
        }
    }

    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            serverPlayer.getCapability(UPCapabilities.PLAYER_CAPABILITY).ifPresent(capability -> {
                if (capability.amberProtection == 0) {
                    return;
                }
                int damage = (int)event.getAmount();
                LOGGER.info("damage " + damage);
                for (int i = 0; i < damage; ++i) {
                    if ((float)capability.amberProtection >= serverPlayer.m_21223_()) {
                        --capability.amberProtection;
                        LOGGER.info("doing damage to amber");
                    } else {
                        serverPlayer.m_21153_(serverPlayer.m_21223_() - 1.0f);
                        LOGGER.info("doing damage to hp");
                    }
                    UPMessages.sendToPlayer(new AmberProtectionSyncS2CPacket(capability.amberProtection), serverPlayer);
                }
                event.setCanceled(true);
            });
        }
    }

    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.getCapability(UPCapabilities.PLAYER_CAPABILITY).ifPresent(capability -> UPMessages.sendToPlayer(new AmberProtectionSyncS2CPacket(capability.amberProtection), player));
        }
    }
}

