/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.client.screen.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Axis;
import com.peeko32213.unusualprehistory.UnusualPrehistory;
import com.peeko32213.unusualprehistory.client.screen.LinkPlantButton;
import com.peeko32213.unusualprehistory.client.screen.PlantLinkData;
import com.peeko32213.unusualprehistory.client.screen.util.BookBlit;
import com.peeko32213.unusualprehistory.client.screen.util.BookPageButton;
import com.peeko32213.unusualprehistory.client.screen.util.EntityLinkData;
import com.peeko32213.unusualprehistory.client.screen.util.ItemRenderData;
import com.peeko32213.unusualprehistory.client.screen.util.LineData;
import com.peeko32213.unusualprehistory.client.screen.util.LinkButton;
import com.peeko32213.unusualprehistory.client.screen.util.LinkData;
import com.peeko32213.unusualprehistory.client.screen.util.Whitespace;
import com.peeko32213.unusualprehistory.common.data.EncyclopediaCodec;
import com.peeko32213.unusualprehistory.common.data.EncyclopediaJsonManager;
import com.peeko32213.unusualprehistory.common.data.EncyclopediaPictureCodec;
import com.peeko32213.unusualprehistory.common.data.EntityIndexCodec;
import com.peeko32213.unusualprehistory.common.data.EntityRenderDataCodec;
import com.peeko32213.unusualprehistory.common.data.PlantIndexCodec;
import com.peeko32213.unusualprehistory.common.data.RecipeCodec;
import com.peeko32213.unusualprehistory.common.entity.IBookEntity;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BookScreen
extends Screen {
    public static final ResourceLocation BOOK_LOCATION = UnusualPrehistory.prefix("textures/gui/book/book_pages.png");
    public static final ResourceLocation BOOK_BIND = UnusualPrehistory.prefix("textures/gui/book/book_binding.png");
    private static final ResourceLocation BOOK_WIDGET_TEXTURE = new ResourceLocation("unusualprehistory:textures/gui/book/widgets.png");
    private final List<EncyclopediaCodec> encyclopediaEntries = EncyclopediaJsonManager.getEncyclopediaEntries().values().stream().toList();
    private List<FormattedCharSequence> cachedPageComponents = Collections.emptyList();
    private List<FormattedCharSequence> nextPageComponents = Collections.emptyList();
    private EncyclopediaCodec currentEntry;
    private List<EncyclopediaPictureCodec> pictures;
    private BookPageButton buttonNextPage;
    private BookPageButton buttonPreviousPage;
    private int page = 0;
    protected int xSize = 390;
    protected int ySize = 320;
    protected int nextPageToStartNr;
    protected int nextPageToStartNrCache;
    protected int previousStartNrCache;
    private int currentPage;
    private ResourceLocation currentResourceLocation;
    private List<RecipeCodec> recipes;
    private Map<Integer, Integer> previousMap = new HashMap<Integer, Integer>();
    private final List<EntityRenderDataCodec> entityRenders = new ArrayList<EntityRenderDataCodec>();
    private final List<EntityLinkData> entityLinkData = new ArrayList<EntityLinkData>();
    private final List<PlantLinkData> plantLinkData = new ArrayList<PlantLinkData>();
    private final Map<String, Entity> renderedEntites = new HashMap<String, Entity>();
    private final List<ItemRenderData> itemRenders = new ArrayList<ItemRenderData>();
    private final List<LineData> lines = new ArrayList<LineData>();
    private String pageToGo = "root";
    protected int linesFromJSON = 0;
    protected int linesFromPrinting = 0;
    protected int maxPagesFromPrinting = 0;
    protected ResourceLocation currentPageText = null;
    private final List<Whitespace> yIndexesToSkip = new ArrayList<Whitespace>();
    private String writtenTitle;
    private final List<LinkData> links = new ArrayList<LinkData>();
    private int mouseX;
    private int mouseY;
    private List<EntityIndexCodec> entityIndex;
    private List<PlantIndexCodec> plantIndex;
    private String entityTooltip;
    private static final Quaternionf ENTITY_ROTATION = new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(130.0), (float)Math.PI);

    public BookScreen(ResourceLocation resourceLocation, int currentPage) {
        super((Component)Component.m_237115_((String)"encyclopedia.title"));
        this.currentResourceLocation = resourceLocation;
        this.currentEntry = resourceLocation.equals((Object)UnusualPrehistory.prefix("root")) ? EncyclopediaJsonManager.getRootPage() : EncyclopediaJsonManager.getEncyclopediaEntries().get(resourceLocation);
        if (resourceLocation.equals((Object)UnusualPrehistory.prefix("plants"))) {
            EncyclopediaJsonManager.getEncyclopediaEntries().values().forEach(encyclopediaCodec -> encyclopediaCodec.getPlantButtons().forEach(plantLinkData -> this.plantLinkData.add((PlantLinkData)plantLinkData)));
            Collections.sort(this.plantLinkData, Comparator.comparing(PlantLinkData::getPlant));
        }
        if (resourceLocation.equals((Object)UnusualPrehistory.prefix("dinosaurs"))) {
            EncyclopediaJsonManager.getEncyclopediaEntries().values().forEach(encyclopediaCodec -> encyclopediaCodec.getEntityButtons().forEach(entityRenderDataCodec -> this.entityLinkData.add((EntityLinkData)entityRenderDataCodec)));
            Collections.sort(this.entityLinkData, Comparator.comparing(EntityLinkData::getEntity));
        }
        if (this.currentEntry == null) {
            this.currentEntry = EncyclopediaJsonManager.getEncyclopediaEntries().get(UnusualPrehistory.prefix("help"));
        }
        this.pageToGo = this.currentEntry.getPageToGo();
        this.entityRenders.clear();
        this.entityRenders.addAll(this.currentEntry.getEntityRenders());
        this.entityIndex = this.currentEntry.getEntityIndex();
        this.plantIndex = this.currentEntry.getPlantIndex();
        this.pictures = this.currentEntry.getPictures();
        this.currentPage = currentPage;
        this.recipes = this.currentEntry.getRecipes();
        this.writtenTitle = this.currentEntry.getTitle();
        this.links.clear();
        this.links.addAll(this.currentEntry.getLinkButtons());
        this.itemRenders.clear();
        this.itemRenders.addAll(this.currentEntry.getItemRenders());
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float partialTicks) {
        double entries;
        double entriesFirstPage;
        this.mouseX = pMouseX;
        this.mouseY = pMouseY;
        int color = this.getBindingColor();
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        this.m_280273_(guiGraphics);
        int i = (this.f_96543_ - this.xSize) / 2;
        int p = (this.f_96544_ - this.ySize + 128) / 2;
        int maxHeight = p + 162;
        int maxWidth = this.xSize + 30;
        BookBlit.blitWithColor(guiGraphics, BOOK_BIND, i, p, 0.0f, 0.0f, this.xSize, this.ySize, this.xSize, this.ySize, r, g, b, 255);
        BookBlit.blitWithColor(guiGraphics, BOOK_LOCATION, i, p, 0.0f, 0.0f, this.xSize, this.ySize, this.xSize, this.ySize, 255, 255, 255, 255);
        for (EncyclopediaPictureCodec pictures : this.pictures) {
            if (pictures.getPageNr() != this.currentPage) continue;
            int offsetX = pictures.getxLocation();
            int offsetY = pictures.getyLocation();
            int xSize = pictures.getXSize();
            int ySize = pictures.getYSize();
            this.addPicture(guiGraphics, offsetX, offsetY, xSize, ySize, pictures.getPictureLocation());
        }
        this.refreshSpacing();
        for (LineData line : this.lines) {
            if (line.getPage() != this.currentPage) continue;
            guiGraphics.m_280056_(this.f_96547_, line.getText(), i + 10 + line.getxIndex(), p + 10 + line.getyIndex() * 12, this.getTextColor(), false);
        }
        for (LineData lines : this.lines) {
            if (this.nextPageToStartNrCache >= lines.getPage()) continue;
            this.nextPageToStartNrCache = lines.getPage();
        }
        if (this.currentResourceLocation.equals((Object)UnusualPrehistory.prefix("dinosaurs"))) {
            double dataSize = this.entityLinkData.size();
            for (EntityIndexCodec linkData : this.entityIndex) {
                double entriesPerPage = linkData.getColums() * linkData.getRows() * 2;
                entriesFirstPage = linkData.getColums() * linkData.getRows();
                entries = dataSize / entriesPerPage;
                if (dataSize < entriesFirstPage) {
                    this.nextPageToStartNrCache = 0;
                    continue;
                }
                this.nextPageToStartNrCache = linkData.getPageNr() + Mth.m_14165_((double)entries);
            }
        }
        if (this.currentResourceLocation.equals((Object)UnusualPrehistory.prefix("plants"))) {
            double dataSize = this.plantLinkData.size();
            for (PlantIndexCodec linkData : this.plantIndex) {
                double entriesPerPage = linkData.getColums() * linkData.getRows() * 2;
                entriesFirstPage = linkData.getColums() * linkData.getRows();
                entries = dataSize / entriesPerPage;
                if (dataSize < entriesFirstPage) {
                    this.nextPageToStartNrCache = 0;
                    continue;
                }
                this.nextPageToStartNrCache = linkData.getPageNr() + Mth.m_14165_((double)entries);
            }
        }
        this.addNextPreviousButtons();
        this.writePageText(guiGraphics);
        super.m_88315_(guiGraphics, pMouseX, pMouseY, partialTicks);
        this.addWidgets(guiGraphics);
        if (this.entityTooltip != null) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 550.0f);
            guiGraphics.m_280245_(this.f_96547_, Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237115_((String)this.entityTooltip), Math.max(this.f_96543_ / 2 - 43, 170)), pMouseX, pMouseY);
            this.entityTooltip = null;
            guiGraphics.m_280168_().m_85849_();
        }
        this.addNextPreviousButtons();
        this.addLinkButtons();
    }

    public ResourceLocation getBookWidgetTexture() {
        return BOOK_WIDGET_TEXTURE;
    }

    protected int getBindingColor() {
        return 6961942;
    }

    public int getWidgetColor() {
        return this.getBindingColor();
    }

    protected int getTextColor() {
        return 0x303030;
    }

    protected int getTitleColor() {
        return 12233880;
    }

    public String getTextFileDirectory() {
        return "unusualprehistory:encyclopedia/";
    }

    public void addPicture(GuiGraphics graphics, int offsetX, int offsetY, int sizeX, int sizeY, ResourceLocation resourceLocation) {
        int i = (this.f_96543_ - this.xSize) / 2;
        int p = (this.f_96544_ - this.ySize + 128) / 2;
        BookBlit.blitWithColor(graphics, resourceLocation, i + offsetX, p + offsetY, 0, 0, sizeX, sizeY, sizeX, sizeY, 0, 0);
    }

    public boolean checkOffsets(int currentHeight, int currentWidth, int heightToSkipStart, int heightToSkipEnd, int widthToSkipStart, int widthToSkipEnd) {
        boolean isHeightInRange;
        int i = (this.f_96543_ - this.xSize) / 2;
        int p = (this.f_96544_ - this.ySize + 128) / 2;
        int maxWidth = 385;
        boolean bl = isHeightInRange = currentHeight >= p + heightToSkipStart && currentHeight <= p + heightToSkipEnd;
        if (currentWidth < maxWidth / 2 - 10) {
            if (widthToSkipStart > maxWidth / 2 - 10) {
                return false;
            }
            boolean isWidthInRange = currentWidth <= i + widthToSkipStart;
            return isHeightInRange && isWidthInRange;
        }
        if (currentWidth >= maxWidth / 2 - 10) {
            if (widthToSkipStart < maxWidth / 2 - 10) {
                return false;
            }
            boolean isWidthInRange = currentWidth <= i + widthToSkipStart;
            return isHeightInRange && isWidthInRange;
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    private void addWidgets(GuiGraphics graphics) {
        CompoundTag tag;
        int k = (this.f_96543_ - this.xSize) / 2;
        int l = (this.f_96544_ - this.ySize + 128) / 2;
        PoseStack matrixStack = graphics.m_280168_();
        for (RecipeCodec recipeData : this.recipes) {
            if (recipeData.getPageNr() != this.currentPage) continue;
            matrixStack.m_85836_();
            matrixStack.m_252880_((float)(k + recipeData.getXLocation()), (float)(l + recipeData.getYLocation()), 0.0f);
            float scale = (float)recipeData.getScale();
            matrixStack.m_85841_(scale, scale, scale);
            RenderSystem.setShader(GameRenderer::m_172817_);
            graphics.m_280218_(this.getBookWidgetTexture(), 0, 0, 0, 88, 116, 53);
            matrixStack.m_85849_();
        }
        for (ItemRenderData itemRenderData : this.itemRenders) {
            Item item;
            if (itemRenderData.getPage() != this.currentPage || (item = BookScreen.getItemByRegistryName(itemRenderData.getItem())) == null) continue;
            float scale = (float)itemRenderData.getScale();
            ItemStack stack = new ItemStack((ItemLike)item);
            if (itemRenderData.getItemTag() != null && !itemRenderData.getItemTag().isEmpty()) {
                tag = null;
                try {
                    tag = TagParser.m_129359_((String)itemRenderData.getItemTag());
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
                stack.m_41751_(tag);
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)k, (float)l, 0.0f);
            graphics.m_280168_().m_85841_(scale, scale, scale);
            graphics.m_280480_(stack, itemRenderData.getX(), itemRenderData.getY());
            graphics.m_280168_().m_85849_();
        }
        for (EntityRenderDataCodec data : this.entityRenders) {
            if (data.getPage() != this.currentPage) continue;
            Entity model = null;
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(data.getEntity()));
            if (type != null) {
                model = this.renderedEntites.putIfAbsent(data.getEntity(), type.m_20615_((Level)Minecraft.m_91087_().f_91073_));
            }
            if (model == null) continue;
            float scale = (float)data.getScale();
            model.f_19797_ = Minecraft.m_91087_().f_91074_.f_19797_;
            if (data.getEntityData() != null && !data.getEntityData().equals("")) {
                try {
                    tag = TagParser.m_129359_((String)data.getEntityData());
                    model.m_20258_(tag);
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
            BookScreen.drawEntityOnScreen(graphics, k + data.getX(), l + data.getY(), 30.0f * scale, data.isFollow_cursor(), data.getRot_x(), data.getRot_y(), data.getRot_z(), this.mouseX, this.mouseY, (LivingEntity)model);
        }
        for (RecipeCodec recipeData : this.recipes) {
            Recipe recipe;
            if (recipeData.getPageNr() != this.currentPage || (recipe = this.getRecipeByName(recipeData.getRecipe())) == null) continue;
            this.renderRecipe(graphics, recipe, recipeData, k, l);
        }
        for (ItemRenderData itemRenderData : this.itemRenders) {
            if (itemRenderData.getPage() != this.currentPage) continue;
        }
    }

    protected void renderRecipe(GuiGraphics guiGraphics, Recipe recipe, RecipeCodec recipeData, int k, int l) {
        int playerTicks = Minecraft.m_91087_().f_91074_.f_19797_;
        float scale = (float)recipeData.getScale();
        NonNullList ingredients = recipe.m_7527_();
        NonNullList displayedStacks = NonNullList.m_122779_();
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ing = (Ingredient)ingredients.get(i);
            ItemStack stack = ItemStack.f_41583_;
            if (!ing.m_43947_()) {
                if (ing.m_43908_().length > 1) {
                    int currentIndex = (int)((float)playerTicks / 20.0f % (float)ing.m_43908_().length);
                    stack = ing.m_43908_()[currentIndex];
                } else {
                    stack = ing.m_43908_()[0];
                }
            }
            if (!stack.m_41619_()) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)k, (float)l, 32.0f);
                guiGraphics.m_280168_().m_252880_((float)((int)((float)recipeData.getXLocation() + (float)(i % 3 * 20) * scale)), (float)((int)((float)recipeData.getYLocation() + (float)(i / 3 * 20) * scale)), 0.0f);
                guiGraphics.m_280168_().m_85841_(scale, scale, scale);
                guiGraphics.m_280480_(stack, 0, 0);
                guiGraphics.m_280168_().m_85849_();
            }
            displayedStacks.add(i, (Object)stack);
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)k, (float)l, 32.0f);
        float finScale = scale * 1.5f;
        guiGraphics.m_280168_().m_252880_((float)recipeData.getXLocation() + 70.0f * finScale, (float)recipeData.getYLocation() + 10.0f * finScale, 0.0f);
        guiGraphics.m_280168_().m_85841_(finScale, finScale, finScale);
        ItemStack result = recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_());
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        guiGraphics.m_280480_(result, 0, 0);
        guiGraphics.m_280168_().m_85849_();
    }

    private static Item getItemByRegistryName(String registryName) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
    }

    public static void drawItemOnScreen(GuiGraphics graphics, int posX, int posY, float scale, boolean follow, double xRot, double yRot, double zRot, float mouseX, float mouseY, ItemRenderData itemRenderData) {
        PoseStack matrixStack = graphics.m_280168_();
        Item item = BookScreen.getItemByRegistryName(itemRenderData.getItem());
        if (item != null) {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (itemRenderData.getItemTag() != null && !itemRenderData.getItemTag().isEmpty()) {
                CompoundTag tag = null;
                try {
                    tag = TagParser.m_129359_((String)itemRenderData.getItemTag());
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
                stack.m_41751_(tag);
            }
            matrixStack.m_85836_();
            PoseStack poseStack = RenderSystem.getModelViewStack();
            poseStack.m_85836_();
            poseStack.m_252880_((float)posX, (float)posY, 0.0f);
            poseStack.m_85841_(scale, scale, scale);
            graphics.m_280480_(stack, itemRenderData.getX(), itemRenderData.getY());
            poseStack.m_85849_();
            matrixStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void drawEntityOnScreen(GuiGraphics graphics, int posX, int posY, float scale, boolean follow, double xRot, double yRot, double zRot, float mouseX, float mouseY, LivingEntity entity) {
        if (entity instanceof IBookEntity) {
            IBookEntity bookEntity = (IBookEntity)entity;
            bookEntity.setFromBook(true);
        }
        PoseStack posestack = graphics.m_280168_();
        posestack.m_85836_();
        posestack.m_252880_((float)posX, (float)posY, 100.0f);
        posestack.m_252931_(new Matrix4f().scaling(scale, scale, -scale));
        Quaternionf quaternion = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf quaternion1 = Axis.f_252529_.m_252977_(0.0f);
        quaternion.mul((Quaternionfc)quaternion1);
        posestack.m_252781_(quaternion);
        posestack.m_252781_(Axis.f_252529_.m_252977_((float)xRot + 125.0f));
        posestack.m_252781_(Axis.f_252436_.m_252977_((float)yRot + 100.0f));
        posestack.m_252781_(Axis.f_252403_.m_252977_((float)zRot));
        posestack.m_252781_(quaternion);
        Vector3f light0 = new Vector3f(1.0f, -1.0f, -1.0f).normalize();
        Vector3f light1 = new Vector3f(-1.0f, 1.0f, 1.0f).normalize();
        RenderSystem.setShaderLights((Vector3f)light0, (Vector3f)light1);
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        quaternion1.conjugate();
        entityrenderdispatcher.m_252923_(quaternion1);
        entityrenderdispatcher.m_114468_(true);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0));
        multibuffersource$buffersource.m_109911_();
        entityrenderdispatcher.m_114468_(false);
        entity.m_146922_(0.0f);
        entity.m_146926_(0.0f);
        entity.f_20883_ = 0.0f;
        entity.f_20886_ = 0.0f;
        entity.f_20885_ = 0.0f;
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }

    public static void drawEntityOnScreenCopy(GuiGraphics graphics, int posX, int posY, float scale, boolean follow, double xRot, double yRot, double zRot, float mouseX, float mouseY, LivingEntity entity) {
        if (entity instanceof IBookEntity) {
            IBookEntity bookEntity = (IBookEntity)entity;
            bookEntity.setFromBook(true);
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_((double)posX, (double)posY, 50.0);
        graphics.m_280168_().m_252931_(new Matrix4f().scaling(scale, scale, -scale));
        graphics.m_280168_().m_252781_(ENTITY_ROTATION);
        Vector3f light0 = new Vector3f(1.0f, -1.0f, -1.0f).normalize();
        Vector3f light1 = new Vector3f(-1.0f, 1.0f, 1.0f).normalize();
        RenderSystem.setShaderLights((Vector3f)light0, (Vector3f)light1);
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        entityrenderdispatcher.m_114468_(false);
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, graphics.m_280168_(), (MultiBufferSource)graphics.m_280091_(), 0xF000F0));
        graphics.m_280262_();
        entityrenderdispatcher.m_114468_(true);
        graphics.m_280168_().m_85849_();
        Lighting.m_84931_();
    }

    private void addLinkButtons() {
        Object linkData;
        int i;
        int startingOffsetY;
        int startingOffsetX;
        int startingSize;
        int startingEntity;
        int linkDataSize;
        this.f_169369_.clear();
        this.m_169413_();
        this.addNextPreviousButtons();
        int k = (this.f_96543_ - this.xSize) / 2;
        int l = (this.f_96544_ - this.ySize + 128) / 2;
        for (LinkData linkData2 : this.links) {
            if (linkData2.getPage() == this.currentPage) {
                int maxLength = Math.max(100, Minecraft.m_91087_().f_91062_.m_92895_(linkData2.getTitleText()) + 20);
                this.yIndexesToSkip.add(new Whitespace(linkData2.getPage(), linkData2.getX() - maxLength / 2, linkData2.getY(), 100, 20));
                this.m_142416_((GuiEventListener)new ExtendedButton(k + linkData2.getX() - maxLength / 2, l + linkData2.getY(), maxLength, 20, (Component)Component.m_237115_((String)linkData2.getTitleText()), p_213021_1_ -> {
                    Minecraft.m_91087_().m_91152_((Screen)new BookScreen(new ResourceLocation(linkData.linked_page), 0));
                    this.addNextPreviousButtons();
                }));
            }
            if (linkData2.getPage() <= this.maxPagesFromPrinting) continue;
            this.maxPagesFromPrinting = linkData2.getPage();
        }
        if (this.currentResourceLocation.equals((Object)UnusualPrehistory.prefix("dinosaurs"))) {
            int rowCount = 0;
            int columnCount = 0;
            EntityIndexCodec entityIndex = this.entityIndex.get(0);
            linkDataSize = this.entityLinkData.size();
            startingEntity = 0;
            if (this.currentPage != entityIndex.getPageNr()) {
                startingSize = entityIndex.getColums() * entityIndex.getRows();
                startingEntity = this.currentPage == entityIndex.getPageNr() + 1 ? linkDataSize - (linkDataSize - startingSize * (this.currentPage - entityIndex.getPageNr())) : linkDataSize - (linkDataSize - startingSize * (this.currentPage - entityIndex.getPageNr() * 2) * 2);
                if (startingEntity < 0) {
                    return;
                }
            }
            startingOffsetX = 16;
            startingOffsetY = 16;
            if (this.currentPage == entityIndex.getPageNr()) {
                startingOffsetX += entityIndex.getxLocation();
            }
            startingOffsetY += entityIndex.getyLocation();
            if (this.currentPage < entityIndex.getPageNr()) {
                return;
            }
            for (i = startingEntity; i < linkDataSize; ++i) {
                linkData = this.entityLinkData.get(i);
                if (rowCount == entityIndex.getRows() || this.currentPage != entityIndex.getPageNr() && i > startingEntity + entityIndex.getColums() * entityIndex.getRows() * 2) break;
                this.yIndexesToSkip.add(new Whitespace(this.currentPage, (int)((double)startingOffsetX + ((double)(columnCount * 24) * ((EntityLinkData)linkData).getScale() - 12.0)), (int)((double)(startingOffsetY + l) + (double)(rowCount * 24) * ((EntityLinkData)linkData).getScale()), 100, 20));
                this.m_142416_((GuiEventListener)new LinkButton(this, (EntityLinkData)linkData, (int)((double)(startingOffsetX + k) + (double)(columnCount * 24) * ((EntityLinkData)linkData).getScale()), (int)((double)(startingOffsetY + l) + (double)(rowCount * 24) * ((EntityLinkData)linkData).getScale()), arg_0 -> this.lambda$addLinkButtons$7((EntityLinkData)linkData, arg_0)));
                if (((EntityLinkData)linkData).getPage() > this.maxPagesFromPrinting) {
                    this.maxPagesFromPrinting = ((EntityLinkData)linkData).getPage();
                }
                if (++columnCount == entityIndex.getColums()) {
                    ++rowCount;
                    columnCount = 0;
                }
                if (entityIndex.getPageNr() != this.currentPage && rowCount >= entityIndex.getRows()) {
                    startingOffsetX = 216;
                    columnCount = 0;
                    rowCount = 0;
                }
                if (rowCount == entityIndex.getRows()) break;
            }
        }
        if (this.currentResourceLocation.equals((Object)UnusualPrehistory.prefix("plants"))) {
            int rowCount = 0;
            int columnCount = 0;
            PlantIndexCodec plantIndex = this.plantIndex.get(0);
            linkDataSize = this.plantLinkData.size();
            startingEntity = 0;
            if (this.currentPage != plantIndex.getPageNr()) {
                startingSize = plantIndex.getColums() * plantIndex.getRows();
                startingEntity = this.currentPage == plantIndex.getPageNr() + 1 ? linkDataSize - (linkDataSize - startingSize * (this.currentPage - plantIndex.getPageNr())) : linkDataSize - (linkDataSize - startingSize * (this.currentPage - plantIndex.getPageNr() * 2) * 2);
                if (startingEntity < 0) {
                    return;
                }
            }
            startingOffsetX = 16;
            startingOffsetY = 16;
            if (this.currentPage == plantIndex.getPageNr()) {
                startingOffsetX += plantIndex.getxLocation();
            }
            startingOffsetY += plantIndex.getyLocation();
            if (this.currentPage < plantIndex.getPageNr()) {
                return;
            }
            for (i = startingEntity; i < linkDataSize; ++i) {
                linkData = this.plantLinkData.get(i);
                if (rowCount == plantIndex.getRows() || this.currentPage != plantIndex.getPageNr() && i > startingEntity + plantIndex.getColums() * plantIndex.getRows() * 2) break;
                this.yIndexesToSkip.add(new Whitespace(this.currentPage, (int)((double)startingOffsetX + ((double)(columnCount * 24) * ((PlantLinkData)linkData).getScale() - 12.0)), (int)((double)(startingOffsetY + l) + (double)(rowCount * 24) * ((PlantLinkData)linkData).getScale()), 100, 20));
                this.m_142416_((GuiEventListener)new LinkPlantButton(this, (PlantLinkData)linkData, (int)((double)(startingOffsetX + k) + (double)(columnCount * 24) * ((PlantLinkData)linkData).getScale()), (int)((double)(startingOffsetY + l) + (double)(rowCount * 24) * ((PlantLinkData)linkData).getScale()), arg_0 -> this.lambda$addLinkButtons$8((PlantLinkData)linkData, arg_0)));
                if (((PlantLinkData)linkData).getPage() > this.maxPagesFromPrinting) {
                    this.maxPagesFromPrinting = ((PlantLinkData)linkData).getPage();
                }
                if (++columnCount == plantIndex.getColums()) {
                    ++rowCount;
                    columnCount = 0;
                }
                if (plantIndex.getPageNr() != this.currentPage && rowCount >= plantIndex.getRows()) {
                    startingOffsetX = 216;
                    columnCount = 0;
                    rowCount = 0;
                }
                if (rowCount == plantIndex.getRows()) break;
            }
        }
    }

    private Recipe getRecipeByName(ResourceLocation registryName) {
        try {
            RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
            if (manager.m_44043_(registryName).isPresent()) {
                return (Recipe)manager.m_44043_(registryName).get();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void refreshSpacing() {
        if (this.currentEntry != null) {
            String lang = Minecraft.m_91087_().m_91102_().m_264236_().toLowerCase();
            this.currentPageText = new ResourceLocation(this.getTextFileDirectory() + lang + "/" + this.currentEntry.getTextLocation());
            boolean invalid = false;
            try {
                InputStream is = Minecraft.m_91087_().m_91098_().m_215595_(this.currentPageText);
                is.close();
            }
            catch (Exception e) {
                invalid = true;
                UnusualPrehistory.LOGGER.warn("Could not find language file for translation, defaulting to English");
                this.currentPageText = new ResourceLocation(this.getTextFileDirectory() + "en_us/" + this.currentEntry.getTextLocation());
            }
            this.addNextPreviousButtons();
            this.addWidgetSpacing();
            this.readInPageText(this.currentPageText);
        }
    }

    protected void writePageText(GuiGraphics guiGraphics) {
        Font font = this.f_96547_;
        int k = (this.f_96543_ - this.xSize) / 2;
        int l = (this.f_96544_ - this.ySize + 128) / 2;
        for (LineData line : this.lines) {
            if (line.getPage() != this.currentPage) continue;
            guiGraphics.m_280056_(font, line.getText(), k + 10 + line.getxIndex(), l + 10 + line.getyIndex() * 12, this.getTextColor(), false);
        }
        if (this.currentPage == 0 && !this.writtenTitle.isEmpty()) {
            String actualTitle = I18n.m_118938_((String)this.writtenTitle, (Object[])new Object[0]);
            guiGraphics.m_280168_().m_85836_();
            float scale = 2.0f;
            if (font.m_92895_(actualTitle) > 80) {
                scale = 2.0f - Mth.m_14036_((float)((float)(font.m_92895_(actualTitle) - 80) * 0.011f), (float)0.0f, (float)1.95f);
            }
            guiGraphics.m_280168_().m_252880_((float)(k + 10), (float)(l + 10), 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            guiGraphics.m_280056_(font, actualTitle, 0, 0, this.getTitleColor(), false);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private void addWidgetSpacing() {
        this.yIndexesToSkip.clear();
        for (ItemRenderData itemRenderData : this.itemRenders) {
            Item item = BookScreen.getItemByRegistryName(itemRenderData.getItem());
            if (item == null) continue;
            this.yIndexesToSkip.add(new Whitespace(itemRenderData.getPage(), itemRenderData.getX(), itemRenderData.getY(), (int)(itemRenderData.getScale() * 17.0), (int)(itemRenderData.getScale() * 15.0)));
        }
        for (RecipeCodec recipeData : this.recipes) {
            Recipe recipe = this.getRecipeByName(recipeData.getRecipe());
            if (recipe == null) continue;
            this.yIndexesToSkip.add(new Whitespace(recipeData.getPageNr(), recipeData.getXLocation(), recipeData.getYLocation() - (int)(recipeData.getScale() * 15.0), (int)(recipeData.getScale() * 35.0), (int)(recipeData.getScale() * 60.0), true));
        }
        for (EncyclopediaPictureCodec imageData : this.pictures) {
            if (imageData == null) continue;
            this.yIndexesToSkip.add(new Whitespace(imageData.getPageNr(), imageData.getxLocation(), imageData.getyLocation(), imageData.getXSize(), imageData.getYSize() - 9));
        }
        if (!this.currentEntry.getTitle().isEmpty()) {
            this.yIndexesToSkip.add(new Whitespace(0, 20, 5, 70, 15));
        }
    }

    protected void readInPageText(ResourceLocation res) {
        Object resource = null;
        int xIndex = 0;
        int actualTextX = 0;
        int yIndex = 0;
        try {
            BufferedReader bufferedreader = Minecraft.m_91087_().m_91098_().m_215597_(res);
            try {
                List readStrings = IOUtils.readLines((Reader)bufferedreader);
                this.linesFromJSON = readStrings.size();
                this.lines.clear();
                ArrayList<String> splitBySpaces = new ArrayList<String>();
                for (String line : readStrings) {
                    splitBySpaces.addAll(Arrays.asList(line.split(" ")));
                }
                Object lineToPrint = "";
                this.linesFromPrinting = 0;
                int page = 0;
                for (int i = 0; i < splitBySpaces.size(); ++i) {
                    String word = (String)splitBySpaces.get(i);
                    int cutoffPoint = xIndex > 100 ? 30 : 35;
                    boolean newline = word.equals("<NEWLINE>");
                    for (Whitespace indexes : this.yIndexesToSkip) {
                        int indexPage = indexes.getPage();
                        if (indexPage != page) continue;
                        int buttonX = indexes.getX();
                        int buttonY = indexes.getY();
                        int width = indexes.getWidth();
                        int height = indexes.getHeight();
                        if (indexes.isDown()) {
                            if (!((float)yIndex >= (float)buttonY / 12.0f) || !((float)yIndex <= (float)(buttonY + height) / 12.0f) || (buttonX >= 90 || xIndex >= 90) && (buttonX < 90 || xIndex < 90)) continue;
                            yIndex += 2;
                            continue;
                        }
                        if (!((float)yIndex >= (float)(buttonY - height) / 12.0f) || !((float)yIndex <= (float)(buttonY + height) / 12.0f) || (buttonX >= 90 || xIndex >= 90) && (buttonX < 90 || xIndex < 90)) continue;
                        ++yIndex;
                    }
                    boolean last = i == splitBySpaces.size() - 1;
                    actualTextX += word.length() + 1;
                    if (((String)lineToPrint).length() + word.length() + 1 >= cutoffPoint || newline) {
                        ++this.linesFromPrinting;
                        if (yIndex > 13) {
                            if (xIndex > 0) {
                                ++page;
                                xIndex = 0;
                                yIndex = 0;
                            } else {
                                xIndex = 200;
                                yIndex = 0;
                            }
                        }
                        if (last) {
                            lineToPrint = (String)lineToPrint + " " + word;
                        }
                        this.lines.add(new LineData(xIndex, yIndex, ((String)lineToPrint).trim().strip(), page));
                        ++yIndex;
                        actualTextX = 0;
                        if (newline) {
                            ++yIndex;
                        }
                        lineToPrint = word.equals("<NEWLINE>") ? "" : word;
                        continue;
                    }
                    lineToPrint = (String)lineToPrint + " " + word;
                    if (!last) continue;
                    ++this.linesFromPrinting;
                    this.lines.add(new LineData(xIndex, yIndex, ((String)lineToPrint).trim().strip(), page));
                    ++yIndex;
                    actualTextX = 0;
                    if (!newline) continue;
                    ++yIndex;
                }
                this.maxPagesFromPrinting = page;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e) {
            UnusualPrehistory.LOGGER.warn("Could not load in page .txt from json from page, page: " + res);
        }
    }

    private void addNextPreviousButtons() {
        int k = (this.f_96543_ - this.xSize) / 2;
        int l = (this.f_96544_ - this.ySize + 128) / 2;
        if (this.currentPage < this.nextPageToStartNrCache) {
            this.buttonNextPage = (BookPageButton)this.m_142416_((GuiEventListener)new BookPageButton(this, k + 365, l + 180, true, p_214205_1_ -> this.onSwitchPage(true), true));
        }
        if (this.currentPage > 0 || !this.currentResourceLocation.equals((Object)UnusualPrehistory.prefix("root"))) {
            this.buttonPreviousPage = (BookPageButton)this.m_142416_((GuiEventListener)new BookPageButton(this, k + 10, l + 180, false, p_214208_1_ -> this.onSwitchPage(false), true));
        }
        if (!this.currentResourceLocation.equals((Object)UnusualPrehistory.prefix("root"))) {
            this.buttonPreviousPage = (BookPageButton)this.m_142416_((GuiEventListener)new BookPageButton(this, k + 10, l + 180, false, p_214208_1_ -> this.onSwitchPage(false), true));
        }
    }

    private void onSwitchPage(boolean next) {
        if (next) {
            this.previousMap.put(this.currentPage, this.nextPageToStartNr);
            Minecraft.m_91087_().m_91152_((Screen)new BookScreen(this.currentResourceLocation, this.currentPage + 1));
        } else {
            if (this.currentResourceLocation.equals((Object)UnusualPrehistory.prefix("root"))) {
                Minecraft.m_91087_().m_91152_((Screen)new BookScreen(this.currentResourceLocation, this.currentPage - 1));
                return;
            }
            if (this.currentPage == 0) {
                Minecraft.m_91087_().m_91152_((Screen)new BookScreen(new ResourceLocation(this.pageToGo), 0));
                return;
            }
            Minecraft.m_91087_().m_91152_((Screen)new BookScreen(this.currentResourceLocation, 0));
        }
    }

    public void setEntityTooltip(String hoverText) {
        this.entityTooltip = hoverText;
    }

    private /* synthetic */ void lambda$addLinkButtons$8(PlantLinkData linkData, Button p_213021_1_) {
        Minecraft.m_91087_().m_91152_((Screen)new BookScreen(new ResourceLocation(linkData.linked_page), 0));
        this.addNextPreviousButtons();
    }

    private /* synthetic */ void lambda$addLinkButtons$7(EntityLinkData linkData, Button p_213021_1_) {
        Minecraft.m_91087_().m_91152_((Screen)new BookScreen(new ResourceLocation(linkData.linked_page), 0));
        this.addNextPreviousButtons();
    }
}

