/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.multistate.mutator;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.chiseling.conversion.IConversionManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessorWithVoxelShape;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.identifier.ISingleStateAreaShareIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.callback.StateClearer;
import mod.chiselsandbits.api.multistate.mutator.callback.StateSetter;
import mod.chiselsandbits.api.multistate.mutator.world.IInWorldMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.multistate.snapshot.SimpleSnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ChiselAdaptingWorldMutator
implements IWorldAreaMutator,
IAreaAccessorWithVoxelShape {
    public static final BlockInformation DEFAULT_STATE = new BlockInformation(Blocks.f_50069_.m_49966_(), Optional.empty());
    private final LevelAccessor world;
    private final BlockPos pos;

    public ChiselAdaptingWorldMutator(LevelAccessor world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        if (this.getWorld().m_151570_(this.getPos())) {
            return new PreAdaptedShapeIdentifier(this.getWorld().m_8055_(this.getPos()));
        }
        BlockEntity tileEntity = this.getWorld().m_7702_(this.getPos());
        if (tileEntity instanceof IMultiStateBlockEntity) {
            return ((IMultiStateBlockEntity)tileEntity).createNewShapeIdentifier();
        }
        return new PreAdaptedShapeIdentifier(this.getWorld().m_8055_(this.getPos()));
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        if (this.getWorld().m_151570_(this.getPos())) {
            return Stream.empty();
        }
        BlockEntity blockEntity = this.getWorld().m_7702_(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            return multiStateBlockEntity.stream();
        }
        BlockState currentState = this.getWorld().m_8055_(this.getPos());
        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
        BlockInformation blockInformation = new BlockInformation(currentState, additionalStateInfo);
        if (IEligibilityManager.getInstance().canBeChiseled(blockInformation) || currentState.m_60795_()) {
            return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new MutablePreAdaptedStateEntry(blockInformation, this.getWorld(), this.getPos(), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
        }
        return Stream.empty();
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vec3 inAreaTarget) {
        if (this.getWorld().m_151570_(this.getPos())) {
            return Optional.empty();
        }
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0) {
            return Optional.empty();
        }
        if (inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0) {
            return Optional.empty();
        }
        BlockEntity blockEntity = this.getWorld().m_7702_(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            return multiStateBlockEntity.getInAreaTarget(inAreaTarget);
        }
        BlockState currentState = this.getWorld().m_8055_(this.getPos());
        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
        BlockInformation blockInformation = new BlockInformation(currentState, additionalStateInfo);
        return Optional.of(new MutablePreAdaptedStateEntry(blockInformation, this.getWorld(), this.getPos(), (Vec3i)VectorUtils.toBlockPos(inAreaTarget.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide())), this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate the given single block!");
        }
        return this.getInAreaTarget(inBlockTarget);
    }

    @Override
    public boolean isInside(Vec3 inAreaTarget) {
        if (this.getWorld().m_151570_(this.getPos())) {
            return false;
        }
        return !(inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0 || inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0);
    }

    @Override
    public boolean isInside(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            return false;
        }
        return this.isInside(inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        if (this.getWorld().m_151570_(this.getPos())) {
            return EmptySnapshot.INSTANCE;
        }
        BlockEntity blockEntity = this.getWorld().m_7702_(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            return multiStateBlockEntity.createSnapshot();
        }
        BlockState currentState = this.getWorld().m_8055_(this.getPos());
        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
        BlockInformation blockInformation = new BlockInformation(currentState, additionalStateInfo);
        return new SimpleSnapshot(blockInformation);
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        block6: {
            BlockInformation blockInformation;
            block5: {
                if (this.getWorld().m_151570_(this.getPos())) {
                    return Stream.empty();
                }
                BlockEntity blockEntity = this.getWorld().m_7702_(this.getPos());
                if (blockEntity instanceof IMultiStateBlockEntity) {
                    IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
                    return multiStateBlockEntity.streamWithPositionMutator(positionMutator);
                }
                BlockState currentState = this.getWorld().m_8055_(this.getPos());
                Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
                blockInformation = new BlockInformation(currentState, additionalStateInfo);
                if (IEligibilityManager.getInstance().canBeChiseled(blockInformation)) break block5;
                if (!currentState.m_60795_()) break block6;
            }
            return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(positionMutator::mutate).map(blockPos -> new MutablePreAdaptedStateEntry(blockInformation, this.getWorld(), this.getPos(), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
        }
        return Stream.empty();
    }

    @Override
    public void forEachWithPositionMutator(IPositionMutator positionMutator, Consumer<IStateEntryInfo> consumer) {
        if (this.getWorld().m_151570_(this.getPos())) {
            return;
        }
        BlockEntity blockEntity = this.getWorld().m_7702_(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            multiStateBlockEntity.forEachWithPositionMutator(positionMutator, consumer);
        }
        BlockState currentState = this.getWorld().m_8055_(this.getPos());
        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
        BlockInformation blockInformation = new BlockInformation(currentState, additionalStateInfo);
        if (IEligibilityManager.getInstance().canBeChiseled(blockInformation) || currentState.m_60795_()) {
            BlockPosForEach.forEachInRange(StateEntrySize.current().getBitsPerBlockSide(), blockPos -> {
                Vec3i target = positionMutator.mutate((Vec3i)blockPos);
                consumer.accept(new MutablePreAdaptedStateEntry(blockInformation, this.getWorld(), this.getPos(), target, this::setInAreaTarget, this::clearInAreaTarget));
            });
        }
    }

    @Override
    public LevelAccessor getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public Vec3 getInWorldStartPoint() {
        return Vec3.m_82528_((Vec3i)this.pos);
    }

    @Override
    public Vec3 getInWorldEndPoint() {
        return Vec3.m_82528_((Vec3i)this.pos).m_82520_((double)(15.0f * StateEntrySize.current().getSizePerBit()), (double)(15.0f * StateEntrySize.current().getSizePerBit()), (double)(15.0f * StateEntrySize.current().getSizePerBit()));
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        if (this.getWorld().m_151570_(this.getPos())) {
            return Stream.empty();
        }
        BlockEntity blockEntity = this.getWorld().m_7702_(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            return multiStateBlockEntity.mutableStream();
        }
        BlockState currentState = this.getWorld().m_8055_(this.getPos());
        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
        BlockInformation blockInformation = new BlockInformation(currentState, additionalStateInfo);
        if (IEligibilityManager.getInstance().canBeChiseled(blockInformation)) {
            return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new MutablePreAdaptedStateEntry(blockInformation, this.getWorld(), this.getPos(), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
        }
        return Stream.empty();
    }

    @Override
    public void setInAreaTarget(IBlockInformation blockInformation, Vec3 inAreaTarget) throws SpaceOccupiedException {
        Optional<IStateVariant> stateVariant;
        if (this.getWorld().m_151570_(this.getPos())) {
            return;
        }
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate blocks with an in area offset greater or equal to 0. Requested was: " + String.valueOf(inAreaTarget));
        }
        if (inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate blocks with an in area offset smaller then 1. Requested was: " + String.valueOf(inAreaTarget));
        }
        BlockEntity blockEntity = this.getWorld().m_7702_(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            multiStateBlockEntity.setInAreaTarget(blockInformation, inAreaTarget);
            return;
        }
        BlockState blockState = this.getWorld().m_8055_(this.getPos());
        BlockInformation newBlockInformation = new BlockInformation(blockState, stateVariant = IStateVariantManager.getInstance().getStateVariant(blockState, Optional.ofNullable(blockEntity)));
        if (!newBlockInformation.isAir()) {
            throw new SpaceOccupiedException();
        }
        Optional<Block> optionalWithConvertedBlock = IConversionManager.getInstance().getChiseledVariantOf(blockInformation.getBlockState());
        if (optionalWithConvertedBlock.isPresent()) {
            Block convertedBlock = optionalWithConvertedBlock.get();
            this.getWorld().m_7731_(this.getPos(), convertedBlock.m_49966_(), 3);
            BlockEntity convertedTileEntity = this.getWorld().m_7702_(this.getPos());
            if (convertedTileEntity instanceof IMultiStateBlockEntity) {
                IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)convertedTileEntity;
                multiStateBlockEntity.initializeWith(newBlockInformation);
                multiStateBlockEntity.setInAreaTarget(blockInformation, inAreaTarget);
                return;
            }
            throw new IllegalStateException("Conversion of the existing block of type: " + String.valueOf(newBlockInformation) + " into a chiseled variant failed.");
        }
    }

    @Override
    public void setInBlockTarget(IBlockInformation blockInformation, BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) throws SpaceOccupiedException {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate the given single block!");
        }
        this.setInAreaTarget(blockInformation, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(Vec3 inAreaTarget) {
        Optional<IStateVariant> stateVariant;
        if (this.getWorld().m_151570_(this.getPos())) {
            return;
        }
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate blocks with an in area offset greater or equal to 0. Requested was: " + String.valueOf(inAreaTarget));
        }
        if (inAreaTarget.m_7096_() > 1.0 || inAreaTarget.m_7098_() > 1.0 || inAreaTarget.m_7094_() > 1.0) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate blocks with an in area offset smaller then 1. Requested was: " + String.valueOf(inAreaTarget));
        }
        BlockEntity blockEntity = this.getWorld().m_7702_(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            multiStateBlockEntity.clearInAreaTarget(inAreaTarget);
            return;
        }
        BlockState blockState = this.getWorld().m_8055_(this.getPos());
        BlockInformation newBlockInformation = new BlockInformation(blockState, stateVariant = IStateVariantManager.getInstance().getStateVariant(blockState, Optional.ofNullable(blockEntity)));
        if (newBlockInformation.isAir()) {
            return;
        }
        Optional<Block> optionalWithConvertedBlock = IConversionManager.getInstance().getChiseledVariantOf(newBlockInformation.getBlockState());
        if (optionalWithConvertedBlock.isPresent()) {
            Block convertedBlock = optionalWithConvertedBlock.get();
            this.getWorld().m_7731_(this.getPos(), convertedBlock.m_49966_(), 3);
            BlockEntity convertedTileEntity = this.getWorld().m_7702_(this.getPos());
            if (convertedTileEntity instanceof IMultiStateBlockEntity) {
                IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)convertedTileEntity;
                multiStateBlockEntity.initializeWith(newBlockInformation);
                multiStateBlockEntity.clearInAreaTarget(inAreaTarget);
                return;
            }
            throw new IllegalStateException("Conversion of the existing block of type: " + String.valueOf(newBlockInformation) + " into a chiseled variant failed.");
        }
    }

    @Override
    public void clearInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate the given single block!");
        }
        this.clearInAreaTarget(inBlockTarget);
    }

    @Override
    public Stream<IInWorldMutableStateEntryInfo> inWorldMutableStream() {
        if (this.getWorld().m_151570_(this.getPos())) {
            return Stream.empty();
        }
        BlockEntity blockEntity = this.getWorld().m_7702_(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            return multiStateBlockEntity.inWorldMutableStream();
        }
        BlockState currentState = this.getWorld().m_8055_(this.getPos());
        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
        BlockInformation blockInformation = new BlockInformation(currentState, additionalStateInfo);
        if (IEligibilityManager.getInstance().canBeChiseled(blockInformation) || currentState.m_60795_()) {
            return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new MutablePreAdaptedStateEntry(blockInformation, this.getWorld(), this.getPos(), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
        }
        return Stream.empty();
    }

    @Override
    public IBatchMutation batch() {
        BlockInformation currentState;
        if (this.getWorld().m_151570_(this.getPos())) {
            return () -> {};
        }
        BlockEntity blockEntity = this.getWorld().m_7702_(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            return ((IMultiStateBlockEntity)blockEntity).batch();
        }
        BlockState blockState = this.getWorld().m_8055_(this.getPos());
        Optional<IStateVariant> stateVariant = IStateVariantManager.getInstance().getStateVariant(blockState, Optional.ofNullable(blockEntity));
        IBlockInformation initializationState = currentState = new BlockInformation(blockState, stateVariant);
        if (currentState.isAir()) {
            currentState = DEFAULT_STATE;
            initializationState = BlockInformation.AIR;
        }
        if (!IEligibilityManager.getInstance().canBeChiseled(currentState) && !currentState.isAir()) {
            return () -> {};
        }
        Optional<Block> optionalWithConvertedBlock = IConversionManager.getInstance().getChiseledVariantOf(currentState.getBlockState());
        if (optionalWithConvertedBlock.isPresent()) {
            Block convertedBlock = optionalWithConvertedBlock.get();
            this.getWorld().m_7731_(this.getPos(), convertedBlock.m_49966_(), 3);
            BlockEntity convertedTileEntity = this.getWorld().m_7702_(this.getPos());
            if (convertedTileEntity instanceof IMultiStateBlockEntity) {
                IBatchMutation batchMutation = ((IMultiStateBlockEntity)convertedTileEntity).batch();
                ((IMultiStateBlockEntity)convertedTileEntity).initializeWith(initializationState);
                return batchMutation;
            }
            throw new IllegalStateException("Conversion of the existing block of type: " + String.valueOf(currentState) + " into a chiseled variant failed.");
        }
        return () -> {};
    }

    @Override
    public IBatchMutation batch(IChangeTracker changeTracker) {
        if (this.getWorld().m_151570_(this.getPos())) {
            return () -> {};
        }
        BlockState blockState = this.getWorld().m_8055_(this.getPos());
        BlockEntity blockEntity = this.getWorld().m_7702_(this.getPos());
        Optional<IStateVariant> stateVariant = IStateVariantManager.getInstance().getStateVariant(blockState, Optional.ofNullable(blockEntity));
        BlockInformation currentState = new BlockInformation(blockState, stateVariant);
        if (!IEligibilityManager.getInstance().canBeChiseled(currentState) && !currentState.isAir()) {
            return () -> {};
        }
        IBatchMutation innerMutation = this.batch();
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateSnapshot before = ((IMultiStateBlockEntity)blockEntity).createSnapshot();
            return () -> {
                IMultiStateSnapshot after = ((IMultiStateBlockEntity)blockEntity).createSnapshot();
                innerMutation.close();
                changeTracker.onBlockUpdated(this.getPos(), before, after);
            };
        }
        return innerMutation;
    }

    @Override
    public VoxelShape provideShape(CollisionType type, BlockPos offset, boolean simplify) {
        if (this.getWorld().m_151570_(this.getPos())) {
            return Shapes.m_83040_();
        }
        BlockEntity blockEntity = this.getWorld().m_7702_(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            return multiStateBlockEntity.provideShape(type, offset, simplify);
        }
        BlockState blockState = this.getWorld().m_8055_(this.getPos());
        Optional<IStateVariant> stateVariant = IStateVariantManager.getInstance().getStateVariant(blockState, Optional.ofNullable(blockEntity));
        BlockInformation currentState = new BlockInformation(blockState, stateVariant);
        if (!IEligibilityManager.getInstance().canBeChiseled(currentState) && !currentState.isAir()) {
            return Shapes.m_83040_();
        }
        if (currentState.isAir() && type.isValidFor(currentState.getBlockState())) {
            return Shapes.m_83144_().m_83216_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
        }
        return currentState.getBlockState().m_60808_((BlockGetter)this.getWorld(), this.getPos()).m_83216_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
    }

    @Override
    @NotNull
    public AABB getBoundingBox() {
        return new AABB((double)this.getPos().m_123341_(), (double)this.getPos().m_123342_(), (double)this.getPos().m_123343_(), (double)(this.getPos().m_123341_() + 1), (double)(this.getPos().m_123342_() + 1), (double)(this.getPos().m_123343_() + 1));
    }

    private static class PreAdaptedShapeIdentifier
    implements ISingleStateAreaShareIdentifier {
        private final int blockState;

        private PreAdaptedShapeIdentifier(BlockState blockState) {
            this.blockState = IBlockStateIdManager.getInstance().getIdFrom(blockState);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PreAdaptedShapeIdentifier)) {
                return false;
            }
            PreAdaptedShapeIdentifier that = (PreAdaptedShapeIdentifier)o;
            return this.blockState == that.blockState;
        }

        public int hashCode() {
            return Objects.hash(this.blockState);
        }
    }

    private static class MutablePreAdaptedStateEntry
    implements IInWorldMutableStateEntryInfo {
        private final IBlockInformation blockInformation;
        private final LevelAccessor world;
        private final Vec3 startPoint;
        private final Vec3 endPoint;
        private final BlockPos blockPos;
        private final StateSetter setCallback;
        private final StateClearer clearCallback;

        public MutablePreAdaptedStateEntry(IBlockInformation blockInformation, LevelAccessor world, BlockPos blockPos, Vec3i inBlockOffset, StateSetter setCallback, StateClearer clearCallback) {
            this.blockInformation = blockInformation;
            this.world = world;
            this.blockPos = blockPos;
            this.startPoint = Vec3.m_82528_((Vec3i)inBlockOffset).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            this.setCallback = setCallback;
            this.clearCallback = clearCallback;
            this.endPoint = this.startPoint.m_82520_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
        }

        @Override
        @NotNull
        public IBlockInformation getBlockInformation() {
            return this.blockInformation;
        }

        @Override
        @NotNull
        public Vec3 getStartPoint() {
            return this.startPoint;
        }

        @Override
        @NotNull
        public Vec3 getEndPoint() {
            return this.endPoint;
        }

        @Override
        public LevelAccessor getWorld() {
            return this.world;
        }

        @Override
        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        @Override
        public void setBlockInformation(IBlockInformation blockInformation) throws SpaceOccupiedException {
            this.setCallback.set(blockInformation, this.getStartPoint());
        }

        @Override
        public void clear() {
            this.clearCallback.accept(this.getStartPoint());
        }
    }
}

