/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.compat.create;

import com.communi.suggestu.scena.core.client.models.data.IBlockModelData;
import com.google.common.collect.Maps;
import dev.engine_room.flywheel.api.instance.InstancerProvider;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.lib.instance.AbstractInstance;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.baked.ForgeBakedModelBuilder;
import java.util.Map;
import mod.chiselsandbits.forge.compat.create.ChiseledBlockOnContraptionModelCache;
import mod.chiselsandbits.registrars.ModModelProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class ChiseledBlockInstance {
    private final InstancerProvider provider;
    private final Map<RenderType, TransformedInstance> modelData = Maps.newConcurrentMap();
    private int localBlockLight = -1;
    private BlockPos localPos;

    public ChiseledBlockInstance(InstancerProvider instancerProvider, BlockPos localPos, ChiseledBlockOnContraptionModelCache cache) {
        this.provider = instancerProvider;
        this.localPos = localPos;
        cache.addConsumer((identifier, modelData) -> Minecraft.m_91087_().execute(() -> this.init((IBlockModelData)modelData)));
    }

    public void init(IBlockModelData data) {
        this.delete();
        this.modelData.clear();
        Map models = (Map)data.getData(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY);
        if (models == null) {
            return;
        }
        models.forEach((renderType, model) -> {
            this.modelData.put((RenderType)renderType, (TransformedInstance)this.provider.instancer(InstanceTypes.TRANSFORMED, (Model)new ForgeBakedModelBuilder(model).build()).createInstance());
            if (this.localBlockLight != -1) {
                this.modelData.get(renderType).light(this.localBlockLight);
            }
        });
    }

    public void beginFrame() {
        for (TransformedInstance value : this.modelData.values()) {
            ((TransformedInstance)value.setIdentityTransform().translate((Vec3i)this.localPos)).setChanged();
        }
    }

    public void setInitialBlockLight(int localBlockLight) {
        this.localBlockLight = localBlockLight;
    }

    void delete() {
        this.modelData.values().forEach(AbstractInstance::delete);
    }
}

