/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer.datagen;

import com.mojang.logging.LogUtils;
import com.peeko32213.seafarer.SeaFarer;
import com.peeko32213.seafarer.core.registry.SFBlocks;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public class BlockstateGenerator
extends BlockStateProvider {
    private static final Logger LOGGER = LogUtils.getLogger();

    public BlockstateGenerator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "seafarer", exFileHelper);
    }

    private String blockName(Block block) {
        return block.m_60589_().m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("seafarer", "block/" + path);
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    public void simpleBlockItem(Block block, ModelFile model) {
        ((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).m_135815_())).parent(model);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)SFBlocks.ALGAE_BLOCK.get());
        this.simpleBlockItem((Block)SFBlocks.ALGAE_BLOCK.get(), this.existingModel(this.getName((Block)SFBlocks.ALGAE_BLOCK.get())));
        this.simpleBlock((Block)SFBlocks.BLUE_SEAGLASS_TILES.get());
        this.simpleBlockItem((Block)SFBlocks.BLUE_SEAGLASS_TILES.get(), this.existingModel(this.getName((Block)SFBlocks.BLUE_SEAGLASS_TILES.get())));
        this.slabBlock((SlabBlock)SFBlocks.BLUE_SEAGLASS_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.BLUE_SEAGLASS_BRICKS.get())), new ResourceLocation("seafarer", "block/blue_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.BLUE_SEAGLASS_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.BLUE_SEAGLASS_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.BLUE_SEAGLASS_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/blue_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.BLUE_SEAGLASS_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.BLUE_SEAGLASS_BRICKS_STAIRS.get())));
        this.slabBlock((SlabBlock)SFBlocks.BLUE_SEAGLASS_TILES_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.BLUE_SEAGLASS_TILES.get())), new ResourceLocation("seafarer", "block/blue_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.BLUE_SEAGLASS_TILES_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.BLUE_SEAGLASS_TILES_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.BLUE_SEAGLASS_TILES_STAIRS.get(), new ResourceLocation("seafarer", "block/blue_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.BLUE_SEAGLASS_TILES_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.BLUE_SEAGLASS_TILES_STAIRS.get())));
        this.simpleBlock((Block)SFBlocks.BROWN_SEAGLASS_TILES.get());
        this.simpleBlockItem((Block)SFBlocks.BROWN_SEAGLASS_TILES.get(), this.existingModel(this.getName((Block)SFBlocks.BROWN_SEAGLASS_TILES.get())));
        this.slabBlock((SlabBlock)SFBlocks.BROWN_SEAGLASS_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.BROWN_SEAGLASS_BRICKS.get())), new ResourceLocation("seafarer", "block/brown_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.BROWN_SEAGLASS_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.BROWN_SEAGLASS_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.BROWN_SEAGLASS_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/brown_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.BROWN_SEAGLASS_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.BROWN_SEAGLASS_BRICKS_STAIRS.get())));
        this.slabBlock((SlabBlock)SFBlocks.BROWN_SEAGLASS_TILES_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.BROWN_SEAGLASS_TILES.get())), new ResourceLocation("seafarer", "block/brown_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.BROWN_SEAGLASS_TILES_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.BROWN_SEAGLASS_TILES_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.BROWN_SEAGLASS_TILES_STAIRS.get(), new ResourceLocation("seafarer", "block/brown_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.BROWN_SEAGLASS_TILES_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.BROWN_SEAGLASS_TILES_STAIRS.get())));
        this.simpleBlock((Block)SFBlocks.GREEN_SEAGLASS_TILES.get());
        this.simpleBlockItem((Block)SFBlocks.GREEN_SEAGLASS_TILES.get(), this.existingModel(this.getName((Block)SFBlocks.GREEN_SEAGLASS_TILES.get())));
        this.slabBlock((SlabBlock)SFBlocks.GREEN_SEAGLASS_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.GREEN_SEAGLASS_BRICKS.get())), new ResourceLocation("seafarer", "block/green_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.GREEN_SEAGLASS_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.GREEN_SEAGLASS_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.GREEN_SEAGLASS_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/green_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.GREEN_SEAGLASS_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.GREEN_SEAGLASS_BRICKS_STAIRS.get())));
        this.slabBlock((SlabBlock)SFBlocks.GREEN_SEAGLASS_TILES_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.GREEN_SEAGLASS_TILES.get())), new ResourceLocation("seafarer", "block/green_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.GREEN_SEAGLASS_TILES_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.GREEN_SEAGLASS_TILES_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.GREEN_SEAGLASS_TILES_STAIRS.get(), new ResourceLocation("seafarer", "block/green_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.GREEN_SEAGLASS_TILES_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.GREEN_SEAGLASS_TILES_STAIRS.get())));
        this.simpleBlock((Block)SFBlocks.ORANGE_SEAGLASS_TILES.get());
        this.simpleBlockItem((Block)SFBlocks.ORANGE_SEAGLASS_TILES.get(), this.existingModel(this.getName((Block)SFBlocks.ORANGE_SEAGLASS_TILES.get())));
        this.slabBlock((SlabBlock)SFBlocks.ORANGE_SEAGLASS_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.ORANGE_SEAGLASS_BRICKS.get())), new ResourceLocation("seafarer", "block/orange_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.ORANGE_SEAGLASS_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.ORANGE_SEAGLASS_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.ORANGE_SEAGLASS_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/orange_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.ORANGE_SEAGLASS_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.ORANGE_SEAGLASS_BRICKS_STAIRS.get())));
        this.slabBlock((SlabBlock)SFBlocks.ORANGE_SEAGLASS_TILES_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.ORANGE_SEAGLASS_TILES.get())), new ResourceLocation("seafarer", "block/orange_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.ORANGE_SEAGLASS_TILES_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.ORANGE_SEAGLASS_TILES_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.ORANGE_SEAGLASS_TILES_STAIRS.get(), new ResourceLocation("seafarer", "block/orange_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.ORANGE_SEAGLASS_TILES_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.ORANGE_SEAGLASS_TILES_STAIRS.get())));
        this.simpleBlock((Block)SFBlocks.PURPLE_SEAGLASS_TILES.get());
        this.simpleBlockItem((Block)SFBlocks.PURPLE_SEAGLASS_TILES.get(), this.existingModel(this.getName((Block)SFBlocks.PURPLE_SEAGLASS_TILES.get())));
        this.slabBlock((SlabBlock)SFBlocks.PURPLE_SEAGLASS_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.PURPLE_SEAGLASS_BRICKS.get())), new ResourceLocation("seafarer", "block/purple_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.PURPLE_SEAGLASS_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.PURPLE_SEAGLASS_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.PURPLE_SEAGLASS_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/purple_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.PURPLE_SEAGLASS_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.PURPLE_SEAGLASS_BRICKS_STAIRS.get())));
        this.slabBlock((SlabBlock)SFBlocks.PURPLE_SEAGLASS_TILES_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.PURPLE_SEAGLASS_TILES.get())), new ResourceLocation("seafarer", "block/purple_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.PURPLE_SEAGLASS_TILES_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.PURPLE_SEAGLASS_TILES_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.PURPLE_SEAGLASS_TILES_STAIRS.get(), new ResourceLocation("seafarer", "block/purple_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.PURPLE_SEAGLASS_TILES_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.PURPLE_SEAGLASS_TILES_STAIRS.get())));
        this.simpleBlock((Block)SFBlocks.RED_SEAGLASS_TILES.get());
        this.simpleBlockItem((Block)SFBlocks.RED_SEAGLASS_TILES.get(), this.existingModel(this.getName((Block)SFBlocks.RED_SEAGLASS_TILES.get())));
        this.slabBlock((SlabBlock)SFBlocks.RED_SEAGLASS_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.RED_SEAGLASS_BRICKS.get())), new ResourceLocation("seafarer", "block/red_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.RED_SEAGLASS_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.RED_SEAGLASS_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.RED_SEAGLASS_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/red_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.RED_SEAGLASS_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.RED_SEAGLASS_BRICKS_STAIRS.get())));
        this.slabBlock((SlabBlock)SFBlocks.RED_SEAGLASS_TILES_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.RED_SEAGLASS_TILES.get())), new ResourceLocation("seafarer", "block/red_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.RED_SEAGLASS_TILES_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.RED_SEAGLASS_TILES_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.RED_SEAGLASS_TILES_STAIRS.get(), new ResourceLocation("seafarer", "block/red_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.RED_SEAGLASS_TILES_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.RED_SEAGLASS_TILES_STAIRS.get())));
        this.simpleBlock((Block)SFBlocks.WHITE_SEAGLASS_BLOCK.get());
        this.simpleBlockItem((Block)SFBlocks.WHITE_SEAGLASS_BLOCK.get(), this.existingModel(this.getName((Block)SFBlocks.WHITE_SEAGLASS_BLOCK.get())));
        this.simpleBlock((Block)SFBlocks.WHITE_SEAGLASS_BRICKS.get());
        this.simpleBlockItem((Block)SFBlocks.WHITE_SEAGLASS_BRICKS.get(), this.existingModel(this.getName((Block)SFBlocks.WHITE_SEAGLASS_BRICKS.get())));
        this.simpleBlock((Block)SFBlocks.WHITE_SEAGLASS_PEBBLED.get());
        this.simpleBlockItem((Block)SFBlocks.WHITE_SEAGLASS_PEBBLED.get(), this.existingModel(this.getName((Block)SFBlocks.WHITE_SEAGLASS_PEBBLED.get())));
        this.simpleBlock((Block)SFBlocks.WHITE_SEAGLASS_TILES.get());
        this.simpleBlockItem((Block)SFBlocks.WHITE_SEAGLASS_TILES.get(), this.existingModel(this.getName((Block)SFBlocks.WHITE_SEAGLASS_TILES.get())));
        this.slabBlock((SlabBlock)SFBlocks.WHITE_SEAGLASS_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.WHITE_SEAGLASS_BRICKS.get())), new ResourceLocation("seafarer", "block/white_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.WHITE_SEAGLASS_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.WHITE_SEAGLASS_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.WHITE_SEAGLASS_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/white_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.WHITE_SEAGLASS_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.WHITE_SEAGLASS_BRICKS_STAIRS.get())));
        this.slabBlock((SlabBlock)SFBlocks.WHITE_SEAGLASS_TILES_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.WHITE_SEAGLASS_TILES.get())), new ResourceLocation("seafarer", "block/white_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.WHITE_SEAGLASS_TILES_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.WHITE_SEAGLASS_TILES_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.WHITE_SEAGLASS_TILES_STAIRS.get(), new ResourceLocation("seafarer", "block/white_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.WHITE_SEAGLASS_TILES_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.WHITE_SEAGLASS_TILES_STAIRS.get())));
        this.simpleBlock((Block)SFBlocks.YELLOW_SEAGLASS_TILES.get());
        this.simpleBlockItem((Block)SFBlocks.YELLOW_SEAGLASS_TILES.get(), this.existingModel(this.getName((Block)SFBlocks.YELLOW_SEAGLASS_TILES.get())));
        this.slabBlock((SlabBlock)SFBlocks.YELLOW_SEAGLASS_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.YELLOW_SEAGLASS_BRICKS.get())), new ResourceLocation("seafarer", "block/yellow_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.YELLOW_SEAGLASS_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.YELLOW_SEAGLASS_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.YELLOW_SEAGLASS_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/yellow_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.YELLOW_SEAGLASS_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.YELLOW_SEAGLASS_BRICKS_STAIRS.get())));
        this.slabBlock((SlabBlock)SFBlocks.YELLOW_SEAGLASS_TILES_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.YELLOW_SEAGLASS_TILES.get())), new ResourceLocation("seafarer", "block/yellow_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.YELLOW_SEAGLASS_TILES_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.YELLOW_SEAGLASS_TILES_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.YELLOW_SEAGLASS_TILES_STAIRS.get(), new ResourceLocation("seafarer", "block/yellow_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.YELLOW_SEAGLASS_TILES_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.YELLOW_SEAGLASS_TILES_STAIRS.get())));
        this.simpleBlock((Block)SFBlocks.PINK_SEAGLASS_BLOCK.get());
        this.simpleBlockItem((Block)SFBlocks.PINK_SEAGLASS_BLOCK.get(), this.existingModel(this.getName((Block)SFBlocks.PINK_SEAGLASS_BLOCK.get())));
        this.simpleBlock((Block)SFBlocks.PINK_SEAGLASS_BRICKS.get());
        this.simpleBlockItem((Block)SFBlocks.PINK_SEAGLASS_BRICKS.get(), this.existingModel(this.getName((Block)SFBlocks.PINK_SEAGLASS_BRICKS.get())));
        this.simpleBlock((Block)SFBlocks.PINK_SEAGLASS_PEBBLED.get());
        this.simpleBlockItem((Block)SFBlocks.PINK_SEAGLASS_PEBBLED.get(), this.existingModel(this.getName((Block)SFBlocks.PINK_SEAGLASS_PEBBLED.get())));
        this.simpleBlock((Block)SFBlocks.PINK_SEAGLASS_TILES.get());
        this.simpleBlockItem((Block)SFBlocks.PINK_SEAGLASS_TILES.get(), this.existingModel(this.getName((Block)SFBlocks.PINK_SEAGLASS_TILES.get())));
        this.slabBlock((SlabBlock)SFBlocks.PINK_SEAGLASS_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.PINK_SEAGLASS_BRICKS.get())), new ResourceLocation("seafarer", "block/pink_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.PINK_SEAGLASS_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.PINK_SEAGLASS_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.PINK_SEAGLASS_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/pink_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.PINK_SEAGLASS_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.PINK_SEAGLASS_BRICKS_STAIRS.get())));
        this.slabBlock((SlabBlock)SFBlocks.PINK_SEAGLASS_TILES_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.PINK_SEAGLASS_TILES.get())), new ResourceLocation("seafarer", "block/pink_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.PINK_SEAGLASS_TILES_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.PINK_SEAGLASS_TILES_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.PINK_SEAGLASS_TILES_STAIRS.get(), new ResourceLocation("seafarer", "block/pink_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.PINK_SEAGLASS_TILES_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.PINK_SEAGLASS_TILES_STAIRS.get())));
        this.paneBlock((IronBarsBlock)SFBlocks.PINK_SEAGLASS_PANE.get(), new ResourceLocation("seafarer", "block/pink_seaglass_block"), new ResourceLocation("seafarer", "block/pink_seaglass_pane_top"));
        this.simpleBlock((Block)SFBlocks.LIME_SEAGLASS_BLOCK.get());
        this.simpleBlockItem((Block)SFBlocks.LIME_SEAGLASS_BLOCK.get(), this.existingModel(this.getName((Block)SFBlocks.LIME_SEAGLASS_BLOCK.get())));
        this.simpleBlock((Block)SFBlocks.LIME_SEAGLASS_BRICKS.get());
        this.simpleBlockItem((Block)SFBlocks.LIME_SEAGLASS_BRICKS.get(), this.existingModel(this.getName((Block)SFBlocks.LIME_SEAGLASS_BRICKS.get())));
        this.simpleBlock((Block)SFBlocks.LIME_SEAGLASS_PEBBLED.get());
        this.simpleBlockItem((Block)SFBlocks.LIME_SEAGLASS_PEBBLED.get(), this.existingModel(this.getName((Block)SFBlocks.LIME_SEAGLASS_PEBBLED.get())));
        this.simpleBlock((Block)SFBlocks.LIME_SEAGLASS_TILES.get());
        this.simpleBlockItem((Block)SFBlocks.LIME_SEAGLASS_TILES.get(), this.existingModel(this.getName((Block)SFBlocks.LIME_SEAGLASS_TILES.get())));
        this.slabBlock((SlabBlock)SFBlocks.LIME_SEAGLASS_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.LIME_SEAGLASS_BRICKS.get())), new ResourceLocation("seafarer", "block/lime_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.LIME_SEAGLASS_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.LIME_SEAGLASS_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.LIME_SEAGLASS_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/lime_seaglass_bricks"));
        this.simpleBlockItem((Block)SFBlocks.LIME_SEAGLASS_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.LIME_SEAGLASS_BRICKS_STAIRS.get())));
        this.slabBlock((SlabBlock)SFBlocks.LIME_SEAGLASS_TILES_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.LIME_SEAGLASS_TILES.get())), new ResourceLocation("seafarer", "block/lime_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.LIME_SEAGLASS_TILES_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.LIME_SEAGLASS_TILES_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.LIME_SEAGLASS_TILES_STAIRS.get(), new ResourceLocation("seafarer", "block/lime_seaglass_tiles"));
        this.simpleBlockItem((Block)SFBlocks.LIME_SEAGLASS_TILES_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.LIME_SEAGLASS_TILES_STAIRS.get())));
        this.paneBlock((IronBarsBlock)SFBlocks.LIME_SEAGLASS_PANE.get(), new ResourceLocation("seafarer", "block/lime_seaglass_block"), new ResourceLocation("seafarer", "block/lime_seaglass_pane_top"));
        this.logBlock((RotatedPillarBlock)SFBlocks.CLAM_SHELL_PILLAR.get());
        this.simpleBlockItem((Block)SFBlocks.CLAM_SHELL_PILLAR.get(), this.existingModel(this.getName((Block)SFBlocks.CLAM_SHELL_PILLAR.get())));
        this.simpleBlock((Block)SFBlocks.CLAM_SHELL_BRICKS.get());
        this.simpleBlockItem((Block)SFBlocks.CLAM_SHELL_BRICKS.get(), this.existingModel(this.getName((Block)SFBlocks.CLAM_SHELL_BRICKS.get())));
        this.slabBlock((SlabBlock)SFBlocks.CLAM_SHELL_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.CLAM_SHELL_BRICKS_SLAB.get())), new ResourceLocation("seafarer", "block/clam_shell_bricks"));
        this.simpleBlockItem((Block)SFBlocks.CLAM_SHELL_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.CLAM_SHELL_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.CLAM_SHELL_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/clam_shell_bricks"));
        this.simpleBlockItem((Block)SFBlocks.CLAM_SHELL_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.CLAM_SHELL_BRICKS_STAIRS.get())));
        this.logBlock((RotatedPillarBlock)SFBlocks.HORN_SHELL_PILLAR.get());
        this.simpleBlockItem((Block)SFBlocks.HORN_SHELL_PILLAR.get(), this.existingModel(this.getName((Block)SFBlocks.HORN_SHELL_PILLAR.get())));
        this.simpleBlock((Block)SFBlocks.HORN_SHELL_BRICKS.get());
        this.simpleBlockItem((Block)SFBlocks.HORN_SHELL_BRICKS.get(), this.existingModel(this.getName((Block)SFBlocks.HORN_SHELL_BRICKS.get())));
        this.slabBlock((SlabBlock)SFBlocks.HORN_SHELL_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.HORN_SHELL_BRICKS_SLAB.get())), new ResourceLocation("seafarer", "block/horn_shell_bricks"));
        this.simpleBlockItem((Block)SFBlocks.HORN_SHELL_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.HORN_SHELL_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.HORN_SHELL_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/horn_shell_bricks"));
        this.simpleBlockItem((Block)SFBlocks.HORN_SHELL_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.HORN_SHELL_BRICKS_STAIRS.get())));
        this.logBlock((RotatedPillarBlock)SFBlocks.SPIKY_SHELL_PILLAR.get());
        this.simpleBlockItem((Block)SFBlocks.SPIKY_SHELL_PILLAR.get(), this.existingModel(this.getName((Block)SFBlocks.SPIKY_SHELL_PILLAR.get())));
        this.simpleBlock((Block)SFBlocks.SPIKY_SHELL_BRICKS.get());
        this.simpleBlockItem((Block)SFBlocks.SPIKY_SHELL_BRICKS.get(), this.existingModel(this.getName((Block)SFBlocks.SPIKY_SHELL_BRICKS.get())));
        this.slabBlock((SlabBlock)SFBlocks.SPIKY_SHELL_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.SPIKY_SHELL_BRICKS_SLAB.get())), new ResourceLocation("seafarer", "block/spiky_shell_bricks"));
        this.simpleBlockItem((Block)SFBlocks.SPIKY_SHELL_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.SPIKY_SHELL_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.SPIKY_SHELL_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/spiky_shell_bricks"));
        this.simpleBlockItem((Block)SFBlocks.SPIKY_SHELL_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.SPIKY_SHELL_BRICKS_STAIRS.get())));
        this.logBlock((RotatedPillarBlock)SFBlocks.SPIRAL_SHELL_PILLAR.get());
        this.simpleBlockItem((Block)SFBlocks.SPIRAL_SHELL_PILLAR.get(), this.existingModel(this.getName((Block)SFBlocks.SPIRAL_SHELL_PILLAR.get())));
        this.simpleBlock((Block)SFBlocks.SPIRAL_SHELL_BRICKS.get());
        this.simpleBlockItem((Block)SFBlocks.SPIRAL_SHELL_BRICKS.get(), this.existingModel(this.getName((Block)SFBlocks.SPIRAL_SHELL_BRICKS.get())));
        this.slabBlock((SlabBlock)SFBlocks.SPIRAL_SHELL_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.SPIRAL_SHELL_BRICKS_SLAB.get())), new ResourceLocation("seafarer", "block/spiral_shell_bricks"));
        this.simpleBlockItem((Block)SFBlocks.SPIRAL_SHELL_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.SPIRAL_SHELL_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.SPIRAL_SHELL_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/spiral_shell_bricks"));
        this.simpleBlockItem((Block)SFBlocks.SPIRAL_SHELL_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.SPIRAL_SHELL_BRICKS_STAIRS.get())));
        this.logBlock((RotatedPillarBlock)SFBlocks.SWIRL_SHELL_PILLAR.get());
        this.simpleBlockItem((Block)SFBlocks.SWIRL_SHELL_PILLAR.get(), this.existingModel(this.getName((Block)SFBlocks.SWIRL_SHELL_PILLAR.get())));
        this.simpleBlock((Block)SFBlocks.SWIRL_SHELL_BRICKS.get());
        this.simpleBlockItem((Block)SFBlocks.SWIRL_SHELL_BRICKS.get(), this.existingModel(this.getName((Block)SFBlocks.SWIRL_SHELL_BRICKS.get())));
        this.slabBlock((SlabBlock)SFBlocks.SWIRL_SHELL_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.SWIRL_SHELL_BRICKS_SLAB.get())), new ResourceLocation("seafarer", "block/swirl_shell_bricks"));
        this.simpleBlockItem((Block)SFBlocks.SWIRL_SHELL_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.SWIRL_SHELL_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.SWIRL_SHELL_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/swirl_shell_bricks"));
        this.simpleBlockItem((Block)SFBlocks.SWIRL_SHELL_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.SWIRL_SHELL_BRICKS_STAIRS.get())));
        this.logBlock((RotatedPillarBlock)SFBlocks.PYRAMID_SHELL_PILLAR.get());
        this.simpleBlockItem((Block)SFBlocks.PYRAMID_SHELL_PILLAR.get(), this.existingModel(this.getName((Block)SFBlocks.PYRAMID_SHELL_PILLAR.get())));
        this.simpleBlock((Block)SFBlocks.PYRAMID_SHELL_BRICKS.get());
        this.simpleBlockItem((Block)SFBlocks.PYRAMID_SHELL_BRICKS.get(), this.existingModel(this.getName((Block)SFBlocks.PYRAMID_SHELL_BRICKS.get())));
        this.slabBlock((SlabBlock)SFBlocks.PYRAMID_SHELL_BRICKS_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.PYRAMID_SHELL_BRICKS_SLAB.get())), new ResourceLocation("seafarer", "block/pyramid_shell_bricks"));
        this.simpleBlockItem((Block)SFBlocks.PYRAMID_SHELL_BRICKS_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.PYRAMID_SHELL_BRICKS_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.PYRAMID_SHELL_BRICKS_STAIRS.get(), new ResourceLocation("seafarer", "block/pyramid_shell_bricks"));
        this.simpleBlockItem((Block)SFBlocks.PYRAMID_SHELL_BRICKS_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.PYRAMID_SHELL_BRICKS_STAIRS.get())));
        this.simpleBlock((Block)SFBlocks.BLUE_MIXED_SPRINKLED_SAND.get());
        this.simpleBlockItem((Block)SFBlocks.BLUE_MIXED_SPRINKLED_SAND.get(), this.existingModel(this.getName((Block)SFBlocks.BLUE_MIXED_SPRINKLED_SAND.get())));
        this.simpleBlock((Block)SFBlocks.RED_MIXED_SPRINKLED_SAND.get());
        this.simpleBlockItem((Block)SFBlocks.RED_MIXED_SPRINKLED_SAND.get(), this.existingModel(this.getName((Block)SFBlocks.RED_MIXED_SPRINKLED_SAND.get())));
        this.simpleBlock((Block)SFBlocks.BLUE_SPRINKLED_SAND.get());
        this.simpleBlockItem((Block)SFBlocks.BLUE_SPRINKLED_SAND.get(), this.existingModel(this.getName((Block)SFBlocks.BLUE_SPRINKLED_SAND.get())));
        this.simpleBlock((Block)SFBlocks.PINK_SPRINKLED_SAND.get());
        this.simpleBlockItem((Block)SFBlocks.PINK_SPRINKLED_SAND.get(), this.existingModel(this.getName((Block)SFBlocks.PINK_SPRINKLED_SAND.get())));
        this.simpleBlock((Block)SFBlocks.PURPLE_SPRINKLED_SAND.get());
        this.simpleBlockItem((Block)SFBlocks.PURPLE_SPRINKLED_SAND.get(), this.existingModel(this.getName((Block)SFBlocks.PURPLE_SPRINKLED_SAND.get())));
        this.simpleBlock((Block)SFBlocks.RED_SPRINKLED_SAND.get());
        this.simpleBlockItem((Block)SFBlocks.RED_SPRINKLED_SAND.get(), this.existingModel(this.getName((Block)SFBlocks.RED_SPRINKLED_SAND.get())));
        this.simpleBlock((Block)SFBlocks.GRAVELY_SAND.get());
        this.simpleBlockItem((Block)SFBlocks.GRAVELY_SAND.get(), this.existingModel(this.getName((Block)SFBlocks.GRAVELY_SAND.get())));
        this.simpleBlock((Block)SFBlocks.ROCKY_SAND.get());
        this.simpleBlockItem((Block)SFBlocks.ROCKY_SAND.get(), this.existingModel(this.getName((Block)SFBlocks.ROCKY_SAND.get())));
        this.simpleBlock((Block)SFBlocks.MIXED_SHELLY_SAND.get());
        this.simpleBlockItem((Block)SFBlocks.MIXED_SHELLY_SAND.get(), this.existingModel(this.getName((Block)SFBlocks.MIXED_SHELLY_SAND.get())));
        this.simpleBlock((Block)SFBlocks.SCATTERED_SHELLY_SAND.get());
        this.simpleBlockItem((Block)SFBlocks.SCATTERED_SHELLY_SAND.get(), this.existingModel(this.getName((Block)SFBlocks.SCATTERED_SHELLY_SAND.get())));
        this.simpleBlock((Block)SFBlocks.JUMBLED_SHELLY_SAND.get());
        this.simpleBlockItem((Block)SFBlocks.JUMBLED_SHELLY_SAND.get(), this.existingModel(this.getName((Block)SFBlocks.JUMBLED_SHELLY_SAND.get())));
        this.paneBlock((IronBarsBlock)SFBlocks.BLUE_SEAGLASS_PANE.get(), new ResourceLocation("seafarer", "block/blue_seaglass_block"), new ResourceLocation("seafarer", "block/blue_seaglass_pane_top"));
        this.paneBlock((IronBarsBlock)SFBlocks.BROWN_SEAGLASS_PANE.get(), new ResourceLocation("seafarer", "block/brown_seaglass_block"), new ResourceLocation("seafarer", "block/brown_seaglass_pane_top"));
        this.paneBlock((IronBarsBlock)SFBlocks.GREEN_SEAGLASS_PANE.get(), new ResourceLocation("seafarer", "block/green_seaglass_block"), new ResourceLocation("seafarer", "block/green_seaglass_pane_top"));
        this.paneBlock((IronBarsBlock)SFBlocks.ORANGE_SEAGLASS_PANE.get(), new ResourceLocation("seafarer", "block/orange_seaglass_block"), new ResourceLocation("seafarer", "block/orange_seaglass_pane_top"));
        this.paneBlock((IronBarsBlock)SFBlocks.PURPLE_SEAGLASS_PANE.get(), new ResourceLocation("seafarer", "block/purple_seaglass_block"), new ResourceLocation("seafarer", "block/purple_seaglass_pane_top"));
        this.paneBlock((IronBarsBlock)SFBlocks.RED_SEAGLASS_PANE.get(), new ResourceLocation("seafarer", "block/red_seaglass_block"), new ResourceLocation("seafarer", "block/red_seaglass_pane_top"));
        this.paneBlock((IronBarsBlock)SFBlocks.WHITE_SEAGLASS_PANE.get(), new ResourceLocation("seafarer", "block/white_seaglass_block"), new ResourceLocation("seafarer", "block/white_seaglass_pane_top"));
        this.paneBlock((IronBarsBlock)SFBlocks.YELLOW_SEAGLASS_PANE.get(), new ResourceLocation("seafarer", "block/yellow_seaglass_block"), new ResourceLocation("seafarer", "block/yellow_seaglass_pane_top"));
        this.simpleBlock((Block)SFBlocks.SALT_BLOCK.get());
        this.simpleBlockItem((Block)SFBlocks.SALT_BLOCK.get(), this.existingModel(this.getName((Block)SFBlocks.SALT_BLOCK.get())));
        this.createPottedPlant(SFBlocks.SEA_THRIFT, SFBlocks.POTTED_SEA_THRIFT, "cutout");
        this.createPottedPlant(SFBlocks.SEA_HOLLY, SFBlocks.POTTED_SEA_HOLLY, "cutout");
        this.createPottedPlant(SFBlocks.COASTAL_LAVENDER, SFBlocks.POTTED_COASTAL_LAVENDER, "cutout");
        this.createPottedPlant(SFBlocks.COASTAL_WILDFLOWER, SFBlocks.POTTED_COASTAL_WILDFLOWER, "cutout");
        this.simpleBlock((Block)SFBlocks.ALGAE_COBBLESTONE.get());
        this.simpleBlockItem((Block)SFBlocks.ALGAE_COBBLESTONE.get(), this.existingModel(this.getName((Block)SFBlocks.ALGAE_COBBLESTONE.get())));
        this.slabBlock((SlabBlock)SFBlocks.ALGAE_COBBLESTONE_SLAB.get(), this.resourceBlock(this.getName((Block)SFBlocks.ALGAE_COBBLESTONE.get())), new ResourceLocation("seafarer", "block/algae_cobblestone"));
        this.simpleBlockItem((Block)SFBlocks.ALGAE_COBBLESTONE_SLAB.get(), this.existingModel(this.getName((Block)SFBlocks.ALGAE_COBBLESTONE_SLAB.get())));
        this.stairsBlock((StairBlock)SFBlocks.ALGAE_COBBLESTONE_STAIRS.get(), new ResourceLocation("seafarer", "block/algae_cobblestone"));
        this.simpleBlockItem((Block)SFBlocks.ALGAE_COBBLESTONE_STAIRS.get(), this.existingModel(this.getName((Block)SFBlocks.ALGAE_COBBLESTONE_STAIRS.get())));
    }

    private void createPottedPlant(RegistryObject<Block> plant, RegistryObject<Block> pottedPlant, String renderType) {
        ConfiguredModel cFfile = new ConfiguredModel(this.pottedPlant(this.name((Block)pottedPlant.get()), this.blockTexture((Block)plant.get()), renderType));
        this.getVariantBuilder((Block)pottedPlant.get()).partialState().setModels(new ConfiguredModel[]{cFfile});
    }

    public ModelFile pottedPlant(String name, ResourceLocation plant, String renderType) {
        return this.singleTexture(name, "block/flower_pot_cross", "plant", plant, renderType);
    }

    private void createWallFan(RegistryObject<Block> b, String renderType) {
        ModelFile file = new ConfiguredModel((ModelFile)this.wallCoral((String)this.name((Block)((Block)b.get())), (ResourceLocation)this.blockTexture((Block)((Block)b.get())), (String)renderType)).model;
        this.getVariantBuilder((Block)b.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(file).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build());
        this.simpleBlockItem((Block)b.get(), file);
    }

    private void createTintedCross(RegistryObject<Block> b, String renderType) {
        this.getVariantBuilder((Block)b.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel(this.tintedCross(this.name((Block)b.get()), this.blockTexture((Block)b.get()), renderType))});
    }

    public ModelFile tintedCross(String name, ResourceLocation cross, String renderType) {
        return this.singleTexture(name, "block/tinted_cross", "cross", cross, renderType);
    }

    private void createDoubleCross(RegistryObject<Block> b, String renderType) {
        String baseName = this.name((Block)b.get());
        this.getVariantBuilder((Block)b.get()).forAllStatesExcept(e -> {
            DoubleBlockHalf val = (DoubleBlockHalf)e.m_61143_((Property)DoublePlantBlock.f_52858_);
            String mod = val == DoubleBlockHalf.LOWER ? "bottom" : "top";
            ResourceLocation texture = SeaFarer.prefix("block/" + baseName + "_" + mod);
            ModelFile text = this.cross(baseName + "_" + mod, texture, renderType);
            return ConfiguredModel.builder().modelFile(text).build();
        }, new Property[0]);
        this.singleTex((Block)b.get(), baseName + "_top");
    }

    private void createCross(RegistryObject<Block> b, String renderType) {
        ConfiguredModel cFfile = new ConfiguredModel(this.cross(this.name((Block)b.get()), this.blockTexture((Block)b.get()), renderType));
        ModelFile file = cFfile.model;
        String baseName = this.name((Block)b.get());
        this.getVariantBuilder((Block)b.get()).partialState().setModels(new ConfiguredModel[]{cFfile});
        this.singleTex((Block)b.get(), baseName);
    }

    public ModelFile cross(String name, ResourceLocation cross, String renderType) {
        return this.singleTexture(name, "block/cross", "cross", cross, renderType);
    }

    private ModelFile singleTexture(String name, String parent, String textureKey, ResourceLocation texture, String renderType) {
        return this.singleTexture(name, this.mcLoc(parent), textureKey, texture, renderType);
    }

    public ModelFile wallCoral(String name, ResourceLocation fan, String renderType) {
        return this.singleTexture(name, "block/coral_wall_fan", "fan", fan, renderType);
    }

    private void createCoralFan(RegistryObject<Block> b, String renderType) {
        this.getVariantBuilder((Block)b.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel(this.coralFan(this.name((Block)b.get()), this.blockTexture((Block)b.get()), renderType))});
        this.singleTex((Block)b.get());
    }

    public ModelFile coralFan(String name, ResourceLocation fan, String renderType) {
        return this.singleTexture(name, "block/coral_fan", "fan", fan, renderType);
    }

    public ModelFile singleTexture(String name, ResourceLocation parent, String textureKey, ResourceLocation texture, String renderType) {
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, parent)).texture(textureKey, texture)).renderType(renderType);
    }

    private BlockModelBuilder generatedWall(String name, ResourceLocation ... layers) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent("block/" + name, "block/wall_inventory");
        for (int i = 0; i < layers.length; ++i) {
            builder = (BlockModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private BlockModelBuilder generatedSlab(String name, ResourceLocation ... layers) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent("block/" + name, "block/slab");
        for (int i = 0; i < layers.length; ++i) {
            builder = (BlockModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private void blockWithTop(RegistryObject<Block> blockRegistryObject) {
        this.horizontalBlock((Block)blockRegistryObject.get(), SeaFarer.prefix("block/" + this.key((Block)blockRegistryObject.get()).m_135815_()), SeaFarer.prefix("block/" + this.key((Block)blockRegistryObject.get()).m_135815_()), SeaFarer.prefix("block/" + this.key((Block)blockRegistryObject.get()).m_135815_() + "_top"));
        this.simpleBlockItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private BlockModelBuilder singleTexItem(Block block, ResourceLocation name) {
        return this.generated(this.name(block), name);
    }

    private BlockModelBuilder singleTexItem(Block block) {
        return this.generated(this.name(block), new ResourceLocation("seafarer", "item/" + this.name(block)));
    }

    private BlockModelBuilder singleTex(Block block) {
        return this.singleTex(block, this.name(block));
    }

    private BlockModelBuilder singleTex(Block block, String name) {
        return this.generated(this.name(block), new ResourceLocation("seafarer", "block/" + name));
    }

    private BlockModelBuilder generated(String name, ResourceLocation ... layers) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent("item/" + name, "item/generated");
        for (int i = 0; i < layers.length; ++i) {
            builder = (BlockModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    public ModelFile createFlatWaterEgg(Block block, String modifier) {
        String baseName = this.getName(block);
        return this.models().singleTexture("block/eggs/" + modifier + baseName.replace("seafarer:", ""), new ResourceLocation("seafarer", "block/template_eggs/template_flat_water_egg"), this.blockTextureEggs(block));
    }

    public ResourceLocation blockTextureEggs(Block block) {
        ResourceLocation name = this.key(block);
        return new ResourceLocation(name.m_135827_(), "block/eggs/" + name.m_135815_());
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private String getName(Block block) {
        return this.key(block).toString().replace("seafarer:", "");
    }

    private Block getBlock(ResourceLocation resourceLocation) {
        return (Block)BuiltInRegistries.f_256975_.m_7745_(resourceLocation);
    }

    public String m_6055_() {
        return "Block States: seafarer";
    }
}

