/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer.common.world.feature;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.peeko32213.seafarer.common.world.feature.util.FastNoiseLite;
import com.peeko32213.seafarer.core.registry.SFBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.slf4j.Logger;

public class AlgaeBoulderFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public AlgaeBoulderFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        BlockPos blockpos = context.m_159777_();
        RandomSource random = context.m_225041_();
        FastNoiseLite noise = AlgaeBoulderFeature.createNoise(worldgenlevel.m_7328_(), 0.05f);
        FastNoiseLite noise2 = AlgaeBoulderFeature.createNoise(worldgenlevel.m_7328_(), 0.4f);
        FastNoiseLite noise3 = AlgaeBoulderFeature.createNoise(worldgenlevel.m_7328_(), 0.5f);
        double middleBlockZ = worldgenlevel.m_6325_(blockpos.m_123341_() >> 4, blockpos.m_123343_() >> 4).m_7697_().m_151393_();
        double middleBlockX = worldgenlevel.m_6325_(blockpos.m_123341_() >> 4, blockpos.m_123343_() >> 4).m_7697_().m_151390_();
        double cornerBlockZ = worldgenlevel.m_6325_(blockpos.m_123341_() >> 4, blockpos.m_123343_() >> 4).m_7697_().m_45605_();
        double cornerBlockX = worldgenlevel.m_6325_(blockpos.m_123341_() >> 4, blockpos.m_123343_() >> 4).m_7697_().m_45604_();
        BlockPos blockPosMid = BlockPos.m_274561_((double)middleBlockX, (double)worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, (int)middleBlockX, (int)middleBlockZ), (double)middleBlockZ);
        BlockPos blockPosCorner = BlockPos.m_274561_((double)cornerBlockX, (double)worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, (int)cornerBlockX, (int)cornerBlockZ), (double)cornerBlockZ);
        int radius = random.m_216339_(5, 10);
        AlgaeBoulderFeature.createSphere(worldgenlevel, random, blockPosMid, noise);
        AlgaeBoulderFeature.addBushes(worldgenlevel, random, blockPosMid, noise3, radius);
        return true;
    }

    public static void createSphere(WorldGenLevel worldgenlevel, RandomSource rand, BlockPos origin, FastNoiseLite noise) {
        int height;
        int radius = height = rand.m_216339_(2, 4);
        BlockState block = ((Block)SFBlocks.ALGAE_COBBLESTONE.get()).m_49966_();
        BlockState block2 = ((Block)SFBlocks.ALGAE_BLOCK.get()).m_49966_();
        BlockState block3 = Blocks.f_50652_.m_49966_();
        BlockState block4 = Blocks.f_49992_.m_49966_();
        origin = origin.m_7918_(0, 0, 0);
        for (int x = -radius; x < radius; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    BlockPos pos = origin.m_7918_(x, y, z);
                    BlockPos pos2 = origin.m_7918_(x, -y, z);
                    double distance = AlgaeBoulderFeature.distance(x, y, z, radius, height, radius);
                    float f = noise.GetNoise(x, y, z);
                    if (!(distance < 1.0)) continue;
                    if ((double)f < 0.3 && (double)f >= -0.5) {
                        worldgenlevel.m_7731_(pos, block, 3);
                        worldgenlevel.m_7731_(pos2, block, 3);
                        continue;
                    }
                    if ((double)f >= 0.3 && (double)f < 0.5) {
                        worldgenlevel.m_7731_(pos, block2, 3);
                        worldgenlevel.m_7731_(pos2, block2, 3);
                        continue;
                    }
                    if ((double)f >= 0.2 && (double)f < 0.4) {
                        worldgenlevel.m_7731_(pos, block3, 3);
                        worldgenlevel.m_7731_(pos2, block3, 3);
                        continue;
                    }
                    if (!((double)f >= 0.7) || !((double)f < 0.9)) continue;
                    worldgenlevel.m_7731_(pos, block4, 3);
                    worldgenlevel.m_7731_(pos2, block4, 3);
                }
            }
        }
    }

    public static void addBushes(WorldGenLevel worldgenlevel, RandomSource rand, BlockPos origin, FastNoiseLite noise, int radius) {
        BlockState block = ((Block)SFBlocks.ALGAE_PLANT.get()).m_49966_();
        BlockState block2 = (BlockState)((Block)SFBlocks.ALGAE_CARPET.get()).m_49966_().m_61124_((Property)MultifaceBlock.m_153933_((Direction)Direction.DOWN), (Comparable)Boolean.valueOf(true));
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                boolean isCorrectBlock;
                BlockPos pos = origin.m_7918_(x, 0, z);
                double yHeight = worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_());
                BlockPos pos2 = BlockPos.m_274561_((double)pos.m_123341_(), (double)yHeight, (double)pos.m_123343_());
                double distance = AlgaeBoulderFeature.distance(x, 0.0, z, radius, 1.0, radius);
                float f = noise.GetNoise(x, (float)yHeight, z);
                if (!(distance < 1.0)) continue;
                boolean bl = isCorrectBlock = worldgenlevel.m_8055_(pos2).m_60713_(Blocks.f_50016_) || !worldgenlevel.m_6425_(pos2).m_76178_() || worldgenlevel.m_8055_(pos2.m_7495_()).m_204336_(BlockTags.f_13061_) || worldgenlevel.m_8055_(pos2.m_7495_()).m_60713_((Block)SFBlocks.ALGAE_COBBLESTONE.get());
                if (f > 0.0f && (double)f < 0.5 && isCorrectBlock) {
                    block = (BlockState)block.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(worldgenlevel.m_6425_(pos2).m_192917_((Fluid)Fluids.f_76193_)));
                    worldgenlevel.m_7731_(pos2, block, 3);
                }
                if (!((double)f >= 0.5) || !(f < 1.0f) || !isCorrectBlock) continue;
                block2 = (BlockState)block2.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(worldgenlevel.m_6425_(pos2).m_192917_((Fluid)Fluids.f_76193_)));
                worldgenlevel.m_7731_(pos2, block2, 3);
            }
        }
    }

    public static void changeTerrain(WorldGenLevel worldgenlevel, RandomSource rand, BlockPos origin, FastNoiseLite noise, int radius) {
        BlockState block = ((Block)SFBlocks.GRAVELY_SAND.get()).m_49966_();
        BlockState block2 = ((Block)SFBlocks.ROCKY_SAND.get()).m_49966_();
        BlockState block3 = Blocks.f_50546_.m_49966_();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                boolean isCorrectBlock;
                BlockPos pos = origin.m_7918_(x, 0, z);
                double yHeight = worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_()) - 1;
                BlockPos pos2 = BlockPos.m_274561_((double)pos.m_123341_(), (double)yHeight, (double)pos.m_123343_());
                double distance = AlgaeBoulderFeature.distance(x, 0.0, z, radius, 1.0, radius);
                float f = noise.GetNoise(x, (float)yHeight, z);
                if (!(distance < 1.0)) continue;
                boolean bl = isCorrectBlock = worldgenlevel.m_8055_(pos2).m_204336_(BlockTags.f_144274_) || worldgenlevel.m_8055_(pos2).m_204336_(BlockTags.f_13029_) || worldgenlevel.m_8055_(pos2).m_60713_(Blocks.f_49994_);
                if (f < 0.0f && (double)f >= -0.4 && isCorrectBlock) {
                    worldgenlevel.m_7731_(pos2, block, 3);
                    continue;
                }
                if (!(f > 0.0f) || !((double)f < 0.2) || !isCorrectBlock) continue;
                worldgenlevel.m_7731_(pos2, block2, 3);
            }
        }
    }

    public static double distance(double x, double y, double z, double xRadius, double yRadius, double zRadius) {
        return Mth.m_144952_((double)(x / xRadius)) + Mth.m_144952_((double)(y / yRadius)) + Mth.m_144952_((double)(z / zRadius));
    }

    private static FastNoiseLite createNoise(long seed, float frequency) {
        FastNoiseLite noise = new FastNoiseLite((int)seed);
        noise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        noise.SetFrequency(frequency);
        return noise;
    }
}

