/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer.common.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.peeko32213.seafarer.common.entity.Brushable;
import com.peeko32213.seafarer.common.entity.StatedAnimal;
import com.peeko32213.seafarer.common.entity.goal.CustomRandomStrollGoal;
import com.peeko32213.seafarer.common.entity.goal.FindWaterGoal;
import com.peeko32213.seafarer.common.entity.goal.GrazeAlgaeGoal;
import com.peeko32213.seafarer.common.entity.goal.LeaveWaterGoal;
import com.peeko32213.seafarer.common.entity.goal.SemiAquaticSwimmingGoal;
import com.peeko32213.seafarer.common.entity.misc.controller.WaterMoveController;
import com.peeko32213.seafarer.common.entity.misc.interfaces.SemiAquatic;
import com.peeko32213.seafarer.common.entity.misc.navigator.SemiAquaticPathNavigation;
import com.peeko32213.seafarer.common.entity.misc.state.EntityAction;
import com.peeko32213.seafarer.common.entity.misc.state.RandomStateGoal;
import com.peeko32213.seafarer.common.entity.misc.state.StateHelper;
import com.peeko32213.seafarer.common.entity.misc.state.WeightedState;
import com.peeko32213.seafarer.core.registry.SFItems;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityMarineIguana
extends StatedAnimal
implements GeoAnimatable,
SemiAquatic,
Brushable,
IForgeShearable {
    private static final EntityDataAccessor<Integer> SALT = SynchedEntityData.m_135353_(EntityMarineIguana.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation MARINE_IGUANA_WALK = RawAnimation.begin().thenLoop("animation.marineiguana.walk");
    private static final RawAnimation MARINE_IGUANA_RUN = RawAnimation.begin().thenLoop("animation.marineiguana.run");
    private static final RawAnimation MARINE_IGUANA_IDLE = RawAnimation.begin().thenLoop("animation.marineiguana.idle");
    private static final RawAnimation MARINE_IGUANA_SIT1 = RawAnimation.begin().thenLoop("animation.marineiguana.sit1");
    private static final RawAnimation MARINE_IGUANA_SIT2 = RawAnimation.begin().thenLoop("animation.marineiguana.sit2");
    private static final RawAnimation MARINE_IGUANA_SIT3 = RawAnimation.begin().thenLoop("animation.marineiguana.sit3");
    private static final RawAnimation MARINE_IGUANA_SWIM = RawAnimation.begin().thenLoop("animation.marineiguana.swim");
    private static final RawAnimation MARINE_IGUANA_SWIM_IDLE = RawAnimation.begin().thenLoop("animation.marineiguana.swim_idle");
    private static final RawAnimation MARINE_IGUANA_SNEEZE = RawAnimation.begin().thenLoop("animation.marineiguana.sneeze");
    private static final RawAnimation MARINE_IGUANA_GRAZE = RawAnimation.begin().thenLoop("animation.marineiguana.graze");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public float prevSwimProgress;
    public float swimProgress;
    private int swimTimer = -1000;
    private boolean isLandNavigator;
    private GrazeAlgaeGoal eatBlockGoal;
    private int eatAnimationTick;
    private int SaltTime = 0;
    private static final EntityDataAccessor<Boolean> SIT_1 = SynchedEntityData.m_135353_(EntityMarineIguana.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SIT_2 = SynchedEntityData.m_135353_(EntityMarineIguana.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SIT_3 = SynchedEntityData.m_135353_(EntityMarineIguana.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityAction IGUANA_SIT_1_ACTION = new EntityAction(0, e -> {}, 1);
    private static final StateHelper IGUANA_SIT_1_STATE = StateHelper.Builder.state(SIT_1, "iguana_sit_1").playTime(70).stopTime(100).affectsAI(true).affectedFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK)).entityAction(IGUANA_SIT_1_ACTION).build();
    private static final EntityAction IGUANA_SIT_2_ACTION = new EntityAction(0, e -> {}, 1);
    private static final StateHelper IGUANA_SIT_2_STATE = StateHelper.Builder.state(SIT_2, "iguana_sit_2").playTime(70).stopTime(100).affectsAI(true).affectedFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK)).entityAction(IGUANA_SIT_2_ACTION).build();
    private static final EntityAction IGUANA_SIT_3_ACTION = new EntityAction(0, e -> {}, 1);
    private static final StateHelper IGUANA_SIT_3_STATE = StateHelper.Builder.state(SIT_3, "iguana_sit_3").playTime(70).stopTime(100).affectsAI(true).affectedFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK)).entityAction(IGUANA_SIT_3_ACTION).build();

    public EntityMarineIguana(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22279_, 0.18).m_22268_(Attributes.f_22278_, 0.5);
    }

    protected void m_8099_() {
        this.eatBlockGoal = new GrazeAlgaeGoal((Mob)this);
        this.f_21345_.m_25352_(2, (Goal)this.eatBlockGoal);
        this.f_21345_.m_25352_(7, (Goal)new FindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(7, (Goal)new LeaveWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(9, (Goal)new SemiAquaticSwimmingGoal(this, 1.0, 10));
        this.f_21345_.m_25352_(3, (Goal)new CustomRandomStrollGoal((PathfinderMob)this, 30, 1.0, 100, 34));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(3, new RandomStateGoal<EntityMarineIguana>(this));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new WaterMoveController((PathfinderMob)this, 1.1f);
            this.f_21344_ = new SemiAquaticPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigator = false;
        }
    }

    public void m_8119_() {
        boolean ground;
        super.m_8119_();
        this.prevSwimProgress = this.swimProgress;
        boolean bl = ground = !this.m_20072_();
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (ground && this.swimProgress > 0.0f) {
            this.swimProgress -= 1.0f;
        }
        if (!ground && this.swimProgress < 5.0f) {
            this.swimProgress += 1.0f;
        }
        if (!this.m_9236_().f_46443_) {
            this.swimTimer = this.m_20069_() ? ++this.swimTimer : --this.swimTimer;
        }
        ++this.SaltTime;
        if (this.m_6084_() && this.SaltTime > 2000) {
            this.SaltTime = 0;
            this.setSalt(Math.min(10, this.getSalt() + 1));
        }
    }

    @Override
    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.m_7822_(pId);
        }
    }

    public boolean isEating() {
        return this.eatAnimationTick > 0;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SALT, (Object)0);
        this.f_19804_.m_135372_(SIT_1, (Object)false);
        this.f_19804_.m_135372_(SIT_2, (Object)false);
        this.f_19804_.m_135372_(SIT_3, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SwimTimer", this.swimTimer);
        compound.m_128405_("SaltTime", this.SaltTime);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.swimTimer = compound.m_128451_("SwimTimer");
        this.SaltTime = compound.m_128451_("SaltTime");
    }

    public int getSalt() {
        return (Integer)this.f_19804_.m_135370_(SALT);
    }

    public void setSalt(int Salt) {
        this.f_19804_.m_135381_(SALT, (Object)Salt);
    }

    public boolean m_6040_() {
        return true;
    }

    @Override
    public boolean shouldEnterWater() {
        return !this.shouldLeaveWater() && this.swimTimer <= -1000;
    }

    @Override
    public boolean shouldLeaveWater() {
        LivingEntity target = this.m_5448_();
        if (target != null && !target.m_20069_()) {
            return true;
        }
        return this.swimTimer > 600;
    }

    @Override
    public int getWaterSearchRange() {
        return 12;
    }

    @Override
    public boolean shouldStopMoving() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    protected <E extends EntityMarineIguana> PlayState Controller(AnimationState<E> event) {
        if (!(event.getLimbSwingAmount() > -0.06f && event.getLimbSwingAmount() < 0.06f || this.m_20069_())) {
            if (this.m_20142_()) {
                event.setAndContinue(MARINE_IGUANA_RUN);
                event.getController().setAnimationSpeed(2.0);
                return PlayState.CONTINUE;
            }
            return event.setAndContinue(MARINE_IGUANA_WALK);
        }
        if (!(event.getLimbSwingAmount() > -0.06f && event.getLimbSwingAmount() < 0.06f || !this.m_20069_())) {
            event.setAnimation(MARINE_IGUANA_SWIM);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.m_20069_()) {
            event.setAnimation(MARINE_IGUANA_SWIM_IDLE);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.getBooleanState(SIT_1)) {
            return event.setAndContinue(MARINE_IGUANA_SIT1);
        }
        if (this.getBooleanState(SIT_2)) {
            return event.setAndContinue(MARINE_IGUANA_SIT2);
        }
        if (this.getBooleanState(SIT_3)) {
            return event.setAndContinue(MARINE_IGUANA_SIT3);
        }
        if (this.isEating()) {
            event.setAndContinue(MARINE_IGUANA_GRAZE);
            return PlayState.CONTINUE;
        }
        return event.setAndContinue(MARINE_IGUANA_IDLE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @javax.annotation.Nullable SpawnGroupData spawnGroupData, @javax.annotation.Nullable CompoundTag tag) {
        spawnGroupData = super.m_6518_(levelAccessor, difficultyInstance, spawnType, spawnGroupData, tag);
        return spawnGroupData;
    }

    public static boolean checkMarineIguanaSpawnRules(EntityType<? extends EntityMarineIguana> dino, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource p_186242_) {
        return EntityMarineIguana.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    @Override
    public void startBrusing() {
    }

    @Override
    public void endBrushing() {
    }

    @Override
    public boolean isBrushable(Player player, @NotNull ItemStack item, Level level, BlockPos pos) {
        return this.canBeBrushed();
    }

    public boolean canBeBrushed() {
        return this.m_6084_() && this.getSalt() > 0;
    }

    @Override
    public List<ItemStack> brush(long gameTime, Player player, Direction direction, ItemStack stack, Level level, BlockPos pos, int fortune) {
        level.m_6269_(null, (Entity)this, SoundEvents.f_276624_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        this.m_146850_(GameEvent.f_223708_);
        if (!level.m_5776_() && this.f_19796_.m_188501_() < (float)this.getSalt() * 0.05f) {
            ItemStack stack1 = ((Item)SFItems.SALT.get()).m_7968_();
            stack1.m_41764_(this.getSalt());
            return Collections.singletonList(stack1);
        }
        this.setSalt(0);
        return Collections.emptyList();
    }

    @Override
    public SoundEvent brushSound() {
        return SoundEvents.f_276624_;
    }

    @Override
    public ImmutableMap<String, StateHelper> getStates() {
        return ImmutableMap.of((Object)IGUANA_SIT_1_STATE.getName(), (Object)IGUANA_SIT_1_STATE, (Object)IGUANA_SIT_2_STATE.getName(), (Object)IGUANA_SIT_2_STATE, (Object)IGUANA_SIT_3_STATE.getName(), (Object)IGUANA_SIT_3_STATE);
    }

    @Override
    public List<WeightedState<StateHelper>> getWeightedStatesToPerform() {
        return ImmutableList.of(WeightedState.of(IGUANA_SIT_1_STATE, 77), WeightedState.of(IGUANA_SIT_2_STATE, 15), WeightedState.of(IGUANA_SIT_3_STATE, 10));
    }
}

