/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer.common.block.entity;

import com.mojang.logging.LogUtils;
import com.peeko32213.seafarer.core.registry.SFBlockEntities;
import com.peeko32213.seafarer.core.registry.SFLootTables;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SFNetBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MAX_SALT = 1;
    private static final int MAX_BRUSH_TIME = 40;
    private static final int SALT_GATHER_TIME = 24000;
    private int saltCount;
    private int gatherTicks;
    private long brushCountResetsAtTick;
    private long coolDownEndsAtTick;
    @javax.annotation.Nullable
    private Direction hitDirection;
    private int brushCount;
    private ItemStack item = ItemStack.f_41583_;
    @javax.annotation.Nullable
    private static final ResourceLocation LOOT_TABLE = SFLootTables.FISHING_NET;
    private final long lootTableSeed;

    public SFNetBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)SFBlockEntities.NET_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.lootTableSeed = pPos.m_121878_();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("count", this.saltCount);
        tag.m_128405_("gatherTicks", this.gatherTicks);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.saltCount = nbt.m_128451_("count");
        this.gatherTicks = nbt.m_128451_("gatherTicks");
    }

    public int getGatherTicks() {
        return this.gatherTicks;
    }

    public int getSaltCount() {
        return this.saltCount;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, SFNetBlockEntity pBlockEntity) {
        if (!pLevel.m_204166_(pPos).m_203656_(BiomeTags.f_207603_) || !pLevel.m_204166_(pPos).m_203656_(BiomeTags.f_207604_) || pPos.m_123342_() < 62) {
            return;
        }
        if (pBlockEntity.saltCount < 1 && pBlockEntity.gatherTicks < 24000) {
            ++pBlockEntity.gatherTicks;
        } else if (pBlockEntity.saltCount < 1) {
            ++pBlockEntity.saltCount;
        }
    }

    public boolean brush(long gameTime, Player player, Direction direction) {
        if (this.hitDirection == null) {
            this.hitDirection = direction;
        }
        this.brushCountResetsAtTick = gameTime + 40L;
        if (gameTime >= this.coolDownEndsAtTick && this.f_58857_ instanceof ServerLevel && this.saltCount >= 1) {
            this.coolDownEndsAtTick = gameTime + 10L;
            this.unpackLootTable(player);
            int i = this.getCompletionState();
            if (++this.brushCount >= 5) {
                this.brushingCompleted(player);
                return true;
            }
            return false;
        }
        return false;
    }

    public void unpackLootTable(Player player) {
        if (LOOT_TABLE != null && this.f_58857_ != null && !this.f_58857_.m_5776_() && this.f_58857_.m_7654_() != null) {
            LootTable lootTable = this.f_58857_.m_7654_().m_278653_().m_278676_(LOOT_TABLE);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)player;
                CriteriaTriggers.f_10563_.m_54597_(serverplayer, LOOT_TABLE);
            }
            LootParams lootparams = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_287239_(player.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)player).m_287235_(LootContextParamSets.f_81411_);
            ObjectArrayList objectarraylist = lootTable.m_287214_(lootparams, this.lootTableSeed);
            this.item = switch (objectarraylist.size()) {
                case 0 -> ItemStack.f_41583_;
                case 1 -> (ItemStack)objectarraylist.get(0);
                default -> {
                    LOGGER.warn("Expected max 1 loot from loot table " + LOOT_TABLE + " got " + objectarraylist.size());
                    yield (ItemStack)objectarraylist.get(0);
                }
            };
            this.m_6596_();
        }
    }

    private void brushingCompleted(Player player) {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            this.dropContent(player);
            BlockState blockstate = this.m_58900_();
            this.f_58857_.m_46796_(3008, this.m_58899_(), Block.m_49956_((BlockState)blockstate));
            --this.saltCount;
            this.brushCount = 0;
            this.gatherTicks = 0;
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
            this.m_6596_();
        }
    }

    private void dropContent(Player player) {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            this.unpackLootTable(player);
            if (!this.item.m_41619_()) {
                double d0 = EntityType.f_20461_.m_20678_();
                double d1 = 1.0 - d0;
                double d2 = d0 / 2.0;
                Direction direction = Objects.requireNonNullElse(this.hitDirection, Direction.UP);
                BlockPos blockpos = this.f_58858_.m_5484_(direction, 1);
                double d3 = (double)blockpos.m_123341_() + 0.5 * d1 + d2;
                double d4 = (double)blockpos.m_123342_() - 0.8 + (double)(EntityType.f_20461_.m_20679_() / 2.0f);
                double d5 = (double)blockpos.m_123343_() + 0.5 * d1 + d2;
                ItemEntity itementity = new ItemEntity(this.f_58857_, d3, d4, d5, this.item.m_41620_(this.f_58857_.f_46441_.m_188503_(21) + 10));
                itementity.m_20256_(Vec3.f_82478_);
                this.f_58857_.m_7967_((Entity)itementity);
                this.item = ItemStack.f_41583_;
            }
        }
    }

    private int getCompletionState() {
        if (this.brushCount == 0) {
            return 0;
        }
        if (this.brushCount < 3) {
            return 1;
        }
        return this.brushCount < 6 ? 2 : 3;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_("count", this.saltCount);
        return compoundTag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundTag tag = pkt.m_131708_();
        if (tag != null && tag.m_128425_("count", 10)) {
            this.saltCount = tag.m_128451_("count");
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
    }
}

