/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.world.gen.processors.catacombs;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.blocks.TombBlock;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDItems;
import com.naterbobber.darkerdepths.init.DDStructureProcessorTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class TombProcessor
extends StructureProcessor {
    public static final Codec<TombProcessor> CODEC = Codec.unit(TombProcessor::new);
    private final Map<BlockPos, StructureTemplate.StructureBlockInfo> tombPartsMap = new HashMap<BlockPos, StructureTemplate.StructureBlockInfo>();

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader level, BlockPos templatePos, BlockPos worldPos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        BlockState blockState = relativeBlockInfo.f_74676_();
        if (blockState.m_60713_(Blocks.f_50528_)) {
            Direction facing = this.getFacingDirection(blockState, settings);
            Set<StructureTemplate.StructureBlockInfo> currentTombPartsSet = TombBlock.generateMultiblockForProcessor(worldPos, facing, level, relativeBlockInfo.f_74675_());
            HashMap currentTombParts = new HashMap();
            currentTombPartsSet.forEach(part -> currentTombParts.put(part.f_74675_(), part));
            this.tombPartsMap.putAll(currentTombParts);
            BlockState tombState = (BlockState)((BlockState)((BlockState)((BlockState)((Block)DDBlocks.TOMB.get()).m_49966_().m_61124_(TombBlock.PART, (Comparable)((Object)TombBlock.Part.FRONT_CENTER))).m_61124_((Property)TombBlock.FACING, (Comparable)facing)).m_61124_((Property)TombBlock.INHABITED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TombBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(worldPos).m_76152_() == Fluids.f_76193_));
            CompoundTag nbt = new CompoundTag();
            ListTag itemsNbt = new ListTag();
            ItemStack forsakenBronzeScrap = new ItemStack((ItemLike)DDItems.FORSAKEN_BRONZE_SCRAP.get());
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_("Slot", (byte)0);
            forsakenBronzeScrap.m_41739_(itemTag);
            itemsNbt.add((Object)itemTag);
            nbt.m_128365_("Items", (Tag)itemsNbt);
            return new StructureTemplate.StructureBlockInfo(relativeBlockInfo.f_74675_(), tombState, nbt);
        }
        StructureTemplate.StructureBlockInfo tombPart = this.tombPartsMap.get(relativeBlockInfo.f_74675_());
        if (tombPart != null) {
            return tombPart;
        }
        return relativeBlockInfo;
    }

    private Direction getFacingDirection(BlockState markerBlock, StructurePlaceSettings settings) {
        if (markerBlock.m_61138_((Property)BlockStateProperties.f_61374_)) {
            Direction markerFacing = (Direction)markerBlock.m_61143_((Property)BlockStateProperties.f_61374_);
            return settings.m_74404_().m_55954_(markerFacing);
        }
        return settings.m_74404_().m_55954_(Direction.NORTH);
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)DDStructureProcessorTypes.TOMB.get();
    }
}

