/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.init;

import com.google.common.collect.Maps;
import com.naterbobber.darkerdepths.blocks.AshBlock;
import com.naterbobber.darkerdepths.blocks.AshFullBlock;
import com.naterbobber.darkerdepths.blocks.ConnectedPillarBlock;
import com.naterbobber.darkerdepths.blocks.CrystalMelonBlock;
import com.naterbobber.darkerdepths.blocks.DDCeilingHangingSignBlock;
import com.naterbobber.darkerdepths.blocks.DDStandingSignBlock;
import com.naterbobber.darkerdepths.blocks.DDWallHangingSignBlock;
import com.naterbobber.darkerdepths.blocks.DDWallSignBlock;
import com.naterbobber.darkerdepths.blocks.DeadLivingCrystalBlock;
import com.naterbobber.darkerdepths.blocks.DeathAnchorBlock;
import com.naterbobber.darkerdepths.blocks.DrySproutsBlock;
import com.naterbobber.darkerdepths.blocks.DuskrockBlock;
import com.naterbobber.darkerdepths.blocks.GeyserBlock;
import com.naterbobber.darkerdepths.blocks.GlimmeringVinePlantBlock;
import com.naterbobber.darkerdepths.blocks.GlimmeringVinesBlock;
import com.naterbobber.darkerdepths.blocks.GlowshroomBlock;
import com.naterbobber.darkerdepths.blocks.GlowshroomLampBlock;
import com.naterbobber.darkerdepths.blocks.GlowshroomLanternBlock;
import com.naterbobber.darkerdepths.blocks.GlowspursBlock;
import com.naterbobber.darkerdepths.blocks.GrimestoneBlock;
import com.naterbobber.darkerdepths.blocks.LayeredDeepslateBlock;
import com.naterbobber.darkerdepths.blocks.LivingCrystalBlock;
import com.naterbobber.darkerdepths.blocks.MagmaPadBlock;
import com.naterbobber.darkerdepths.blocks.MobPlacerBlock;
import com.naterbobber.darkerdepths.blocks.MossyGrimestoneBlock;
import com.naterbobber.darkerdepths.blocks.ParanoiaAltarBlock;
import com.naterbobber.darkerdepths.blocks.PetrifiedRootBlock;
import com.naterbobber.darkerdepths.blocks.PetrifiedRootPlantBlock;
import com.naterbobber.darkerdepths.blocks.PorousBlock;
import com.naterbobber.darkerdepths.blocks.RopeBlock;
import com.naterbobber.darkerdepths.blocks.SproutsBlock;
import com.naterbobber.darkerdepths.blocks.StoneMelonBlock;
import com.naterbobber.darkerdepths.blocks.TombBlock;
import com.naterbobber.darkerdepths.blocks.VerticalSlabBlock;
import com.naterbobber.darkerdepths.blocks.VoidSoulJarBlock;
import com.naterbobber.darkerdepths.blocks.VoidSoulTorchBlock;
import com.naterbobber.darkerdepths.blocks.WallVoidSoulTorchBlock;
import com.naterbobber.darkerdepths.blocks.WoodPostBlock;
import com.naterbobber.darkerdepths.init.DDBlockSetTypes;
import com.naterbobber.darkerdepths.init.DDItems;
import com.naterbobber.darkerdepths.init.DDParticleTypes;
import com.naterbobber.darkerdepths.init.DDSoundEvents;
import com.naterbobber.darkerdepths.init.DDWoodType;
import com.naterbobber.darkerdepths.item.BlockItemWithHoverText;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="darkerdepths", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DDBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"darkerdepths");
    public static final Map<RegistryObject<? extends Item>, String> COMPAT = Maps.newLinkedHashMap();
    public static final BlockBehaviour.Properties PETRIFIED_LOG_PROPERTIES = DDBlocks.blockProperties(2.4f, 3.0f, SoundType.f_56763_, true);
    public static final BlockBehaviour.Properties PETRIFIED_PLANKS_PROPERTIES = DDBlocks.blockProperties(2.5f, 3.0f, SoundType.f_56736_, true);
    public static final BlockBehaviour.Properties PETRIFIED_BUTTON_PROPERTIES = DDBlocks.blockProperties(0.5f, SoundType.f_56736_, true);
    public static final BlockBehaviour.Properties PETRIFIED_SIGN_PROPERTIES = DDBlocks.blockProperties(1.0f, SoundType.f_56736_, true).m_60910_();
    public static final BlockBehaviour.Properties DARKSLATE_PROPERTIES = DDBlocks.blockProperties(3.5f, 6.5f, SoundType.f_154677_, true);
    public static final BlockBehaviour.Properties DARKSLATE_BRICKS_PROPERTIES = DDBlocks.blockProperties(4.0f, 7.5f, SoundType.f_154678_, true);
    public static final BlockBehaviour.Properties ARIDROCK_PROPERTIES = DDBlocks.blockProperties(1.5f, 6.0f, SoundType.f_56742_, true).m_284180_(MapColor.f_283761_);
    public static final BlockBehaviour.Properties ARIDROCK_BRICKS_PROPERTIES = DDBlocks.blockProperties(2.0f, 6.0f, SoundType.f_56742_, true).m_284180_(MapColor.f_283761_);
    public static final BlockBehaviour.Properties DUSKROCK_PROPERTIES = DDBlocks.blockProperties(1.25f, 4.0f, SoundType.f_154659_, true);
    public static final BlockBehaviour.Properties DUSKROCK_BRICKS_PROPERTIES = DDBlocks.blockProperties(1.5f, 5.0f, SoundType.f_56742_, true);
    public static final BlockBehaviour.Properties LIVING_CRYSTAL_PROPERTIES = DDBlocks.blockProperties(4.0f, 7.5f, SoundType.f_154677_, true).m_60977_();
    public static final BlockBehaviour.Properties FORSAKEN_BRONZE_PROPERTIES = DDBlocks.blockProperties(8.0f, 15.0f, SoundType.f_56725_, true);
    public static final RegistryObject<Block> PETRIFIED_LOG = DDBlocks.registerBlock("petrified_log", () -> new RotatedPillarBlock(PETRIFIED_LOG_PROPERTIES));
    public static final RegistryObject<Block> PETRIFIED_WOOD = DDBlocks.registerBlock("petrified_wood", () -> new RotatedPillarBlock(PETRIFIED_LOG_PROPERTIES));
    public static final RegistryObject<Block> STRIPPED_PETRIFIED_LOG = DDBlocks.registerBlock("stripped_petrified_log", () -> new RotatedPillarBlock(PETRIFIED_LOG_PROPERTIES));
    public static final RegistryObject<Block> STRIPPED_PETRIFIED_WOOD = DDBlocks.registerBlock("stripped_petrified_wood", () -> new RotatedPillarBlock(PETRIFIED_LOG_PROPERTIES));
    public static final RegistryObject<Block> PETRIFIED_PLANKS = DDBlocks.registerBlock("petrified_planks", () -> new Block(PETRIFIED_PLANKS_PROPERTIES));
    public static final RegistryObject<Block> VERTICAL_PETRIFIED_PLANKS = DDBlocks.registerCompatBlock("quark", "vertical_petrified_planks", () -> new Block(PETRIFIED_PLANKS_PROPERTIES));
    public static final RegistryObject<Block> PETRIFIED_STAIRS = DDBlocks.registerBlock("petrified_stairs", () -> new StairBlock(() -> ((Block)PETRIFIED_PLANKS.get()).m_49966_(), PETRIFIED_PLANKS_PROPERTIES));
    public static final RegistryObject<Block> PETRIFIED_SLAB = DDBlocks.registerBlock("petrified_slab", () -> new SlabBlock(PETRIFIED_PLANKS_PROPERTIES));
    public static final RegistryObject<Block> PETRIFIED_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "petrified_vertical_slab", () -> new VerticalSlabBlock(PETRIFIED_PLANKS_PROPERTIES));
    public static final RegistryObject<Block> PETRIFIED_FENCE = DDBlocks.registerBlock("petrified_fence", () -> new FenceBlock(PETRIFIED_PLANKS_PROPERTIES));
    public static final RegistryObject<Block> PETRIFIED_FENCE_GATE = DDBlocks.registerBlock("petrified_fence_gate", () -> new FenceGateBlock(PETRIFIED_PLANKS_PROPERTIES, DDWoodType.PETRIFIED));
    public static final RegistryObject<Block> PETRIFIED_DOOR = DDBlocks.registerBlock("petrified_door", () -> new DoorBlock(PETRIFIED_PLANKS_PROPERTIES, DDBlockSetTypes.PETRIFIED));
    public static final RegistryObject<Block> PETRIFIED_TRAPDOOR = DDBlocks.registerBlock("petrified_trapdoor", () -> new TrapDoorBlock(PETRIFIED_PLANKS_PROPERTIES, DDBlockSetTypes.PETRIFIED));
    public static final RegistryObject<Block> PETRIFIED_PRESSURE_PLATE = DDBlocks.registerBlock("petrified_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, PETRIFIED_BUTTON_PROPERTIES, DDBlockSetTypes.PETRIFIED));
    public static final RegistryObject<Block> PETRIFIED_BUTTON = DDBlocks.registerBlock("petrified_button", () -> new ButtonBlock(PETRIFIED_BUTTON_PROPERTIES, DDBlockSetTypes.PETRIFIED, 30, true));
    public static final RegistryObject<Block> PETRIFIED_SIGN = DDBlocks.registerNoTabBlock("petrified_sign", () -> new DDStandingSignBlock(PETRIFIED_SIGN_PROPERTIES, DDWoodType.PETRIFIED));
    public static final RegistryObject<Block> PETRIFIED_WALL_SIGN = DDBlocks.registerNoTabBlock("petrified_wall_sign", () -> new DDWallSignBlock(PETRIFIED_SIGN_PROPERTIES, DDWoodType.PETRIFIED));
    public static final RegistryObject<Block> PETRIFIED_HANGING_SIGN = DDBlocks.registerNoTabBlock("petrified_hanging_sign", () -> new DDCeilingHangingSignBlock(PETRIFIED_SIGN_PROPERTIES, DDWoodType.PETRIFIED));
    public static final RegistryObject<Block> PETRIFIED_WALL_HANGING_SIGN = DDBlocks.registerNoTabBlock("petrified_wall_hanging_sign", () -> new DDWallHangingSignBlock(PETRIFIED_SIGN_PROPERTIES, DDWoodType.PETRIFIED));
    public static final RegistryObject<Block> PETRIFIED_POST = DDBlocks.registerCompatBlock("quark", "petrified_post", () -> new WoodPostBlock(PETRIFIED_LOG_PROPERTIES.m_60955_()));
    public static final RegistryObject<Block> STRIPPED_PETRIFIED_POST = DDBlocks.registerCompatBlock("quark", "stripped_petrified_post", () -> new WoodPostBlock(PETRIFIED_LOG_PROPERTIES.m_60955_()));
    public static final RegistryObject<Block> POROUS_PETRIFIED_LOG = DDBlocks.registerBlock("porous_petrified_log", () -> new PorousBlock(PETRIFIED_LOG_PROPERTIES.m_60977_().m_60953_(value -> 6)));
    public static final RegistryObject<Block> ARIDROCK = DDBlocks.registerBlock("aridrock", () -> new RotatedPillarBlock(ARIDROCK_PROPERTIES));
    public static final RegistryObject<Block> ARIDROCK_STAIRS = DDBlocks.registerBlock("aridrock_stairs", () -> new StairBlock(() -> ((Block)ARIDROCK.get()).m_49966_(), ARIDROCK_PROPERTIES));
    public static final RegistryObject<Block> ARIDROCK_SLAB = DDBlocks.registerBlock("aridrock_slab", () -> new SlabBlock(ARIDROCK_PROPERTIES));
    public static final RegistryObject<Block> ARIDROCK_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "aridrock_vertical_slab", () -> new VerticalSlabBlock(ARIDROCK_PROPERTIES));
    public static final RegistryObject<Block> ARIDROCK_WALL = DDBlocks.registerBlock("aridrock_wall", () -> new WallBlock(ARIDROCK_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_ARIDROCK = DDBlocks.registerBlock("polished_aridrock", () -> new Block(ARIDROCK_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_ARIDROCK_STAIRS = DDBlocks.registerBlock("polished_aridrock_stairs", () -> new StairBlock(() -> ((Block)POLISHED_ARIDROCK.get()).m_49966_(), ARIDROCK_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_ARIDROCK_SLAB = DDBlocks.registerBlock("polished_aridrock_slab", () -> new SlabBlock(ARIDROCK_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_ARIDROCK_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "polished_aridrock_vertical_slab", () -> new VerticalSlabBlock(ARIDROCK_PROPERTIES));
    public static final RegistryObject<Block> ARIDROCK_BRICKS = DDBlocks.registerBlock("aridrock_bricks", () -> new Block(ARIDROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> ARIDROCK_BRICKS_STAIRS = DDBlocks.registerBlock("aridrock_bricks_stairs", () -> new StairBlock(((Block)ARIDROCK_BRICKS.get()).m_49966_(), ARIDROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> ARIDROCK_BRICKS_SLAB = DDBlocks.registerBlock("aridrock_bricks_slab", () -> new SlabBlock(ARIDROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> ARIDROCK_BRICKS_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "aridrock_bricks_vertical_slab", () -> new VerticalSlabBlock(ARIDROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> ARIDROCK_BRICKS_WALL = DDBlocks.registerBlock("aridrock_bricks_wall", () -> new WallBlock(ARIDROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> CHISELED_ARIDROCK_BRICKS = DDBlocks.registerBlock("chiseled_aridrock_bricks", () -> new Block(ARIDROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> CRACKED_ARIDROCK_BRICKS = DDBlocks.registerBlock("cracked_aridrock_bricks", () -> new Block(ARIDROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> ARIDROCK_PILLAR = DDBlocks.registerBlock("aridrock_pillar", () -> new ConnectedPillarBlock(ARIDROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> SKULL_WALL = DDBlocks.registerBlock("skull_wall", () -> new Block(ARIDROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> DUSKROCK = DDBlocks.registerBlock("duskrock", () -> new DuskrockBlock(DUSKROCK_PROPERTIES));
    public static final RegistryObject<Block> DUSKROCK_STAIRS = DDBlocks.registerBlock("duskrock_stairs", () -> new StairBlock(() -> ((Block)DUSKROCK.get()).m_49966_(), DUSKROCK_PROPERTIES));
    public static final RegistryObject<Block> DUSKROCK_SLAB = DDBlocks.registerBlock("duskrock_slab", () -> new SlabBlock(DUSKROCK_PROPERTIES));
    public static final RegistryObject<Block> DUSKROCK_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "duskrock_vertical_slab", () -> new VerticalSlabBlock(DUSKROCK_PROPERTIES));
    public static final RegistryObject<Block> DUSKROCK_WALL = DDBlocks.registerBlock("duskrock_wall", () -> new WallBlock(DUSKROCK_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_DUSKROCK = DDBlocks.registerBlock("polished_duskrock", () -> new Block(DUSKROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_DUSKROCK_STAIRS = DDBlocks.registerBlock("polished_duskrock_stairs", () -> new StairBlock(() -> ((Block)POLISHED_DUSKROCK.get()).m_49966_(), DUSKROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_DUSKROCK_SLAB = DDBlocks.registerBlock("polished_duskrock_slab", () -> new SlabBlock(DUSKROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_DUSKROCK_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "polished_duskrock_vertical_slab", () -> new VerticalSlabBlock(DUSKROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> DUSKROCK_BRICKS = DDBlocks.registerBlock("duskrock_bricks", () -> new Block(DUSKROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> DUSKROCK_BRICKS_STAIRS = DDBlocks.registerBlock("duskrock_bricks_stairs", () -> new StairBlock(() -> ((Block)POLISHED_DUSKROCK.get()).m_49966_(), DUSKROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> DUSKROCK_BRICKS_SLAB = DDBlocks.registerBlock("duskrock_bricks_slab", () -> new SlabBlock(DUSKROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> DUSKROCK_BRICKS_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "duskrock_bricks_vertical_slab", () -> new VerticalSlabBlock(DUSKROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> DUSKROCK_BRICKS_WALL = DDBlocks.registerBlock("duskrock_bricks_wall", () -> new WallBlock(DUSKROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> CHISELED_DUSKROCK_BRICKS = DDBlocks.registerBlock("chiseled_duskrock_bricks", () -> new Block(DUSKROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> CRACKED_DUSKROCK_BRICKS = DDBlocks.registerBlock("cracked_duskrock_bricks", () -> new Block(DUSKROCK_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> VOID_SOUL_JAR = DDBlocks.registerNoTabBlock("void_soul_jar", () -> new VoidSoulJarBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.8f).m_60918_(SoundType.f_56744_).m_60953_(value -> 5)));
    public static final RegistryObject<Block> FORSAKEN_BRONZE_BLOCK = DDBlocks.registerBlock("forsaken_bronze_block", () -> new Block(FORSAKEN_BRONZE_PROPERTIES));
    public static final RegistryObject<Block> DEATH_ANCHOR = DDBlocks.registerTooltipBlock("death_anchor", () -> new DeathAnchorBlock(FORSAKEN_BRONZE_PROPERTIES), List.of(Component.m_237115_((String)"tooltip.darkerdepths.death_anchor.shift_desc_1").m_130940_(ChatFormatting.GOLD), Component.m_237115_((String)"tooltip.darkerdepths.death_anchor.shift_desc_2").m_130940_(ChatFormatting.GOLD)));
    public static final RegistryObject<Block> TOMB = DDBlocks.registerBlock("tomb", () -> new TombBlock(DDBlocks.blockProperties(4.0f, 10.0f, SoundType.f_154677_, true).m_60955_()));
    public static final RegistryObject<Block> PARANOIA_ALTAR = DDBlocks.registerNoTabBlock("paranoia_altar", () -> new ParanoiaAltarBlock(DDBlocks.blockProperties(2.5f, 3.0f, SoundType.f_154677_, true).m_60953_(level -> 9).m_60955_()));
    public static final RegistryObject<Block> ARID_DEEPSLATE = DDBlocks.registerBlock("arid_deepslate", () -> new LayeredDeepslateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_).m_60977_()));
    public static final RegistryObject<Block> VOID_SOUL_TORCH = DDBlocks.registerNoTabBlock("void_soul_torch", () -> new VoidSoulTorchBlock(BlockBehaviour.Properties.m_284310_().m_60913_(0.0f, 1.0f).m_60910_().m_60918_(SoundType.f_56736_).m_60953_(state -> 10), () -> DDParticleTypes.VOID_SOUL_FLAME.get()));
    public static final RegistryObject<Block> WALL_VOID_SOUL_TORCH = DDBlocks.registerNoTabBlock("wall_void_soul_torch", () -> new WallVoidSoulTorchBlock(BlockBehaviour.Properties.m_284310_().m_60913_(0.0f, 1.0f).m_60910_().m_60918_(SoundType.f_56736_).lootFrom(VOID_SOUL_TORCH).m_60953_(state -> 12), () -> DDParticleTypes.VOID_SOUL_FLAME.get()));
    public static final RegistryObject<Block> PETRIFIED_ROOTS = DDBlocks.registerBlock("petrified_roots", () -> new PetrifiedRootBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_222979_(BlockBehaviour.OffsetType.XZ).m_60910_().m_60966_().m_60918_(SoundType.f_154673_)));
    public static final RegistryObject<Block> PETRIFIED_ROOTS_PLANT = DDBlocks.registerNoTabBlock("petrified_roots_plant", () -> new PetrifiedRootPlantBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_222979_(BlockBehaviour.OffsetType.XZ).m_60910_().m_60966_().m_60918_(SoundType.f_154673_)));
    public static final RegistryObject<Block> DRY_SPROUTS = DDBlocks.registerBlock("dry_sprouts", () -> new DrySproutsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50036_).m_222979_(BlockBehaviour.OffsetType.XZ)));
    public static final RegistryObject<Block> AMBER_BLOCK = DDBlocks.registerBlock("amber_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60999_().m_60978_(1.0f).m_60918_(SoundType.f_154654_).m_60953_(value -> 7)));
    public static final RegistryObject<Block> AMBER_CLUSTER = DDBlocks.registerBlock("amber_cluster", () -> new AmethystClusterBlock(6, 3, BlockBehaviour.Properties.m_284310_().m_60999_().m_60978_(1.0f).m_60918_(SoundType.f_154656_).m_60953_(value -> 7)));
    public static final RegistryObject<Block> DARKSLATE = DDBlocks.registerBlock("darkslate", () -> new RotatedPillarBlock(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> DARKSLATE_STAIRS = DDBlocks.registerBlock("darkslate_stairs", () -> new StairBlock(() -> ((Block)DARKSLATE.get()).m_49966_(), DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> DARKSLATE_SLAB = DDBlocks.registerBlock("darkslate_slab", () -> new SlabBlock(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> DARKSLATE_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "darkslate_vertical_slab", () -> new VerticalSlabBlock(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> DARKSLATE_WALL = DDBlocks.registerBlock("darkslate_wall", () -> new WallBlock(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_DARKSLATE = DDBlocks.registerBlock("polished_darkslate", () -> new Block(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_DARKSLATE_STAIRS = DDBlocks.registerBlock("polished_darkslate_stairs", () -> new StairBlock(() -> ((Block)POLISHED_DARKSLATE.get()).m_49966_(), DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_DARKSLATE_SLAB = DDBlocks.registerBlock("polished_darkslate_slab", () -> new SlabBlock(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_DARKSLATE_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "polished_darkslate_vertical_slab", () -> new VerticalSlabBlock(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> DARKSLATE_BRICKS = DDBlocks.registerBlock("darkslate_bricks", () -> new Block(DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> DARKSLATE_BRICKS_STAIRS = DDBlocks.registerBlock("darkslate_bricks_stairs", () -> new StairBlock(((Block)DARKSLATE_BRICKS.get()).m_49966_(), DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> DARKSLATE_BRICKS_SLAB = DDBlocks.registerBlock("darkslate_bricks_slab", () -> new SlabBlock(DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> DARKSLATE_BRICKS_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "darkslate_bricks_vertical_slab", () -> new VerticalSlabBlock(DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> DARKSLATE_BRICKS_WALL = DDBlocks.registerBlock("darkslate_bricks_wall", () -> new WallBlock(DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> CHISELED_DARKSLATE_BRICKS = DDBlocks.registerBlock("chiseled_darkslate_bricks", () -> new Block(DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> CRACKED_DARKSLATE_BRICKS = DDBlocks.registerBlock("cracked_darkslate_bricks", () -> new Block(DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> GEYSER = DDBlocks.registerBlock("geyser", () -> new GeyserBlock(DARKSLATE_PROPERTIES.m_60977_()));
    public static final RegistryObject<Block> STONE_MELON = DDBlocks.registerBlock("stone_melon", () -> new StoneMelonBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283861_).m_60999_().m_60978_(1.0f).m_60918_(SoundType.f_154677_)));
    public static final RegistryObject<Block> DEAD_LIVING_CRYSTAL = DDBlocks.registerBlock("dead_living_crystal", () -> new DeadLivingCrystalBlock(LIVING_CRYSTAL_PROPERTIES));
    public static final RegistryObject<Block> LIVING_CRYSTAL = DDBlocks.registerBlock("living_crystal", () -> new LivingCrystalBlock(LIVING_CRYSTAL_PROPERTIES));
    public static final RegistryObject<Block> CRYSTAL_MELON = DDBlocks.registerTooltipBlock("crystal_melon", () -> new CrystalMelonBlock(DDBlocks.blockProperties(1.5f, 1.0f, SoundType.f_154654_, true).m_60953_(value -> 10)), List.of(Component.m_237115_((String)"tooltip.darkerdepths.crystal_melon.shift_desc_1").m_130940_(ChatFormatting.AQUA), Component.m_237115_((String)"tooltip.darkerdepths.crystal_melon.shift_desc_2").m_130940_(ChatFormatting.AQUA)));
    public static final RegistryObject<Block> MAGMA_PAD = DDBlocks.registerNoTabBlock("magma_pad", () -> new MagmaPadBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.1f).m_60953_(state -> 3).m_60918_(DDSoundEvents.GRIMESTONE).m_60955_().m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> ASH_BLOCK = DDBlocks.registerBlock("ash_block", () -> new AshFullBlock(DDBlocks.blockProperties(0.2f, SoundType.f_56747_, false).m_284180_(MapColor.f_283927_).m_60977_()));
    public static final RegistryObject<Block> ASH = DDBlocks.registerBlock("ash", () -> new AshBlock(DDBlocks.blockProperties(0.1f, SoundType.f_56747_, true).m_284180_(MapColor.f_283927_).m_60977_()));
    public static final RegistryObject<Block> GRIMESTONE = DDBlocks.registerBlock("grimestone", () -> new GrimestoneBlock(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> GRIMESTONE_STAIRS = DDBlocks.registerBlock("grimestone_stairs", () -> new StairBlock(((Block)GRIMESTONE.get()).m_49966_(), DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> GRIMESTONE_SLAB = DDBlocks.registerBlock("grimestone_slab", () -> new SlabBlock(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> GRIMESTONE_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "grimestone_vertical_slab", () -> new VerticalSlabBlock(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> GRIMESTONE_WALL = DDBlocks.registerBlock("grimestone_wall", () -> new WallBlock(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> MOSSY_GRIMESTONE = DDBlocks.registerBlock("mossy_grimestone", () -> new MossyGrimestoneBlock(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_GRIMESTONE = DDBlocks.registerBlock("polished_grimestone", () -> new Block(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_GRIMESTONE_STAIRS = DDBlocks.registerBlock("polished_grimestone_stairs", () -> new StairBlock(((Block)POLISHED_GRIMESTONE.get()).m_49966_(), DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_GRIMESTONE_SLAB = DDBlocks.registerBlock("polished_grimestone_slab", () -> new SlabBlock(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> POLISHED_GRIMESTONE_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "polished_grimestone_vertical_slab", () -> new VerticalSlabBlock(DARKSLATE_PROPERTIES));
    public static final RegistryObject<Block> GRIMESTONE_BRICKS = DDBlocks.registerBlock("grimestone_bricks", () -> new Block(DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> GRIMESTONE_BRICKS_STAIRS = DDBlocks.registerBlock("grimestone_bricks_stairs", () -> new StairBlock(((Block)GRIMESTONE_BRICKS.get()).m_49966_(), DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> GRIMESTONE_BRICKS_SLAB = DDBlocks.registerBlock("grimestone_bricks_slab", () -> new SlabBlock(DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> GRIMESTONE_BRICKS_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "grimestone_bricks_vertical_slab", () -> new VerticalSlabBlock(DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> GRIMESTONE_BRICKS_WALL = DDBlocks.registerBlock("grimestone_bricks_wall", () -> new WallBlock(DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> CHISELED_GRIMESTONE_BRICKS = DDBlocks.registerBlock("chiseled_grimestone_bricks", () -> new Block(DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> CRACKED_GRIMESTONE_BRICKS = DDBlocks.registerBlock("cracked_grimestone_bricks", () -> new Block(DARKSLATE_BRICKS_PROPERTIES));
    public static final RegistryObject<Block> GLOWSHROOM_BLOCK = DDBlocks.registerBlock("glowshroom_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60918_(SoundType.f_56750_)));
    public static final RegistryObject<Block> GLOWSHROOM_STEM = DDBlocks.registerBlock("glowshroom_stem", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_60913_(1.2f, 2.0f).m_60918_(SoundType.f_56763_)));
    public static final RegistryObject<Block> GLOWSHROOM_HEART = DDBlocks.registerBlock("glowshroom_heart", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56713_).m_60953_(value -> 15)));
    public static final RegistryObject<Block> GLOWSHROOM = DDBlocks.registerBlock("glowshroom", () -> new GlowshroomBlock(BlockBehaviour.Properties.m_284310_().m_60913_(0.0f, 1.0f).m_60918_(SoundType.f_56750_).m_60953_(state -> 3 + 2 * (Integer)state.m_61143_((Property)GlowshroomBlock.CLUSTERS_1_3)).m_60910_()));
    public static final RegistryObject<Block> POTTED_GLOWSHROOM = DDBlocks.registerNoTabBlock("potted_glowshroom", () -> new FlowerPotBlock((Block)GLOWSHROOM.get(), BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_()));
    public static final RegistryObject<Block> GLOWSPURS = DDBlocks.registerBlock("glowspurs", () -> new GlowspursBlock(BlockBehaviour.Properties.m_284310_().m_60966_().m_60953_(value -> 5).m_60918_(SoundType.f_56750_).m_60910_()));
    public static final RegistryObject<Block> MOSSY_SPROUTS = DDBlocks.registerBlock("mossy_sprouts", () -> new SproutsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50034_).m_60918_(SoundType.f_56752_).m_222979_(BlockBehaviour.OffsetType.XZ)));
    public static final RegistryObject<Block> GLIMMERING_VINES = DDBlocks.registerBlock("glimmering_vines", () -> new GlimmeringVinesBlock(BlockBehaviour.Properties.m_284310_().m_60910_().m_60953_(value -> 8).m_60918_(SoundType.f_154665_)));
    public static final RegistryObject<Block> GLIMMERING_VINE_PLANT = DDBlocks.registerNoTabBlock("glimmering_vine_plant", () -> new GlimmeringVinePlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GLIMMERING_VINES.get())).m_60918_(SoundType.f_154665_)));
    public static final RegistryObject<Block> GLOWSHROOM_LAMP = DDBlocks.registerBlock("glowshroom_lamp", () -> new GlowshroomLampBlock(BlockBehaviour.Properties.m_284310_().m_60913_(0.3f, 0.3f).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 15 : 0).m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<Block> GLOWSHROOM_LANTERN = DDBlocks.registerBlock("glowshroom_lantern", () -> new GlowshroomLanternBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50681_)));
    public static final RegistryObject<Block> ROPE = DDBlocks.registerNoTabBlock("rope", () -> new RopeBlock(DDBlocks.blockProperties(0.1f, SoundType.f_56745_, false)));
    public static final RegistryObject<Block> MOB_PLACER = DDBlocks.registerNoTabBlock("mob_placer", () -> new MobPlacerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50752_)));

    public static <B extends Block> RegistryObject<B> registerBlock(String name, Supplier<? extends B> blocks) {
        RegistryObject block = BLOCKS.register(name, blocks);
        DDItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public static <B extends Block> RegistryObject<B> registerNoTabBlock(String name, Supplier<? extends B> blocks) {
        return BLOCKS.register(name, blocks);
    }

    public static <B extends Block> RegistryObject<B> registerTooltipBlock(String name, Supplier<? extends B> blocks, List<Component> tooltips) {
        RegistryObject block = BLOCKS.register(name, blocks);
        DDItems.ITEMS.register(name, () -> new BlockItemWithHoverText((Block)block.get(), new Item.Properties(), tooltips));
        return block;
    }

    public static <B extends Block> RegistryObject<B> registerCompatBlock(String modId, String key, Supplier<? extends B> block) {
        RegistryObject blocks = BLOCKS.register(key, block);
        RegistryObject item = DDItems.ITEMS.register(key, () -> new BlockItem((Block)blocks.get(), new Item.Properties()));
        COMPAT.put((RegistryObject<? extends Item>)item, modId);
        return blocks;
    }

    public static BlockBehaviour.Properties blockProperties(float destroyTime, float explosionResistance, SoundType sound, boolean requiresTool) {
        if (requiresTool) {
            return BlockBehaviour.Properties.m_284310_().m_60913_(destroyTime, explosionResistance).m_60918_(sound).m_60999_();
        }
        return BlockBehaviour.Properties.m_284310_().m_60913_(destroyTime, explosionResistance).m_60918_(sound);
    }

    public static BlockBehaviour.Properties blockProperties(float destroyTime, SoundType sound, boolean requiresTool) {
        if (requiresTool) {
            return BlockBehaviour.Properties.m_284310_().m_60978_(destroyTime).m_60918_(sound).m_60999_();
        }
        return BlockBehaviour.Properties.m_284310_().m_60978_(destroyTime).m_60918_(sound);
    }
}

