/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.events;

import com.naterbobber.darkerdepths.api.DeathAnchorLocation;
import com.naterbobber.darkerdepths.entities.BodySnatcherEntity;
import com.naterbobber.darkerdepths.entities.GlowshroomMonsterEntity;
import com.naterbobber.darkerdepths.entities.VoidSoulEntity;
import com.naterbobber.darkerdepths.entities.VoidSoulKnightEntity;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDDamageTypes;
import com.naterbobber.darkerdepths.init.DDEnchantments;
import com.naterbobber.darkerdepths.init.DDEntityTypes;
import com.naterbobber.darkerdepths.init.DDItems;
import com.naterbobber.darkerdepths.init.DDMobEffects;
import com.naterbobber.darkerdepths.init.DDNetwork;
import com.naterbobber.darkerdepths.init.DDPoiTypes;
import com.naterbobber.darkerdepths.network.SendDeathAnchorPacket;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="darkerdepths", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MobEvents {
    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        SpawnPlacements.m_21754_((EntityType)((EntityType)DDEntityTypes.GLOWSHROOM_MONSTER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)DDEntityTypes.BODY_SNATCHER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        event.put((EntityType)DDEntityTypes.GLOWSHROOM_MONSTER.get(), GlowshroomMonsterEntity.createAttributes().m_22265_());
        event.put((EntityType)DDEntityTypes.BODY_SNATCHER.get(), BodySnatcherEntity.createAttributes().m_22265_());
        event.put((EntityType)DDEntityTypes.VOID_SOUL_KNIGHT.get(), VoidSoulKnightEntity.createAttributes().m_22265_());
        event.put((EntityType)DDEntityTypes.VOID_SOUL.get(), VoidSoulEntity.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        Player player;
        ItemStack itemStack;
        LivingEntity entity = event.getEntity();
        DamageSource damageSource = event.getSource();
        Entity damageSourceEntity = damageSource.m_7639_();
        if (entity.m_21023_((MobEffect)DDMobEffects.SOUL_BINDING.get()) && entity.m_21124_((MobEffect)DDMobEffects.SOUL_BINDING.get()).m_19557_() > 0) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
        if (damageSourceEntity instanceof Player && (itemStack = (player = (Player)damageSourceEntity).m_21120_(player.m_7655_())).m_150930_((Item)DDItems.STILETTO.get())) {
            CompoundTag tag = itemStack.m_41783_();
            if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)DDEnchantments.SWIFT_STRIKE.get()), (ItemStack)itemStack) > 0 && tag != null && tag.m_128451_("TimeFrame") > 0) {
                player.m_36335_().m_41527_(itemStack.m_41720_());
                entity.m_216990_(SoundEvents.f_11871_);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            DeathAnchorLocation deathAnchorLocation;
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof DeathAnchorLocation && (deathAnchorLocation = (DeathAnchorLocation)entity).getDeathAnchorLocation().isPresent()) {
                GlobalPos globalPos = deathAnchorLocation.getDeathAnchorLocation().get();
                ResourceKey resourcekey = globalPos.m_122640_();
                ServerLevel newServer = serverLevel.m_7654_().m_129880_(resourcekey);
                ResourceKey key = DDPoiTypes.DEATH_ANCHOR.getKey();
                if (key == null || newServer == null) {
                    return;
                }
                BlockPos pos = globalPos.m_122646_();
                boolean exists = newServer.m_8904_().m_217874_(key, pos);
                if (!exists) {
                    return;
                }
                event.setCanceled(true);
                entity.m_21153_(1.0f);
                BlockPos teleportPos = pos.m_7494_();
                if (!serverLevel.m_8055_(teleportPos).m_60795_()) {
                    boolean safe = false;
                    int radius = 1;
                    for (int y = -radius; y <= radius; ++y) {
                        for (int x = -radius; x <= radius; ++x) {
                            for (int z = -radius; z <= radius; ++z) {
                                BlockPos blockPos = teleportPos.m_7918_(x, y, z);
                                Vec3 vec3 = DismountHelper.m_38441_((EntityType)entity.m_6095_(), (CollisionGetter)serverLevel, (BlockPos)blockPos, (boolean)true);
                                if (vec3 == null) continue;
                                teleportPos = BlockPos.m_274446_((Position)vec3);
                                safe = true;
                            }
                        }
                    }
                    if (!safe && serverLevel.m_8055_(teleportPos).m_204336_(BlockTags.f_144287_) && serverLevel.m_8055_(teleportPos.m_7494_()).m_204336_(BlockTags.f_144287_)) {
                        serverLevel.m_46961_(teleportPos, false);
                        serverLevel.m_46961_(teleportPos.m_7494_(), false);
                    }
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)DDMobEffects.SOUL_BINDING.get(), 200, 0, true, false));
                entity.m_264318_(newServer, (double)teleportPos.m_123341_() + 0.5, (double)teleportPos.m_123342_(), (double)teleportPos.m_123343_() + 0.5, Set.of(), 0.0f, 0.0f);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    DDNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SendDeathAnchorPacket());
                }
                entity.m_7311_(0);
            }
        }
    }

    @SubscribeEvent
    public void onMobEffectRemove(MobEffectEvent.Remove event) {
        if (event.getEffect() == DDMobEffects.SOUL_BINDING.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onMobEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null && effectInstance.m_19544_() == DDMobEffects.SOUL_BINDING.get()) {
            DeathAnchorLocation deathAnchorLocation;
            if (entity instanceof DeathAnchorLocation && (deathAnchorLocation = (DeathAnchorLocation)entity).getDeathAnchorLocation().isPresent()) {
                ServerLevel serverLevel;
                ServerLevel newServer;
                GlobalPos globalPos = deathAnchorLocation.getDeathAnchorLocation().get();
                ResourceKey resourcekey = globalPos.m_122640_();
                BlockPos pos = globalPos.m_122646_();
                ResourceKey key = DDPoiTypes.DEATH_ANCHOR.getKey();
                if (key == null) {
                    return;
                }
                Level level = entity.m_9236_();
                if (level instanceof ServerLevel && (newServer = (serverLevel = (ServerLevel)level).m_7654_().m_129880_(resourcekey)) != null && newServer.m_8904_().m_217874_(key, pos)) {
                    newServer.m_186460_(pos, (Block)DDBlocks.DEATH_ANCHOR.get(), 2);
                }
                deathAnchorLocation.setDeathAnchorLocation(Optional.empty());
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.m_150110_().f_35937_) {
                    DamageSource damageSource = new DamageSource((Holder)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DDDamageTypes.SOUL_BINDING_DAMAGE));
                    entity.m_6469_(damageSource, Float.MAX_VALUE);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_9236_().m_5776_()) {
            return;
        }
        if (event.getSlot() != EquipmentSlot.HEAD) {
            return;
        }
        ItemStack newlyEquipped = event.getTo();
        ItemStack previouslyEquipped = event.getFrom();
        if (newlyEquipped.m_150930_((Item)DDItems.GLOWSHROOM_CAP.get())) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, -1, 0, false, false, true));
        }
        if (previouslyEquipped.m_150930_((Item)DDItems.GLOWSHROOM_CAP.get()) && !newlyEquipped.m_150930_((Item)DDItems.GLOWSHROOM_CAP.get())) {
            player.m_21195_(MobEffects.f_19598_);
        }
    }
}

