/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.client;

import com.naterbobber.darkerdepths.init.DDItems;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

@OnlyIn(value=Dist.CLIENT)
public class DynamicLightHandler {
    private static final Minecraft INSTANCE = Minecraft.m_91087_();
    public static final Map<BlockPos, LightValue> LIGHT_SOURCES = new ConcurrentHashMap<BlockPos, LightValue>();
    private static final int LIGHT_SCAN_RADIUS = 64;

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (DynamicLightHandler.INSTANCE.f_91074_ == null || DynamicLightHandler.INSTANCE.f_91073_ == null) {
            return;
        }
        LIGHT_SOURCES.forEach((pos, value) -> {
            value.shouldKeep = false;
        });
        AABB searchArea = DynamicLightHandler.INSTANCE.f_91074_.m_20191_().m_82400_(64.0);
        DynamicLightHandler.INSTANCE.f_91073_.m_6443_(LivingEntity.class, searchArea, DynamicLightHandler::shouldGlow).forEach(entity -> {
            BlockPos lightPos = entity.m_20097_();
            if (!DynamicLightHandler.INSTANCE.f_91073_.m_8055_(lightPos).m_280296_()) {
                lightPos = entity.m_20183_();
            }
            DynamicLightHandler.LIGHT_SOURCES.computeIfAbsent((BlockPos)lightPos, (Function<BlockPos, LightValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onClientTick$1(net.minecraft.core.BlockPos ), (Lnet/minecraft/core/BlockPos;)Lcom/naterbobber/darkerdepths/client/DynamicLightHandler$LightValue;)()).shouldKeep = true;
        });
        if (!LIGHT_SOURCES.isEmpty()) {
            LIGHT_SOURCES.forEach((pos, value) -> DynamicLightHandler.INSTANCE.f_91073_.m_7726_().m_7827_().m_7174_(pos));
            LIGHT_SOURCES.entrySet().removeIf(entry -> !((LightValue)entry.getValue()).shouldKeep);
        }
    }

    public static boolean shouldGlow(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.HEAD).m_41720_() == DDItems.GLOWSHROOM_CAP.get() && !entity.m_5833_();
    }

    private static /* synthetic */ LightValue lambda$onClientTick$1(BlockPos k) {
        return new LightValue();
    }

    public static class LightValue {
        public boolean shouldKeep = true;
    }
}

