/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks.blockentities;

import com.naterbobber.darkerdepths.blocks.ParanoiaAltarBlock;
import com.naterbobber.darkerdepths.config.DDConfigs;
import com.naterbobber.darkerdepths.entities.BodySnatcherEntity;
import com.naterbobber.darkerdepths.entities.VoidSoulMonster;
import com.naterbobber.darkerdepths.init.DDBlockEntityTypes;
import com.naterbobber.darkerdepths.init.DDEntityTypes;
import com.naterbobber.darkerdepths.init.DDMobEffects;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.RenderUtils;

public class ParanoiaAltarBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int tickCounter = 0;

    public ParanoiaAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DDBlockEntityTypes.PARANOIA_ALTAR.get(), pos, state);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::animationPredicate)});
    }

    private PlayState animationPredicate(AnimationState<ParanoiaAltarBlockEntity> state) {
        state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!((Boolean)state.m_61143_((Property)ParanoiaAltarBlock.ENABLED)).booleanValue() || level.f_46443_) {
            return;
        }
        if (this.tickCounter++ != 100) {
            return;
        }
        this.tickCounter = 0;
        int radiusHorizontal = (Integer)DDConfigs.PARANOIA_ALTAR_RADIUS_HORIZONTAL.get();
        int radiusY = (Integer)DDConfigs.PARANOIA_ALTAR_RADIUS_VERTICAL.get();
        AABB finalArea = new AABB(pos).m_82377_((double)radiusHorizontal, (double)radiusY, (double)radiusHorizontal);
        List players = level.m_45976_(Player.class, finalArea);
        int playerMobCap = 6;
        int catacombsMobCap = players.size() * playerMobCap;
        for (Player player : players) {
            if (player.m_5833_() || player.m_7500_() && !((Boolean)DDConfigs.PARANOIA_ALTAR_EFFECTS_CREATIVE.get()).booleanValue()) continue;
            player.m_7292_(new MobEffectInstance((MobEffect)DDMobEffects.PARANOIA.get(), 320, 0, false, false, true));
            if (level.m_213780_().m_188500_() > 0.33) continue;
            List catacombsBodySnatcherList = level.m_45976_(BodySnatcherEntity.class, finalArea);
            List playerBodySnatcherList = level.m_45976_(BodySnatcherEntity.class, player.m_20191_().m_82400_(28.0));
            if (!((Boolean)state.m_61143_((Property)ParanoiaAltarBlock.LOCKED)).booleanValue() || catacombsBodySnatcherList.size() > catacombsMobCap || playerBodySnatcherList.size() > playerMobCap) continue;
            this.spawnMobInValidPosition(level, player, (Entity)new BodySnatcherEntity((EntityType<? extends VoidSoulMonster>)((EntityType)DDEntityTypes.BODY_SNATCHER.get()), level));
        }
    }

    private void spawnMobInValidPosition(Level level, Player player, Entity entity) {
        BlockPos pos;
        boolean found = false;
        int height = 6;
        int spawnAttempts = 20;
        block0: do {
            if (!level.m_8055_(pos = this.getRandomPositionAroundPlayer(player, 16.0, 24.0, height, level.m_213780_())).m_60795_()) continue;
            for (int i = 0; i < height; ++i) {
                BlockPos nextPos = pos.m_5487_(Direction.Axis.Y, -i);
                if (level.m_8055_(nextPos).m_60795_()) continue;
                found = true;
                pos = nextPos.m_7494_();
                continue block0;
            }
        } while (!found && --spawnAttempts > 0);
        if (found) {
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            level.m_7967_(entity);
        }
    }

    private BlockPos getRandomPositionAroundPlayer(Player player, double minRadius, double maxRadius, int height, RandomSource random) {
        Vec3 position;
        AABB minHorizontalArea = player.m_20191_().m_82400_(minRadius);
        AABB maxHorizontalArea = player.m_20191_().m_82400_(maxRadius);
        AABB verticalArea = player.m_20191_().m_82400_((double)height / 2.0);
        AABB minArea = new AABB(minHorizontalArea.f_82288_, verticalArea.f_82289_, minHorizontalArea.f_82290_, minHorizontalArea.f_82291_, verticalArea.f_82292_, minHorizontalArea.f_82293_);
        AABB maxArea = new AABB(maxHorizontalArea.f_82288_, verticalArea.f_82289_, maxHorizontalArea.f_82290_, maxHorizontalArea.f_82291_, verticalArea.f_82292_, maxHorizontalArea.f_82293_);
        while (minArea.m_82390_(position = new Vec3(maxArea.f_82288_ + random.m_188500_() * maxArea.m_82362_(), maxArea.f_82289_ + random.m_188500_() * (double)height, maxArea.f_82290_ + random.m_188500_() * maxArea.m_82385_()))) {
        }
        return BlockPos.m_274446_((Position)position);
    }
}

