/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks;

import com.naterbobber.darkerdepths.blocks.blockentities.TombBlockEntity;
import com.naterbobber.darkerdepths.init.DDBlockEntityTypes;
import com.naterbobber.darkerdepths.init.DDBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TombBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty INHABITED = BooleanProperty.m_61465_((String)"inhabited");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape CORNER_PART = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.0, (double)3.0, (double)6.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)1.0, (double)10.0, (double)4.0, (double)16.0, (double)15.0, (double)16.0)});
    private static final VoxelShape CORNER_PART_MIRRORED = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)14.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)3.0, (double)6.0, (double)13.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)10.0, (double)4.0, (double)15.0, (double)15.0, (double)16.0)});
    private static final VoxelShape CENTER_PART = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)3.0, (double)6.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)10.0, (double)4.0, (double)16.0, (double)15.0, (double)16.0)});
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);

    public TombBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)Part.FRONT_CENTER))).m_61124_((Property)INHABITED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART, WATERLOGGED, INHABITED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Part part = (Part)((Object)state.m_61143_(PART));
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        VoxelShape shape = part.shape();
        return TombBlock.rotateVoxelShape(shape, facing);
    }

    public RenderShape m_7514_(BlockState state) {
        return state.m_61143_(PART) == Part.FRONT_CENTER ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(PART, (Comparable)((Object)Part.FRONT_CENTER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Map<Part, MultiblockPartData> parts = TombBlock.generateMultiblockPartData(this.getMainBlockPos(pos, state), facing, level);
        for (MultiblockPartData partData : parts.values()) {
            BlockState block = level.m_8055_(partData.pos);
            if (block.m_60713_((Block)this) ? block.m_61143_((Property)FACING) != partData.state.m_61143_((Property)FACING) || block.m_61143_(PART) != partData.state.m_61143_(PART) : !block.m_247087_()) {
                return false;
            }
            if (super.m_7898_(partData.state, level, partData.pos)) continue;
            return false;
        }
        return true;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.f_46443_ && !isMoving && state.m_61143_(PART) == Part.FRONT_CENTER) {
            this.placeMultiblockParts(level, pos, state);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.f_46443_ && !state.m_60713_(newState.m_60734_())) {
            TombBlockEntity tombEntity;
            BlockEntity blockEntity;
            if (state.m_61143_(PART) == Part.FRONT_CENTER && (blockEntity = level.m_7702_(pos)) instanceof TombBlockEntity && (tombEntity = (TombBlockEntity)blockEntity).hasStoredItem()) {
                ItemStack storedItem = tombEntity.getStoredItem();
                TombBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)storedItem);
            }
            this.removeMultiblockParts(level, pos, state);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockPos mainPos;
        Part part;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if ((part = (Part)((Object)state.m_61143_(PART))) != Part.FRONT_CENTER && !level.m_8055_(mainPos = this.getMainBlockPos(currentPos, state)).m_60713_((Block)this)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos mainPos;
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(mainPos = this.getMainBlockPos(pos, state))) instanceof TombBlockEntity) {
            TombBlockEntity tombEntity = (TombBlockEntity)blockEntity;
            if (player.m_36341_() && tombEntity.isOpen() && tombEntity.isInhabited() && tombEntity.hasStoredItem()) {
                tombEntity.toggleTomb();
                return InteractionResult.SUCCESS;
            }
            if (player.m_36341_()) {
                return InteractionResult.SUCCESS;
            }
            if (tombEntity.isOpen() && tombEntity.isInhabited()) {
                ItemStack storedItem;
                ItemStack heldItem = player.m_21120_(hand);
                if (tombEntity.hasStoredItem() && heldItem.m_41619_() && !(storedItem = tombEntity.m_7407_(0, 64)).m_41619_()) {
                    if (!player.m_150109_().m_36054_(storedItem)) {
                        player.m_36176_(storedItem, false);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            tombEntity.toggleTomb();
        }
        return InteractionResult.SUCCESS;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        return super.m_49635_(state, params);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return state.m_61143_(PART) == Part.FRONT_CENTER ? new TombBlockEntity(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (state.m_61143_(PART) == Part.FRONT_CENTER) {
            return TombBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)DDBlockEntityTypes.TOMB.get()), TombBlockEntity::tick);
        }
        return null;
    }

    private static Map<Part, MultiblockPartData> generateMultiblockPartData(BlockPos mainPos, Direction facing, LevelReader level) {
        HashMap<Part, MultiblockPartData> parts = new HashMap<Part, MultiblockPartData>();
        for (Part part : Part.values()) {
            BlockPos partPos = TombBlock.getPartPos(mainPos, part, facing);
            boolean isWaterlogged = level.m_6425_(partPos).m_76152_() == Fluids.f_76193_;
            BlockState partState = (BlockState)((BlockState)((BlockState)((Block)DDBlocks.TOMB.get()).m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(PART, (Comparable)((Object)part))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
            parts.put(part, new MultiblockPartData(partPos, partState));
        }
        return parts;
    }

    public static Set<StructureTemplate.StructureBlockInfo> generateMultiblockForProcessor(BlockPos mainPos, Direction facing, LevelReader level, BlockPos relativePos) {
        Map<Part, MultiblockPartData> parts = TombBlock.generateMultiblockPartData(mainPos, facing, level);
        HashSet<StructureTemplate.StructureBlockInfo> targets = new HashSet<StructureTemplate.StructureBlockInfo>();
        for (MultiblockPartData partData : parts.values()) {
            targets.add(new StructureTemplate.StructureBlockInfo(relativePos.m_121955_((Vec3i)partData.pos.m_121996_((Vec3i)mainPos)), partData.state, null));
        }
        return targets;
    }

    private void placeMultiblockParts(Level level, BlockPos mainPos, BlockState mainState) {
        Direction facing = (Direction)mainState.m_61143_((Property)FACING);
        Map<Part, MultiblockPartData> parts = TombBlock.generateMultiblockPartData(mainPos, facing, (LevelReader)level);
        for (MultiblockPartData partData : parts.values()) {
            level.m_7731_(partData.pos, partData.state, 3);
        }
    }

    private void removeMultiblockParts(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Map<Part, MultiblockPartData> parts = TombBlock.generateMultiblockPartData(this.getMainBlockPos(pos, state), facing, (LevelReader)level);
        for (MultiblockPartData partData : parts.values()) {
            BlockState replace = (Boolean)partData.state.m_61143_((Property)WATERLOGGED) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(partData.pos, replace, 3);
            level.m_142052_(partData.pos, partData.state);
        }
    }

    public static BlockPos getPartPos(BlockPos mainPos, Part part, Direction facing) {
        Direction right = facing.m_122427_();
        return mainPos.m_5484_(part.xOffset() > 0 ? right : right.m_122424_(), Math.abs(part.xOffset())).m_5484_(part.zOffset() > 0 ? facing : facing.m_122424_(), Math.abs(part.zOffset()));
    }

    private BlockPos getMainBlockPos(BlockPos partPos, BlockState state) {
        Part part = (Part)((Object)state.m_61143_(PART));
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction left = facing.m_122428_();
        return partPos.m_5484_(part.xOffset() > 0 ? left : left.m_122424_(), Math.abs(part.xOffset())).m_5484_(part.zOffset() > 0 ? facing.m_122424_() : facing, Math.abs(part.zOffset()));
    }

    private static VoxelShape rotateVoxelShape(VoxelShape shape, Direction direction) {
        if (direction == Direction.NORTH) {
            return shape;
        }
        ArrayList rotatedBoxes = new ArrayList();
        shape.m_83299_().forEach(aabb -> {
            double minX = aabb.f_82288_;
            double minY = aabb.f_82289_;
            double minZ = aabb.f_82290_;
            double maxX = aabb.f_82291_;
            double maxY = aabb.f_82292_;
            double maxZ = aabb.f_82293_;
            VoxelShape rotatedBox = switch (direction) {
                case Direction.SOUTH -> Shapes.m_83048_((double)(1.0 - maxX), (double)minY, (double)(1.0 - maxZ), (double)(1.0 - minX), (double)maxY, (double)(1.0 - minZ));
                case Direction.WEST -> Shapes.m_83048_((double)minZ, (double)minY, (double)(1.0 - maxX), (double)maxZ, (double)maxY, (double)(1.0 - minX));
                case Direction.EAST -> Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX);
                default -> shape;
            };
            rotatedBoxes.add(rotatedBox);
        });
        return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])rotatedBoxes.toArray(new VoxelShape[0]));
    }

    public static enum Part implements StringRepresentable
    {
        FRONT_CENTER("front_center", 0, 0, CENTER_PART),
        FRONT_LEFT("front_left", -1, 0, CORNER_PART),
        FRONT_RIGHT("front_right", 1, 0, CORNER_PART_MIRRORED),
        BACK_CENTER("back_center", 0, -1, TombBlock.rotateVoxelShape(CENTER_PART, Direction.SOUTH)),
        BACK_LEFT("back_left", -1, -1, TombBlock.rotateVoxelShape(CORNER_PART_MIRRORED, Direction.SOUTH)),
        BACK_RIGHT("back_right", 1, -1, TombBlock.rotateVoxelShape(CORNER_PART, Direction.SOUTH));

        private final String name;
        private final int xOffset;
        private final int zOffset;
        private final VoxelShape shape;

        private Part(String name, int xOffset, int zOffset, VoxelShape shape) {
            this.name = name;
            this.xOffset = xOffset;
            this.zOffset = zOffset;
            this.shape = shape;
        }

        public String m_7912_() {
            return this.name;
        }

        public int xOffset() {
            return this.xOffset;
        }

        public int zOffset() {
            return this.zOffset;
        }

        public VoxelShape shape() {
            return this.shape;
        }
    }

    private record MultiblockPartData(BlockPos pos, BlockState state) {
    }
}

