/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.phys.Vec3;

public abstract class WaypointRenderer {
    protected WaypointProperties waypointProperties;
    private final Minecraft minecraft = Minecraft.m_91087_();
    protected EntityRenderDispatcher renderManager = this.minecraft.m_91290_();

    protected WaypointRenderer() {
    }

    public void render(PoseStack poseStack) {
        this.waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
        Collection<Waypoint> waypoints = WaypointStore.INSTANCE.getAll();
        String playerDim = this.minecraft.f_91074_.m_9236_().m_46472_().m_135782_().toString();
        for (Waypoint waypoint : waypoints) {
            if (!this.canDrawWaypoint(waypoint, playerDim) || this.waypointProperties.shaderBeacon.get().booleanValue() && !this.waypointProperties.showRotatingBeam.get().booleanValue() && !this.waypointProperties.showStaticBeam.get().booleanValue()) continue;
            try {
                MultiBufferSource.BufferSource buffers = this.minecraft.m_91269_().m_110104_();
                poseStack.m_85836_();
                this.renderWaypoint(waypoint, poseStack, (MultiBufferSource)buffers);
                poseStack.m_85849_();
                buffers.m_109911_();
            }
            catch (Exception t) {
                Journeymap.getLogger().error("EntityWaypoint failed to render for " + waypoint + ": ", (Throwable)t);
            }
        }
    }

    private boolean canDrawWaypoint(Waypoint waypoint, String playerDim) {
        return (Waypoint.Origin.EXTERNAL_FORCE.getValue().equals(waypoint.getOrigin()) || waypoint.isEnable() && JourneymapClient.getInstance().getWaypointProperties().beaconEnabled.get() != false && JourneymapClient.getInstance().getStateHandler().canShowInGameBeacons() && JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed()) && waypoint.getDimensions().contains(playerDim);
    }

    protected void renderWaypoint(Waypoint waypoint, PoseStack poseStack, MultiBufferSource buffers) {
        float partialTicks = this.minecraft.m_91296_();
        long gameTime = this.minecraft.f_91073_.m_46467_();
        float fadeAlpha = 1.0f;
        Vec3 waypointVec = waypoint.getPosition().m_82520_(0.0, 0.118, 0.0);
        Vec3 playerVec = this.minecraft.f_91074_.m_20182_();
        double actualDistance = playerVec.m_82554_(waypointVec);
        int maxDistance = this.waypointProperties.maxDistance.get();
        int minDistance = this.waypointProperties.minDistance.get();
        float[] rgba = RGB.floats(waypoint.getColor(), fadeAlpha * 0.4f);
        double viewX = this.renderManager.f_114358_.m_90583_().m_7096_();
        double viewY = this.renderManager.f_114358_.m_90583_().m_7098_();
        double viewZ = this.renderManager.f_114358_.m_90583_().m_7094_();
        double viewDistance = actualDistance;
        double maxRenderDistance = (Integer)this.minecraft.f_91066_.m_231984_().m_231551_() * 16;
        if (maxDistance > 0 && actualDistance > (double)maxDistance) {
            return;
        }
        if (waypoint.isDeathPoint() && this.waypointProperties.autoRemoveDeathpoints.get().booleanValue() && actualDistance < (double)this.waypointProperties.autoRemoveDeathpointDistance.get().intValue() && actualDistance > 1.5) {
            Journeymap.getLogger().debug("Auto removing deathpoint " + waypoint);
            WaypointStore.INSTANCE.remove(waypoint, true);
            return;
        }
        if (Waypoint.Origin.TEMP.getValue().equals(waypoint.getOrigin()) && (actualDistance <= (double)this.waypointProperties.autoRemoveTempWaypoints.get().intValue() || actualDistance <= (double)(minDistance + 4)) && actualDistance > 1.5) {
            Journeymap.getLogger().debug("Auto removing temp waypoint " + waypoint);
            WaypointStore.INSTANCE.remove(waypoint, true);
        }
        if (minDistance > 0) {
            if ((int)actualDistance <= minDistance) {
                return;
            }
            if ((int)actualDistance <= minDistance + 4) {
                fadeAlpha = Math.min((float)(actualDistance - (double)minDistance) / 3.0f, 1.0f);
            }
        }
        if (viewDistance > maxRenderDistance) {
            Vec3 delta = waypointVec.m_82546_(playerVec).m_82541_();
            waypointVec = playerVec.m_82520_(delta.f_82479_ * maxRenderDistance, delta.f_82480_ * maxRenderDistance, delta.f_82481_ * maxRenderDistance);
            viewDistance = maxRenderDistance;
        }
        double scale = 0.00390625 * ((viewDistance + 4.0) / 3.0);
        double shiftX = waypointVec.f_82479_ - viewX;
        double shiftY = waypointVec.f_82480_ - viewY;
        double shiftZ = waypointVec.f_82481_ - viewZ;
        this.render(poseStack, buffers, waypoint, partialTicks, gameTime, rgba, fadeAlpha, shiftX, shiftY, shiftZ, playerVec, waypointVec, viewDistance, actualDistance, scale);
    }

    protected abstract void render(PoseStack var1, MultiBufferSource var2, Waypoint var3, float var4, long var5, float[] var7, float var8, double var9, double var11, double var13, Vec3 var15, Vec3 var16, double var17, double var19, double var21);
}

