/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.util.CompatUtil;

public class SilverBomb
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Integer> TIME = SynchedEntityData.m_135353_(SilverBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LAST_DURATION = SynchedEntityData.m_135353_(SilverBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean shrapnel;
    private int duration;
    private int explosion;
    private int bouncy;

    public SilverBomb(EntityType<? extends SilverBomb> entity, Level world) {
        super(entity, world);
    }

    public SilverBomb(Level world, LivingEntity entity, ItemStack stack) {
        super((EntityType)GEntityTypes.SILVER_BOMB.get(), entity, world);
        CompoundTag tag;
        if (!stack.m_41619_() && stack.m_41782_() && (tag = stack.m_41783_()) != null) {
            this.explosion = tag.m_128451_("Explosion");
            this.duration = tag.m_128451_("Duration");
            this.bouncy = tag.m_128451_("Bouncy");
            this.shrapnel = tag.m_128471_("Shrapnel");
        }
        this.f_19804_.m_135381_(LAST_DURATION, (Object)(this.duration * 20));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TIME, (Object)40);
        this.f_19804_.m_135372_(LAST_DURATION, (Object)0);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setTime(tag.m_128451_("Time"));
        this.setLastDuration(tag.m_128451_("LastDuration"));
        this.duration = tag.m_128451_("Duration");
        this.explosion = tag.m_128451_("Explosion");
        this.bouncy = tag.m_128451_("Bouncy");
        this.shrapnel = tag.m_128471_("Shrapnel");
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("LastDuration", this.getLastDuration());
        tag.m_128405_("Time", this.getTime());
        tag.m_128405_("Duration", this.duration);
        tag.m_128405_("Explosion", this.explosion);
        tag.m_128405_("Bouncy", this.bouncy);
        tag.m_128379_("Sharpnel", this.shrapnel);
    }

    public void setTime(int time) {
        this.f_19804_.m_135381_(TIME, (Object)time);
    }

    public int getTime() {
        return (Integer)this.f_19804_.m_135370_(TIME);
    }

    public void setLastDuration(int lastDuration) {
        this.f_19804_.m_135381_(LAST_DURATION, (Object)lastDuration);
    }

    public int getLastDuration() {
        return (Integer)this.f_19804_.m_135370_(LAST_DURATION);
    }

    protected float m_7139_() {
        return 0.05f;
    }

    protected Item m_7881_() {
        return (Item)GItems.SILVER_BOMB.get();
    }

    public void m_8119_() {
        super.m_8119_();
        CompatUtil compatUtil = new CompatUtil();
        if (!this.m_213877_()) {
            int k;
            int i;
            if (this.m_9236_().m_5776_() && !this.m_20069_()) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.3, this.m_20189_(), 0.0, 0.0, 0.0);
            }
            if ((i = this.getTime()) > (k = -this.getLastDuration())) {
                this.setTime(i - 1);
            }
            if (!this.m_20069_() && i == k && !this.m_9236_().m_5776_()) {
                this.bombExplode(compatUtil);
            }
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        CompatUtil compatUtil = new CompatUtil();
        if (!this.m_9236_().m_5776_()) {
            this.bombExplode(compatUtil);
        }
    }

    private void bombExplode(CompatUtil compatUtil) {
        if (this.shrapnel && compatUtil.isModInstalled("oreganized")) {
            this.shrapnelExplode(compatUtil);
        } else {
            boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this.m_19749_());
            this.m_9236_().m_254877_((Entity)this, null, new ExplosionDamageCalculator(){

                public boolean m_6714_(Explosion explosion, BlockGetter world, BlockPos pos, BlockState state, float p_46098_) {
                    return (double)world.m_8055_(pos).m_60734_().m_155943_() < 3.0;
                }
            }, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f + (float)this.explosion, false, flag ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void shrapnelExplode(CompatUtil compatUtil) {
        String modid = "oreganized";
        SimpleParticleType LEAD_SHRAPNEL = compatUtil.getCompatParticle(modid, "lead_shrapnel");
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 6.0f, Level.ExplosionInteraction.NONE);
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)LEAD_SHRAPNEL, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 100, 0.0, 0.0, 0.0, 5.0);
        }
        int primedShrapnelBombRadius = 30;
        int radius = primedShrapnelBombRadius / 4 + this.explosion;
        for (Entity entity : this.m_9236_().m_45933_((Entity)this, new AABB(this.m_20185_() - (double)radius, this.m_20186_() - 4.0, this.m_20189_() - (double)radius, this.m_20185_() + (double)radius, this.m_20186_() + 4.0, this.m_20189_() + (double)radius))) {
            int random = (int)(Math.random() * 100.0);
            boolean shouldPoison = false;
            if (entity.m_20280_((Entity)this) <= 16.0) {
                shouldPoison = true;
            } else if (entity.m_20280_((Entity)this) <= 64.0) {
                if (random < 60) {
                    shouldPoison = true;
                }
            } else if (entity.m_20280_((Entity)this) <= 225.0) {
                if (random < radius) {
                    shouldPoison = true;
                }
            } else if (entity.m_20280_((Entity)this) <= (double)(radius * radius) && random < 5) {
                shouldPoison = true;
            }
            if (!shouldPoison || !(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            MobEffect STUNNED = compatUtil.getCompatEffect(modid, "stunned");
            livingEntity.m_6469_(this.m_9236_().m_269111_().m_269425_(), 2.0f);
            livingEntity.m_7292_(new MobEffectInstance(STUNNED, 800));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 260));
        }
    }

    public void m_7822_(byte id) {
        if (id == 3) {
            ItemStack itemstack = this.m_37454_();
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)(itemstack.m_41619_() ? (ParticleOptions)GParticleTypes.SILVER_BOMB.get() : new ItemParticleOption(ParticleTypes.f_123752_, itemstack)), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        Vec3 deltaMovement = this.m_20184_();
        Vec3 vec3 = deltaMovement.m_82492_(deltaMovement.f_82479_ / 5.0, 0.0, deltaMovement.f_82481_ / 5.0);
        Direction direction = hit.m_82434_();
        double booster = 0.3 + (double)((float)this.bouncy / 10.0f);
        if (direction == Direction.UP || direction == Direction.DOWN) {
            this.m_20334_(vec3.f_82479_, vec3.f_82480_ < 0.0 ? -vec3.f_82480_ * booster : 0.0, vec3.f_82481_);
        }
        if (direction == Direction.WEST || direction == Direction.EAST) {
            this.m_20334_(vec3.f_82479_ < 0.65 ? -vec3.f_82479_ * booster * (double)Mth.m_14031_((float)1.5707964f) : 0.0, vec3.f_82480_, vec3.f_82481_);
        }
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            this.m_20334_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_ < 0.65 ? -vec3.f_82481_ * booster * (double)Mth.m_14031_((float)2.3561945f) : 0.0);
        }
        if (!this.m_9236_().m_5776_() && this.m_20069_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }
}

