/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.shared.effect;

import dev.foxgirl.pickaxetrims.shared.OreDetectUtil;
import dev.foxgirl.pickaxetrims.shared.PickaxeTrimsImpl;
import dev.foxgirl.pickaxetrims.shared.effect.AbstractEffect;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class RedstoneVeinMineEffect
extends AbstractEffect {
    private final Queue<Runnable> pendingTasks = new ArrayDeque<Runnable>();

    private void findPositions(BlockPos pos, Block block, Level level, ServerPlayer player, List<BlockPos> positions, int depth) {
        if (depth-- < 0) {
            return;
        }
        if (block != level.m_8055_(pos).m_60734_()) {
            return;
        }
        if (!positions.contains(pos)) {
            positions.add(pos);
            this.findPositions(pos.m_122012_(), block, level, player, positions, depth);
            this.findPositions(pos.m_122019_(), block, level, player, positions, depth);
            this.findPositions(pos.m_122029_(), block, level, player, positions, depth);
            this.findPositions(pos.m_122024_(), block, level, player, positions, depth);
            this.findPositions(pos.m_7494_(), block, level, player, positions, depth);
            this.findPositions(pos.m_7495_(), block, level, player, positions, depth);
        }
    }

    private void sortPositions(BlockPos pos, List<BlockPos> positions) {
        positions.sort((a, b) -> {
            double aDistance = a.m_123331_((Vec3i)pos);
            double bDistance = b.m_123331_((Vec3i)pos);
            return Double.compare(aDistance, bDistance);
        });
    }

    @Override
    public void onTickEnd(@NotNull MinecraftServer server) {
        Runnable task = this.pendingTasks.poll();
        if (task != null) {
            task.run();
        }
    }

    @Override
    public void onBlockBreak(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ServerPlayer player) {
        Block block = state.m_60734_();
        if (OreDetectUtil.isOreBlock(block)) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            this.findPositions(pos, block, level, player, positions, PickaxeTrimsImpl.getInstance().config.redstoneVeinMineDepth);
            this.sortPositions(pos, positions);
            positions.stream().map(it -> () -> level.m_46953_(it, true, (Entity)player)).forEach(this.pendingTasks::add);
        }
    }
}

