/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.shared;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.LootEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.value.IntValue;
import dev.foxgirl.pickaxetrims.shared.PickaxeTrim;
import dev.foxgirl.pickaxetrims.shared.PickaxeTrimsConfig;
import dev.foxgirl.pickaxetrims.shared.effect.CryingObsidianMultiBreakEffect;
import dev.foxgirl.pickaxetrims.shared.effect.LapisGlowEffect;
import dev.foxgirl.pickaxetrims.shared.effect.RedstoneVeinMineEffect;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PickaxeTrimsImpl
implements TickEvent.Server,
BlockEvent.Break,
LootEvent.ModifyLootTable {
    private static PickaxeTrimsImpl INSTANCE;
    @NotNull
    public final PickaxeTrimsConfig config;
    @NotNull
    private final DeferredRegister<Item> registryItem;
    @NotNull
    private final DeferredRegister<CreativeModeTab> registryItemGroup;
    @NotNull
    private final @NotNull Supplier<@NotNull SmithingTemplateItem> smithingTemplateItem;
    @NotNull
    private final @NotNull RegistrySupplier<@NotNull CreativeModeTab> itemGroup;
    private CryingObsidianMultiBreakEffect cryingObsidianEffect;
    private RedstoneVeinMineEffect redstoneEffect;
    private LapisGlowEffect lapisEffect;

    public static PickaxeTrimsImpl getInstance() {
        return INSTANCE;
    }

    @NotNull
    public SmithingTemplateItem getSmithingTemplateItem() {
        return this.smithingTemplateItem.get();
    }

    @NotNull
    public CreativeModeTab getItemGroup() {
        return (CreativeModeTab)this.itemGroup.get();
    }

    @NotNull
    public ResourceKey<CreativeModeTab> getItemGroupKey() {
        return ResourceKey.m_135785_((ResourceKey)this.itemGroup.getRegistryKey(), (ResourceLocation)this.itemGroup.getId());
    }

    public PickaxeTrimsImpl() {
        INSTANCE = this;
        this.config = PickaxeTrimsConfig.loadConfig();
        this.registryItem = DeferredRegister.create((String)"pickaxetrims", (ResourceKey)Registries.f_256913_);
        this.registryItemGroup = DeferredRegister.create((String)"pickaxetrims", (ResourceKey)Registries.f_279569_);
        this.smithingTemplateItem = this.registryItem.register(ResourceLocation.m_214293_((String)"pickaxetrims", (String)"fracture_armor_trim_smithing_template"), () -> SmithingTemplateItem.m_266172_((ResourceLocation)ResourceLocation.m_214293_((String)"pickaxetrims", (String)"fracture")));
        this.itemGroup = this.registryItemGroup.register(ResourceLocation.m_214293_((String)"pickaxetrims", (String)"pickaxe_trims_tab"), () -> CreativeTabRegistry.create((Component)Component.m_237115_((String)"itemGroup.pickaxetrims"), () -> PickaxeTrim.set(new ItemStack((ItemLike)Items.f_42395_), PickaxeTrim.TrimType.EMERALD)));
    }

    public void initialize() {
        this.registryItem.register();
        this.registryItemGroup.register();
        LootEvent.MODIFY_LOOT_TABLE.register((Object)this);
        TickEvent.SERVER_POST.register((Object)this);
        BlockEvent.BREAK.register((Object)this);
        this.cryingObsidianEffect = new CryingObsidianMultiBreakEffect();
        this.redstoneEffect = new RedstoneVeinMineEffect();
        this.lapisEffect = new LapisGlowEffect();
    }

    public void forEachStackForItemGroup(@NotNull @NotNull Consumer<@NotNull ItemStack> consumer) {
        for (PickaxeTrim.PickaxeType pickaxeType : PickaxeTrim.PickaxeType.VALUES) {
            for (PickaxeTrim.TrimType trimType : PickaxeTrim.TrimType.VALUES) {
                consumer.accept(PickaxeTrim.set(new ItemStack((ItemLike)pickaxeType.getItem()), trimType));
            }
        }
        consumer.accept(new ItemStack((ItemLike)this.getSmithingTemplateItem()));
    }

    private boolean shouldModifyLootTable(ResourceLocation id) {
        return this.config.smithingTemplateLootTables.contains(id.toString());
    }

    private int getLootTableEmptyEntryWeight() {
        return Math.max(0, 1 - (int)(1.0f / this.config.smithingTemplateLootProbability));
    }

    public void modifyLootTable(@Nullable LootDataManager lootDataManager, ResourceLocation id, LootEvent.LootTableModificationContext context, boolean builtin) {
        if (this.shouldModifyLootTable(id)) {
            context.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(this.getLootTableEmptyEntryWeight())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)this.getSmithingTemplateItem()).m_79707_(1)));
        }
    }

    public void tick(@NotNull MinecraftServer server) {
        this.cryingObsidianEffect.onTickEnd(server);
        this.redstoneEffect.onTickEnd(server);
        this.lapisEffect.onTickEnd(server);
    }

    public EventResult breakBlock(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ServerPlayer player, @Nullable IntValue xp) {
        PickaxeTrim.TrimType trimType = PickaxeTrim.getTrimType(player.m_21205_());
        if (trimType != null) {
            switch (trimType) {
                case CRYING_OBSIDIAN: {
                    this.cryingObsidianEffect.onBlockBreak(level, pos, state, player);
                    break;
                }
                case REDSTONE: {
                    this.redstoneEffect.onBlockBreak(level, pos, state, player);
                    break;
                }
                case LAPIS_LAZULI: {
                    this.lapisEffect.onBlockBreak(level, pos, state, player);
                    break;
                }
            }
        }
        return EventResult.pass();
    }
}

