/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.shared;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import dev.architectury.platform.Platform;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PickaxeTrimsConfig {
    public int cryingObsidianMultiBreakRadius = 1;
    public int lapisGlowRadius = 10;
    public float lapisGlowSeconds = 10.0f;
    public int redstoneVeinMineDepth = 16;
    public float copperDurabilityMultiplier = 2.0f;
    public float emeraldDoubleDropsChance = 0.5f;
    public float quartzExperienceMultiplierMin = 1.5f;
    public float quartzExperienceMultiplierMax = 3.0f;
    public float smithingTemplateLootProbability = 0.1f;
    public List<String> smithingTemplateLootTables = List.of("minecraft:chests/desert_pyramid", "minecraft:chests/buried_treasure", "minecraft:chests/shipwreck_treasure", "minecraft:chests/stronghold_corridor", "minecraft:chests/stronghold_crossing", "minecraft:chests/stronghold_library", "minecraft:chests/woodland_mansion", "minecraft:chests/village/village_toolsmith");

    public static PickaxeTrimsConfig loadConfig() {
        Logger logger = LogManager.getLogger();
        Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
        Path configPath = Platform.getConfigFolder().resolve("pickaxetrims.json");
        Path tempPath = Platform.getConfigFolder().resolve("pickaxetrims.json.tmp");
        try {
            return (PickaxeTrimsConfig)gson.fromJson((Reader)Files.newBufferedReader(configPath), PickaxeTrimsConfig.class);
        }
        catch (NoSuchFileException cause) {
            logger.warn("Config file not found, will be created");
        }
        catch (JsonParseException cause) {
            logger.error("Failed to parse config file", (Throwable)cause);
        }
        catch (Exception cause) {
            logger.error("Failed to load config file", (Throwable)cause);
        }
        PickaxeTrimsConfig config = new PickaxeTrimsConfig();
        try {
            Files.writeString(tempPath, (CharSequence)gson.toJson((Object)config, PickaxeTrimsConfig.class), new OpenOption[0]);
            Files.move(tempPath, configPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception cause) {
            logger.error("Failed to save new config file", (Throwable)cause);
        }
        return config;
    }
}

