/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.unusualfishmod.common.entity.util.misc;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MovingBlockData {
    private BlockState state;
    private VoxelShape shape;
    private BlockPos offset;
    @Nullable
    public CompoundTag blockData;

    public MovingBlockData(BlockState state, VoxelShape shape, BlockPos offset, @Nullable CompoundTag blockData) {
        this.state = state;
        this.shape = shape;
        this.offset = offset;
        this.blockData = blockData;
    }

    public MovingBlockData(Level level, CompoundTag tag) {
        this(NbtUtils.m_247651_((HolderGetter)level.m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("BlockState")), MovingBlockData.getShapeFromTag(tag.m_128469_("VoxelShape")), new BlockPos(tag.m_128451_("OffsetX"), tag.m_128451_("OffsetY"), tag.m_128451_("OffsetZ")), tag.m_128441_("BlockData") ? tag.m_128469_("BlockData") : null);
    }

    public BlockState getState() {
        return this.state;
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public VoxelShape getShape() {
        return this.shape;
    }

    public void setShape(VoxelShape shape) {
        this.shape = shape;
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    public void setOffset(BlockPos offset) {
        this.offset = offset;
    }

    @Nullable
    public CompoundTag getBlockData() {
        return this.blockData;
    }

    public void setBlockData(@Nullable CompoundTag blockData) {
        this.blockData = blockData;
    }

    public CompoundTag toTag() {
        CompoundTag data = new CompoundTag();
        data.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.state));
        data.m_128365_("VoxelShape", (Tag)this.getShapeTag());
        data.m_128405_("OffsetX", this.offset.m_123341_());
        data.m_128405_("OffsetY", this.offset.m_123342_());
        data.m_128405_("OffsetZ", this.offset.m_123343_());
        if (this.blockData != null) {
            data.m_128365_("BlockData", (Tag)this.blockData);
        }
        return data;
    }

    private CompoundTag getShapeTag() {
        CompoundTag data = new CompoundTag();
        ListTag listTag = new ListTag();
        for (AABB shapeAABB : this.shape.m_83299_()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("BoxMinX", shapeAABB.f_82288_);
            tag.m_128347_("BoxMinY", shapeAABB.f_82289_);
            tag.m_128347_("BoxMinZ", shapeAABB.f_82290_);
            tag.m_128347_("BoxMaxX", shapeAABB.f_82291_);
            tag.m_128347_("BoxMaxY", shapeAABB.f_82292_);
            tag.m_128347_("BoxMaxZ", shapeAABB.f_82293_);
            listTag.add((Object)tag);
        }
        data.m_128365_("AABBs", (Tag)listTag);
        return data;
    }

    private static VoxelShape getShapeFromTag(CompoundTag data) {
        VoxelShape shape = Shapes.m_83040_();
        if (data.m_128441_("AABBs")) {
            ListTag listtag = data.m_128437_("AABBs", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag innerTag = listtag.m_128728_(i);
                AABB aabb = new AABB(innerTag.m_128459_("BoxMinX"), innerTag.m_128459_("BoxMinY"), innerTag.m_128459_("BoxMinZ"), innerTag.m_128459_("BoxMaxX"), innerTag.m_128459_("BoxMaxY"), innerTag.m_128459_("BoxMaxZ"));
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82695_);
            }
        }
        return shape;
    }
}

