/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.highlighter;

import com.anthonyhilyard.iceberg.util.ItemColor;
import com.electronwill.nightconfig.core.Config;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="highlighter", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HighlighterConfig {
    public static final ForgeConfigSpec SPEC;
    public static final HighlighterConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue clearOnInventoryClose;
    public final ForgeConfigSpec.BooleanValue clearOnHover;
    public final ForgeConfigSpec.BooleanValue clearOnSelect;
    public final ForgeConfigSpec.BooleanValue useItemNameColor;
    public final ForgeConfigSpec.BooleanValue showOnHotbar;
    public final ForgeConfigSpec.ConfigValue<IconPosition> iconPosition;
    private static Map<Pair<Item, CompoundTag>, TextColor> colorCache;

    public HighlighterConfig(ForgeConfigSpec.Builder build) {
        build.comment("Client Configuration").push("client").push("options");
        this.clearOnInventoryClose = build.comment(" If new item markers should be cleared when the inventory is closed.").define("clear_on_close", true);
        this.clearOnHover = build.comment(" If new item markers should be cleared when the item tooltip is displayed.").define("clear_on_hover", true);
        this.clearOnSelect = build.comment(" If new item markers should be cleared when the item is selected on the hotbar.").define("clear_on_select", true);
        this.useItemNameColor = build.comment(" If icons should match the color of items names (as shown in tooltips).  Otherwise icons will all be gold.").define("item_name_color", false);
        this.showOnHotbar = build.comment(" If new item markers should show on the hotbar.").define("show_on_hotbar", true);
        this.iconPosition = build.comment(" The position of new item markers.").defineEnum("icon_position", (Enum)IconPosition.UpperLeft);
        build.pop().pop();
    }

    public static TextColor getColorForItem(ItemStack itemStack, TextColor defaultColor) {
        Pair key = Pair.of((Object)itemStack.m_41720_(), (Object)itemStack.m_41783_());
        if (!colorCache.containsKey(key)) {
            TextColor color = ItemColor.getColorForItem((ItemStack)itemStack, (TextColor)defaultColor);
            colorCache.put((Pair<Item, CompoundTag>)key, color);
        }
        return colorCache.get(key);
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading e) {
        if (e.getConfig().getModId().equals("highlighter")) {
            colorCache.clear();
        }
    }

    static {
        Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(HighlighterConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (HighlighterConfig)specPair.getLeft();
        colorCache = Maps.newHashMap();
    }

    public static enum IconPosition {
        UpperLeft,
        UpperRight,
        LowerLeft,
        LowerRight;

    }
}

