/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.trades;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.misc.CodecMapRegistry;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.misc.RegistryAccessJsonReloadListener;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.moonlight.api.trades.NoOpListing;
import net.mehvahdjukaar.moonlight.api.trades.RemoveNonDataListingListing;
import net.mehvahdjukaar.moonlight.api.trades.SimpleItemListing;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemListingRegistry
extends RegistryAccessJsonReloadListener {
    private static final ItemListingRegistry INSTANCE = new ItemListingRegistry();
    protected static final CodecMapRegistry<ModItemListing> REGISTRY = MapRegistry.ofCodec();
    private final Map<EntityType<?>, Set<ModItemListing>> specialTradesAdded = new HashMap();
    private final Map<VillagerProfession, Set<ModItemListing>> tradesAdded = new HashMap<VillagerProfession, Set<ModItemListing>>();
    private final Map<EntityType<?>, Int2ObjectArrayMap<Set<VillagerTrades.ItemListing>>> specialTradesRemoved = new HashMap();
    private final Map<VillagerProfession, Int2ObjectArrayMap<Set<VillagerTrades.ItemListing>>> tradesRemoved = new HashMap<VillagerProfession, Int2ObjectArrayMap<Set<VillagerTrades.ItemListing>>>();

    @ApiStatus.Internal
    public static void init() {
        REGISTRY.register(new ResourceLocation("simple"), SimpleItemListing.CODEC);
        REGISTRY.register(new ResourceLocation("remove_all_non_data"), RemoveNonDataListingListing.CODEC);
        REGISTRY.register(new ResourceLocation("no_op"), NoOpListing.CODEC);
    }

    public ItemListingRegistry() {
        super(new Gson(), "moonlight/villager_trade");
    }

    @Override
    public void parse(Map<ResourceLocation, JsonElement> jsons, RegistryAccess registryAccess) {
        ModItemListing listing;
        Int2ObjectMap wanderingTraderTrades;
        Int2ObjectArrayMap<Set<VillagerTrades.ItemListing>> removed;
        Int2ObjectMap<VillagerTrades.ItemListing[]> tradeMap;
        RemoveNonDataListingListing listing2;
        this.restoreVanillaState();
        ArrayList<Pair> toAdd = new ArrayList<Pair>();
        ArrayList<Pair> toAddSpecial = new ArrayList<Pair>();
        ArrayList<Pair> toRemove = new ArrayList<Pair>();
        ArrayList<Pair> toRemoveSpecial = new ArrayList<Pair>();
        DynamicOps ops = ForgeHelper.addConditionOps(RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess));
        for (Map.Entry<ResourceLocation, JsonElement> e : jsons.entrySet()) {
            JsonElement json = e.getValue();
            ResourceLocation id = e.getKey();
            if (!id.m_135815_().contains("/")) continue;
            ResourceLocation targetId = id.m_247266_(p -> p.substring(0, p.lastIndexOf(47)));
            Optional profession = BuiltInRegistries.f_256735_.m_6612_(targetId);
            if (profession.isPresent()) {
                ModItemListing trade = ItemListingRegistry.parseOrThrow(json, id, ops).orElse(null);
                if (trade == null || trade instanceof NoOpListing) continue;
                if (trade instanceof RemoveNonDataListingListing) {
                    RemoveNonDataListingListing rl = (RemoveNonDataListingListing)trade;
                    toRemove.add(Pair.of((Object)rl, (Object)((VillagerProfession)profession.get())));
                    continue;
                }
                toAdd.add(Pair.of((Object)trade, (Object)((VillagerProfession)profession.get())));
                continue;
            }
            Optional entityType = BuiltInRegistries.f_256780_.m_6612_(targetId);
            if (entityType.isPresent()) {
                ModItemListing trade = ItemListingRegistry.parseOrThrow(json, id, ops).orElse(null);
                if (trade == null || trade instanceof NoOpListing) continue;
                if (trade instanceof RemoveNonDataListingListing) {
                    RemoveNonDataListingListing rl = (RemoveNonDataListingListing)trade;
                    toRemoveSpecial.add(Pair.of((Object)rl, (Object)((EntityType)entityType.get())));
                    continue;
                }
                toAddSpecial.add(Pair.of((Object)trade, (Object)((EntityType)entityType.get())));
                continue;
            }
            Moonlight.LOGGER.warn("Unknown villager type: {}", (Object)targetId);
        }
        for (Pair pair : toRemove) {
            VillagerProfession profession = (VillagerProfession)pair.getSecond();
            listing2 = (RemoveNonDataListingListing)pair.getFirst();
            removed = this.removeMatchingTrades(listing2, tradeMap = ItemListingRegistry.getTradeMapForProfession(profession));
            if (removed.isEmpty()) continue;
            this.tradesRemoved.computeIfAbsent(profession, k -> new Int2ObjectArrayMap()).putAll(removed);
        }
        for (Pair pair : toRemoveSpecial) {
            EntityType entity = (EntityType)pair.getSecond();
            if (entity != EntityType.f_20494_ || (removed = this.removeMatchingTrades(listing2 = (RemoveNonDataListingListing)pair.getFirst(), (Int2ObjectMap<VillagerTrades.ItemListing[]>)(wanderingTraderTrades = VillagerTrades.f_35628_))).isEmpty()) continue;
            this.specialTradesRemoved.computeIfAbsent(entity, k -> new Int2ObjectArrayMap()).putAll(removed);
        }
        for (Pair pair : toAdd) {
            listing = (ModItemListing)pair.getFirst();
            VillagerProfession profession = (VillagerProfession)pair.getSecond();
            tradeMap = ItemListingRegistry.getTradeMapForProfession(profession);
            ItemListingRegistry.addTrade(tradeMap, listing, true);
            this.tradesAdded.computeIfAbsent(profession, k -> new HashSet()).add(listing);
        }
        for (Pair pair : toAddSpecial) {
            listing = (ModItemListing)pair.getFirst();
            EntityType entity = (EntityType)pair.getSecond();
            if (entity == EntityType.f_20494_) {
                wanderingTraderTrades = VillagerTrades.f_35628_;
                ItemListingRegistry.addTrade((Int2ObjectMap<VillagerTrades.ItemListing[]>)wanderingTraderTrades, listing, true);
            }
            this.specialTradesAdded.computeIfAbsent(entity, k -> new HashSet()).add(listing);
        }
        int added = this.specialTradesAdded.values().stream().mapToInt(Set::size).sum() + this.tradesAdded.values().stream().mapToInt(Set::size).sum();
        int removed2 = this.tradesRemoved.values().stream().mapToInt(map -> map.values().stream().mapToInt(Set::size).sum()).sum() + this.specialTradesRemoved.values().stream().mapToInt(map -> map.values().stream().mapToInt(Set::size).sum()).sum();
        if (added > 0) {
            Moonlight.LOGGER.info("Applied {} data villager trades", (Object)added);
        }
        if (removed2 > 0) {
            Moonlight.LOGGER.info("Removed {} data villager trades", (Object)removed2);
        }
    }

    @NotNull
    private static Int2ObjectMap<VillagerTrades.ItemListing[]> getTradeMapForProfession(VillagerProfession profession) {
        return VillagerTrades.f_35627_.computeIfAbsent(profession, k -> new Int2ObjectArrayMap());
    }

    private static void addTrade(Int2ObjectMap<VillagerTrades.ItemListing[]> tradeMap, @NotNull ModItemListing listing, boolean add) {
        int level = listing.getLevel();
        VillagerTrades.ItemListing[] existing = (VillagerTrades.ItemListing[])tradeMap.computeIfAbsent(level, k -> new VillagerTrades.ItemListing[0]);
        tradeMap.put(listing.getLevel(), (Object)ItemListingRegistry.mergeArrays(existing, add, listing));
    }

    private static VillagerTrades.ItemListing[] mergeArrays(VillagerTrades.ItemListing[] existing, boolean add, VillagerTrades.ItemListing ... toAdd) {
        ArrayList<VillagerTrades.ItemListing> list = new ArrayList<VillagerTrades.ItemListing>(List.of(existing));
        if (add) {
            list.addAll(List.of(toAdd));
        } else {
            list.removeAll(List.of(toAdd));
        }
        return (VillagerTrades.ItemListing[])list.toArray(VillagerTrades.ItemListing[]::new);
    }

    private Int2ObjectArrayMap<Set<VillagerTrades.ItemListing>> removeMatchingTrades(RemoveNonDataListingListing removal, Int2ObjectMap<VillagerTrades.ItemListing[]> originalTrades) {
        Int2ObjectArrayMap removedTrades = new Int2ObjectArrayMap();
        HashMap<Integer, VillagerTrades.ItemListing[]> updatedTrades = new HashMap<Integer, VillagerTrades.ItemListing[]>();
        for (Int2ObjectMap.Entry entry : originalTrades.int2ObjectEntrySet()) {
            int level = entry.getIntKey();
            VillagerTrades.ItemListing[] trades = (VillagerTrades.ItemListing[])entry.getValue();
            ArrayList<VillagerTrades.ItemListing> remaining = new ArrayList<VillagerTrades.ItemListing>();
            HashSet<VillagerTrades.ItemListing> removedAtLevel = new HashSet<VillagerTrades.ItemListing>();
            for (VillagerTrades.ItemListing trade : trades) {
                if (removal.matches(level, trade)) {
                    removedAtLevel.add(trade);
                    continue;
                }
                remaining.add(trade);
            }
            if (removedAtLevel.isEmpty()) continue;
            removedTrades.put(level, removedAtLevel);
            updatedTrades.put(level, (VillagerTrades.ItemListing[])remaining.toArray(VillagerTrades.ItemListing[]::new));
        }
        originalTrades.putAll(updatedTrades);
        return removedTrades;
    }

    private void restoreVanillaState() {
        EntityType entity;
        VillagerTrades.ItemListing[] array;
        int level;
        Int2ObjectMap<VillagerTrades.ItemListing[]> tradeMap;
        Set<ModItemListing> listings;
        VillagerProfession profession;
        for (Map.Entry<VillagerProfession, Set<ModItemListing>> entry : this.tradesAdded.entrySet()) {
            profession = entry.getKey();
            listings = entry.getValue();
            tradeMap = ItemListingRegistry.getTradeMapForProfession(profession);
            for (ModItemListing listing : listings) {
                level = listing.getLevel();
                array = (VillagerTrades.ItemListing[])tradeMap.get(level);
                if (array == null) continue;
                ItemListingRegistry.addTrade(tradeMap, listing, false);
            }
        }
        for (Map.Entry<VillagerProfession, Set<ModItemListing>> entry : this.specialTradesAdded.entrySet()) {
            entity = (EntityType)entry.getKey();
            listings = entry.getValue();
            if (entity != EntityType.f_20494_) continue;
            tradeMap = VillagerTrades.f_35628_;
            for (ModItemListing listing : listings) {
                level = listing.getLevel();
                array = (VillagerTrades.ItemListing[])tradeMap.get(level);
                if (array == null) continue;
                ItemListingRegistry.addTrade(tradeMap, listing, false);
            }
        }
        for (Map.Entry<VillagerProfession, Set<ModItemListing>> entry : this.tradesRemoved.entrySet()) {
            profession = entry.getKey();
            Int2ObjectMap removedPerLevel = (Int2ObjectMap)entry.getValue();
            tradeMap = ItemListingRegistry.getTradeMapForProfession(profession);
            this.restoreMap(tradeMap, (Int2ObjectMap<Set<VillagerTrades.ItemListing>>)removedPerLevel);
        }
        for (Map.Entry<VillagerProfession, Set<ModItemListing>> entry : this.specialTradesRemoved.entrySet()) {
            entity = (EntityType)entry.getKey();
            if (entity != EntityType.f_20494_) continue;
            Int2ObjectMap tradeMap2 = VillagerTrades.f_35628_;
            Int2ObjectMap removedPerLevel = (Int2ObjectMap)entry.getValue();
            this.restoreMap((Int2ObjectMap<VillagerTrades.ItemListing[]>)tradeMap2, (Int2ObjectMap<Set<VillagerTrades.ItemListing>>)removedPerLevel);
        }
        this.tradesAdded.clear();
        this.specialTradesAdded.clear();
        this.tradesRemoved.clear();
        this.specialTradesRemoved.clear();
    }

    private void restoreMap(Int2ObjectMap<VillagerTrades.ItemListing[]> tradeMap, Int2ObjectMap<Set<VillagerTrades.ItemListing>> removedPerLevel) {
        for (Int2ObjectMap.Entry levelEntry : removedPerLevel.int2ObjectEntrySet()) {
            int level = levelEntry.getIntKey();
            Set removedTrades = (Set)levelEntry.getValue();
            VillagerTrades.ItemListing[] currentArray = (VillagerTrades.ItemListing[])tradeMap.get(level);
            tradeMap.put(level, (Object)ItemListingRegistry.mergeArrays(currentArray, true, (VillagerTrades.ItemListing[])removedTrades.toArray(VillagerTrades.ItemListing[]::new)));
        }
    }

    private static Optional<ModItemListing> parseOrThrow(JsonElement j, ResourceLocation id, DynamicOps<JsonElement> ops) {
        return ModItemListing.CODEC.parse(ops, (Object)j).result();
    }

    public static List<? extends VillagerTrades.ItemListing> getVillagerListings(VillagerProfession profession, int level) {
        VillagerTrades.ItemListing[] array = (VillagerTrades.ItemListing[])ItemListingRegistry.getTradeMapForProfession(profession).get(level);
        if (array == null) {
            return List.of();
        }
        return Arrays.stream(array).toList();
    }

    public static List<? extends VillagerTrades.ItemListing> getSpecialListings(EntityType<?> entityType, int level, HolderLookup.Provider provider) {
        if (entityType == EntityType.f_20494_) {
            VillagerTrades.ItemListing[] array = (VillagerTrades.ItemListing[])VillagerTrades.f_35628_.get(level);
            if (array == null) {
                return List.of();
            }
            return Arrays.stream(array).toList();
        }
        Set<ModItemListing> special = ItemListingRegistry.INSTANCE.specialTradesAdded.get(entityType);
        if (special == null) {
            return List.of();
        }
        ArrayList<ModItemListing> listings = new ArrayList<ModItemListing>();
        for (ModItemListing listing : special) {
            if (listing.getLevel() != level) continue;
            listings.add(listing);
        }
        return listings;
    }

    @Deprecated(forRemoval=true)
    public static List<? extends VillagerTrades.ItemListing> getSpecialListings(EntityType<?> entityType, int level) {
        return ItemListingRegistry.getSpecialListings(entityType, level, (HolderLookup.Provider)Utils.hackyGetRegistryAccess());
    }

    public static void registerSerializer(ResourceLocation id, Codec<? extends ModItemListing> trade) {
        REGISTRY.register(id, trade);
    }

    public static void registerSimple(ResourceLocation id, VillagerTrades.ItemListing instance, int level) {
        SpecialListing specialListing = new SpecialListing(instance, level);
        ItemListingRegistry.registerSerializer(id, specialListing.getCodec());
    }

    private static class SpecialListing
    implements ModItemListing {
        private final Codec<ModItemListing> codec = Codec.unit((Object)this);
        private final VillagerTrades.ItemListing listing;
        private final int level;

        public SpecialListing(VillagerTrades.ItemListing listing, int level) {
            this.listing = listing;
            this.level = level;
        }

        @Override
        public Codec<? extends ModItemListing> getCodec() {
            return this.codec;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource random) {
            return this.listing.m_213663_(trader, random);
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

