/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_useful_copper.core.entity.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class FollowPlayerGoal
extends Goal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.forNonCombat().range(10.0).ignoreLineOfSight();
    private final PathfinderMob mob;
    private final double speedModifier;
    private final TargetingConditions targetingConditions;
    private int calmDown;
    @Nullable
    private Player player;
    private boolean isRunning;

    public FollowPlayerGoal(PathfinderMob mob, double speedModifier) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.targetingConditions = TEMP_TARGETING.copy().selector(livingEntity -> livingEntity instanceof Player);
    }

    public boolean canUse() {
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.player = this.mob.level().getNearestPlayer(this.targetingConditions, (LivingEntity)this.mob);
        return this.player != null;
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void start() {
        this.isRunning = true;
    }

    public void stop() {
        this.player = null;
        this.mob.getNavigation().stop();
        this.calmDown = Goal.reducedTickDelay((int)100);
        this.isRunning = false;
    }

    public void tick() {
        this.mob.getLookControl().setLookAt((Entity)this.player, (float)(this.mob.getMaxHeadYRot() + 20), (float)this.mob.getMaxHeadXRot());
        if (this.mob.distanceToSqr((Entity)this.player) < 8.0) {
            this.mob.getNavigation().stop();
        } else {
            this.mob.getNavigation().moveTo((Entity)this.player, this.speedModifier);
        }
    }
}

