/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_crossbows.forge.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class BetterCrossbowsConfigForge {
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final Config CONFIG;

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(Config::new);
        CONFIG = (Config)pair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    public static class Config {
        public final ForgeConfigSpec.ConfigValue<String> copperDamage;
        public final ForgeConfigSpec.ConfigValue<Double> copperSpeed;
        public final ForgeConfigSpec.ConfigValue<String> goldenDamage;
        public final ForgeConfigSpec.ConfigValue<Double> goldenSpeed;
        public final ForgeConfigSpec.ConfigValue<String> diamondDamage;
        public final ForgeConfigSpec.ConfigValue<Double> diamondSpeed;
        public final ForgeConfigSpec.ConfigValue<String> netheriteDamage;
        public final ForgeConfigSpec.ConfigValue<Double> netheriteSpeed;

        public Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Better Crossbows Configuration File");
            builder.push("Crossbow_Copper");
            this.copperDamage = builder.comment("Damage dealt by Copper Crossbow (min-max range, e.g., \"5-10\" means 5 to 10 damage)").define("Damage", (Object)"5-10");
            this.copperSpeed = builder.comment("Charge speed multiplier (lower = faster, 1.0 = normal crossbow speed)").define("Speed", (Object)1.2);
            builder.pop();
            builder.push("Crossbow_Golden");
            this.goldenDamage = builder.comment("Damage dealt by Golden Crossbow (min-max range)").define("Damage", (Object)"4-9");
            this.goldenSpeed = builder.comment("Charge speed multiplier (lower = faster)").define("Speed", (Object)0.4);
            builder.pop();
            builder.push("Crossbow_Diamond");
            this.diamondDamage = builder.comment("Damage dealt by Diamond Crossbow (min-max range)").define("Damage", (Object)"12-17");
            this.diamondSpeed = builder.comment("Charge speed multiplier (lower = faster)").define("Speed", (Object)0.6);
            builder.pop();
            builder.push("Crossbow_Netherite");
            this.netheriteDamage = builder.comment("Damage dealt by Netherite Crossbow (min-max range)").define("Damage", (Object)"20-25");
            this.netheriteSpeed = builder.comment("Charge speed multiplier (lower = faster)").define("Speed", (Object)0.4);
            builder.pop();
        }
    }
}

