/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.items;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import teamdraco.finsandstails.common.entities.FlatbackLeafSnailEntity;
import teamdraco.finsandstails.common.entities.RiverPebbleSnailEntity;
import teamdraco.finsandstails.common.entities.SiderolWhiskeredSnailEntity;

public class FinsPotItem
extends BucketItem {
    private final Supplier<? extends EntityType<?>> entityTypeSupplier;
    private final Supplier<? extends Fluid> fluid;
    private final boolean hasTooltip;

    public FinsPotItem(Supplier<? extends EntityType<?>> entityType, Supplier<? extends Fluid> fluid, Item.Properties builder) {
        this(entityType, fluid, builder, true);
    }

    public FinsPotItem(Supplier<? extends EntityType<?>> entityType, Supplier<? extends Fluid> fluid, Item.Properties builder, boolean hasTooltip) {
        super(fluid, builder);
        this.fluid = fluid;
        this.hasTooltip = hasTooltip;
        this.entityTypeSupplier = entityType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        BlockHitResult result;
        ItemStack itemstack = playerIn.m_21120_(handIn);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)playerIn, (Level)worldIn, (ItemStack)itemstack, (HitResult)(result = FinsPotItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE)));
        if (ret != null) {
            return ret;
        }
        if (result.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = result.m_82425_();
        Direction direction = result.m_82434_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        if (worldIn.m_7966_(playerIn, blockpos) && playerIn.m_36204_(blockpos1, direction, itemstack)) {
            BlockState blockstate = worldIn.m_8055_(blockpos);
            BlockPos blockpos2 = blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, blockpos, blockstate, this.fluid.get()) ? blockpos : blockpos1;
            this.m_142073_(playerIn, worldIn, blockpos2, result);
            if (worldIn instanceof ServerLevel) {
                this.placeEntity((ServerLevel)worldIn, itemstack, blockpos2);
            }
            if (playerIn instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)playerIn, blockpos2, itemstack);
                if (this.entityTypeSupplier instanceof FlatbackLeafSnailEntity || this.entityTypeSupplier instanceof RiverPebbleSnailEntity || this.entityTypeSupplier instanceof SiderolWhiskeredSnailEntity) {
                    // empty if block
                }
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)this.getEmptyItem(itemstack, playerIn), (boolean)worldIn.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (this.hasTooltip && stack.m_41782_()) {
            tooltip.add((Component)Component.m_237115_((String)(this.getEntityType().m_20675_() + "." + stack.m_41783_().m_128451_("Variant"))).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        }
    }

    private void placeEntity(ServerLevel worldIn, ItemStack stack, BlockPos pos) {
        this.entityTypeSupplier.get().m_20592_(worldIn, stack, null, pos, MobSpawnType.BUCKET, true, false);
    }

    private EntityType<?> getEntityType() {
        return this.entityTypeSupplier.get();
    }

    private ItemStack getEmptyItem(ItemStack stack, Player player) {
        return !player.m_7500_() ? new ItemStack((ItemLike)Items.f_42618_) : stack;
    }
}

