/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.items;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class FinsBucketItem
extends MobBucketItem {
    private final Supplier<? extends EntityType<?>> entityTypeSupplier;
    private final boolean hasTooltip;

    public FinsBucketItem(Supplier<? extends EntityType<?>> entityType, Supplier<? extends Fluid> fluid, Item.Properties builder) {
        this(entityType, fluid, builder, false);
    }

    public FinsBucketItem(Supplier<? extends EntityType<?>> entityType, Supplier<? extends Fluid> fluid, Item.Properties builder, boolean hasTooltip) {
        super(entityType, fluid, () -> SoundEvents.f_11779_, builder);
        this.hasTooltip = hasTooltip;
        this.entityTypeSupplier = entityType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (this.getFluid() == Fluids.f_76191_) {
            BlockHitResult result;
            ItemStack itemstack = playerIn.m_21120_(handIn);
            InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)playerIn, (Level)worldIn, (ItemStack)itemstack, (HitResult)(result = FinsBucketItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE)));
            if (ret != null) {
                return ret;
            }
            if (result.m_6662_() == HitResult.Type.MISS) {
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
            if (result.m_6662_() != HitResult.Type.BLOCK) {
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
            BlockPos blockpos = result.m_82425_();
            Direction direction = result.m_82434_();
            BlockPos blockpos1 = blockpos.m_121945_(direction);
            this.m_142131_(playerIn, worldIn, itemstack, blockpos1);
            if (playerIn instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)playerIn, blockpos1, itemstack);
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)FinsBucketItem.m_40699_((ItemStack)itemstack, (Player)playerIn), (boolean)worldIn.m_5776_());
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (this.hasTooltip && stack.m_41782_()) {
            tooltip.add((Component)Component.m_237115_((String)(this.entityTypeSupplier.get().m_20675_() + "." + stack.m_41783_().m_128451_("Variant"))).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        }
    }
}

