/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import teamdraco.finsandstails.FTConfig;
import teamdraco.finsandstails.common.entities.PenglilEntity;
import teamdraco.finsandstails.common.entities.WanderingSailorEntity;
import teamdraco.finsandstails.common.entities.WherbleEntity;
import teamdraco.finsandstails.common.entities.ai.IHydrate;
import teamdraco.finsandstails.common.entities.item.TealArrowfishArrowEntity;
import teamdraco.finsandstails.registry.FTEnchantments;
import teamdraco.finsandstails.registry.FTTags;

@Mod.EventBusSubscriber(modid="finsandtails", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonForgeEvents {
    @SubscribeEvent
    public static void onArrowfishHit(ProjectileImpactEvent e) {
        EntityHitResult hitResult;
        Entity entity;
        Projectile proj = e.getProjectile();
        HitResult result = e.getRayTraceResult();
        if (result instanceof EntityHitResult && (entity = (hitResult = (EntityHitResult)result).m_82443_()) instanceof LivingEntity) {
            TealArrowfishArrowEntity fishArrow;
            Entity owner;
            LivingEntity target = (LivingEntity)entity;
            if (proj instanceof TealArrowfishArrowEntity && (owner = (fishArrow = (TealArrowfishArrowEntity)proj).m_19749_()) instanceof Player) {
                Player player = (Player)owner;
                List penglils = player.m_9236_().m_45971_(PenglilEntity.class, TargetingConditions.m_148353_(), (LivingEntity)player, player.m_20191_().m_82400_(32.0));
                for (PenglilEntity penglil : penglils) {
                    if (!penglil.m_21824_() || penglil.m_269323_() == null || penglil.m_269323_().equals((Object)target)) continue;
                    if (target instanceof TamableAnimal) {
                        boolean flag;
                        TamableAnimal tamable = (TamableAnimal)target;
                        boolean bl = flag = tamable.m_21824_() && tamable.m_269323_() != null && !tamable.m_269323_().equals((Object)owner);
                        if (flag) {
                            penglil.m_6710_(target);
                            continue;
                        }
                        return;
                    }
                    penglil.m_6710_(target);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerAttackEntity(AttackEntityEvent e) {
    }

    @SubscribeEvent
    public static void onPlayerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        InteractionHand hand = InteractionHand.OFF_HAND;
        Entity target = event.getTarget();
        Player player = event.getEntity();
        ItemStack offhandItem = player.m_21120_(hand);
        if (offhandItem.m_204117_(FTTags.CLAW_GAUNTLETS)) {
            player.m_6674_(hand);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (target.m_6469_(player.m_9236_().m_269111_().m_269075_(player), (float)player.m_21133_(Attributes.f_22281_))) {
                    offhandItem.m_41622_(1, (LivingEntity)player, p_21301_ -> p_21301_.m_21166_(EquipmentSlot.OFFHAND));
                    if (offhandItem.getEnchantmentLevel((Enchantment)FTEnchantments.UPPERCUTTING.get()) > 0) {
                        target.m_20256_(target.m_20184_().m_82520_(0.0, 0.3, 0.0));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickAir(PlayerInteractEvent event) {
        InteractionHand hand = event.getHand();
        Player player = event.getEntity();
        ItemStack offhandItem = player.m_6844_(EquipmentSlot.OFFHAND);
        if (offhandItem.m_204117_(FTTags.CLAW_GAUNTLETS)) {
            player.m_6674_(hand);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Wolf || entity instanceof Fox) {
            ((PathfinderMob)event.getEntity()).f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), WherbleEntity.class, true));
        }
        if (entity instanceof AbstractVillager) {
            ((PathfinderMob)event.getEntity()).f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal((Mob)((PathfinderMob)entity), WanderingSailorEntity.class, 6.0f));
        }
    }

    @SubscribeEvent
    public static void onHitWaterPotion(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof ThrownPotion) {
            boolean flag;
            ThrownPotion potionEntity = (ThrownPotion)projectile;
            ItemStack itemstack = potionEntity.m_7846_();
            Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
            List list = PotionUtils.m_43547_((ItemStack)itemstack);
            boolean bl = flag = potion == Potions.f_43599_ && list.isEmpty();
            if (flag) {
                CommonForgeEvents.applyWater((Projectile)potionEntity);
            }
        }
    }

    private static void applyWater(Projectile projectile) {
        AABB aabb = projectile.m_20191_().m_82377_(4.0, 2.0, 4.0);
        for (LivingEntity livingEntity : projectile.m_9236_().m_45976_(LivingEntity.class, aabb)) {
            if (!(livingEntity instanceof IHydrate)) continue;
            IHydrate hydrate = (IHydrate)livingEntity;
            hydrate.rehydrate();
        }
    }

    @SubscribeEvent
    public static void crabsFavorXPDrops(LivingExperienceDropEvent event) {
        Player attacker = event.getAttackingPlayer();
        if (attacker != null) {
            ItemStack heldItem = attacker.m_21205_();
            ItemStack heldItemOffhand = attacker.m_21206_();
            if (EnchantmentHelper.m_44831_((ItemStack)heldItem).containsKey(FTEnchantments.CRABS_FAVOR.get()) && EnchantmentHelper.m_44831_((ItemStack)heldItemOffhand).containsKey(FTEnchantments.CRABS_FAVOR.get())) {
                int i = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)FTEnchantments.CRABS_FAVOR.get()), (ItemStack)event.getAttackingPlayer().m_21120_(InteractionHand.MAIN_HAND));
                event.setDroppedExperience(event.getOriginalExperience() * i + attacker.m_20193_().f_46441_.m_188503_(3));
            }
        }
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        LootPool pool = event.getTable().getPool("main");
        if (name.equals((Object)BuiltInLootTables.f_78723_) && ((Boolean)FTConfig.Common.INSTANCE.finsFishingLoot.get()).booleanValue()) {
            CommonForgeEvents.addEntry(pool, CommonForgeEvents.getInjectEntry(new ResourceLocation("finsandtails", "inject/fishing"), 10, 1));
        }
        if (name.equals((Object)BuiltInLootTables.f_78730_)) {
            CommonForgeEvents.addEntry(pool, CommonForgeEvents.getInjectEntry(new ResourceLocation("finsandtails:inject/fisherman_gift"), 15, 1));
        }
    }

    private static LootPoolEntryContainer getInjectEntry(ResourceLocation location, int weight, int quality) {
        return LootTableReference.m_79776_((ResourceLocation)location).m_79707_(weight).m_79711_(quality).m_7512_();
    }

    private static void addEntry(LootPool pool, LootPoolEntryContainer entry) {
        LootPoolEntryContainer[] newEntries = new LootPoolEntryContainer[pool.f_79023_.length + 1];
        System.arraycopy(pool.f_79023_, 0, newEntries, 0, pool.f_79023_.length);
        newEntries[pool.f_79023_.length] = entry;
        pool.f_79023_ = newEntries;
    }
}

