/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import teamdraco.finsandstails.FTConfig;
import teamdraco.finsandstails.client.ClientUtils;
import teamdraco.finsandstails.common.entities.BandedRedbackShrimpEntity;
import teamdraco.finsandstails.common.entities.BluWeeEntity;
import teamdraco.finsandstails.common.entities.CrownedHorateeEntity;
import teamdraco.finsandstails.common.entities.FlatbackLeafSnailEntity;
import teamdraco.finsandstails.common.entities.FlatbackSuckerEntity;
import teamdraco.finsandstails.common.entities.GoldenRiverRayEntity;
import teamdraco.finsandstails.common.entities.GopjetEntity;
import teamdraco.finsandstails.common.entities.HighFinnedBlueEntity;
import teamdraco.finsandstails.common.entities.MudhorseEntity;
import teamdraco.finsandstails.common.entities.NightLightSquidEntity;
import teamdraco.finsandstails.common.entities.OrnateBugfishEntity;
import teamdraco.finsandstails.common.entities.PapaWeeEntity;
import teamdraco.finsandstails.common.entities.PeaWeeEntity;
import teamdraco.finsandstails.common.entities.PenglilEntity;
import teamdraco.finsandstails.common.entities.PhantomNudibranchEntity;
import teamdraco.finsandstails.common.entities.RedBullCrabEntity;
import teamdraco.finsandstails.common.entities.RiverPebbleSnailEntity;
import teamdraco.finsandstails.common.entities.RubberBellyGliderEntity;
import teamdraco.finsandstails.common.entities.SiderolWhiskeredSnailEntity;
import teamdraco.finsandstails.common.entities.SpindlyGemCrabEntity;
import teamdraco.finsandstails.common.entities.SwampMuckerEntity;
import teamdraco.finsandstails.common.entities.TealArrowfishEntity;
import teamdraco.finsandstails.common.entities.WanderingSailorEntity;
import teamdraco.finsandstails.common.entities.WeeWeeEntity;
import teamdraco.finsandstails.common.entities.WherbleEntity;
import teamdraco.finsandstails.common.entities.WhiteBullCrabEntity;
import teamdraco.finsandstails.common.entities.item.TealArrowfishArrowEntity;
import teamdraco.finsandstails.data.PlayerHitComboData;
import teamdraco.finsandstails.data.PlayerHitComboProvider;
import teamdraco.finsandstails.network.FTMessages;
import teamdraco.finsandstails.network.INetworkPacket;
import teamdraco.finsandstails.network.TriggerFlyingPacket;
import teamdraco.finsandstails.registry.FTBannerPatterns;
import teamdraco.finsandstails.registry.FTBlocks;
import teamdraco.finsandstails.registry.FTContainers;
import teamdraco.finsandstails.registry.FTCreativeModeTabs;
import teamdraco.finsandstails.registry.FTEnchantments;
import teamdraco.finsandstails.registry.FTEntities;
import teamdraco.finsandstails.registry.FTItems;
import teamdraco.finsandstails.registry.FTRecipes;
import teamdraco.finsandstails.registry.FTSounds;

@Mod(value="finsandtails")
public class FinsAndTails {
    public static final String MOD_ID = "finsandtails";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final SimpleChannel NETWORK = INetworkPacket.makeChannel("network", "1");
    private static int currentNetworkId;

    public FinsAndTails() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        bus.addListener(this::registerCommon);
        bus.addListener(this::registerEntityAttributes);
        bus.addListener(this::registerSpawnPlacements);
        bus.addListener(this::registerCapabilities);
        forgeBus.addGenericListener(Entity.class, this::attachCapabilities);
        FTBannerPatterns.BANNER_PATTERNS.register(bus);
        FTRecipes.RECIPE_TYPE.register(bus);
        FTRecipes.SERIALIZERS.register(bus);
        FTEnchantments.REGISTER.register(bus);
        FTItems.ITEMS.register(bus);
        FTBlocks.BLOCKS.register(bus);
        FTContainers.REGISTER.register(bus);
        FTEntities.REGISTER.register(bus);
        FTSounds.REGISTER.register(bus);
        FTCreativeModeTabs.CREATIVE_MODE_TABS.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)FTConfig.Common.SPEC);
        this.registerMessage(TriggerFlyingPacket.class, TriggerFlyingPacket::new, LogicalSide.SERVER);
        FTMessages.register();
    }

    private void attachCapabilities(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof Player && !((Entity)e.getObject()).getCapability(PlayerHitComboProvider.HIT_COMBO).isPresent()) {
            e.addCapability(new ResourceLocation(MOD_ID, "hit_combo"), (ICapabilityProvider)new PlayerHitComboProvider());
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent e) {
        e.register(PlayerHitComboData.class);
    }

    private void registerSpawnPlacements(SpawnPlacementRegisterEvent e) {
        e.register((EntityType)FTEntities.BLU_WEE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.PEA_WEE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.BANDED_REDBACK_SHRIMP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.SWAMP_MUCKER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.TEAL_ARROWFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.FLATBACK_SUCKER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.HIGH_FINNED_BLUE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.MUDHORSE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.PHANTOM_NUDIBRANCH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.ORNATE_BUGFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.PENGLIL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PenglilEntity::canPenglilSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.SPINDLY_GEM_CRAB.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.FLATBACK_LEAF_SNAIL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.RED_BULL_CRAB.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RedBullCrabEntity::canCrabSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.WHITE_BULL_CRAB.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RedBullCrabEntity::canCrabSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.WEE_WEE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.VIBRA_WEE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.RIVER_PEBBLE_SNAIL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.SIDEROL_WHISKERED_SNAIL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.GOLDEN_RIVER_RAY.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.NIGHT_LIGHT_SQUID.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, NightLightSquidEntity::checkSquidSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.GOPJET.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.PAPA_WEE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.WHERBLE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WherbleEntity::checkWherbleSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        e.register((EntityType)FTEntities.CROWNED_HORATTE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrownedHorateeEntity::checkCrownedSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
    }

    private void registerCommon(FMLCommonSetupEvent event) {
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43602_)}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FTItems.NIGHT_LIGHT_SQUID.get()}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43603_));
        DispenserBlock.m_52672_((ItemLike)((ItemLike)FTItems.TEAL_ARROWFISH.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level level, Position pos, ItemStack stack) {
                TealArrowfishArrowEntity arrow = new TealArrowfishArrowEntity(level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
                arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                return arrow;
            }
        });
    }

    private void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)FTEntities.BANDED_REDBACK_SHRIMP.get(), BandedRedbackShrimpEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.BLU_WEE.get(), BluWeeEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.FLATBACK_SUCKER.get(), FlatbackSuckerEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.HIGH_FINNED_BLUE.get(), HighFinnedBlueEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.MUDHORSE.get(), MudhorseEntity.createAttributes().m_22265_());
        event.put((EntityType)FTEntities.ORNATE_BUGFISH.get(), OrnateBugfishEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.PEA_WEE.get(), PeaWeeEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.PENGLIL.get(), PenglilEntity.createAttributes().m_22265_());
        event.put((EntityType)FTEntities.PHANTOM_NUDIBRANCH.get(), PhantomNudibranchEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.SPINDLY_GEM_CRAB.get(), SpindlyGemCrabEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.SWAMP_MUCKER.get(), SwampMuckerEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.TEAL_ARROWFISH.get(), TealArrowfishEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.FLATBACK_LEAF_SNAIL.get(), FlatbackLeafSnailEntity.createAttributes().m_22265_());
        event.put((EntityType)FTEntities.RUBBER_BELLY_GLIDER.get(), RubberBellyGliderEntity.registerRBGAttributes().m_22265_());
        event.put((EntityType)FTEntities.RED_BULL_CRAB.get(), RedBullCrabEntity.createAttributes().m_22265_());
        event.put((EntityType)FTEntities.WHITE_BULL_CRAB.get(), WhiteBullCrabEntity.createAttributes().m_22265_());
        event.put((EntityType)FTEntities.WEE_WEE.get(), WeeWeeEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.VIBRA_WEE.get(), AbstractFish.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.GOPJET.get(), GopjetEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.RIVER_PEBBLE_SNAIL.get(), RiverPebbleSnailEntity.createAttributes().m_22265_());
        event.put((EntityType)FTEntities.SIDEROL_WHISKERED_SNAIL.get(), SiderolWhiskeredSnailEntity.createAttributes().m_22265_());
        event.put((EntityType)FTEntities.GOLDEN_RIVER_RAY.get(), GoldenRiverRayEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.NIGHT_LIGHT_SQUID.get(), NightLightSquidEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.PAPA_WEE.get(), PapaWeeEntity.m_27495_().m_22265_());
        event.put((EntityType)FTEntities.WHERBLE.get(), WherbleEntity.createAttributes().m_22265_());
        event.put((EntityType)FTEntities.WANDERING_SAILOR.get(), WanderingSailorEntity.createAttributes().m_22265_());
        event.put((EntityType)FTEntities.CROWNED_HORATTE.get(), CrownedHorateeEntity.createAttributes().m_22265_());
    }

    private <T extends INetworkPacket> void registerMessage(Class<T> message, Function<FriendlyByteBuf, T> reader, LogicalSide side) {
        NETWORK.registerMessage(currentNetworkId++, message, INetworkPacket::write, reader, (msg, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.enqueueWork(() -> msg.handle((Player)(context.getDirection().getOriginationSide().isServer() ? ClientUtils.getClientPlayer() : context.getSender())));
            context.setPacketHandled(true);
        }, Optional.of(side.isClient() ? NetworkDirection.PLAY_TO_CLIENT : NetworkDirection.PLAY_TO_SERVER));
    }
}

