/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.block.blockentity.ConversionCrucibleBlockEntity;
import com.github.alexmodguy.alexscaves.server.block.poi.ACPOIRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class LicowitchUseCrucibleGoal
extends Goal {
    private BlockPos cruciblePos = null;
    private final LicowitchEntity mob;
    private int executionCooldown = 10;
    private int cookTime = 0;
    private ItemEntity tossedItem;
    private int tossItemCooldown = 0;
    private int checkReachCooldown = 0;

    public LicowitchUseCrucibleGoal(LicowitchEntity mob) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.mob = mob;
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (!(target != null && target.m_6084_() || this.mob.getAnimation() != IAnimatedEntity.NO_ANIMATION)) {
            if (this.executionCooldown-- > 0) {
                return false;
            }
            this.executionCooldown = 350 + this.mob.m_217043_().m_188503_(200);
            BlockPos pos = null;
            if (this.mob.getLastCruciblePos() != null) {
                if (LicowitchUseCrucibleGoal.canWitchUseCrucibleAt(this.mob.m_9236_(), this.mob.getLastCruciblePos(), true)) {
                    this.executionCooldown = 10;
                    pos = this.mob.getLastCruciblePos();
                } else {
                    this.mob.setLastCruciblePos(null);
                }
            }
            if (pos == null) {
                List<BlockPos> list = LicowitchUseCrucibleGoal.getNearbyCrucibles(this.mob.m_20183_(), (ServerLevel)this.mob.m_9236_(), 32).sorted(Comparator.comparingDouble(arg_0 -> ((BlockPos)this.mob.m_20183_()).m_123331_(arg_0))).toList();
                if (!list.isEmpty()) {
                    pos = list.get(0);
                }
            }
            if (pos != null && this.mob.m_217043_().m_188503_(4) == 0) {
                this.cruciblePos = pos;
                this.mob.setLastCruciblePos(this.cruciblePos);
                return true;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        LivingEntity target = this.mob.m_5448_();
        return this.cruciblePos != null && LicowitchUseCrucibleGoal.canWitchUseCrucibleAt(this.mob.m_9236_(), this.cruciblePos, true) && (target == null || !target.m_6084_()) && this.cookTime < 300;
    }

    private static Stream<BlockPos> getNearbyCrucibles(BlockPos blockpos, ServerLevel world, int range) {
        PoiManager pointofinterestmanager = world.m_8904_();
        return pointofinterestmanager.m_27138_(poiTypeHolder -> poiTypeHolder.m_203565_(ACPOIRegistry.CONVERSION_CRUCIBLE.getKey()), blockpos2 -> LicowitchUseCrucibleGoal.canWitchUseCrucibleAt((Level)world, blockpos2, true), blockpos, range, PoiManager.Occupancy.ANY);
    }

    private static boolean canWitchUseCrucibleAt(Level world, BlockPos pos, boolean inUse) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof ConversionCrucibleBlockEntity) {
            ConversionCrucibleBlockEntity crucible = (ConversionCrucibleBlockEntity)blockEntity;
            if (crucible.isWitchMode() && inUse) {
                return true;
            }
            if (crucible.getConvertingToBiome() == null && crucible.getFilledLevel() == 0) {
                return !crucible.isWitchMode();
            }
        }
        return false;
    }

    public void m_8041_() {
        Vec3 teleportVec;
        super.m_8041_();
        this.cookTime = 0;
        this.tossItemCooldown = 0;
        this.checkReachCooldown = 0;
        this.mob.updateHeldItems = true;
        this.mob.updateFoldedArms = true;
        if (this.tossedItem != null) {
            this.tossedItem.m_146870_();
            this.tossedItem = null;
        }
        if (this.mob.m_5448_() == null && (teleportVec = LandRandomPos.m_148488_((PathfinderMob)this.mob, (int)12, (int)8)) != null) {
            teleportVec = teleportVec.m_82520_(0.0, 1.0, 0.0);
            AABB aabb = this.mob.m_20191_().m_82383_(teleportVec.m_82546_(this.mob.m_20182_()));
            if (this.mob.m_9236_().m_5450_((Entity)this.mob, Shapes.m_83064_((AABB)aabb))) {
                this.mob.setTeleportingToPos(teleportVec);
            }
        }
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.updateHeldItems = false;
        this.mob.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        this.mob.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
    }

    public void m_8037_() {
        if (this.tossItemCooldown > 0) {
            --this.tossItemCooldown;
        }
        if (this.checkReachCooldown > 0) {
            --this.checkReachCooldown;
        }
        if (this.checkReachCooldown == 0) {
            this.checkReachCooldown = 100 + this.mob.m_217043_().m_188503_(40);
            if (this.mob.canTeleport() && !this.mob.canReach(this.cruciblePos)) {
                this.mob.setTeleportingToPos(Vec3.m_82512_((Vec3i)this.cruciblePos.m_121945_((Direction)Util.m_214670_((Object[])ACMath.HORIZONTAL_DIRECTIONS, (RandomSource)this.mob.m_217043_()))));
                return;
            }
        }
        Vec3 center = Vec3.m_82512_((Vec3i)this.cruciblePos);
        double distance = Vec3.m_82539_((Vec3i)this.cruciblePos).m_82546_(this.mob.m_20182_()).m_165924_();
        if (distance < 8.0) {
            this.mob.m_21563_().m_24950_(center.f_82479_, center.f_82480_ + 1.0 - Math.sin((float)this.cookTime * 0.2f) * (double)0.2f, center.f_82481_, 10.0f, (float)this.mob.m_8132_());
        }
        if (distance > 2.5) {
            this.mob.m_21573_().m_26519_((double)((float)this.cruciblePos.m_123341_() + 0.5f), (double)this.cruciblePos.m_123342_(), (double)((float)this.cruciblePos.m_123343_() + 0.5f), 1.0);
        } else {
            if (distance < 1.25) {
                this.mob.m_21566_().m_24988_(0.1f, 0.0f);
            } else {
                this.mob.m_21566_().m_24988_(0.0f, 0.0f);
            }
            this.mob.setLastCruciblePos(this.cruciblePos);
            this.mob.m_21573_().m_26573_();
            BlockEntity blockEntity = this.mob.m_9236_().m_7702_(this.cruciblePos);
            if (blockEntity instanceof ConversionCrucibleBlockEntity) {
                ConversionCrucibleBlockEntity crucibleBlock = (ConversionCrucibleBlockEntity)blockEntity;
                if (this.hasLineOfSightCrucible()) {
                    this.mob.updateHeldItems = false;
                    boolean flag = crucibleBlock.isWitchMode();
                    crucibleBlock.setWitchModeDuration(10);
                    if (!flag && crucibleBlock.isWitchMode()) {
                        crucibleBlock.rerollWantedItem();
                        crucibleBlock.markUpdated();
                    }
                    if (this.mob.areArmsVisuallyCrossed(1.0f) && this.mob.getAnimation() == IAnimatedEntity.NO_ANIMATION && !crucibleBlock.getWantItem().m_41619_() && crucibleBlock.getItemDisplayProgress(1.0f) >= 1.0f) {
                        this.mob.m_21008_(InteractionHand.MAIN_HAND, crucibleBlock.getWantItem().m_41777_());
                    }
                    if (!crucibleBlock.getWantItem().m_41619_() && crucibleBlock.getItemDisplayProgress(1.0f) >= 1.0f && this.tossItemCooldown == 0) {
                        if (this.tossedItem != null) {
                            this.tossedItem.m_146870_();
                        }
                        if (this.mob.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                            this.mob.setAnimation(this.mob.m_5737_() == HumanoidArm.RIGHT ? LicowitchEntity.ANIMATION_SWING_RIGHT : LicowitchEntity.ANIMATION_SWING_LEFT);
                        } else if ((this.mob.getAnimation() == LicowitchEntity.ANIMATION_SWING_RIGHT || this.mob.getAnimation() == LicowitchEntity.ANIMATION_SWING_LEFT) && this.mob.getAnimationTick() == 4) {
                            this.mob.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                            Vec3 from = this.mob.getSwingArmPosition();
                            ItemStack stack = crucibleBlock.getWantItem().m_41777_();
                            this.tossedItem = new ItemEntity(this.mob.m_9236_(), from.f_82479_, from.f_82480_, from.f_82481_, stack);
                            Vec3 delta = center.m_82546_(from).m_82541_().m_82490_((double)0.13f).m_82520_(0.0, (double)0.4f, 0.0);
                            this.tossedItem.m_32062_();
                            this.tossedItem.m_20256_(delta);
                            this.tossedItem.m_6043_();
                            this.mob.m_9236_().m_7967_((Entity)this.tossedItem);
                            this.tossItemCooldown = 50;
                        }
                    }
                    ++this.cookTime;
                }
            }
        }
    }

    public boolean hasLineOfSightCrucible() {
        BlockHitResult raytraceresult = this.mob.m_9236_().m_45547_(new ClipContext(this.mob.m_20299_(1.0f), new Vec3((double)this.cruciblePos.m_123341_() + 0.5, (double)this.cruciblePos.m_123342_() + 0.5, (double)this.cruciblePos.m_123343_() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob));
        if (raytraceresult instanceof BlockHitResult) {
            BlockHitResult blockRayTraceResult = raytraceresult;
            BlockPos pos = blockRayTraceResult.m_82425_();
            return pos.equals((Object)this.cruciblePos) || this.mob.m_9236_().m_46859_(pos) || this.mob.m_9236_().m_7702_(pos) == this.mob.m_9236_().m_7702_(this.cruciblePos);
        }
        return true;
    }
}

