/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ActivatedByAltar;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AbyssmarineWallBlock
extends WallBlock
implements ActivatedByAltar {
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;

    public AbyssmarineWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_57949_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_57951_, (Comparable)WallSide.NONE)).m_61124_((Property)f_57950_, (Comparable)WallSide.NONE)).m_61124_((Property)f_57952_, (Comparable)WallSide.NONE)).m_61124_((Property)f_57953_, (Comparable)WallSide.NONE)).m_61124_((Property)f_57954_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(15)));
        this.shapeByIndex = this.makeAbyssalShapes(4.0f, 3.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.collisionShapeByIndex = this.makeAbyssalShapes(4.0f, 3.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    public void m_213897_(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource randomSource) {
        super.m_213897_(state, serverLevel, pos, randomSource);
        serverLevel.m_7731_(pos, this.updateDistance(state, (Level)serverLevel, pos), 3);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        BlockState newState = super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
        int i = ActivatedByAltar.getDistanceAt(state1) + 1;
        if (i != 1 || (Integer)newState.m_61143_((Property)DISTANCE) != i) {
            levelAccessor.m_186460_(blockPos, (Block)this, 2);
        }
        return newState;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.updateDistance(super.m_5573_(context), context.m_43725_(), context.m_8083_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISTANCE, ACTIVE, f_57949_, f_57951_, f_57950_, f_57953_, f_57952_, f_57954_});
    }

    private Map<BlockState, VoxelShape> makeAbyssalShapes(float p_57966_, float p_57967_, float p_57968_, float p_57969_, float p_57970_, float p_57971_) {
        float f = 8.0f - p_57966_;
        float f1 = 8.0f + p_57966_;
        float f2 = 8.0f - p_57967_;
        float f3 = 8.0f + p_57967_;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)p_57968_, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)p_57969_, (double)0.0, (double)f3, (double)p_57970_, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)p_57969_, (double)f2, (double)f3, (double)p_57970_, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)p_57969_, (double)f2, (double)f3, (double)p_57970_, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)p_57969_, (double)f2, (double)16.0, (double)p_57970_, (double)f3);
        VoxelShape voxelshape5 = Block.m_49796_((double)f2, (double)p_57969_, (double)0.0, (double)f3, (double)p_57971_, (double)f3);
        VoxelShape voxelshape6 = Block.m_49796_((double)f2, (double)p_57969_, (double)f2, (double)f3, (double)p_57971_, (double)16.0);
        VoxelShape voxelshape7 = Block.m_49796_((double)0.0, (double)p_57969_, (double)f2, (double)f3, (double)p_57971_, (double)f3);
        VoxelShape voxelshape8 = Block.m_49796_((double)f2, (double)p_57969_, (double)f2, (double)16.0, (double)p_57971_, (double)f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean obool : f_57949_.m_6908_()) {
            for (WallSide wallside : f_57950_.m_6908_()) {
                for (WallSide wallside1 : f_57951_.m_6908_()) {
                    for (WallSide wallside2 : f_57953_.m_6908_()) {
                        for (WallSide wallside3 : f_57952_.m_6908_()) {
                            VoxelShape voxelshape9 = Shapes.m_83040_();
                            voxelshape9 = AbyssmarineWallBlock.applyWallShape(voxelshape9, wallside, voxelshape4, voxelshape8);
                            voxelshape9 = AbyssmarineWallBlock.applyWallShape(voxelshape9, wallside2, voxelshape3, voxelshape7);
                            voxelshape9 = AbyssmarineWallBlock.applyWallShape(voxelshape9, wallside1, voxelshape1, voxelshape5);
                            voxelshape9 = AbyssmarineWallBlock.applyWallShape(voxelshape9, wallside3, voxelshape2, voxelshape6);
                            if (obool.booleanValue()) {
                                voxelshape9 = Shapes.m_83110_((VoxelShape)voxelshape9, (VoxelShape)voxelshape);
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_57949_, (Comparable)obool)).m_61124_((Property)f_57950_, (Comparable)wallside)).m_61124_((Property)f_57953_, (Comparable)wallside2)).m_61124_((Property)f_57951_, (Comparable)wallside1)).m_61124_((Property)f_57952_, (Comparable)wallside3);
                            for (int i = 1; i <= 15; ++i) {
                                builder.put((Object)((BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_57954_, (Comparable)Boolean.valueOf(false))), (Object)voxelshape9);
                                builder.put((Object)((BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_57954_, (Comparable)Boolean.valueOf(true))), (Object)voxelshape9);
                                builder.put((Object)((BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_57954_, (Comparable)Boolean.valueOf(false))), (Object)voxelshape9);
                                builder.put((Object)((BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_57954_, (Comparable)Boolean.valueOf(true))), (Object)voxelshape9);
                            }
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    private static VoxelShape applyWallShape(VoxelShape p_58034_, WallSide p_58035_, VoxelShape p_58036_, VoxelShape p_58037_) {
        if (p_58035_ == WallSide.TALL) {
            return Shapes.m_83110_((VoxelShape)p_58034_, (VoxelShape)p_58037_);
        }
        return p_58035_ == WallSide.LOW ? Shapes.m_83110_((VoxelShape)p_58034_, (VoxelShape)p_58036_) : p_58034_;
    }

    public VoxelShape m_5940_(BlockState p_58050_, BlockGetter p_58051_, BlockPos p_58052_, CollisionContext p_58053_) {
        return this.shapeByIndex.get(p_58050_);
    }

    public VoxelShape m_5939_(BlockState p_58055_, BlockGetter p_58056_, BlockPos p_58057_, CollisionContext p_58058_) {
        return this.collisionShapeByIndex.get(p_58055_);
    }
}

