/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.CaramelCubeModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.CustomBookEntityRenderer;
import com.github.alexmodguy.alexscaves.client.render.entity.layer.LicowitchPossessionLayer;
import com.github.alexmodguy.alexscaves.server.entity.living.CaramelCubeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class CaramelCubeRenderer
extends MobRenderer<CaramelCubeEntity, CaramelCubeModel>
implements CustomBookEntityRenderer {
    private static final ResourceLocation TEXTURE_SMALL = new ResourceLocation("alexscaves:textures/entity/caramel_cube/caramel_cube_small.png");
    private static final ResourceLocation TEXTURE_SMALL_OUTSIDE = new ResourceLocation("alexscaves:textures/entity/caramel_cube/caramel_cube_small_outside.png");
    private static final ResourceLocation TEXTURE_MEDIUM = new ResourceLocation("alexscaves:textures/entity/caramel_cube/caramel_cube_medium.png");
    private static final ResourceLocation TEXTURE_MEDIUM_OUTSIDE = new ResourceLocation("alexscaves:textures/entity/caramel_cube/caramel_cube_medium_outside.png");
    private static final ResourceLocation TEXTURE_LARGE = new ResourceLocation("alexscaves:textures/entity/caramel_cube/caramel_cube_large.png");
    private static final ResourceLocation TEXTURE_LARGE_OUTSIDE = new ResourceLocation("alexscaves:textures/entity/caramel_cube/caramel_cube_large_outside.png");
    private boolean sepia = false;

    public CaramelCubeRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new CaramelCubeModel(), 0.65f);
        this.m_115326_(new LayerOutside());
        this.m_115326_(new LicowitchPossessionLayer(this, this::getOutsideTextureLocation));
    }

    protected void scale(CaramelCubeEntity mob, PoseStack matrixStackIn, float partialTicks) {
        int size = mob.getSlimeSize();
        float scaleBy = size == 2 ? 4.0f : (size == 1 ? 2.0f : 1.0f);
        matrixStackIn.m_85841_(scaleBy, scaleBy, scaleBy);
    }

    public ResourceLocation getTextureLocation(CaramelCubeEntity entity) {
        switch (entity.getSlimeSize()) {
            case 1: {
                return TEXTURE_MEDIUM;
            }
            case 2: {
                return TEXTURE_LARGE;
            }
        }
        return TEXTURE_SMALL;
    }

    public ResourceLocation getOutsideTextureLocation(CaramelCubeEntity entity) {
        switch (entity.getSlimeSize()) {
            case 1: {
                return TEXTURE_MEDIUM_OUTSIDE;
            }
            case 2: {
                return TEXTURE_LARGE_OUTSIDE;
            }
        }
        return TEXTURE_SMALL_OUTSIDE;
    }

    @Nullable
    protected RenderType getRenderType(CaramelCubeEntity caramelCubeEntity, boolean normal, boolean translucent, boolean outline) {
        ResourceLocation resourcelocation = this.getTextureLocation(caramelCubeEntity);
        if (translucent) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (normal) {
            return this.sepia ? ACRenderTypes.getBookWidget(resourcelocation, true) : RenderType.m_110458_((ResourceLocation)resourcelocation);
        }
        return outline ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    @Override
    public void setSepiaFlag(boolean sepiaFlag) {
        this.sepia = sepiaFlag;
    }

    class LayerOutside
    extends RenderLayer<CaramelCubeEntity, CaramelCubeModel> {
        public LayerOutside() {
            super((RenderLayerParent)CaramelCubeRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, CaramelCubeEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entitylivingbaseIn.m_20145_()) {
                ((CaramelCubeModel)this.m_117386_()).m_7695_(matrixStackIn, bufferIn.m_6299_(CaramelCubeRenderer.this.sepia ? ACRenderTypes.getBookWidget(CaramelCubeRenderer.this.getOutsideTextureLocation(entitylivingbaseIn), true) : RenderType.m_110473_((ResourceLocation)CaramelCubeRenderer.this.getOutsideTextureLocation(entitylivingbaseIn))), packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

