/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import me.ramidzkh.mekae2.util.ChemicalBridge;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.radiation.IRadiationManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MekanismKey
extends AEKey {
    public static final byte GAS = 0;
    public static final byte INFUSION = 1;
    public static final byte PIGMENT = 2;
    public static final byte SLURRY = 3;
    private final ChemicalStack<?> stack;

    private MekanismKey(ChemicalStack<?> stack) {
        this.stack = stack;
    }

    @Nullable
    public static MekanismKey of(ChemicalStack<?> stack) {
        if (stack.isEmpty()) {
            return null;
        }
        return new MekanismKey(stack.copy());
    }

    public ChemicalStack<?> getStack() {
        return this.stack;
    }

    public ChemicalStack<?> withAmount(long amount) {
        return ChemicalBridge.withAmount(this.stack, amount);
    }

    public byte getForm() {
        if (this.stack instanceof GasStack) {
            return 0;
        }
        if (this.stack instanceof InfusionStack) {
            return 1;
        }
        if (this.stack instanceof PigmentStack) {
            return 2;
        }
        if (this.stack instanceof SlurryStack) {
            return 3;
        }
        throw new UnsupportedOperationException();
    }

    public AEKeyType getType() {
        return MekanismKeyType.TYPE;
    }

    public AEKey dropSecondary() {
        return this;
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128344_("t", this.getForm());
        return this.stack.write(tag);
    }

    public Object getPrimaryKey() {
        return this.stack.getType();
    }

    public ResourceLocation getId() {
        return this.stack.getTypeRegistryName();
    }

    public void writeToPacket(FriendlyByteBuf data) {
        data.writeByte((int)this.getForm());
        this.stack.writeToPacket(data);
    }

    protected Component computeDisplayName() {
        return this.stack.getType().getTextComponent();
    }

    public void addDrops(long amount, List<ItemStack> drops, Level level, BlockPos pos) {
        ChemicalStack<?> chemicalStack = this.stack;
        if (chemicalStack instanceof GasStack) {
            GasStack gasStack = (GasStack)chemicalStack;
            IRadiationManager.INSTANCE.dumpRadiation(new Coord4D((Vec3i)pos, level), ChemicalBridge.withAmount(gasStack, amount));
        }
    }

    public boolean isTagged(TagKey<?> tag) {
        Chemical chemical = this.stack.getType();
        if (chemical instanceof Gas) {
            Gas gas = (Gas)chemical;
            return tag.f_203867_().equals((Object)MekanismAPI.GAS_REGISTRY_NAME) && gas.is(tag);
        }
        chemical = this.stack.getType();
        if (chemical instanceof InfuseType) {
            InfuseType infuse = (InfuseType)chemical;
            return tag.f_203867_().equals((Object)MekanismAPI.INFUSE_TYPE_REGISTRY_NAME) && infuse.is(tag);
        }
        chemical = this.stack.getType();
        if (chemical instanceof Pigment) {
            Pigment pigment = (Pigment)chemical;
            return tag.f_203867_().equals((Object)MekanismAPI.PIGMENT_REGISTRY_NAME) && pigment.is(tag);
        }
        chemical = this.stack.getType();
        if (chemical instanceof Slurry) {
            Slurry slurry = (Slurry)chemical;
            return tag.f_203867_().equals((Object)MekanismAPI.SLURRY_REGISTRY_NAME) && slurry.is(tag);
        }
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MekanismKey that = (MekanismKey)((Object)o);
        return Objects.equals(this.stack.getType(), that.stack.getType());
    }

    public int hashCode() {
        return Objects.hash(this.stack.getType());
    }

    public String toString() {
        return "MekanismKey{stack=" + String.valueOf(this.stack.getType()) + "}";
    }
}

