/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.behaviors.GenericSlotCapacities;
import appeng.api.client.StorageCellModels;
import appeng.api.features.P2PTunnelAttunement;
import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AEKeyTypes;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.storage.cells.ICellGuiHandler;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.capabilities.Capabilities;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.common.MEStorageMenu;
import appeng.parts.automation.StackWorldBehaviors;
import me.ramidzkh.mekae2.AMItems;
import me.ramidzkh.mekae2.AMMenus;
import me.ramidzkh.mekae2.AppliedMekanisticsClient;
import me.ramidzkh.mekae2.MekCapabilities;
import me.ramidzkh.mekae2.ae2.ChemicalContainerItemStrategy;
import me.ramidzkh.mekae2.ae2.GenericStackChemicalStorage;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import me.ramidzkh.mekae2.ae2.stack.MekanismExternalStorageStrategy;
import me.ramidzkh.mekae2.ae2.stack.MekanismStackExportStrategy;
import me.ramidzkh.mekae2.ae2.stack.MekanismStackImportStrategy;
import me.ramidzkh.mekae2.data.MekAE2DataGenerators;
import me.ramidzkh.mekae2.qio.QioSupport;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="appmek")
public class AppliedMekanistics {
    public static final String ID = "appmek";

    public AppliedMekanistics() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        AMItems.initialize(bus);
        AMMenus.initialize(bus);
        bus.addListener(MekAE2DataGenerators::onGatherData);
        bus.addListener(event -> {
            if (!event.getRegistryKey().equals((Object)Registries.f_256747_)) {
                return;
            }
            AEKeyTypes.register((AEKeyType)MekanismKeyType.TYPE);
        });
        StackWorldBehaviors.registerImportStrategy((AEKeyType)MekanismKeyType.TYPE, MekanismStackImportStrategy::new);
        StackWorldBehaviors.registerExportStrategy((AEKeyType)MekanismKeyType.TYPE, MekanismStackExportStrategy::new);
        StackWorldBehaviors.registerExternalStorageStrategy((AEKeyType)MekanismKeyType.TYPE, MekanismExternalStorageStrategy::new);
        ContainerItemStrategy.register((AEKeyType)MekanismKeyType.TYPE, MekanismKey.class, (ContainerItemStrategy)new ChemicalContainerItemStrategy());
        GenericSlotCapacities.register((AEKeyType)MekanismKeyType.TYPE, (Long)((Long)GenericSlotCapacities.getMap().get(AEKeyType.fluids())));
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, this::initializeCapabilities);
        QioSupport.initialize();
        bus.addListener(event -> {
            event.enqueueWork(this::initializeModels);
            event.enqueueWork(this::initializeUpgrades);
            event.enqueueWork(this::initializeAttunement);
        });
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> AppliedMekanisticsClient::initialize);
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(ID, path);
    }

    private void initializeCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        final BlockEntity blockEntity = (BlockEntity)event.getObject();
        event.addCapability(AppliedMekanistics.id("generic_inv_wrapper"), new ICapabilityProvider(){

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
                if (capability == MekCapabilities.GAS_HANDLER_CAPABILITY) {
                    return blockEntity.getCapability(Capabilities.GENERIC_INTERNAL_INV, side).lazyMap(GenericStackChemicalStorage.OfGas::new).cast();
                }
                if (capability == MekCapabilities.INFUSION_HANDLER_CAPABILITY) {
                    return blockEntity.getCapability(Capabilities.GENERIC_INTERNAL_INV, side).lazyMap(GenericStackChemicalStorage.OfInfusion::new).cast();
                }
                if (capability == MekCapabilities.PIGMENT_HANDLER_CAPABILITY) {
                    return blockEntity.getCapability(Capabilities.GENERIC_INTERNAL_INV, side).lazyMap(GenericStackChemicalStorage.OfPigment::new).cast();
                }
                if (capability == MekCapabilities.SLURRY_HANDLER_CAPABILITY) {
                    return blockEntity.getCapability(Capabilities.GENERIC_INTERNAL_INV, side).lazyMap(GenericStackChemicalStorage.OfSlurry::new).cast();
                }
                return LazyOptional.empty();
            }
        });
    }

    private void initializeModels() {
        StorageCells.addCellGuiHandler((ICellGuiHandler)new ICellGuiHandler(){

            public boolean isSpecializedFor(ItemStack cell) {
                IBasicCellItem basicCellItem;
                Item item = cell.m_41720_();
                return item instanceof IBasicCellItem && (basicCellItem = (IBasicCellItem)item).getKeyType() == MekanismKeyType.TYPE;
            }

            public void openChestGui(Player player, IChestOrDrive chest, ICellHandler cellHandler, ItemStack cell) {
                MenuOpener.open((MenuType)MEStorageMenu.TYPE, (Player)player, (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)((BlockEntity)chest)));
            }
        });
        StorageCellModels.registerModel(() -> AMItems.CHEMICAL_CELL_CREATIVE.get(), (ResourceLocation)AppEng.makeId((String)"block/drive/cells/creative_cell"));
        for (AMItems.Tier tier : AMItems.Tier.values()) {
            RegistryObject<Item> cell = AMItems.get(tier);
            RegistryObject<Item> portable = AMItems.getPortableCell(tier);
            this.registerCell(() -> cell.get(), () -> portable.get(), cell.getId().m_135815_());
        }
    }

    private void registerCell(ItemLike cell, ItemLike portableCell, String path) {
        StorageCellModels.registerModel((ItemLike)cell, (ResourceLocation)AppliedMekanistics.id("block/drive/cells/" + path));
        StorageCellModels.registerModel((ItemLike)portableCell, (ResourceLocation)AppliedMekanistics.id("block/drive/cells/" + path));
    }

    private void initializeUpgrades() {
        String storageCellGroup = GuiText.StorageCells.getTranslationKey();
        String portableStorageCellGroup = GuiText.PortableCells.getTranslationKey();
        for (AMItems.Tier tier : AMItems.Tier.values()) {
            RegistryObject<Item> cell = AMItems.get(tier);
            RegistryObject<Item> portableCell = AMItems.getPortableCell(tier);
            Upgrades.add((ItemLike)AEItems.INVERTER_CARD, () -> cell.get(), (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, () -> cell.get(), (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.VOID_CARD, () -> cell.get(), (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.INVERTER_CARD, () -> portableCell.get(), (int)1, (String)portableStorageCellGroup);
            Upgrades.add((ItemLike)AEItems.ENERGY_CARD, () -> portableCell.get(), (int)2, (String)portableStorageCellGroup);
        }
    }

    private void initializeAttunement() {
        P2PTunnelAttunement.registerAttunementTag(() -> AMItems.CHEMICAL_P2P_TUNNEL.get());
    }
}

