/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.data;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public class DataTransformer {
    private static final ThreadLocal<Boolean> REENTRANT_GUARD = ThreadLocal.withInitial(() -> false);
    private static final List<Function<ResourceLocation, ResourceLocation>> TRANSFORMERS = new CopyOnWriteArrayList<Function<ResourceLocation, ResourceLocation>>();

    public static void onDataTransformation(Consumer<Transformer> consumer) {
        consumer.accept(TRANSFORMERS::add);
    }

    public static boolean shouldCheckNamespace() {
        return !TRANSFORMERS.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceLocation applyTransformsIfPossible(String namespace, String path) {
        if (TRANSFORMERS.isEmpty() || REENTRANT_GUARD.get().booleanValue()) {
            return null;
        }
        REENTRANT_GUARD.set(true);
        try {
            ResourceLocation original = new ResourceLocation(namespace, path);
            for (Function<ResourceLocation, ResourceLocation> transformer : TRANSFORMERS) {
                ResourceLocation result = transformer.apply(original);
                if (result == null) continue;
                ResourceLocation resourceLocation = result;
                return resourceLocation;
            }
            Iterator<Function<ResourceLocation, ResourceLocation>> iterator = null;
            return iterator;
        }
        finally {
            REENTRANT_GUARD.set(false);
        }
    }

    public static interface Transformer {
        public void add(Function<ResourceLocation, ResourceLocation> var1);

        default public void remap(ResourceLocation original, ResourceLocation remapped) {
            this.add(path -> {
                if (path.equals((Object)original)) {
                    return remapped;
                }
                return null;
            });
        }
    }
}

