/*
 * Decompiled with CFR 0.152.
 */
package com.ancientsand.world;

import com.ancientsand.init.ModBlocks;
import com.ancientsand.init.ModEntities;
import com.ancientsand.init.ModPieces;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class TombPieces {
    private static final ResourceLocation ENTRY_1 = new ResourceLocation("ancientsand", "entry_1");
    private static final ResourceLocation ENTRY_2 = new ResourceLocation("ancientsand", "entry_2");
    private static final ResourceLocation TUBE = new ResourceLocation("ancientsand", "tube");
    private static final ResourceLocation ROOM = new ResourceLocation("ancientsand", "room");
    private static final ResourceLocation HALL_1 = new ResourceLocation("ancientsand", "hall_1");
    private static final ResourceLocation HALL_2 = new ResourceLocation("ancientsand", "hall_2");
    private static final ResourceLocation DOOR = new ResourceLocation("ancientsand", "door");
    private static final ResourceLocation STORAGE = new ResourceLocation("ancientsand", "storage");
    private static final ResourceLocation THRONE = new ResourceLocation("ancientsand", "throne");

    public static void addPieces(StructureTemplateManager manager, BlockPos pos, StructurePieceAccessor pieceList, RandomSource random) {
        Rotation rotation = Rotation.NONE;
        if (random.m_188503_(10) < 6) {
            pieceList.m_142679_((StructurePiece)new Piece(manager, ENTRY_1, pos, rotation));
        } else {
            pieceList.m_142679_((StructurePiece)new Piece(manager, ENTRY_2, pos.m_7918_(0, 0, -2), rotation));
        }
        pieceList.m_142679_((StructurePiece)new Piece(manager, TUBE, pos.m_7918_(4, -5, 2), rotation));
        pieceList.m_142679_((StructurePiece)new Piece(manager, TUBE, pos.m_7918_(4, -10, 2), rotation));
        BlockPos entry = pos.m_7918_(2, -16, 0);
        pieceList.m_142679_((StructurePiece)new Piece(manager, ROOM, entry, rotation));
        pieceList.m_142679_((StructurePiece)new Piece(manager, random.m_188503_(10) < 6 ? HALL_1 : HALL_2, entry.m_7918_(-8, 0, 0), rotation));
        pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_1, entry.m_7918_(8, 0, -8), rotation.m_55952_(Rotation.CLOCKWISE_90)));
        if (random.m_188503_(10) < 5) {
            if (random.m_188503_(10) < 5) {
                pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_2, entry.m_7918_(-16, 0, 0), rotation));
            } else {
                pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_1, entry.m_7918_(-16, 0, 0), rotation));
                pieceList.m_142679_((StructurePiece)new Piece(manager, TUBE, entry.m_7918_(-14, -4, 2), rotation));
                BlockPos layer = entry.m_7918_(-16, -10, 0);
                pieceList.m_142679_((StructurePiece)new Piece(manager, ROOM, layer, rotation));
                pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_1, layer.m_7918_(-8, 0, 0), rotation));
                pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_1, layer.m_7918_(8, 0, -8), rotation.m_55952_(Rotation.CLOCKWISE_90)));
                if (random.m_188503_(10) < 5) {
                    pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_2, layer.m_7918_(-16, 0, 0), rotation));
                } else {
                    pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_2, layer.m_7918_(8, 0, -16), rotation.m_55952_(Rotation.CLOCKWISE_90)));
                }
            }
        } else if (random.m_188503_(10) < 5) {
            pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_2, entry.m_7918_(8, 0, -16), rotation.m_55952_(Rotation.CLOCKWISE_90)));
        } else {
            pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_1, entry.m_7918_(8, 0, -16), rotation.m_55952_(Rotation.CLOCKWISE_90)));
            pieceList.m_142679_((StructurePiece)new Piece(manager, TUBE, entry.m_7918_(6, -4, -14), rotation.m_55952_(Rotation.CLOCKWISE_90)));
            BlockPos layer = entry.m_7918_(0, -10, -16);
            pieceList.m_142679_((StructurePiece)new Piece(manager, ROOM, layer, rotation));
            pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_1, layer.m_7918_(-8, 0, 0), rotation));
            pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_1, layer.m_7918_(8, 0, -8), rotation.m_55952_(Rotation.CLOCKWISE_90)));
            if (random.m_188503_(10) < 5) {
                pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_2, layer.m_7918_(-16, 0, 0), rotation));
            } else {
                pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_2, layer.m_7918_(8, 0, -16), rotation.m_55952_(Rotation.CLOCKWISE_90)));
            }
        }
        if (random.m_188503_(10) < 5) {
            pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_1, entry.m_7918_(9, 0, 0), rotation));
            pieceList.m_142679_((StructurePiece)new Piece(manager, DOOR, entry.m_7918_(17, 0, 0), rotation));
            if (random.m_188503_(10) < 5) {
                pieceList.m_142679_((StructurePiece)new Piece(manager, STORAGE, entry.m_7918_(21, 0, 0), rotation));
            } else {
                pieceList.m_142679_((StructurePiece)new Piece(manager, THRONE, entry.m_7918_(21, 0, -2), rotation));
            }
        } else {
            pieceList.m_142679_((StructurePiece)new Piece(manager, HALL_1, entry.m_7918_(8, 0, 9), rotation.m_55952_(Rotation.CLOCKWISE_90)));
            pieceList.m_142679_((StructurePiece)new Piece(manager, DOOR, entry.m_7918_(8, 0, 17), rotation.m_55952_(Rotation.CLOCKWISE_90)));
            if (random.m_188503_(10) < 5) {
                pieceList.m_142679_((StructurePiece)new Piece(manager, STORAGE, entry.m_7918_(8, 0, 21), rotation.m_55952_(Rotation.CLOCKWISE_90)));
            } else {
                pieceList.m_142679_((StructurePiece)new Piece(manager, THRONE, entry.m_7918_(10, 0, 21), rotation.m_55952_(Rotation.CLOCKWISE_90)));
            }
        }
    }

    public static class Piece
    extends TemplateStructurePiece {
        public Piece(StructureTemplateManager p_228540_, ResourceLocation p_228541_, BlockPos p_228542_, Rotation p_228543_) {
            super((StructurePieceType)ModPieces.TOMB_PIECE.get(), 0, p_228540_, p_228541_, p_228541_.toString(), Piece.makeSettings(p_228543_), p_228542_);
        }

        public Piece(StructurePieceSerializationContext p_228545_, CompoundTag p_228546_) {
            super((StructurePieceType)ModPieces.TOMB_PIECE.get(), p_228546_, p_228545_.f_226956_(), p_228568_ -> Piece.makeSettings(Rotation.valueOf((String)p_228546_.m_128461_("Rot"))));
        }

        public void m_213694_(WorldGenLevel worldIn, StructureManager p_229138_, ChunkGenerator p_229139_, RandomSource random, BoundingBox p_229141_, ChunkPos p_229142_, BlockPos pos) {
            super.m_213694_(worldIn, p_229138_, p_229139_, random, p_229141_, p_229142_, pos);
            for (int d = 0; d < 3; ++d) {
                BlockPos blockpos = pos.m_7918_(random.m_216339_(-9, 7), random.m_216339_(-16, -10), random.m_216339_(-9, 7));
                if (worldIn.m_8055_(blockpos).m_60734_() != ModBlocks.REMNANT_BLOCK.get()) continue;
                if (!worldIn.m_46859_(blockpos.m_7495_()) && worldIn.m_46859_(blockpos.m_7494_())) {
                    worldIn.m_7731_(blockpos, Blocks.f_49992_.m_49966_(), 2);
                    if (random.m_188503_(4) != 1) continue;
                    worldIn.m_7731_(blockpos.m_7494_(), Blocks.f_50036_.m_49966_(), 2);
                    continue;
                }
                worldIn.m_7731_(blockpos, Blocks.f_50062_.m_49966_(), 2);
            }
        }

        private static StructurePlaceSettings makeSettings(Rotation p_228556_) {
            return new StructurePlaceSettings().m_74379_(p_228556_).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        }

        protected void m_183620_(StructurePieceSerializationContext p_228558_, CompoundTag p_228559_) {
            super.m_183620_(p_228558_, p_228559_);
            p_228559_.m_128359_("Rot", this.f_73657_.m_74404_().name());
        }

        protected void m_213704_(String function, BlockPos pos, ServerLevelAccessor worldIn, RandomSource random, BoundingBox sbb) {
            if (function.startsWith("Chamber")) {
                if (random.m_188503_(6) == 1) {
                    worldIn.m_7731_(pos, ((Block)ModBlocks.ROYAL_CHAMBER.get()).m_49966_(), 2);
                } else {
                    worldIn.m_7731_(pos, ((Block)ModBlocks.COMMON_CHAMBER.get()).m_49966_(), 2);
                }
            }
            if (function.startsWith("Spawner")) {
                worldIn.m_7731_(pos, Blocks.f_50085_.m_49966_(), 2);
                BlockEntity blockentity = worldIn.m_7702_(pos);
                if (blockentity instanceof SpawnerBlockEntity) {
                    SpawnerBlockEntity spawnerblockentity = (SpawnerBlockEntity)blockentity;
                    if (random.m_188503_(6) == 1) {
                        spawnerblockentity.m_252803_((EntityType)ModEntities.MOURNER.get(), random);
                    } else {
                        spawnerblockentity.m_252803_((EntityType)ModEntities.PARCHED.get(), random);
                    }
                }
            }
        }
    }
}

