/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.mixin.world.SinglePoolElementAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.world.StructureTemplateAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralUtils {
    private static int ACTIVE_ENTITIES = 0;
    private static final Set<Bee> BEE_SET = new HashSet<Bee>();
    public static final List<BlockState> VANILLA_CANDLES = ImmutableList.of((Object)Blocks.f_152482_.m_49966_(), (Object)Blocks.f_152518_.m_49966_(), (Object)Blocks.f_152524_.m_49966_(), (Object)Blocks.f_152520_.m_49966_(), (Object)Blocks.f_152521_.m_49966_(), (Object)Blocks.f_152516_.m_49966_(), (Object)Blocks.f_152522_.m_49966_(), (Object)Blocks.f_152512_.m_49966_(), (Object)Blocks.f_152517_.m_49966_(), (Object)Blocks.f_152514_.m_49966_(), (Object)Blocks.f_152511_.m_49966_(), (Object)Blocks.f_152484_.m_49966_(), (Object[])new BlockState[]{Blocks.f_152515_.m_49966_(), Blocks.f_152519_.m_49966_(), Blocks.f_152523_.m_49966_(), Blocks.f_152483_.m_49966_(), Blocks.f_152513_.m_49966_()});

    public static void updateEntityCount(ServerLevel world) {
        BEE_SET.clear();
        int counter = 0;
        for (Entity entity : world.m_8583_()) {
            if (entity.m_6084_() && entity instanceof LivingEntity) {
                ++counter;
            }
            if (!(entity instanceof Bee)) continue;
            BEE_SET.add((Bee)entity);
        }
        ACTIVE_ENTITIES = counter;
        BEE_SET.removeIf(bee -> bee.m_21532_() || bee.m_27854_() || bee.m_8077_() || bee.m_21523_() || bee.m_20160_() || bee.m_21525_());
    }

    public static int getNearbyActiveEntitiesInDimension(ServerLevel level, BlockPos position) {
        if (level.m_46472_().equals(BzDimension.BZ_WORLD_KEY)) {
            return ACTIVE_ENTITIES;
        }
        return level.m_45976_(Bee.class, new AABB(position.m_7918_(-16, -16, -16), position.m_7918_(16, 16, 16))).size();
    }

    public static void adjustEntityCountInBz(int adjust) {
        ACTIVE_ENTITIES += adjust;
    }

    public static Set<Bee> getAllWildBees() {
        return BEE_SET;
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, RandomSource random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.m_188501_() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static BlockPos getRandomBlockposWithinRange(LivingEntity entity, int maxRadius, int minRadius) {
        BlockPos newBeePos = BlockPos.m_274561_((double)(entity.m_20185_() + (double)((entity.m_217043_().m_188503_(maxRadius) + minRadius) * (entity.m_217043_().m_188499_() ? 1 : -1))), (double)Doubles.constrainToRange((double)(entity.m_20186_() + (double)((entity.m_217043_().m_188503_(maxRadius) + minRadius) * (entity.m_217043_().m_188499_() ? 1 : -1))), (double)1.0, (double)254.0), (double)(entity.m_20189_() + (double)((entity.m_217043_().m_188503_(maxRadius) + minRadius) * (entity.m_217043_().m_188499_() ? 1 : -1))));
        return newBeePos;
    }

    public static void givePlayerItem(Player playerEntity, InteractionHand hand, ItemStack itemstackToGive, boolean giveContainerItem, boolean shrinkCurrentItem) {
        if (playerEntity.m_9236_().m_5776_()) {
            return;
        }
        ItemStack playerItem = playerEntity.m_21120_(hand);
        ItemStack copiedPlayerItem = playerItem.m_41777_();
        boolean instabuild = playerEntity.m_150110_().f_35937_;
        if (!playerItem.m_41619_()) {
            playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)playerItem.m_41720_()));
        }
        if (!instabuild && shrinkCurrentItem) {
            playerItem.m_41774_(1);
        }
        if (!itemstackToGive.m_41619_()) {
            if (playerItem.m_41619_()) {
                playerEntity.m_21008_(hand, itemstackToGive);
            } else if (instabuild) {
                if (!playerEntity.m_150109_().m_36063_(itemstackToGive)) {
                    playerEntity.m_150109_().m_36054_(itemstackToGive);
                }
            } else if (!playerEntity.m_150109_().m_36054_(itemstackToGive)) {
                playerEntity.m_36176_(itemstackToGive, false);
            }
        }
        if (giveContainerItem && PlatformHooks.hasCraftingRemainder(copiedPlayerItem)) {
            ItemStack containerItem = PlatformHooks.getCraftingRemainder(copiedPlayerItem);
            if (playerItem.m_41619_()) {
                playerEntity.m_21008_(hand, containerItem);
            } else if (instabuild) {
                if (!playerEntity.m_150109_().m_36063_(containerItem)) {
                    playerEntity.m_150109_().m_36054_(containerItem);
                }
            } else if (!playerEntity.m_150109_().m_36054_(containerItem)) {
                playerEntity.m_36176_(containerItem, false);
            }
        }
    }

    public static boolean canJigsawsAttach(StructureTemplate.StructureBlockInfo jigsaw1, StructureTemplate.StructureBlockInfo jigsaw2, String parentJoint, String parentTarget) {
        FrontAndTop prop1 = (FrontAndTop)jigsaw1.f_74676_().m_61143_((Property)JigsawBlock.f_54222_);
        FrontAndTop prop2 = (FrontAndTop)jigsaw2.f_74676_().m_61143_((Property)JigsawBlock.f_54222_);
        return prop1.m_122625_() == prop2.m_122625_().m_122424_() && (prop1.m_122629_() == prop2.m_122629_() || GeneralUtils.isRollableJoint(parentJoint, prop1)) && parentTarget.equals(GeneralUtils.getStringMicroOptimised(jigsaw2.f_74677_(), "name"));
    }

    private static boolean isRollableJoint(String joint, FrontAndTop prop1) {
        if (!joint.equals("rollable") && !joint.equals("aligned")) {
            return !prop1.m_122625_().m_122434_().m_122479_();
        }
        return joint.equals("rollable");
    }

    public static String getStringMicroOptimised(CompoundTag tag, String key) {
        String string;
        Tag tag2 = tag.m_128423_(key);
        if (tag2 instanceof StringTag) {
            StringTag stringTag = (StringTag)tag2;
            string = stringTag.m_7916_();
        } else {
            string = "";
        }
        return string;
    }

    public static int getFirstLandYFromPos(LevelReader worldView, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)pos);
        ChunkAccess currentChunk = worldView.m_46865_((BlockPos)mutable);
        BlockState currentState = currentChunk.m_8055_((BlockPos)mutable);
        while (mutable.m_123342_() >= worldView.m_141937_() && GeneralUtils.isReplaceableByStructures(currentState)) {
            mutable.m_122173_(Direction.DOWN);
            currentState = currentChunk.m_8055_((BlockPos)mutable);
        }
        return mutable.m_123342_();
    }

    private static boolean isReplaceableByStructures(BlockState blockState) {
        return blockState.m_60795_() || !blockState.m_60819_().m_76178_() || blockState.m_247087_() || blockState.m_60713_(BzBlocks.HONEY_CRYSTAL.get());
    }

    public static BlockPos getLowestLand(ChunkGenerator chunkGenerator, RandomState randomState, BlockPos centerPos, LevelHeightAccessor heightLimitView, boolean canBeOnLiquid, boolean canBeInLiquid) {
        BlockState currentBlockstate;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122178_(centerPos.m_123341_(), 1, centerPos.m_123343_());
        NoiseColumn blockView = chunkGenerator.m_214184_(mutable.m_123341_(), mutable.m_123343_(), heightLimitView, randomState);
        BlockState pastBlockstate = currentBlockstate = blockView.m_183556_(mutable.m_123342_());
        while (mutable.m_123342_() <= GeneralUtils.getMaxTerrainLimit(chunkGenerator)) {
            if (canBeInLiquid && !currentBlockstate.m_60819_().m_76178_()) {
                mutable.m_122173_(Direction.UP);
                return mutable;
            }
            if ((canBeOnLiquid || !pastBlockstate.m_60819_().m_76178_()) && currentBlockstate.m_60795_()) {
                mutable.m_122173_(Direction.UP);
                return mutable;
            }
            mutable.m_122173_(Direction.UP);
            pastBlockstate = currentBlockstate;
            currentBlockstate = blockView.m_183556_(mutable.m_123342_());
        }
        return mutable;
    }

    public static int getMaxTerrainLimit(ChunkGenerator chunkGenerator) {
        return chunkGenerator.m_142062_() + chunkGenerator.m_6331_();
    }

    public static void spawnItemEntity(ServerLevel serverLevel, BlockPos blockPos, ItemStack itemToSpawn, double randomXZSpeed, double ySpeed) {
        if (!itemToSpawn.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity((Level)serverLevel, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_() + 0.5, itemToSpawn);
            itemEntity.m_20256_(new Vec3(serverLevel.f_46441_.m_188583_() * randomXZSpeed, ySpeed, serverLevel.f_46441_.m_188583_() * randomXZSpeed));
            itemEntity.m_32060_();
            serverLevel.m_7967_((Entity)itemEntity);
        }
    }

    public static void centerAllPieces(BlockPos targetPos, List<? extends StructurePiece> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        BlockPos structureCenter = pieces.get(0).m_73547_().m_162394_();
        int xOffset = targetPos.m_123341_() - structureCenter.m_123341_();
        int zOffset = targetPos.m_123343_() - structureCenter.m_123343_();
        for (StructurePiece structurePiece : pieces) {
            structurePiece.m_6324_(xOffset, 0, zOffset);
        }
    }

    public static <T> List<T> convertHoldersetToList(Optional<HolderSet.Named<T>> blockTagResult) {
        return blockTagResult.map(holders -> holders.m_203614_().map(Holder::m_203334_).collect(Collectors.toCollection(ArrayList::new))).orElseGet(ArrayList::new);
    }

    public static <B, T extends B> boolean isInTag(Registry<B> registry, TagKey<B> key, T value) {
        return ((Holder.Reference)registry.m_203300_(registry.m_7447_(value)).orElseThrow()).m_203656_(key);
    }

    public static <T> boolean listMatches(List<T> list, List<? extends Predicate<T>> predicates) {
        if (list.size() != predicates.size()) {
            return false;
        }
        ArrayList<Predicate<T>> copiedPredicates = new ArrayList<Predicate<T>>(predicates);
        for (int i = copiedPredicates.size() - 1; i >= 0; --i) {
            block4: {
                for (int k = list.size() - 1; k >= 0; --k) {
                    if (!((Predicate)copiedPredicates.get(i)).test(list.get(k))) {
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            copiedPredicates.remove(i);
        }
        return copiedPredicates.isEmpty();
    }

    public static int split(int value, boolean upper) {
        return upper ? value >> 16 : value & 0xFFFF;
    }

    public static int merge(int upper, int lower) {
        return (upper << 16) + (lower & 0xFFFF);
    }

    public static boolean isBlockAllowedForSugarWaterWaterlogging(BlockState blockState) {
        return blockState.m_204336_(BzTags.WATERLOGGABLE_BLOCKS_WHEN_PLACED_IN_FLUID) && !blockState.m_204336_(BzTags.FORCED_DISALLOW_WATERLOGGING_BLOCKS_WHEN_PLACED_IN_FLUID);
    }

    public static boolean isPermissionAllowedAtSpot(Level level, Entity entity, BlockPos pos, boolean placingBlock) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).m_142265_(level, pos)) {
            return false;
        }
        return PlatformHooks.isPermissionAllowedAtSpot(level, entity, pos, placingBlock);
    }

    public static <T extends Comparable<T>> BlockState getStateWithProperty(BlockState state, BlockState stateToCopy, Property<T> property) {
        return (BlockState)state.m_61124_(property, stateToCopy.m_61143_(property));
    }

    public static void placeInWorldWithoutNeighborUpdate(ServerLevelAccessor serverLevelAccessor, StructureTemplate structureTemplate, BlockPos blockPos, BlockPos blockPos2, StructurePlaceSettings structurePlaceSettings, RandomSource randomSource, int i) {
        if (((StructureTemplateAccessor)structureTemplate).bumblezone$getBlocks().isEmpty()) {
            return;
        }
        List list = structurePlaceSettings.m_74387_(((StructureTemplateAccessor)structureTemplate).bumblezone$getBlocks(), blockPos).m_74652_();
        if (list.isEmpty() && structurePlaceSettings.m_74408_() || structureTemplate.m_163801_().m_123341_() < 1 || structureTemplate.m_163801_().m_123342_() < 1 || structureTemplate.m_163801_().m_123343_() < 1) {
            return;
        }
        BoundingBox boundingBox = structurePlaceSettings.m_74409_();
        ArrayList list2 = Lists.newArrayListWithCapacity((int)(structurePlaceSettings.m_74413_() ? list.size() : 0));
        ArrayList list3 = Lists.newArrayListWithCapacity((int)(structurePlaceSettings.m_74413_() ? list.size() : 0));
        ArrayList list4 = Lists.newArrayListWithCapacity((int)list.size());
        int j = Integer.MAX_VALUE;
        int k = Integer.MAX_VALUE;
        int l = Integer.MAX_VALUE;
        int m = Integer.MIN_VALUE;
        int n = Integer.MIN_VALUE;
        int o = Integer.MIN_VALUE;
        List list5 = StructureTemplate.m_74517_((ServerLevelAccessor)serverLevelAccessor, (BlockPos)blockPos, (BlockPos)blockPos2, (StructurePlaceSettings)structurePlaceSettings, (List)list);
        for (StructureTemplate.StructureBlockInfo structureBlockInfo : list5) {
            BlockEntity blockEntity;
            BlockPos blockPos3 = structureBlockInfo.f_74675_();
            if (boundingBox != null && !boundingBox.m_71051_((Vec3i)blockPos3)) continue;
            FluidState fluidState = structurePlaceSettings.m_74413_() ? serverLevelAccessor.m_6425_(blockPos3) : null;
            BlockState blockState = structureBlockInfo.f_74676_().m_60715_(structurePlaceSettings.m_74401_()).m_60717_(structurePlaceSettings.m_74404_());
            if (structureBlockInfo.f_74677_() != null) {
                blockEntity = serverLevelAccessor.m_7702_(blockPos3);
                Clearable.m_18908_((Object)blockEntity);
                serverLevelAccessor.m_7731_(blockPos3, Blocks.f_50375_.m_49966_(), 20);
            }
            if (!serverLevelAccessor.m_7731_(blockPos3, blockState, i)) continue;
            j = Math.min(j, blockPos3.m_123341_());
            k = Math.min(k, blockPos3.m_123342_());
            l = Math.min(l, blockPos3.m_123343_());
            m = Math.max(m, blockPos3.m_123341_());
            n = Math.max(n, blockPos3.m_123342_());
            o = Math.max(o, blockPos3.m_123343_());
            list4.add(Pair.of((Object)blockPos3, (Object)structureBlockInfo.f_74677_()));
            if (structureBlockInfo.f_74677_() != null && (blockEntity = serverLevelAccessor.m_7702_(blockPos3)) != null) {
                if (blockEntity instanceof RandomizableContainerBlockEntity) {
                    structureBlockInfo.f_74677_().m_128356_("LootTableSeed", randomSource.m_188505_());
                }
                blockEntity.m_142466_(structureBlockInfo.f_74677_());
            }
            if (fluidState == null) continue;
            if (blockState.m_60819_().m_76170_()) {
                list3.add(blockPos3);
                continue;
            }
            if (!(blockState.m_60734_() instanceof LiquidBlockContainer)) continue;
            ((LiquidBlockContainer)blockState.m_60734_()).m_7361_((LevelAccessor)serverLevelAccessor, blockPos3, blockState, fluidState);
            if (fluidState.m_76170_()) continue;
            list2.add(blockPos3);
        }
        boolean bl = true;
        Direction[] directions = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        while (bl && !list2.isEmpty()) {
            bl = false;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                BlockState blockState2;
                Block block;
                BlockPos blockPos3 = (BlockPos)iterator.next();
                FluidState fluidState2 = serverLevelAccessor.m_6425_(blockPos3);
                for (int p = 0; p < directions.length && !fluidState2.m_76170_(); ++p) {
                    BlockPos blockPos5 = blockPos3.m_121945_(directions[p]);
                    FluidState fluidState = serverLevelAccessor.m_6425_(blockPos5);
                    if (!fluidState.m_76170_() || list3.contains(blockPos5)) continue;
                    fluidState2 = fluidState;
                }
                if (!fluidState2.m_76170_() || !((block = (blockState2 = serverLevelAccessor.m_8055_(blockPos3)).m_60734_()) instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)block).m_7361_((LevelAccessor)serverLevelAccessor, blockPos3, blockState2, fluidState2);
                bl = true;
                iterator.remove();
            }
        }
        if (j <= m) {
            if (!structurePlaceSettings.m_74410_()) {
                BitSetDiscreteVoxelShape discreteVoxelShape = new BitSetDiscreteVoxelShape(m - j + 1, n - k + 1, o - l + 1);
                for (Pair pair : list4) {
                    BlockPos blockPos6 = (BlockPos)pair.getFirst();
                    discreteVoxelShape.m_142703_(blockPos6.m_123341_() - j, blockPos6.m_123342_() - k, blockPos6.m_123343_() - l);
                }
                StructureTemplate.m_74510_((LevelAccessor)serverLevelAccessor, (int)i, (DiscreteVoxelShape)discreteVoxelShape, (int)j, (int)k, (int)l);
            }
            for (Pair pair : list4) {
                BlockEntity blockEntity;
                BlockPos blockPos7 = (BlockPos)pair.getFirst();
                if (!structurePlaceSettings.m_74410_()) {
                    BlockState blockState3;
                    BlockState blockState2 = serverLevelAccessor.m_8055_(blockPos7);
                    if (blockState2 != (blockState3 = Block.m_49931_((BlockState)blockState2, (LevelAccessor)serverLevelAccessor, (BlockPos)blockPos7))) {
                        serverLevelAccessor.m_7731_(blockPos7, blockState3, i & 0xFFFFFFFE);
                    }
                    serverLevelAccessor.m_6289_(blockPos7, blockState3.m_60734_());
                }
                if (pair.getSecond() == null || (blockEntity = serverLevelAccessor.m_7702_(blockPos7)) == null) continue;
                blockEntity.m_6596_();
            }
        }
        if (!structurePlaceSettings.m_74408_()) {
            GeneralUtils.placeEntities(serverLevelAccessor, structureTemplate, blockPos, structurePlaceSettings.m_74401_(), structurePlaceSettings.m_74404_(), structurePlaceSettings.m_74407_(), boundingBox, structurePlaceSettings.m_74414_());
        }
    }

    public static void placeInWorldWithChunkSectionCachingAndWithoutNeighborUpdate(ServerLevelAccessor serverLevelAccessor, StructureTemplate structureTemplate, BlockPos blockPos, BlockPos blockPos2, StructurePlaceSettings structurePlaceSettings, RandomSource randomSource, int i) {
        if (((StructureTemplateAccessor)structureTemplate).bumblezone$getBlocks().isEmpty()) {
            return;
        }
        List list = structurePlaceSettings.m_74387_(((StructureTemplateAccessor)structureTemplate).bumblezone$getBlocks(), blockPos).m_74652_();
        if (list.isEmpty() && structurePlaceSettings.m_74408_() || structureTemplate.m_163801_().m_123341_() < 1 || structureTemplate.m_163801_().m_123342_() < 1 || structureTemplate.m_163801_().m_123343_() < 1) {
            return;
        }
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)serverLevelAccessor);
        BoundingBox boundingBox = structurePlaceSettings.m_74409_();
        ArrayList list2 = Lists.newArrayListWithCapacity((int)(structurePlaceSettings.m_74413_() ? list.size() : 0));
        ArrayList list3 = Lists.newArrayListWithCapacity((int)(structurePlaceSettings.m_74413_() ? list.size() : 0));
        ArrayList list4 = Lists.newArrayListWithCapacity((int)list.size());
        int j = Integer.MAX_VALUE;
        int k = Integer.MAX_VALUE;
        int l = Integer.MAX_VALUE;
        int m = Integer.MIN_VALUE;
        int n = Integer.MIN_VALUE;
        int o = Integer.MIN_VALUE;
        List list5 = StructureTemplate.m_74517_((ServerLevelAccessor)serverLevelAccessor, (BlockPos)blockPos, (BlockPos)blockPos2, (StructurePlaceSettings)structurePlaceSettings, (List)list);
        for (StructureTemplate.StructureBlockInfo structureBlockInfo : list5) {
            BlockEntity blockEntity;
            BlockPos blockPos3 = structureBlockInfo.f_74675_();
            if (boundingBox != null && !boundingBox.m_71051_((Vec3i)blockPos3)) continue;
            FluidState fluidState = structurePlaceSettings.m_74413_() ? bulkSectionAccess.getFluidState(blockPos3) : null;
            BlockState blockState = structureBlockInfo.f_74676_().m_60715_(structurePlaceSettings.m_74401_()).m_60717_(structurePlaceSettings.m_74404_());
            if (structureBlockInfo.f_74677_() != null) {
                blockEntity = serverLevelAccessor.m_7702_(blockPos3);
                Clearable.m_18908_((Object)blockEntity);
                GeneralUtils.SetBlockWithChangeNotified(serverLevelAccessor, bulkSectionAccess, blockPos3, Blocks.f_50375_.m_49966_());
            }
            if (!GeneralUtils.SetBlockWithChangeNotified(serverLevelAccessor, bulkSectionAccess, blockPos3, blockState)) continue;
            j = Math.min(j, blockPos3.m_123341_());
            k = Math.min(k, blockPos3.m_123342_());
            l = Math.min(l, blockPos3.m_123343_());
            m = Math.max(m, blockPos3.m_123341_());
            n = Math.max(n, blockPos3.m_123342_());
            o = Math.max(o, blockPos3.m_123343_());
            list4.add(Pair.of((Object)blockPos3, (Object)structureBlockInfo.f_74677_()));
            if (structureBlockInfo.f_74677_() != null && (blockEntity = serverLevelAccessor.m_7702_(blockPos3)) != null) {
                if (blockEntity instanceof RandomizableContainerBlockEntity) {
                    structureBlockInfo.f_74677_().m_128356_("LootTableSeed", randomSource.m_188505_());
                }
                blockEntity.m_142466_(structureBlockInfo.f_74677_());
            }
            if (fluidState == null) continue;
            if (blockState.m_60819_().m_76170_()) {
                list3.add(blockPos3);
                continue;
            }
            if (!(blockState.m_60734_() instanceof LiquidBlockContainer)) continue;
            ((LiquidBlockContainer)blockState.m_60734_()).m_7361_((LevelAccessor)serverLevelAccessor, blockPos3, blockState, fluidState);
            if (fluidState.m_76170_()) continue;
            list2.add(blockPos3);
        }
        boolean bl = true;
        Direction[] directions = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        while (bl && !list2.isEmpty()) {
            bl = false;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                BlockState blockState2;
                Block block;
                BlockPos blockPos3 = (BlockPos)iterator.next();
                FluidState fluidState2 = bulkSectionAccess.getFluidState(blockPos3);
                for (int p = 0; p < directions.length && !fluidState2.m_76170_(); ++p) {
                    BlockPos blockPos5 = blockPos3.m_121945_(directions[p]);
                    FluidState fluidState = bulkSectionAccess.getFluidState(blockPos5);
                    if (!fluidState.m_76170_() || list3.contains(blockPos5)) continue;
                    fluidState2 = fluidState;
                }
                if (!fluidState2.m_76170_() || !((block = (blockState2 = bulkSectionAccess.getBlockState(blockPos3)).m_60734_()) instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)block).m_7361_((LevelAccessor)serverLevelAccessor, blockPos3, blockState2, fluidState2);
                bl = true;
                iterator.remove();
            }
        }
        if (j <= m) {
            if (!structurePlaceSettings.m_74410_()) {
                BitSetDiscreteVoxelShape discreteVoxelShape = new BitSetDiscreteVoxelShape(m - j + 1, n - k + 1, o - l + 1);
                for (Pair pair : list4) {
                    BlockPos blockPos6 = (BlockPos)pair.getFirst();
                    discreteVoxelShape.m_142703_(blockPos6.m_123341_() - j, blockPos6.m_123342_() - k, blockPos6.m_123343_() - l);
                }
                StructureTemplate.m_74510_((LevelAccessor)serverLevelAccessor, (int)i, (DiscreteVoxelShape)discreteVoxelShape, (int)j, (int)k, (int)l);
            }
            for (Pair pair : list4) {
                BlockEntity blockEntity;
                BlockPos blockPos7 = (BlockPos)pair.getFirst();
                if (!structurePlaceSettings.m_74410_()) {
                    BlockState blockState3;
                    BlockState blockState2 = bulkSectionAccess.getBlockState(blockPos7);
                    if (blockState2 != (blockState3 = Block.m_49931_((BlockState)blockState2, (LevelAccessor)serverLevelAccessor, (BlockPos)blockPos7))) {
                        GeneralUtils.SetBlockWithChangeNotified(serverLevelAccessor, bulkSectionAccess, blockPos7, blockState3);
                    }
                    serverLevelAccessor.m_6289_(blockPos7, blockState3.m_60734_());
                }
                if (pair.getSecond() == null || (blockEntity = serverLevelAccessor.m_7702_(blockPos7)) == null) continue;
                blockEntity.m_6596_();
            }
        }
        if (!structurePlaceSettings.m_74408_()) {
            GeneralUtils.placeEntities(serverLevelAccessor, structureTemplate, blockPos, structurePlaceSettings.m_74401_(), structurePlaceSettings.m_74404_(), structurePlaceSettings.m_74407_(), boundingBox, structurePlaceSettings.m_74414_());
        }
    }

    private static boolean SetBlockWithChangeNotified(ServerLevelAccessor serverLevelAccessor, UnsafeBulkSectionAccess bulkSectionAccess, BlockPos blockPos3, BlockState newState) {
        BlockState oldState = bulkSectionAccess.setBlockStateAndGetOldState(blockPos3, newState, false);
        if (oldState != null) {
            serverLevelAccessor.m_6018_().m_6559_(blockPos3, oldState, newState);
            return true;
        }
        return false;
    }

    private static void placeEntities(ServerLevelAccessor serverLevelAccessor, StructureTemplate structureTemplate, BlockPos blockPos, Mirror mirror, Rotation rotation, BlockPos blockPos2, @Nullable BoundingBox boundingBox, boolean bl) {
        for (StructureTemplate.StructureEntityInfo structureEntityInfo : ((StructureTemplateAccessor)structureTemplate).bumblezone$getEntityInfoList()) {
            BlockPos blockPos3 = StructureTemplate.m_74593_((BlockPos)structureEntityInfo.f_74684_, (Mirror)mirror, (Rotation)rotation, (BlockPos)blockPos2).m_121955_((Vec3i)blockPos);
            if (boundingBox != null && !boundingBox.m_71051_((Vec3i)blockPos3)) continue;
            CompoundTag compoundTag = structureEntityInfo.f_74685_.m_6426_();
            Vec3 vec3 = StructureTemplate.m_74578_((Vec3)structureEntityInfo.f_74683_, (Mirror)mirror, (Rotation)rotation, (BlockPos)blockPos2);
            Vec3 vec32 = vec3.m_82520_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
            ListTag listTag = new ListTag();
            listTag.add((Object)DoubleTag.m_128500_((double)vec32.f_82479_));
            listTag.add((Object)DoubleTag.m_128500_((double)vec32.f_82480_));
            listTag.add((Object)DoubleTag.m_128500_((double)vec32.f_82481_));
            compoundTag.m_128365_("Pos", (Tag)listTag);
            compoundTag.m_128473_("UUID");
            GeneralUtils.createEntityIgnoreException(serverLevelAccessor, compoundTag).ifPresent(entity -> {
                float f = entity.m_7890_(rotation);
                entity.m_7678_(vec32.f_82479_, vec32.f_82480_, vec32.f_82481_, f + (entity.m_6961_(mirror) - entity.m_146908_()), entity.m_146909_());
                if (bl && entity instanceof Mob) {
                    ((Mob)entity).m_6518_(serverLevelAccessor, serverLevelAccessor.m_6436_(BlockPos.m_274446_((Position)vec32)), MobSpawnType.STRUCTURE, null, compoundTag);
                }
                serverLevelAccessor.m_47205_(entity);
            });
        }
    }

    private static Optional<Entity> createEntityIgnoreException(ServerLevelAccessor serverLevelAccessor, CompoundTag compoundTag) {
        try {
            return EntityType.m_20642_((CompoundTag)compoundTag, (Level)serverLevelAccessor.m_6018_());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static boolean isSimilarInColor(int color1, int color2, int threshold) {
        return Math.abs(GeneralUtils.getRed(color1) - GeneralUtils.getRed(color2)) + Math.abs(GeneralUtils.getGreen(color1) - GeneralUtils.getGreen(color2)) + Math.abs(GeneralUtils.getBlue(color1) - GeneralUtils.getBlue(color2)) < threshold;
    }

    public static boolean isSimilarInVisualColor(int color1, int color2, int hueThreshold, int valueThreshold) {
        double[] hue2;
        double[] hue1 = GeneralUtils.ColorToHsv(color1);
        double hueDiff = hue1[0] - (hue2 = GeneralUtils.ColorToHsv(color2))[0];
        if (hueDiff > 180.0) {
            hueDiff -= 360.0;
        } else if (hueDiff < -180.0) {
            hueDiff += 360.0;
        }
        double hueDistance = Math.sqrt(hueDiff * hueDiff);
        double valueDiff = Math.abs(hue1[2] - hue2[2]);
        return hueDistance < (double)hueThreshold && valueDiff < (double)valueThreshold;
    }

    public static double[] ColorToHsv(int color) {
        int r = GeneralUtils.getRed(color);
        int g = GeneralUtils.getGreen(color);
        int b = GeneralUtils.getBlue(color);
        double h = 0.0;
        double min = Math.min(Math.min(r, g), b);
        double v = Math.max(Math.max(r, g), b);
        double delta = v - min;
        double s = v == 0.0 ? 0.0 : delta / v;
        if (s == 0.0) {
            h = 0.0;
        } else {
            if ((double)r == v) {
                h = (double)(g - b) / delta;
            } else if ((double)g == v) {
                h = 2.0 + (double)(b - r) / delta;
            } else if ((double)b == v) {
                h = 4.0 + (double)(r - g) / delta;
            }
            h *= 60.0;
            if (h < 0.0) {
                h += 360.0;
            }
        }
        double[] hsv = new double[]{h, s * 360.0, v};
        return hsv;
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int colorToInt(int red, int green, int blue) {
        return (red << 16) + (green << 8) + blue;
    }

    public static double capBetween(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    public static List<BlockPos> matchingBlocksOfKindInRange(Level level, BlockPos centerPos, int radius, Predicate<BlockState> predicate) {
        ObjectArrayList validPos = new ObjectArrayList();
        ChunkPos maxChunkPos = new ChunkPos(SectionPos.m_123171_((int)(centerPos.m_123341_() + radius)), SectionPos.m_123171_((int)(centerPos.m_123343_() + radius)));
        ChunkPos minChunkPos = new ChunkPos(SectionPos.m_123171_((int)(centerPos.m_123341_() - radius)), SectionPos.m_123171_((int)(centerPos.m_123343_() - radius)));
        for (int xOffset = minChunkPos.f_45578_; xOffset <= maxChunkPos.f_45578_; ++xOffset) {
            for (int zOffset = minChunkPos.f_45579_; zOffset <= maxChunkPos.f_45579_; ++zOffset) {
                LevelChunk chunk = level.m_6325_(xOffset, zOffset);
                GeneralUtils.scanChunkForMatchInRange(predicate, (List<BlockPos>)validPos, (ChunkAccess)chunk, centerPos, radius);
            }
        }
        return validPos;
    }

    private static void scanChunkForMatchInRange(Predicate<BlockState> predicate, List<BlockPos> validPos, ChunkAccess chunk, BlockPos originalPos, int radius) {
        BlockPos.MutableBlockPos mutableSectionWorldOrigin = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutableSectionWorldBlockPos = new BlockPos.MutableBlockPos();
        int radiusSq = radius * radius;
        for (int i = chunk.m_151560_(); i < chunk.m_151561_(); ++i) {
            LevelChunkSection levelChunkSection;
            int sectionWorldY = SectionPos.m_123223_((int)i);
            if (sectionWorldY + 15 < originalPos.m_123342_() - radius || sectionWorldY > originalPos.m_123342_() + radius || !(levelChunkSection = chunk.m_183278_(chunk.m_151566_(i))).m_63002_(predicate)) continue;
            mutableSectionWorldOrigin.m_122178_(SectionPos.m_123223_((int)chunk.m_7697_().f_45578_), sectionWorldY, SectionPos.m_123223_((int)chunk.m_7697_().f_45579_));
            for (int yOffset = 0; yOffset < 16; ++yOffset) {
                for (int zOffset = 0; zOffset < 16; ++zOffset) {
                    for (int xOffset = 0; xOffset < 16; ++xOffset) {
                        BlockState blockState;
                        mutableSectionWorldBlockPos.m_122190_((Vec3i)mutableSectionWorldOrigin).m_122184_(xOffset, yOffset, zOffset);
                        int xDiff = originalPos.m_123341_() - mutableSectionWorldBlockPos.m_123341_();
                        int yDiff = originalPos.m_123342_() - mutableSectionWorldBlockPos.m_123342_();
                        int zDiff = originalPos.m_123343_() - mutableSectionWorldBlockPos.m_123343_();
                        if (xDiff * xDiff + yDiff * yDiff + zDiff * zDiff > radiusSq || !predicate.test(blockState = levelChunkSection.m_62982_(xOffset, yOffset, zOffset))) continue;
                        validPos.add(mutableSectionWorldBlockPos.m_7949_());
                    }
                }
            }
        }
    }

    public static String formatTickDurationNoMilliseconds(int tickDuration, float tickRate) {
        int j = Mth.m_14143_((float)((float)tickDuration / tickRate));
        int k = j / 60;
        return String.format(Locale.ROOT, "%02d:%02d", k %= 60, j %= 60);
    }

    public static List<ItemStack> convertBlockTagsToItemStacks(TagKey<Block> baseTag, @Nullable TagKey<Block> disallowTag) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (Holder blockHolder : BuiltInRegistries.f_256975_.m_206058_(baseTag)) {
            ItemStack itemStack;
            Item item;
            if (disallowTag != null && blockHolder.m_203656_(disallowTag) || (item = ((Block)blockHolder.m_203334_()).m_5456_()) == null || (itemStack = item.m_7968_()).m_41619_()) continue;
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }

    public static List<StructureTemplate.StructureBlockInfo> getShuffledJigsawBlocksWithoutPriority(SinglePoolElement singlePoolElement, StructureTemplateManager structureTemplateManager, BlockPos blockPos, Rotation rotation, RandomSource randomSource) {
        StructureTemplate structureTemplate = (StructureTemplate)((SinglePoolElementAccessor)singlePoolElement).bumblezone$getTemplate().map(arg_0 -> ((StructureTemplateManager)structureTemplateManager).m_230359_(arg_0), Function.identity());
        ObjectArrayList objectArrayList = structureTemplate.m_230335_(blockPos, new StructurePlaceSettings().m_74379_(rotation), Blocks.f_50678_, true);
        Util.m_214673_((ObjectArrayList)objectArrayList, (RandomSource)randomSource);
        return objectArrayList;
    }

    public static boolean isOutsideStructureAllowedBounds(StructurePlaceSettings settings, BlockPos pos) {
        return settings.m_74409_() != null && !settings.m_74409_().m_71051_((Vec3i)pos);
    }

    public static boolean isFaceFullFast(BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        BlockState blockstate = blockGetter.m_8055_(blockPos);
        VoxelShape overallShape = blockstate.m_60812_(blockGetter, blockPos);
        return GeneralUtils.isFaceFullFast(overallShape, direction);
    }

    public static boolean isFaceFullFast(VoxelShape overallShape, Direction direction) {
        if (overallShape == Shapes.m_83144_()) {
            return true;
        }
        if (overallShape == Shapes.m_83040_()) {
            return false;
        }
        return Block.m_49918_((VoxelShape)overallShape, (Direction)direction);
    }

    public static Optional<Property<Integer>> getBlockCurrentAge(BlockState blockState) {
        Property property;
        Optional<Property<Integer>> propertyOptional = blockState.m_61147_().stream().filter(p -> p.m_61708_().equalsIgnoreCase("age")).findAny();
        if (propertyOptional.isPresent() && (property = propertyOptional.get()).m_61709_() == Integer.class) {
            return propertyOptional;
        }
        return Optional.empty();
    }

    public static Optional<Integer> getAgePropertyMaxAge(Property<Integer> ageProperty) {
        return ageProperty.m_6908_().stream().max(Comparable::compareTo);
    }

    @NotNull
    public static BlockState copyNonAgeProperties(BlockState oldState, BlockState newState) {
        for (Property property : newState.m_61147_()) {
            if (property.m_61708_().equalsIgnoreCase("age")) continue;
            newState = GeneralUtils.copyProperty(oldState, newState, property);
        }
        return newState;
    }

    @NotNull
    private static <T extends Comparable<T>> BlockState copyProperty(BlockState state, BlockState newState, Property<T> propertyToCopy) {
        if (newState.m_61138_(propertyToCopy) && state.m_61138_(propertyToCopy)) {
            newState = (BlockState)newState.m_61124_(propertyToCopy, state.m_61143_(propertyToCopy));
        }
        return newState;
    }

    public static class BasicItemTrade
    implements VillagerTrades.ItemListing {
        private final Item itemToTrade;
        private final Item itemToReceive;
        private final int amountToGive;
        private final int amountToReceive;
        protected final int maxUses;
        protected final int experience;
        protected final float multiplier;

        public BasicItemTrade(Item itemToTrade, Item itemToReceive, int amountToGive, int amountToReceive) {
            this(itemToReceive, itemToTrade, amountToGive, amountToReceive, 20, 2, 0.05f);
        }

        public BasicItemTrade(Item itemToTrade, Item itemToReceive, int amountToGive, int amountToReceive, int maxUses, int experience, float multiplier) {
            this.itemToTrade = itemToTrade;
            this.itemToReceive = itemToReceive;
            this.amountToGive = amountToGive;
            this.amountToReceive = amountToReceive;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack in = new ItemStack((ItemLike)this.itemToTrade, this.amountToGive);
            ItemStack out = new ItemStack((ItemLike)this.itemToReceive, this.amountToReceive);
            return new MerchantOffer(in, out, this.maxUses, this.experience, this.multiplier);
        }
    }

    public static final class Lazy<T> {
        private volatile T value;
        private Supplier<T> supplierValue;

        public Lazy() {
        }

        public Lazy(Supplier<T> supplierValue) {
            this.supplierValue = supplierValue;
        }

        public T getOrCompute(Supplier<T> supplier) {
            T result = this.value;
            return result == null ? this.maybeCompute(supplier) : result;
        }

        private synchronized T maybeCompute(Supplier<T> supplier) {
            if (this.value == null) {
                this.value = Objects.requireNonNull(supplier.get());
            }
            return this.value;
        }

        public T getOrFillFromInternal() {
            T result = this.value;
            return result == null ? this.maybeCompute(this.supplierValue) : result;
        }
    }
}

