/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.utils.SuppliedMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BzMusicDiscs
extends RecordItem {
    private static final SuppliedMap<SoundEvent, RecordItem> MUSIC_DISCS = new SuppliedMap(new IdentityHashMap(), new HashMap());
    private final Supplier<SoundEvent> sound;
    private final IntSupplier timeSupplier;
    private final boolean hasDownload;

    public BzMusicDiscs(int comparatorOutput, Supplier<SoundEvent> sound, Item.Properties settings, IntSupplier musicTimeLength, boolean hasDownload) {
        super(comparatorOutput, SoundEvents.f_12019_, settings, 0);
        this.sound = sound;
        this.timeSupplier = musicTimeLength;
        this.hasDownload = hasDownload;
        MUSIC_DISCS.put(sound, () -> this);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)this.m_43050_().m_130940_(ChatFormatting.GRAY));
        if (this.hasDownload) {
            List<MutableComponent> componentList = GeneralUtilsClient.autoWrappedTooltip(this.m_5524_() + ".desc", this.m_5524_() + ".download");
            componentList.forEach(component -> list.add((Component)component.m_130940_(tooltipFlag.m_7050_() ? ChatFormatting.DARK_PURPLE : ChatFormatting.DARK_GRAY)));
        }
    }

    public SoundEvent m_43051_() {
        return this.sound.get();
    }

    public int m_43036_() {
        return this.timeSupplier.getAsInt() * 20;
    }

    public static RecordItem get(SoundEvent sound) {
        return MUSIC_DISCS.get(sound);
    }
}

