/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids.forge;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.vertex.PoseStack;
import com.telepathicgrunt.the_bumblezone.fluids.base.ClientFluidProperties;
import com.telepathicgrunt.the_bumblezone.fluids.forge.BzFluidType;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BzClientFluidExtension
implements IClientFluidTypeExtensions {
    private final BzFluidType type;
    private ClientFluidProperties properties;

    public BzClientFluidExtension(BzFluidType type) {
        this.type = type;
    }

    private void checkForProperties() {
        if (this.properties == null) {
            this.properties = ClientFluidProperties.get(this.type.properties().id());
            if (this.properties == null) {
                throw new IllegalStateException("Client Fluid properties for " + String.valueOf(this.type.properties().id()) + " is missing!");
            }
        }
    }

    public ResourceLocation getStillTexture() {
        this.checkForProperties();
        return this.properties.still();
    }

    public ResourceLocation getFlowingTexture() {
        this.checkForProperties();
        return this.properties.flowing();
    }

    @Nullable
    public ResourceLocation getOverlayTexture() {
        this.checkForProperties();
        return this.properties.overlay();
    }

    public void renderOverlay(Minecraft mc, PoseStack poseStack) {
        this.checkForProperties();
        this.properties.fluidOverlay(mc, poseStack);
    }

    public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        this.checkForProperties();
        return this.properties.tintColor(state, getter, pos);
    }

    public int getTintColor() {
        this.checkForProperties();
        return this.properties.tintColor(null, null, null);
    }

    @NotNull
    public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
        this.checkForProperties();
        Optional<Vector3f> result = this.properties.modifyFogColor(camera, partialTick, level, renderDistance, darkenWorldAmount, fluidFogColor);
        return result.orElse(fluidFogColor);
    }

    public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
        this.checkForProperties();
        this.properties.modifyFog(camera, mode, renderDistance, partialTick, nearDistance, farDistance, shape);
    }
}

