/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.blockentities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EssenceBlockEntity
extends BlockEntity {
    private static final String UUID_TAG = "uuid";
    private static final String EVENT_TIMER_TAG = "eventTimer";
    private static final String PROGRESS_TAG = "eventBarProgress";
    private static final String PLAYERS_IN_ARENA_TAG = "playersInArena";
    private static final String EVENT_ENTITIES_IN_ARENA_TAG = "eventEntitiesInArena";
    private static final String EXTRA_EVENT_TRACKING_PROGRESS_TAG = "extraEventTrackingProgress";
    private static final String ARENA_SIZE_TAG = "arenaSize";
    private static final String BEATEN_TAG = "beaten";
    private UUID uuid = null;
    private int eventTimer = 0;
    private List<UUID> playerInArena = new ArrayList<UUID>();
    private ServerEssenceEvent eventBar = null;
    private List<EventEntities> eventEntitiesInArena = Collections.synchronizedList(new ArrayList());
    private int extraEventTrackingProgress = 0;
    private BlockPos arenaSize = BlockPos.f_121853_;
    private boolean beaten = false;

    protected EssenceBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        Block block = blockState.m_60734_();
        if (block instanceof EssenceBlock) {
            EssenceBlock essenceBlock = (EssenceBlock)block;
            this.eventBar = essenceBlock.getServerEssenceEvent();
        }
    }

    public EssenceBlockEntity(BlockPos blockPos, BlockState blockState) {
        this(BzBlockEntities.ESSENCE_BLOCK.get(), blockPos, blockState);
        Block block = blockState.m_60734_();
        if (block instanceof EssenceBlock) {
            EssenceBlock essenceBlock = (EssenceBlock)block;
            this.eventBar = essenceBlock.getServerEssenceEvent();
        }
    }

    public int getEventTimer() {
        return this.eventTimer;
    }

    public void setEventTimer(int eventTimer) {
        this.eventTimer = eventTimer;
    }

    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    public List<UUID> getPlayerInArena() {
        return this.playerInArena;
    }

    public void setPlayerInArena(List<UUID> playerInArena) {
        this.playerInArena = playerInArena;
    }

    public ServerEssenceEvent getEventBar() {
        return this.eventBar;
    }

    public void setEventBar(ServerEssenceEvent eventBar) {
        this.eventBar = eventBar;
    }

    public List<EventEntities> getEventEntitiesInArena() {
        return this.eventEntitiesInArena;
    }

    public void setEventEntitiesInArena(List<EventEntities> eventEntitiesInArena) {
        this.eventEntitiesInArena = eventEntitiesInArena;
    }

    public int getExtraEventTrackingProgress() {
        return this.extraEventTrackingProgress;
    }

    public void setExtraEventTrackingProgress(int extraEventTrackingProgress) {
        this.extraEventTrackingProgress = extraEventTrackingProgress;
    }

    public BlockPos getArenaSize() {
        Level level;
        if (this.arenaSize.equals((Object)BlockPos.f_121853_) && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            StructureTemplateManager structureTemplateManager = serverLevel.m_215082_();
            Optional optionalStructureTemplate = structureTemplateManager.m_230407_(((EssenceBlock)this.m_58900_().m_60734_()).getArenaNbt());
            optionalStructureTemplate.ifPresent(loadingStructureTemplate -> {
                Vec3i size = loadingStructureTemplate.m_163801_();
                this.setArenaSize(new BlockPos(size));
            });
        }
        return this.arenaSize;
    }

    public void setArenaSize(BlockPos arenaSize) {
        this.arenaSize = arenaSize;
    }

    public boolean isBeaten() {
        return this.beaten;
    }

    public void setBeaten(boolean beaten) {
        this.beaten = beaten;
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (compoundTag != null) {
            this.beaten = compoundTag.m_128471_(BEATEN_TAG);
            this.eventBar.m_142711_(compoundTag.m_128457_(PROGRESS_TAG));
            this.extraEventTrackingProgress = compoundTag.m_128451_(EXTRA_EVENT_TRACKING_PROGRESS_TAG);
            this.eventTimer = compoundTag.m_128451_(EVENT_TIMER_TAG);
            this.eventBar.setEndEventTimer(this.eventTimer, 20.0f);
            this.uuid = compoundTag.m_128441_(UUID_TAG) ? compoundTag.m_128342_(UUID_TAG) : UUID.randomUUID();
            if (compoundTag.m_128441_(PLAYERS_IN_ARENA_TAG)) {
                this.playerInArena.clear();
                for (Tag tag : compoundTag.m_128437_(PLAYERS_IN_ARENA_TAG, 11)) {
                    this.playerInArena.add(NbtUtils.m_129233_((Tag)tag));
                }
            }
            if (compoundTag.m_128441_(EVENT_ENTITIES_IN_ARENA_TAG)) {
                this.eventEntitiesInArena.clear();
                for (Tag tag : compoundTag.m_128437_(EVENT_ENTITIES_IN_ARENA_TAG, 11)) {
                    this.eventEntitiesInArena.add(new EventEntities(NbtUtils.m_129233_((Tag)tag)));
                }
            }
            if (compoundTag.m_128441_(ARENA_SIZE_TAG)) {
                this.arenaSize = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_(ARENA_SIZE_TAG));
            }
        }
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        this.saveFieldsToTag(compoundTag);
        if (this.m_58904_() != null) {
            for (int i = this.getPlayerInArena().size() - 1; i >= 0; --i) {
                UUID playerUUID = this.getPlayerInArena().get(i);
                ServerPlayer serverPlayer = this.m_58904_().m_7654_().m_6846_().m_11259_(playerUUID);
                if (serverPlayer == null || !serverPlayer.m_21224_() && Math.abs(serverPlayer.m_20183_().m_123341_() - this.m_58899_().m_123341_()) <= (this.getArenaSize().m_123341_() + 1) / 2 && Math.abs(serverPlayer.m_20183_().m_123342_() - this.m_58899_().m_123342_()) <= (this.getArenaSize().m_123342_() + 1) / 2 && Math.abs(serverPlayer.m_20183_().m_123343_() - this.m_58899_().m_123343_()) <= (this.getArenaSize().m_123343_() + 1) / 2) continue;
                Block block = this.m_58900_().m_60734_();
                if (block instanceof EssenceBlock) {
                    EssenceBlock essenceBlock = (EssenceBlock)block;
                    essenceBlock.onPlayerLeave(serverPlayer.m_284548_(), serverPlayer, this);
                }
                this.getPlayerInArena().remove(playerUUID);
                this.getEventBar().m_6539_(serverPlayer);
                this.m_6596_();
            }
        }
    }

    private void saveFieldsToTag(CompoundTag compoundTag) {
        compoundTag.m_128379_(BEATEN_TAG, this.beaten);
        compoundTag.m_128365_(UUID_TAG, (Tag)NbtUtils.m_129226_((UUID)this.getUUID()));
        compoundTag.m_128405_(EVENT_TIMER_TAG, this.eventTimer);
        compoundTag.m_128405_(EXTRA_EVENT_TRACKING_PROGRESS_TAG, this.extraEventTrackingProgress);
        compoundTag.m_128350_(PROGRESS_TAG, this.eventBar.m_142717_());
        ListTag players = new ListTag();
        for (UUID target : this.playerInArena) {
            players.add((Object)NbtUtils.m_129226_((UUID)target));
        }
        compoundTag.m_128365_(PLAYERS_IN_ARENA_TAG, (Tag)players);
        ListTag eventEntities = new ListTag();
        for (EventEntities target : this.eventEntitiesInArena) {
            eventEntities.add((Object)NbtUtils.m_129226_((UUID)target.uuid()));
        }
        compoundTag.m_128365_(EVENT_ENTITIES_IN_ARENA_TAG, (Tag)eventEntities);
        compoundTag.m_128365_(ARENA_SIZE_TAG, (Tag)NbtUtils.m_129224_((BlockPos)this.arenaSize));
    }

    public ResourceLocation getSavedNbtLocation() {
        return new ResourceLocation("the_bumblezone", "essence/saved_area/" + this.m_58899_().m_123341_() + "_" + this.m_58899_().m_123342_() + "_" + this.m_58899_().m_123343_() + "_" + this.getUUID().toString().toLowerCase(Locale.ROOT));
    }

    public String getSavedNbtLocationAsString() {
        return "the_bumblezone:essence/saved_area/" + this.m_58899_().m_123341_() + "_" + this.m_58899_().m_123342_() + "_" + this.m_58899_().m_123343_() + "_" + this.getUUID().toString().toLowerCase(Locale.ROOT);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.saveFieldsToTag(tag);
        return tag;
    }

    public boolean shouldDrawSide(Direction direction) {
        return Block.m_152444_((BlockState)this.m_58900_(), (BlockGetter)this.m_58904_(), (BlockPos)this.m_58899_(), (Direction)direction, (BlockPos)this.m_58899_().m_121945_(direction));
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!essenceBlockEntity.getPlayerInArena().isEmpty()) {
                EssenceBlockEntity.performArenaTick(serverLevel, blockPos, blockState, essenceBlockEntity);
            } else if (essenceBlockEntity.getEventTimer() > 0) {
                EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, false);
            }
        }
    }

    private static void performArenaTick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        boolean endEvent = false;
        if (serverLevel.m_46467_() % 20L == 0L) {
            for (int i = essenceBlockEntity.getPlayerInArena().size() - 1; i >= 0; --i) {
                UUID playerUUID = essenceBlockEntity.getPlayerInArena().get(i);
                ServerPlayer serverPlayer = (ServerPlayer)serverLevel.m_46003_(playerUUID);
                if (serverPlayer != null && !PlatformHooks.isFakePlayer(serverPlayer)) {
                    EssenceBlock essenceBlock;
                    Block block;
                    if (serverPlayer.m_21224_() || Math.abs(serverPlayer.m_20183_().m_123341_() - blockPos.m_123341_()) > essenceBlockEntity.getArenaSize().m_123341_() / 2 || Math.abs(serverPlayer.m_20183_().m_123342_() - blockPos.m_123342_()) > essenceBlockEntity.getArenaSize().m_123342_() / 2 || Math.abs(serverPlayer.m_20183_().m_123343_() - blockPos.m_123343_()) > essenceBlockEntity.getArenaSize().m_123343_() / 2) {
                        block = essenceBlockEntity.m_58900_().m_60734_();
                        if (block instanceof EssenceBlock) {
                            essenceBlock = (EssenceBlock)block;
                            essenceBlock.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
                        }
                        essenceBlockEntity.getPlayerInArena().remove(playerUUID);
                        essenceBlockEntity.getEventBar().m_6539_(serverPlayer);
                        essenceBlockEntity.m_6596_();
                        continue;
                    }
                    block = essenceBlockEntity.m_58900_().m_60734_();
                    if (!(block instanceof EssenceBlock)) continue;
                    essenceBlock = (EssenceBlock)block;
                    if (!essenceBlockEntity.getEventBar().m_8324_().contains(serverPlayer)) {
                        essenceBlockEntity.getEventBar().m_6543_(serverPlayer);
                        essenceBlock.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
                    }
                    if (!essenceBlock.hasMiningFatigue()) continue;
                    if (serverPlayer.m_21023_(MobEffects.f_19599_) && serverPlayer.m_21124_(MobEffects.f_19599_).m_19564_() >= 0) {
                        serverPlayer.m_21195_(MobEffects.f_19599_);
                    }
                    serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19599_, essenceBlockEntity.getEventTimer(), -1, false, false));
                    continue;
                }
                essenceBlockEntity.getPlayerInArena().remove(playerUUID);
                essenceBlockEntity.getEventBar().m_6539_(serverPlayer);
                essenceBlockEntity.m_6596_();
            }
            if (essenceBlockEntity.getPlayerInArena().isEmpty()) {
                endEvent = true;
            }
        }
        if (essenceBlockEntity.getEventTimer() <= 0) {
            endEvent = true;
        }
        if (endEvent) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, false);
        } else {
            essenceBlockEntity.setEventTimer(essenceBlockEntity.getEventTimer() - 1);
            essenceBlockEntity.getEventBar().setEndEventTimer(essenceBlockEntity.getEventTimer(), 20.0f);
            Block block = blockState.m_60734_();
            if (block instanceof EssenceBlock) {
                EssenceBlock essenceBlock = (EssenceBlock)block;
                essenceBlock.performUniqueArenaTick(serverLevel, blockPos, blockState, essenceBlockEntity);
            }
            essenceBlockEntity.m_6596_();
        }
    }

    public static void EndEvent(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity, boolean won) {
        Optional optionalStructureTemplate = serverLevel.m_215082_().m_230407_(essenceBlockEntity.getSavedNbtLocation());
        optionalStructureTemplate.ifPresentOrElse(structureTemplate -> {
            Vec3i size = structureTemplate.m_163801_();
            BlockPos negativeHalfLengths = new BlockPos(-size.m_123341_() / 2, -size.m_123342_() / 2, -size.m_123343_() / 2);
            structureTemplate.m_230328_((ServerLevelAccessor)serverLevel, blockPos.m_121955_((Vec3i)negativeHalfLengths), blockPos.m_121955_((Vec3i)negativeHalfLengths), EssenceBlock.PLACEMENT_SETTINGS.getOrFillFromInternal(), serverLevel.m_213780_(), 18);
            for (UUID playerUUID : essenceBlockEntity.getPlayerInArena()) {
                Block patt1$temp;
                ServerPlayer serverPlayer = (ServerPlayer)serverLevel.m_46003_(playerUUID);
                if (serverPlayer == null) continue;
                Block patt0$temp = essenceBlockEntity.m_58900_().m_60734_();
                if (patt0$temp instanceof EssenceBlock) {
                    EssenceBlock essenceBlock = (EssenceBlock)patt0$temp;
                    essenceBlock.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
                }
                if (blockPos.m_123341_() + size.m_123341_() <= serverPlayer.m_20183_().m_123341_() || blockPos.m_123342_() + size.m_123342_() <= serverPlayer.m_20183_().m_123342_() || blockPos.m_123343_() + size.m_123343_() <= serverPlayer.m_20183_().m_123343_() || blockPos.m_123341_() - size.m_123341_() >= serverPlayer.m_20183_().m_123341_() || blockPos.m_123342_() - size.m_123342_() >= serverPlayer.m_20183_().m_123342_() || blockPos.m_123343_() - size.m_123343_() >= serverPlayer.m_20183_().m_123343_()) continue;
                Direction direction = Direction.Plane.HORIZONTAL.m_235690_(serverLevel.m_213780_());
                serverPlayer.m_20334_(0.0, 0.0, 0.0);
                serverPlayer.m_6021_((double)((float)blockPos.m_123341_() + (float)direction.m_122429_() * ((float)(negativeHalfLengths.m_123341_() + 1) / -2.0f) + 0.5f), (double)(blockPos.m_123342_() + negativeHalfLengths.m_123342_() + 2), (double)((float)blockPos.m_123343_() + (float)direction.m_122431_() * ((float)(negativeHalfLengths.m_123343_() + 1) / -2.0f) + 0.5f));
                serverPlayer.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82512_((Vec3i)blockPos));
                EssenceBlock.spawnParticles(serverLevel, serverPlayer.m_20182_(), serverPlayer.m_217043_());
                if (!won || !((patt1$temp = blockState.m_60734_()) instanceof EssenceBlock)) continue;
                EssenceBlock essenceBlock = (EssenceBlock)patt1$temp;
                LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(essenceBlock.getEssenceItemReward());
                if (lootTable != null) {
                    LootParams.Builder lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_287286_(LootContextParams.f_81455_, (Object)serverPlayer);
                    ObjectArrayList newItems = new ObjectArrayList();
                    lootTable.m_287228_(lootParams.m_287235_(LootContextParamSets.f_81418_), arg_0 -> ((ObjectArrayList)newItems).add(arg_0));
                    for (ItemStack reward : newItems) {
                        BzCriterias.ESSENCE_EVENT_REWARD_TRIGGER.trigger(serverPlayer, reward);
                        if (serverPlayer.m_36356_(reward)) continue;
                        serverPlayer.m_36176_(reward, false);
                    }
                }
                int xpReward = essenceBlock.getEssenceXpReward();
                if (essenceBlockEntity.isBeaten()) {
                    xpReward = (int)((double)xpReward * 0.1);
                }
                serverPlayer.m_6756_(xpReward);
                essenceBlock.awardPlayerWinStat(serverPlayer);
            }
            List entities = serverLevel.m_45933_(null, new AABB((double)(blockPos.m_123341_() + size.m_123341_()), (double)(blockPos.m_123342_() + size.m_123342_()), (double)(blockPos.m_123343_() + size.m_123343_()), (double)(blockPos.m_123341_() - size.m_123341_()), (double)(blockPos.m_123342_() - size.m_123342_()), (double)(blockPos.m_123343_() - size.m_123343_())));
            for (Entity entity : entities) {
                Mob mob;
                NeutralMob neutralMob;
                if ((!(entity instanceof NeutralMob) || !((neutralMob = (NeutralMob)entity).m_5448_() instanceof Player)) && (!(entity instanceof Mob) || !((mob = (Mob)entity).m_5448_() instanceof Player))) continue;
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            for (EventEntities eventEntities : essenceBlockEntity.getEventEntitiesInArena()) {
                Entity entity = serverLevel.m_8791_(eventEntities.uuid());
                if (entity == null) continue;
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (!essenceBlockEntity.getPlayerInArena().isEmpty() && won && !BzGeneralConfigs.repeatableEssenceEvents) {
                serverLevel.m_7731_(blockPos, BzBlocks.HEAVY_AIR.get().m_49966_(), 3);
            }
        }, () -> Bumblezone.LOGGER.error("Bumblezone Essence Block failed to restore area from saved NBT - {} - {} - Location: {}", new Object[]{essenceBlockEntity, blockState, essenceBlockEntity.getSavedNbtLocationAsString()}));
        essenceBlockEntity.getEventBar().m_7706_();
        essenceBlockEntity.getPlayerInArena().clear();
        essenceBlockEntity.getEventEntitiesInArena().clear();
        essenceBlockEntity.setExtraEventTrackingProgress(0);
        essenceBlockEntity.setEventTimer(0);
        essenceBlockEntity.m_6596_();
    }

    public void m_7651_() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (UUID playerUUID : this.getPlayerInArena()) {
                Block block;
                ServerPlayer serverPlayer = (ServerPlayer)serverLevel.m_46003_(playerUUID);
                if (serverPlayer == null || !((block = this.m_58900_().m_60734_()) instanceof EssenceBlock)) continue;
                EssenceBlock essenceBlock = (EssenceBlock)block;
                essenceBlock.onPlayerLeave(serverLevel, serverPlayer, this);
            }
        }
        this.getEventBar().m_7706_();
        super.m_7651_();
    }

    public static EssenceBlockEntity getEssenceBlockAtLocation(Level level, ResourceKey<Level> targetLevel, BlockPos targetBlockPos, UUID targetEssenceUUID) {
        EssenceBlockEntity essenceBlockEntity;
        BlockEntity blockEntity;
        if (targetEssenceUUID != null && level != null && targetBlockPos != null && level.m_46472_().equals(targetLevel) && (blockEntity = level.m_7702_(targetBlockPos)) instanceof EssenceBlockEntity && (essenceBlockEntity = (EssenceBlockEntity)blockEntity).getEventTimer() > 0 && essenceBlockEntity.getUUID().equals(targetEssenceUUID)) {
            return essenceBlockEntity;
        }
        return null;
    }

    public record EventEntities(UUID uuid) {
    }
}

