/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class EssenceBlockRed
extends EssenceBlock {
    private static final int ENTITIES_TO_KILL = 100;

    public EssenceBlockRed() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283913_));
    }

    @Override
    public ResourceLocation getArenaNbt() {
        return new ResourceLocation("the_bumblezone", "essence/red_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return BzGeneralConfigs.redArenaTimeFrameInTicks;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.red_essence_event", BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_20).m_7003_(true);
    }

    @Override
    public ResourceLocation getEssenceItemReward() {
        return new ResourceLocation("the_bumblezone", "gameplay/rewards/red_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(ServerPlayer serverPlayer) {
        serverPlayer.m_36220_(BzStats.RAGING_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        if (essenceBlockEntity.getPlayerInArena().isEmpty()) {
            return;
        }
        int entitiesKilled = essenceBlockEntity.getExtraEventTrackingProgress();
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        if (entitiesKilled != 100 && (double)eventEntitiesInArena.size() < Math.min(3.0 + (double)essenceBlockEntity.getPlayerInArena().size() * 1.5, (double)(100 - entitiesKilled))) {
            int currentEntityCount = eventEntitiesInArena.size() + entitiesKilled;
            EssenceBlockRed.SpawnNewEnemy(serverLevel, blockPos, blockState, essenceBlockEntity, currentEntityCount, eventEntitiesInArena);
        } else {
            for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
                Mob mob;
                NeutralMob neutralMob;
                UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
                Entity entity = serverLevel.m_8791_(entityToCheck);
                if (entity == null) {
                    ++entitiesKilled;
                    eventEntitiesInArena.remove(i);
                    continue;
                }
                if (entity instanceof NeutralMob && !((neutralMob = (NeutralMob)entity).m_5448_() instanceof Player)) {
                    playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.m_213780_().m_188503_(essenceBlockEntity.getPlayerInArena().size()));
                    player = serverLevel.m_46003_(playerUUID);
                    neutralMob.m_7870_(Integer.MAX_VALUE);
                    neutralMob.m_6925_(playerUUID);
                    neutralMob.m_6710_((LivingEntity)player);
                } else if (entity instanceof Mob && !((mob = (Mob)entity).m_5448_() instanceof Player)) {
                    playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.m_213780_().m_188503_(essenceBlockEntity.getPlayerInArena().size()));
                    player = serverLevel.m_46003_(playerUUID);
                    mob.m_6710_((LivingEntity)player);
                }
                if (Math.abs(entity.m_20183_().m_123341_() - blockPos.m_123341_()) <= essenceBlockEntity.getArenaSize().m_123341_() / 2 && Math.abs(entity.m_20183_().m_123342_() - blockPos.m_123342_()) <= essenceBlockEntity.getArenaSize().m_123342_() / 2 && Math.abs(entity.m_20183_().m_123343_() - blockPos.m_123343_()) <= essenceBlockEntity.getArenaSize().m_123343_() / 2) continue;
                int yOffset = -essenceBlockEntity.getArenaSize().m_123342_() / 2 + 2;
                BlockPos center = blockPos.m_7918_(0, yOffset, 0);
                entity.m_6027_((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_());
            }
        }
        float newProgress = (float)entitiesKilled / 100.0f;
        essenceBlockEntity.getEventBar().m_142711_(1.0f - newProgress);
        essenceBlockEntity.setExtraEventTrackingProgress(entitiesKilled);
        if (entitiesKilled == 100) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
    }

    private static void SpawnNewEnemy(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity, int currentEntityCount, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        TagKey<EntityType<?>> enemyTagToUse = BzTags.ESSENCE_RAGING_ARENA_NORMAL_ENEMY;
        int entityToSpawnIndex = currentEntityCount + 1;
        if (entityToSpawnIndex % 25 == 0 || entityToSpawnIndex == 49 || entityToSpawnIndex == 73 || entityToSpawnIndex == 74 || entityToSpawnIndex == 97 || entityToSpawnIndex == 98 || entityToSpawnIndex == 99) {
            enemyTagToUse = BzTags.ESSENCE_RAGING_ARENA_BOSS_ENEMY;
        } else if (entityToSpawnIndex % 5 == 0) {
            enemyTagToUse = BzTags.ESSENCE_RAGING_ARENA_STRONG_ENEMY;
        } else if (entityToSpawnIndex % 3 == 0) {
            enemyTagToUse = BzTags.ESSENCE_RAGING_ARENA_RANGED_ENEMY;
        }
        List entityTypeList = BuiltInRegistries.f_256780_.m_203431_(enemyTagToUse).map(holders -> holders.m_203614_().map(Holder::m_203334_).toList()).orElseGet(ArrayList::new);
        EntityType entityTypeToSpawn = (EntityType)entityTypeList.get(serverLevel.m_213780_().m_188503_(entityTypeList.size()));
        int yOffset = -essenceBlockEntity.getArenaSize().m_123342_() / 2 + 2;
        Entity entity = entityTypeToSpawn.m_262496_(serverLevel, blockPos.m_7918_(0, yOffset, 0), MobSpawnType.TRIGGERED);
        if (entity != null) {
            entity.m_20049_("the_bumblezone.red_essence_arena");
            if (entity instanceof Slime) {
                Slime slime = (Slime)entity;
                slime.m_7839_(4, true);
            }
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.m_20148_()));
            UUID playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.m_213780_().m_188503_(essenceBlockEntity.getPlayerInArena().size()));
            ServerPlayer player = serverLevel.m_7654_().m_6846_().m_11259_(playerUUID);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                float maxHeart = Math.max(serverPlayer.m_21223_(), serverPlayer.m_21233_());
                float maxArmor = serverPlayer.m_21230_();
                float mobHealthBoost = maxHeart / 15.0f + maxArmor / 10.0f;
                float mobAttackBoost = maxHeart / 20.0f + maxArmor / 15.0f;
                boolean isEssenced = EssenceOfTheBees.hasEssence(serverPlayer);
                if (!isEssenced) {
                    mobHealthBoost *= 1.5f;
                    mobAttackBoost *= 1.5f;
                }
                float timeProgress = 1.0f - (float)essenceBlockEntity.getEventTimer() / (float)((EssenceBlock)blockState.m_60734_()).getEventTimeFrame();
                float enemyProgress = (float)essenceBlockEntity.getExtraEventTrackingProgress() / 100.0f;
                float progressDiff = (float)(Math.pow(enemyProgress - timeProgress + 1.0f, 2.0) - 1.0);
                if ((double)progressDiff > 0.06) {
                    progressDiff = (float)Math.pow((double)((enemyProgress - timeProgress) * 2.0f) + 0.5, 5.0);
                    mobHealthBoost += (float)((int)(progressDiff / 0.025f));
                    mobAttackBoost += (float)((int)(progressDiff / 0.1f));
                }
                if (entity instanceof LivingEntity) {
                    AttributeInstance livingEntityAttributeFollowRange;
                    AttributeInstance livingEntityAttributeFlyingSpeed;
                    AttributeInstance livingEntityAttributeSpeed;
                    AttributeInstance livingEntityAttributeAttack;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    AttributeInstance livingEntityAttributeHealth = livingEntity.m_21051_(Attributes.f_22276_);
                    if (livingEntityAttributeHealth != null) {
                        livingEntityAttributeHealth.m_22125_(new AttributeModifier(UUID.fromString("03c85bd0-09eb-11ee-be56-0242ac120002"), "Essence Arena Health Boost", (double)mobHealthBoost, AttributeModifier.Operation.ADDITION));
                        livingEntity.m_5634_(mobHealthBoost);
                    }
                    if ((livingEntityAttributeAttack = livingEntity.m_21051_(Attributes.f_22281_)) != null) {
                        livingEntityAttributeAttack.m_22125_(new AttributeModifier(UUID.fromString("355141f8-09eb-11ee-be56-0242ac120002"), "Essence Arena Damage Boost", (double)mobAttackBoost, AttributeModifier.Operation.ADDITION));
                    }
                    if ((livingEntityAttributeSpeed = livingEntity.m_21051_(Attributes.f_22279_)) != null) {
                        livingEntityAttributeSpeed.m_22125_(new AttributeModifier(UUID.fromString("39ca0496-fa37-488f-8199-c4779f1afe0c"), "Essence Arena Speed Boost", isEssenced ? 0.05 : 0.065, AttributeModifier.Operation.ADDITION));
                    }
                    if ((livingEntityAttributeFlyingSpeed = livingEntity.m_21051_(Attributes.f_22280_)) != null) {
                        livingEntityAttributeFlyingSpeed.m_22125_(new AttributeModifier(UUID.fromString("c762c216-0a3a-11ee-be56-0242ac120002"), "Essence Arena Flying Speed Boost", 0.065, AttributeModifier.Operation.ADDITION));
                    }
                    if ((livingEntityAttributeFollowRange = livingEntity.m_21051_(Attributes.f_22277_)) != null) {
                        livingEntityAttributeFollowRange.m_22125_(new AttributeModifier(UUID.fromString("23a7a8a9-85bc-4dc3-9417-a4bd4b1b95a2"), "Essence Arena Sight Boost", 32.0, AttributeModifier.Operation.ADDITION));
                    }
                }
                if (entity instanceof NeutralMob) {
                    NeutralMob neutralMob = (NeutralMob)entity;
                    neutralMob.m_7870_(Integer.MAX_VALUE);
                    neutralMob.m_6925_(playerUUID);
                    neutralMob.m_6710_((LivingEntity)serverPlayer);
                } else if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_6710_((LivingEntity)serverPlayer);
                    if (entity instanceof Rabbit) {
                        Rabbit rabbit = (Rabbit)entity;
                        rabbit.m_28464_(Rabbit.Variant.EVIL);
                    }
                }
            }
        }
    }

    @Override
    public void onPlayerEnter(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, BzSounds.RAGING_EVENT.get().m_11660_(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, BzSounds.RAGING_EVENT.get().m_11660_(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

